/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-03-03 00:23:12 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1265 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=15192 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_backups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `package` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `archive_name` varchar(350) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `progress` float NOT NULL DEFAULT '0',
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE') COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `version` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`),
  KEY `archive_name` (`archive_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_entities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value_1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_3` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_4` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_5` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `version` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`),
  KEY `value_2` (`value_2`),
  KEY `value_3` (`value_3`),
  KEY `value_4` (`value_4`),
  KEY `value_5` (`value_5`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=40562 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=681 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1623 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_internal_links` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  `target_post_id` bigint unsigned NOT NULL,
  `type` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_internal_meta` (
  `object_id` bigint unsigned NOT NULL,
  `internal_link_count` int unsigned DEFAULT '0',
  `external_link_count` int unsigned DEFAULT '0',
  `incoming_link_count` int unsigned DEFAULT '0',
  PRIMARY KEY (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_snippets` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `code` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tags` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scope` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'global',
  `priority` smallint NOT NULL DEFAULT '10',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `revision` bigint NOT NULL DEFAULT '1',
  `cloud_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `scope` (`scope`),
  KEY `active` (`active`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int unsigned NOT NULL DEFAULT '0',
  `unixday` int unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfblocks7` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` int unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int unsigned DEFAULT '0',
  `blockedHits` int unsigned DEFAULT '0',
  `expiration` bigint unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB AUTO_INCREMENT=12609 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `real_path` text NOT NULL,
  `knownFile` tinyint unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfhits` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint DEFAULT '0',
  `statusCode` int NOT NULL DEFAULT '200',
  `isGoogle` tinyint NOT NULL,
  `userID` int unsigned NOT NULL,
  `newVisit` tinyint unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB AUTO_INCREMENT=18262 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfhoover` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfknownfilelist` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `wordpress_path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int unsigned NOT NULL,
  `failed` tinyint unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wflogins` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB AUTO_INCREMENT=3775 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfls_2fa_secrets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int unsigned NOT NULL,
  `vtime` int unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfls_role_counts` (
  `serialized_roles` varbinary(255) NOT NULL,
  `two_factor_inactive` tinyint(1) NOT NULL,
  `user_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`serialized_roles`,`two_factor_inactive`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int NOT NULL DEFAULT '1000',
  `ctime` int unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfpendingissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfsecurityevents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfsnipcache` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int unsigned NOT NULL DEFAULT '0',
  `type` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=14075 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfstatus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wftrafficrates` (
  `eMin` int unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfwaffailures` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `throwable` text NOT NULL,
  `rule_id` int unsigned DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `wp_users` VALUES 
("1","admin","$P$BuRMjRqeGhbOpyj66/2O8cj0qrGRM50","admin","admin@staging-projects.com","https://best-ultrawin.com","2024-08-17 13:03:13","","0","admin");

INSERT IGNORE INTO `wp_usermeta` VALUES 
("1","1","nickname","admin"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","wp_capabilities","a:2:{s:13:\"administrator\";b:1;s:18:\"ai1wm_gdrive_admin\";s:1:\"0\";}"),
("13","1","wp_user_level","10"),
("14","1","dismissed_wp_pointers","theme_editor_notice"),
("15","1","show_welcome_panel","0"),
("16","1","session_tokens","a:1:{s:64:\"15807ee2832d978fc23442a70d8a4b22bc3404466393aeeac768874db1cacf5d\";a:4:{s:10:\"expiration\";i:1741133729;s:2:\"ip\";s:13:\"183.83.52.112\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Safari/537.36\";s:5:\"login\";i:1740960929;}}"),
("17","1","wp_dashboard_quick_press_last_post_id","1620"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:11:\"183.83.52.0\";}"),
("19","1","wp_persisted_preferences","a:3:{s:4:\"core\";a:2:{s:26:\"isComplementaryAreaVisible\";b:1;s:10:\"openPanels\";a:2:{i:0;s:11:\"post-status\";i:1;s:55:\"generatepress-block-element/generatepress-block-element\";}}s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2024-08-17T14:46:43.720Z\";}"),
("20","1","wp_user-settings","libraryContent=browse"),
("21","1","wp_user-settings-time","1723901491"),
("22","1","generateblocks_onboarding","a:1:{s:22:\"insert_inner_container\";b:1;}"),
("23","1","manageedit-postcolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("24","1","manageedit-postcolumnshidden_default","1"),
("25","1","manageedit-pagecolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("26","1","manageedit-pagecolumnshidden_default","1"),
("27","1","meta-box-order_page","a:2:{i:0;b:0;s:4:\"side\";s:38:\"submitdiv,rank_math_metabox_content_ai\";}"),
("28","1","last_update","1724264420"),
("29","1","nav_menu_recently_edited","4"),
("30","1","managenav-menuscolumnshidden","a:4:{i:0;s:11:\"link-target\";i:1;s:15:\"title-attribute\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";}"),
("31","1","metaboxhidden_nav-menus","a:2:{i:0;s:12:\"add-post_tag\";i:1;s:15:\"add-post_format\";}"),
("32","1","meta-box-order_post","a:2:{i:0;b:0;s:4:\"side\";s:38:\"submitdiv,rank_math_metabox_content_ai\";}"),
("33","1","wfls-last-login","1740960929");

INSERT IGNORE INTO `wp_actionscheduler_actions` VALUES 
("1261","action_scheduler/migration_hook","failed","2024-08-17 14:42:45","2024-08-17 14:42:45","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1723905765;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1723905765;}","1","1","2024-08-17 14:43:44","2024-08-17 14:43:44","0",NULL),
("1264","action_scheduler/migration_hook","failed","2024-10-22 12:19:42","2024-10-22 12:19:42","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1729599582;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1729599582;}","1","1","2024-10-22 12:19:42","2024-10-22 12:19:42","0",NULL);

INSERT IGNORE INTO `wp_actionscheduler_groups` VALUES 
("1","action-scheduler-migration");

INSERT IGNORE INTO `wp_actionscheduler_logs` VALUES 
("4","1261","action created","2024-08-17 14:41:45","2024-08-17 14:41:45"),
("5","1261","action started via WP Cron","2024-08-17 14:43:44","2024-08-17 14:43:44"),
("6","1261","action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-08-17 14:43:44","2024-08-17 14:43:44"),
("13","1264","action created","2024-10-22 12:18:42","2024-10-22 12:18:42"),
("14","1264","action started via WP Cron","2024-10-22 12:19:42","2024-10-22 12:19:42"),
("15","1264","action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-10-22 12:19:42","2024-10-22 12:19:42");

INSERT IGNORE INTO `wp_duplicator_backups` VALUES 
("1","20250303_002310_Daily_ultrawin","cee5c4df2687c3057637_20250303002310","20","2025-03-03 00:23:10","unknown","{\n    \"ID\": 1,\n    \"VersionWP\": \"6.7.2\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20250303_002310_Daily_ultrawin\",\n    \"Hash\": \"cee5c4df2687c3057637_20250303002310\",\n    \"NameHash\": \"20250303_002310_Daily_ultrawin_cee5c4df2687c3057637_20250303002310\",\n    \"Type\": 2,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/best-ultrawin.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250303_002310_Daily_ultrawin_cee5c4df2687c3057637_20250303002310_scan.json\",\n    \"timer_start\": 1740961391.84599,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/.opcache\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/.tmb\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/bps-backup\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/cache\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/old-cache\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/updraft\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/wfcache\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/.htaccess\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/.user.ini\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/php.ini\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/web.config\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-config.php\",\n            \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20250303_002310_Daily_ultrawin_cee5c4df2687c3057637_20250303002310_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\",\n        \"Size\": 174652204,\n        \"Dirs\": [],\n        \"DirCount\": 1845,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 10310,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250303_002310_Daily_ultrawin_cee5c4df2687c3057637_20250303002310_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"FkuOyY0\\/huD1naqVh+i6q6hN1TsuGseXz8JGmE+nTbabZXRTC\\/RIUQQkVb\\/J4+x1IUYaG8pgNfV+\\/pkcDPT7lA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"best-ultrawin\",\n            \"tablesBaseCount\": 45,\n            \"tablesFinalCount\": 45,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 4983,\n            \"tablesSizeOnDisk\": 9748480,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 147456\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 0,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"305\",\n                    \"insertedRows\": 0,\n                    \"size\": 2457600\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"353\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"118\",\n                    \"insertedRows\": 0,\n                    \"size\": 3375104\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"763\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"204\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"1179\",\n                    \"insertedRows\": 0,\n                    \"size\": 1261568\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"1938\",\n                    \"insertedRows\": 0,\n                    \"size\": 622592\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20250303_002310_Daily_ultrawin_cee5c4df2687c3057637_20250303002310_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/best-ultrawin\\/htdocs\\/best-ultrawin.com\\/wp-content\\/backups-dup-pro\\/tmp\\/20250303_002310_Daily_ultrawin_cee5c4df2687c3057637_20250303002310_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 20,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 1740961392,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"wp_users\",\n            \"wp_usermeta\",\n            \"wp_actionscheduler_actions\",\n            \"wp_actionscheduler_claims\",\n            \"wp_actionscheduler_groups\",\n            \"wp_actionscheduler_logs\",\n            \"wp_commentmeta\",\n            \"wp_comments\",\n            \"wp_duplicator_backups\",\n            \"wp_duplicator_entities\",\n            \"wp_links\",\n            \"wp_options\",\n            \"wp_postmeta\",\n            \"wp_posts\",\n            \"wp_rank_math_internal_links\",\n            \"wp_rank_math_internal_meta\",\n            \"wp_snippets\",\n            \"wp_term_relationships\",\n            \"wp_term_taxonomy\",\n            \"wp_termmeta\",\n            \"wp_terms\",\n            \"wp_wfblockediplog\",\n            \"wp_wfblocks7\",\n            \"wp_wfconfig\",\n            \"wp_wfcrawlers\",\n            \"wp_wffilechanges\",\n            \"wp_wffilemods\",\n            \"wp_wfhits\",\n            \"wp_wfhoover\",\n            \"wp_wfissues\",\n            \"wp_wfknownfilelist\",\n            \"wp_wflivetraffichuman\",\n            \"wp_wflocs\",\n            \"wp_wflogins\",\n            \"wp_wfls_2fa_secrets\",\n            \"wp_wfls_role_counts\",\n            \"wp_wfls_settings\",\n            \"wp_wfnotifications\",\n            \"wp_wfpendingissues\",\n            \"wp_wfreversecache\",\n            \"wp_wfsecurityevents\",\n            \"wp_wfsnipcache\",\n            \"wp_wfstatus\",\n            \"wp_wftrafficrates\",\n            \"wp_wfwaffailures\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1740961391.863599,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 4983,\n            \"tables\": {\n                \"wp_users\": {\n                    \"start\": \"1\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_snippets\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfblockediplog\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfblocks7\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfconfig\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfcrawlers\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wffilechanges\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wffilemods\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfhits\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfhoover\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfissues\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfknownfilelist\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wflocs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wflogins\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfls_role_counts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfls_settings\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfnotifications\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfpendingissues\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfreversecache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfsecurityevents\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfsnipcache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfstatus\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wftrafficrates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"wp_wfwaffailures\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2025-03-03 00:23:10\",\n    \"updated\": \"2025-03-03 00:23:12\",\n    \"flags\": [\n        \"SCHEDULE_RUN_NOW\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","20250303_002310_Daily_ultrawin_cee5c4df2687c3057637_20250303002310_archive.zip","20","SCHEDULE_RUN_NOW,ZIP_ARCHIVE","4.5.16.4","2025-03-03 00:23:12");

INSERT IGNORE INTO `wp_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"crypt\": true,\n    \"email_summary_frequency\": \"weekly\",\n    \"email_summary_recipients\": [\n        \"admin@staging-projects.com\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 1,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"admin@staging-projects.com\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"ajax_protocol\": \"https\",\n    \"custom_ajax_url\": \"https:\\/\\/best-ultrawin.com\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": 2048,\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"dropbox_upload_chunksize_in_kb\": null,\n    \"dropbox_transfer_mode\": null,\n    \"gdrive_upload_chunksize_in_kb\": null,\n    \"gdrive_transfer_mode\": null,\n    \"s3_upload_part_size_in_kb\": null,\n    \"onedrive_upload_chunksize_in_kb\": null,\n    \"local_upload_chunksize_in_MB\": null,\n    \"manual_mode_storage_ids\": [\n        6\n    ],\n    \"license_key_visible\": 1,\n    \"lkp\": \"\",\n    \"last_system_check_timestamp\": 1724267432,\n    \"initial_activation_timestamp\": 1724267432,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"id\": 1,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.16.4\",\n    \"created\": \"0000-00-00 00:00:00\",\n    \"updated\": \"2025-03-03 00:18:09\"\n}","","","","","","4.5.16.4","0000-00-00 00:00:00","2025-03-03 00:18:09"),
("2","DUP_PRO_Secure_Global_Entity","{\n    \"basic_auth_password\": \"\",\n    \"lkp\": \"\",\n    \"id\": 2,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.16.4\",\n    \"created\": \"0000-00-00 00:00:00\",\n    \"updated\": \"2025-03-03 00:18:09\"\n}","","","","","","4.5.16.4","0000-00-00 00:00:00","2025-03-03 00:18:09"),
("3","DUP_PRO_System_Global_Entity","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1740961390,\n    \"id\": 3,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.16.4\",\n    \"created\": \"0000-00-00 00:00:00\",\n    \"updated\": \"2025-03-03 00:23:10\"\n}","","","","","","4.5.16.4","0000-00-00 00:00:00","2025-03-03 00:23:10"),
("4","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"Default\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"jC9rUSckTxfy15BwXORzyAo94jKG6oux8M\\/l+VfyEDVbYb2D+CfcxPWhjnnfJ\\/zLVWrFi4gdHVJuEyYeK8QTUw==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"id\": 4,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.16.4\",\n    \"created\": \"0000-00-00 00:00:00\",\n    \"updated\": \"2025-03-03 00:18:00\"\n}","","","","","","4.5.16.4","0000-00-00 00:00:00","2025-03-03 00:18:00"),
("5","DUP_PRO_Package_Template_Entity","{\n    \"name\": \"[Manual Mode]\",\n    \"notes\": \"\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"E1a2Iq6g8da4Heizo6k3kow13T+uUV7K+wG0PM5wQF8rSN3ZAaHQ3hV27uqExwf1oasmGxIiWz1OVC\\/H9s\\/StQ==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"id\": 5,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.16.4\",\n    \"created\": \"0000-00-00 00:00:00\",\n    \"updated\": \"2025-03-03 00:18:00\"\n}","","","","","","4.5.16.4","0000-00-00 00:00:00","2025-03-03 00:18:00"),
("6","DUP_PRO_Storage_Entity","{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"1oDSVjxcvvkkSVXha\\/nSSzSPVTjY7sPQMi6DMs7+gQlm3KeJL37KNgFCL3duOZ686y+m2160UxHWtE76rQYcGaLEWsm5JdB6neQn+7ihQTZl9lqevsmHGJqEXJLJ2wb0XdpJLsNTBEgDN5zRUmocY4f98QenF5cIU4IevdNSR3EEoO7iIa\\/udDG+0rm8JDFD1QRBkYykGcksM8cLw5Mb3hChFGUG1PIlSrsNI8ABsBigZoQIOr1O5Wv\\/yQ00q\\/5qmqwGs6IvbRidJl194nP8nKYGjYs6GwJZZV3Tc+kRGDM0ZME6S2BANw==\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"id\": 6,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2025-03-03 00:17:59\",\n    \"updated\": \"2025-03-03 00:18:00\"\n}","","","","","","4.5.16.4","2025-03-03 00:17:59","2025-03-03 00:18:00"),
("7","EmailSummary","{\n    \"manualPackageIds\": [],\n    \"scheduledPackageIds\": [],\n    \"failedPackageIds\": [],\n    \"scheduleIds\": [\n        11\n    ],\n    \"storageIds\": [\n        6,\n        10\n    ],\n    \"id\": 7,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2025-03-03 00:17:59\",\n    \"updated\": \"2025-03-03 00:21:54\"\n}","","","","","","4.5.16.4","2025-03-03 00:17:59","2025-03-03 00:21:54"),
("8","Dynamic_Entity","{\n    \"data\": {\n        \"dropbox_upload_chunksize_in_kb\": 2000,\n        \"dropbox_transfer_mode\": 1,\n        \"gdrive_upload_chunksize_in_kb\": 1024,\n        \"gdrive_transfer_mode\": 0,\n        \"s3_upload_part_size_in_kb\": 6000,\n        \"onedrive_upload_chunksize_in_kb\": 3200,\n        \"local_upload_chunksize_in_MB\": 16\n    },\n    \"id\": 8,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2025-03-03 00:18:00\",\n    \"updated\": \"2025-03-03 00:18:00\"\n}","","","","","","4.5.16.4","2025-03-03 00:18:00","2025-03-03 00:18:00"),
("9","LicenseDataEntity","{\n    \"licenseKey\": \"kv7FxwMe4qjzXCh9w9kQ1bWSbt+riCE3q\\/60W+rhEPBp1uCTegqrDhrOAARF0AJEWB+QRQK8ZPsBwq6Dyv8YQ24sQBuJYSjr2zupqOJpEV8sJuSxx3gmOPckkrxs3xtX\",\n    \"status\": \"TPOJkKgozG7EkWi0VAtVb+E8BOZGo8gcGC6NrhnDDyhRGGjlyc7FsJ05y8Sr4iynqhh\\/7FifKKMWyyNXo5FF\\/LS4pmH43z49\",\n    \"type\": \"K3jUdPHuJrW4hxkHSil7E94meQ27QDPVHFf7UjzNVAkSOugZpK0OrezH6KSzPU\\/khYw\\/dBvSPMVqZqJQUWWAIMNCbfBqCoQ6\",\n    \"data\": \"NEDhS15onPHDUEfVr1+b2V7XwQct1EsZyS7kv8VgOW6ZzDDr8h9MiiPmzfqgU5VfSN6wgJQdZvI3Q3kIYojxaUiXfP+32o0CzE5cJz9Oy10SzoxB4wNjPSJGO8uZQg7JiqeXsdXHRaXmNm7kGyJ2xXNErybT604SaNEjqqHmrRTXvwPVfsd6GDCqjjH8OA0pxiMka2QpTTFiKoGwojlbqofq9fa1ROVtyJOtvFborYpslxbhixc8SMVfmOBgeWPzvQPp4AjavOghxFmq6VcX9h0PaMcc3WE\\/gb11KhBUEEBE1AOYrs1DOxpaJu\\/Koskg9W8VWzqcId67Ek7hn4ZYC8RDS9iDj3IEuyvKZbEurdMkuq+5IXpFuJVf6WTszMYjsqQ8hXZSFz+PKR3fHKOJAJeZN2Ap5M6N+L8oMirJmHchPnmV6J6MGZ3r+UiJrXvWx1Ixt6hQGFtGedAGHbmFDK1Saq0g3U\\/eB2FXEPySYZEkQzV4f7JlJZ\\/JryMv0TNt6DaiZpCAIgaQnOowQWeU4Q==\",\n    \"lastRemoteUpdate\": \"2025-03-03 00:18:14\",\n    \"lastFailureTime\": \"\",\n    \"id\": 9,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2025-03-03 00:18:00\",\n    \"updated\": \"2025-03-03 00:18:14\"\n}","","","","","","4.5.16.4","2025-03-03 00:18:00","2025-03-03 00:18:14"),
("10","DUP_PRO_Storage_Entity","{\n    \"name\": \"GDrive\",\n    \"notes\": \"\",\n    \"storage_type\": 3,\n    \"config\": \"qDzqJvDBuG7k\\/zUPo\\/Zl+Wxc\\/yV9F1G+uHduzG0R6G5m3KeJL37KNgFCL3duOZ68DZsNFJLXyi25z3qo7vxj5SH5CFboYI+xuB7KyEvg7wrFmI\\/OZ0M4jgSg7uIhr+50Mb7SubwkMUNbLJpv9fjw+iG7sRlZ+U9pt4CNwvzqS+UC3mD4zAZb1IeFdbtdxK3Fo1P2a1j3tPRdw5xl9ZO0WU7UELNEh1fGIbuxGVn5T2l3gU241sJJiMpmpbY4kdSweugRoTlLUOwpS+axg0oHSZhowMPwVPVLKCA+UPSlrTlnjCiCjTMVdAla3RlivYFYQmeC0jeKWdi1Fd\\/ve\\/T1Ohu7fbgFWjhmxOt+OPzjZ\\/pEiTjrKBbyX4akCAwEVGBOggbK6c+c+dFjHPE14yGlyqLUZgLmbNZZrNx1vMevUs1WcQ3ADwfmNWVMXPC2qpFeIAkvArnCTR35anz\\/8je9kkskOiNpNgbB88XKBgZ4KgCRjnAc8WGK3aW07FaVlT4bZIuaYALdBoCZEuvZZ9977AqqExk9pXyZir4J65lu63TRblzf0TpBN9V5Yp3pMSJWKMAAOFT9iAigiqh+6ft+2n0gmICd9nz5mKPZSqAVOIiCuZ4SE7TAt0W3Zx0kZZq6SI7yJzmlhTfBnAL8t98gwoxjqINfUVu9nlzNA+MdX7PCn0y3051EvuzWEa\\/S18RRDG31SrCHvSzjxRzy9jUec7g74CkuNcZ9KCzXtLfO9i7R4Bn3zwYy6pCwHBtDj\\/Pgp5sFH8kg7TeEq1XEa9Xq5c4zlomJ\\/VbiUoEI5HtLwijxfYy8N7Okc2++JqjNxBybAx+TYWXExjwKPq5W7RGDW17+tECiu89xU5XaG\\/SPWNtxKpVMRLv1EztV3R0SKm2sBClPXpnl3bTkROeoM1nDba3\\/ZyMk75NYIEDrp4v17cXEukMKErWDWoyWrEI2nxcDmRzayA9kT\\/y7ZwF013Z715DGm0wR+rfnFZ2NhAjTKhAY+cFlKFKOzzUkx5x5rYmS3MB1u1emxaaZlNdyTkrK8zXi0pIWZ8G8g1sgHZ7CyVALE9JBmTfRq42qv6o892w5\\/vOQIHgXYrOJzDuXJ7okQ6oFjHh785fftKqe9JkBfMfDNmAtC0H0qiQQ8aWiEp8zWiO9GLKlpcsKeKxscHX+5xSbwAgG2KoQZNTosvCMOU17nWm2cFHWf9FKE2MyYrqEcq+1AOon5wG2+hYbsrFfWafjviS\\/JZRLAtBEJKrrxp2RpTTMBxNoMJJzQhww4CyUlGHeDXw7kE+BaCsqpzYGwpmGQAUD3uk7B+DQnw6dsfxgSFnDsSoJKolEm2WDTXDThXUtdQabe9AHIi0lH91aYLQ3YzQqDpCSVt5ggffm57am4QdOMmFKwlIeU6LZX5tN41PUHfUAwsLppgg40x5fmIwzPPMbRKNcQjPkL4G93MH16+OVI9q1yph6GoeCcwlX+Ch+Cg3xfKo=\",\n    \"legacyEntity\": false,\n    \"local_storage_folder\": \"\",\n    \"local_max_files\": 10,\n    \"local_filter_protection\": true,\n    \"purge_package_record\": true,\n    \"dropbox_access_token\": \"\",\n    \"dropbox_access_token_secret\": \"\",\n    \"dropbox_v2_access_token\": \"\",\n    \"dropbox_storage_folder\": \"\",\n    \"dropbox_max_files\": 10,\n    \"dropbox_authorization_state\": 0,\n    \"onedrive_endpoint_url\": \"\",\n    \"onedrive_resource_id\": \"\",\n    \"onedrive_access_token\": \"\",\n    \"onedrive_refresh_token\": \"\",\n    \"onedrive_token_obtained\": 0,\n    \"onedrive_user_id\": \"\",\n    \"onedrive_storage_folder\": \"\",\n    \"onedrive_max_files\": 10,\n    \"onedrive_storage_folder_id\": \"\",\n    \"onedrive_authorization_state\": 0,\n    \"onedrive_storage_folder_web_url\": \"\",\n    \"ftp_server\": \"\",\n    \"ftp_port\": 21,\n    \"ftp_username\": \"\",\n    \"ftp_password\": \"\",\n    \"ftp_use_curl\": false,\n    \"ftp_storage_folder\": \"\",\n    \"ftp_max_files\": 10,\n    \"ftp_timeout_in_secs\": 15,\n    \"ftp_ssl\": false,\n    \"ftp_passive_mode\": false,\n    \"sftp_server\": \"\",\n    \"sftp_port\": 22,\n    \"sftp_username\": \"\",\n    \"sftp_password\": \"\",\n    \"sftp_private_key\": \"\",\n    \"sftp_private_key_password\": \"\",\n    \"sftp_storage_folder\": \"\",\n    \"sftp_timeout_in_secs\": 15,\n    \"sftp_max_files\": 10,\n    \"sftp_disable_chunking_mode\": false,\n    \"gdrive_access_token_set_json\": \"\",\n    \"gdrive_refresh_token\": \"\",\n    \"gdrive_storage_folder\": \"\",\n    \"gdrive_max_files\": 10,\n    \"gdrive_authorization_state\": 0,\n    \"gdrive_client_number\": -1,\n    \"s3_access_key\": \"\",\n    \"s3_bucket\": \"\",\n    \"s3_max_files\": 10,\n    \"s3_provider\": \"amazon\",\n    \"s3_region\": \"\",\n    \"s3_endpoint\": \"\",\n    \"s3_secret_key\": \"\",\n    \"s3_storage_class\": \"STANDARD\",\n    \"s3_storage_folder\": \"\",\n    \"s3_ACL_full_control\": true,\n    \"id\": 10,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2025-03-03 00:18:45\",\n    \"updated\": \"2025-03-03 00:22:13\"\n}","","","","","","4.5.16.4","2025-03-03 00:18:45","2025-03-03 00:22:13"),
("11","DUP_PRO_Schedule_Entity","{\n    \"name\": \"Daily\",\n    \"template_id\": 4,\n    \"start_ticks\": 1420070400,\n    \"repeat_type\": 0,\n    \"active\": true,\n    \"next_run_time\": 1741046400,\n    \"run_every\": 1,\n    \"weekly_days\": 0,\n    \"day_of_month\": 1,\n    \"cron_string\": \"0 0 * * *\",\n    \"last_run_time\": -1,\n    \"last_run_status\": 1,\n    \"times_run\": 0,\n    \"storage_ids\": [\n        10\n    ],\n    \"id\": 11,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2025-03-03 00:21:54\",\n    \"updated\": \"2025-03-03 00:21:54\"\n}","","","","","","4.5.16.4","2025-03-03 00:21:54","2025-03-03 00:21:54");

INSERT IGNORE INTO `wp_options` VALUES 
("1","cron","a:24:{i:1740961419;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1740962352;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1740962359;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1740962950;a:1:{s:21:\"ai1wm_storage_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1740963876;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1740963890;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1740967392;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1740968157;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"660434c6268da002c8def4430fb35fc0\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1621;}}}}i:1740968207;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"8342a503375ccd8362a7ad4f22d6edd8\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1622;}}}}i:1740969192;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1740970992;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1741006326;a:1:{s:35:\"rank_math/content-ai/update_prompts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1741007076;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1741007090;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1741007096;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1741017600;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1741030759;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1741046400;a:1:{s:35:\"rank_math/redirection/clean_trashed\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1741439161;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1741525476;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1741565760;a:1:{s:28:\"ai1wmge_gdrive_weekly_export\";a:1:{s:32:\"07310ab6b045f2193b7b715f5f6fde83\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:1:{i:0;a:2:{s:10:\"secret_key\";s:12:\"Gw2emxERhnNR\";s:6:\"gdrive\";i:1;}}s:8:\"interval\";i:604800;}}}i:1741615200;a:1:{s:33:\"duplicator_pro_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1742002888;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","on"),
("2","siteurl","https://best-ultrawin.com","on"),
("3","home","https://best-ultrawin.com","on"),
("4","blogname","Ultrawin","on"),
("5","blogdescription","Best fantasy app in India","on"),
("6","users_can_register","0","on"),
("7","admin_email","admin@staging-projects.com","on"),
("8","start_of_week","1","on"),
("9","use_balanceTags","0","on"),
("10","use_smilies","1","on"),
("11","require_name_email","1","on"),
("12","comments_notify","1","on"),
("13","posts_per_rss","10","on"),
("14","rss_use_excerpt","0","on"),
("15","mailserver_url","mail.example.com","on"),
("16","mailserver_login","login@example.com","on"),
("17","mailserver_pass","password","on"),
("18","mailserver_port","110","on"),
("19","default_category","1","on"),
("20","default_comment_status","open","on"),
("21","default_ping_status","open","on"),
("22","default_pingback_flag","1","on"),
("23","posts_per_page","10","on"),
("24","date_format","F j, Y","on"),
("25","time_format","g:i a","on"),
("26","links_updated_date_format","F j, Y g:i a","on"),
("27","comment_moderation","0","on"),
("28","moderation_notify","1","on"),
("29","permalink_structure","/%postname%/","on"),
("30","rewrite_rules","a:117:{s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:25:\"index.php?xsl=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/schema-preview/?$\";s:57:\"index.php?category=$matches[1]&schema-preview=$matches[3]\";s:27:\"tag/(.+?)/schema-preview/?$\";s:57:\"index.php?post_tag=$matches[1]&schema-preview=$matches[3]\";s:28:\"type/(.+?)/schema-preview/?$\";s:60:\"index.php?post_format=$matches[1]&schema-preview=$matches[3]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:37:\"gp_elements/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"gp_elements/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"gp_elements/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"gp_elements/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"gp_elements/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"gp_elements/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"gp_elements/(.+?)/embed/?$\";s:44:\"index.php?gp_elements=$matches[1]&embed=true\";s:30:\"gp_elements/(.+?)/trackback/?$\";s:38:\"index.php?gp_elements=$matches[1]&tb=1\";s:38:\"gp_elements/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?gp_elements=$matches[1]&paged=$matches[2]\";s:45:\"gp_elements/(.+?)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?gp_elements=$matches[1]&cpage=$matches[2]\";s:43:\"gp_elements/(.+?)/schema-preview(/(.*))?/?$\";s:60:\"index.php?gp_elements=$matches[1]&schema-preview=$matches[3]\";s:34:\"gp_elements/(.+?)(?:/([0-9]+))?/?$\";s:50:\"index.php?gp_elements=$matches[1]&page=$matches[2]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=29&cpage=$matches[1]\";s:29:\"gb-template-viewer(/(.*))?/?$\";s:41:\"index.php?&gb-template-viewer=$matches[2]\";s:25:\"schema-preview(/(.*))?/?$\";s:37:\"index.php?&schema-preview=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:33:\"(.?.+?)/schema-preview(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&schema-preview=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:33:\"([^/]+)/schema-preview(/(.*))?/?$\";s:53:\"index.php?name=$matches[1]&schema-preview=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","on"),
("31","hack_file","0","on"),
("32","blog_charset","UTF-8","on"),
("33","moderation_keys","","off"),
("34","active_plugins","a:12:{i:0;s:85:\"all-in-one-wp-migration-gdrive-extension/all-in-one-wp-migration-gdrive-extension.php\";i:1;s:91:\"all-in-one-wp-migration-unlimited-extension/all-in-one-wp-migration-unlimited-extension.php\";i:2;s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";i:3;s:33:\"duplicator-pro/duplicator-pro.php\";i:4;s:29:\"generateblocks-pro/plugin.php\";i:5;s:25:\"generateblocks/plugin.php\";i:6;s:25:\"gp-premium/gp-premium.php\";i:7;s:29:\"mainwp-child/mainwp-child.php\";i:8;s:38:\"seo-by-rank-math-pro/rank-math-pro.php\";i:9;s:30:\"seo-by-rank-math/rank-math.php\";i:10;s:43:\"seraphinite-accelerator-ext/plugin_root.php\";i:11;s:23:\"wordfence/wordfence.php\";}","on"),
("35","category_base","","on"),
("36","ping_sites","http://rpc.pingomatic.com/","on"),
("37","comment_max_links","2","on"),
("38","gmt_offset","0","on"),
("39","default_email_category","1","on"),
("40","recently_edited","a:3:{i:0;s:87:\"/home/best-ultrawin/htdocs/best-ultrawin.com/wp-content/themes/generatepress/header.php\";i:2;s:86:\"/home/best-ultrawin/htdocs/best-ultrawin.com/wp-content/themes/generatepress/style.css\";i:3;s:0:\"\";}","off"),
("41","template","generatepress","on"),
("42","stylesheet","generatepress","on"),
("43","comment_registration","0","on"),
("44","html_type","text/html","on"),
("45","use_trackback","0","on"),
("46","default_role","subscriber","on"),
("47","db_version","58975","on"),
("48","uploads_use_yearmonth_folders","1","on"),
("49","upload_path","","on"),
("50","blog_public","0","on"),
("51","default_link_category","2","on"),
("53","tag_base","","on"),
("54","show_avatars","1","on"),
("55","avatar_rating","G","on"),
("56","upload_url_path","","on"),
("57","thumbnail_size_w","150","on"),
("58","thumbnail_size_h","150","on"),
("59","thumbnail_crop","1","on"),
("60","medium_size_w","300","on"),
("61","medium_size_h","300","on"),
("62","avatar_default","mystery","on"),
("63","large_size_w","1024","on"),
("64","large_size_h","1024","on"),
("65","image_default_link_type","none","on"),
("66","image_default_size","","on"),
("67","image_default_align","","on"),
("68","close_comments_for_old_posts","0","on"),
("69","close_comments_days_old","14","on"),
("70","thread_comments","1","on"),
("71","thread_comments_depth","5","on"),
("72","page_comments","0","on"),
("73","comments_per_page","50","on"),
("74","default_comments_page","newest","on"),
("75","comment_order","asc","on"),
("76","sticky_posts","a:0:{}","on"),
("77","widget_categories","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("78","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("79","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","auto"),
("80","uninstall_plugins","a:1:{s:33:\"duplicator-pro/duplicator-pro.php\";a:2:{i:0;s:24:\"Duplicator\\Core\\Unistall\";i:1;s:8:\"unistall\";}}","off"),
("81","timezone_string","","on"),
("82","page_for_posts","0","on"),
("83","page_on_front","29","on"),
("84","default_post_format","0","on"),
("85","link_manager_enabled","0","on"),
("86","finished_splitting_shared_terms","1","on"),
("87","site_icon","1528","on"),
("88","medium_large_size_w","768","on"),
("89","medium_large_size_h","0","on"),
("90","wp_page_for_privacy_policy","3","on"),
("91","show_comments_cookies_opt_in","1","on"),
("92","admin_email_lifespan","1741220131","on"),
("93","disallowed_keys","","off"),
("94","comment_previously_approved","1","on"),
("95","auto_plugin_theme_update_emails","a:0:{}","off"),
("96","auto_update_core_dev","enabled","on"),
("97","auto_update_core_minor","enabled","on"),
("98","auto_update_core_major","enabled","on"),
("99","wp_force_deactivated_plugins","a:0:{}","off"),
("100","wp_attachment_pages_enabled","0","on"),
("101","initial_db_version","57155","on"),
("102","wp_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:90:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:23:\"rank_math_edit_htaccess\";b:1;s:16:\"rank_math_titles\";b:1;s:17:\"rank_math_general\";b:1;s:17:\"rank_math_sitemap\";b:1;s:21:\"rank_math_404_monitor\";b:1;s:22:\"rank_math_link_builder\";b:1;s:22:\"rank_math_redirections\";b:1;s:22:\"rank_math_role_manager\";b:1;s:19:\"rank_math_analytics\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:25:\"rank_math_onpage_advanced\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;s:20:\"rank_math_content_ai\";b:1;s:19:\"rank_math_admin_bar\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:23:\"rank_math_site_analysis\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:14:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:25:\"rank_math_onpage_analysis\";b:1;s:24:\"rank_math_onpage_general\";b:1;s:24:\"rank_math_onpage_snippet\";b:1;s:23:\"rank_math_onpage_social\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","auto"),
("103","fresh_site","0","off"),
("104","user_count","1","off"),
("105","widget_block","a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","auto"),
("106","sidebars_widgets","a:12:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:6:\"header\";a:0:{}s:8:\"footer-1\";a:0:{}s:8:\"footer-2\";a:0:{}s:8:\"footer-3\";a:0:{}s:8:\"footer-4\";a:0:{}s:8:\"footer-5\";a:0:{}s:10:\"footer-bar\";a:0:{}s:7:\"top-bar\";a:0:{}s:13:\"array_version\";i:3;}","auto"),
("107","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("108","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("109","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("110","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("111","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("112","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("113","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("114","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("115","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("116","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("117","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("118","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("119","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("120","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("125","recovery_keys","a:0:{}","off"),
("126","theme_mods_twentytwentyfour","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1723900006;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","off"),
("152","recently_activated","a:0:{}","off"),
("159","finished_updating_comment_type","1","auto"),
("163","edd_sl_9b4b9278ab03eed62e9ded0113d4678e","a:2:{s:7:\"timeout\";i:1723910780;s:5:\"value\";s:63070:\"{\"new_version\":\"2.4.1\",\"stable_version\":\"2.4.1\",\"name\":\"GP Premium\",\"slug\":\"gp-premium\",\"url\":\"https:\\/\\/generatepress.com\\/downloads\\/gp-premium\\/?changelog=1\",\"last_updated\":\"2024-08-12 01:32:57\",\"homepage\":\"https:\\/\\/generatepress.com\\/downloads\\/gp-premium\\/\",\"package\":\"\",\"download_link\":\"\",\"sections\":{\"description\":\"<p>The entire collection of GeneratePress premium modules. Once activated, each module extends certain aspects of GeneratePress, giving you more options to build your website.<\\/p>\\n<h4> Documentation <\\/h4>\\n<p>Check out our <a href=\\\"https:\\/\\/docs.generatepress.com\\\">documentation<\\/a> for more information on each module and how to use them.<\\/p>\",\"changelog\":\"<h4> 2.4.1 <\\/h4>\\n<ul>\\n<li>Security: Harden variable against XSS attacks<\\/li>\\n<\\/ul>\\n<h4> 2.4.0 <\\/h4>\\n<ul>\\n<li>Security: Disallow scripts in custom field template tags<\\/li>\\n<li>Important: Requires PHP 7.2 or greater<\\/li>\\n<li>Feature: Improve Site Library filters<\\/li>\\n<li>Feature: Add search capability in Site Library<\\/li>\\n<li>Feature: Allow author searching in Site Library<\\/li>\\n<li>Feature: Add <code>generate_smooth_scroll_offset<\\/code> filter<\\/li>\\n<li>Feature: Use built-in read more text filters<\\/li>\\n<li>Fix: PHP 8.1 notices<\\/li>\\n<li>Fix: Display posts in columns option changes Query Loop blocks<\\/li>\\n<li>Fix: Remove no-csstransforms3d CSS from off canvas panel<\\/li>\\n<li>Fix: Display Rules taxonomies missing when has_archive disabled<\\/li>\\n<li>Fix: Navigation logo undefined array keys<\\/li>\\n<li>Tweak: Update Content Template templates<\\/li>\\n<li>Tweak: Update Archive Navigation templates<\\/li>\\n<li>Tweak: Update Page Hero templates<\\/li>\\n<li>Tweak: Update post meta templates<\\/li>\\n<li>Tweak: Update post navigation templates<\\/li>\\n<li>Tweak: Update site footer templates<\\/li>\\n<li>Tweak: Remove deprecated filter_input functions<\\/li>\\n<li>General: Updated translations<\\/li>\\n<\\/ul>\\n<h4> 2.3.2 <\\/h4>\\n<ul>\\n<li>Tweak: Remove deprecated wp_get_loading_attr_default function<\\/li>\\n<\\/ul>\\n<h4> 2.3.1 <\\/h4>\\n<ul>\\n<li>Fix: SelectSearch component infinite loop<\\/li>\\n<li>Fix: Block widths inside Block Elements<\\/li>\\n<\\/ul>\\n<h4> 2.3.0 <\\/h4>\\n<ul>\\n<li>Feature: Add Search Modal Element type<\\/li>\\n<li>Fix: Inline post meta feature in GenerateBlocks 1.7<\\/li>\\n<li>Fix: Close \\\"Choose Element Type\\\" modal with ESC key<\\/li>\\n<li>Fix: Replace WooCommerce secondary image attachment size<\\/li>\\n<li>Fix: WP Filesystem error missing credentials<\\/li>\\n<li>Fix: Undefined array keys in dynamic Container URL<\\/li>\\n<li>Fix: Author avatar in Header\\/Block Element titles<\\/li>\\n<li>Fix: Infinite loop error when autosaving with dynamic content block<\\/li>\\n<li>Fix: Add aria-label to off-canvas panel button<\\/li>\\n<li>Fix: WooCommerce button dynamic typography<\\/li>\\n<li>Fix: Empty WooCommerce quantity fields<\\/li>\\n<li>Fix: PHP 8.1 notice using disable elements in Customizer<\\/li>\\n<li>Tweak: Improve license key area<\\/li>\\n<li>Tweak: Improve off-canvas transitions<\\/li>\\n<li>Tweak: Check for WooCommerce functions<\\/li>\\n<li>Tweak: Open off-canvas using space bar<\\/li>\\n<li>Tweak: Use image ID in mobile header\\/sticky nav logos<\\/li>\\n<li>Tweak: Improve Elements hook selection dropdown UI<\\/li>\\n<li>Tweak: Add site library check for min GenerateBlocks version<\\/li>\\n<li>Tweak: Add Loop Template to Custom Post Type dropdown filters<\\/li>\\n<\\/ul>\\n<h4> 2.2.2 <\\/h4>\\n<ul>\\n<li>Fix: Off Canvas anchor links not working<\\/li>\\n<\\/ul>\\n<h4> 2.2.1 <\\/h4>\\n<ul>\\n<li>Fix: Add value to off-canvas aria-hidden attribute<\\/li>\\n<li>Tweak: Remove\\/add aria-hidden to off-canvas on toggle<\\/li>\\n<\\/ul>\\n<h4> 2.2.0 <\\/h4>\\n<ul>\\n<li>Feature: Allow block element autosave<\\/li>\\n<li>Feature: Add revisions to block elements<\\/li>\\n<li>Feature: Add Loop Template block element<\\/li>\\n<li>Feature: Dont display the raw license key in the Dashboard<\\/li>\\n<li>Feature: Add \\\"Paginated Results\\\" to Element Display Rules<\\/li>\\n<li>Fix: Element post navigation template PHP warning when not using GB Pro<\\/li>\\n<li>Fix: Remove unnecessary zoom CSS from featured images<\\/li>\\n<li>Fix: Font icon CSS order<\\/li>\\n<li>Fix: Load more button showing in product tax archives<\\/li>\\n<li>Fix: Prevent tabbing in hidden off-canvas panel<\\/li>\\n<li>Fix: Hide hidden off-canvas panel from screen readers<\\/li>\\n<li>Fix: menu-toggle aria-controls when using off-canvas panel<\\/li>\\n<li>Fix: Focus first focusable element when opening off-canvas panel<\\/li>\\n<li>Fix: Focus slideout toggle when closing off-canvas panel<\\/li>\\n<li>Fix: Off-Canvas Panel sub-menu a11y<\\/li>\\n<li>Fix: Prevent secondary nav legacy typography CSS<\\/li>\\n<li>Fix: Fix dynamic term meta link<\\/li>\\n<li>Fix: Block margins in the block element editor<\\/li>\\n<li>Fix: Embeds in Block Elements<\\/li>\\n<li>Fix: Apply display rules to editor with no ID<\\/li>\\n<li>Fix: Navigation background image applying to secondary nav<\\/li>\\n<li>Fix: WooCommerce order received page float issue<\\/li>\\n<li>Fix: Block element editor error in GenerateBlocks 1.7<\\/li>\\n<li>Tweak: Remove jquery-migrate from sticky script<\\/li>\\n<li>Tweak: Add message in Blog section about Loop Template<\\/li>\\n<\\/ul>\\n<h4> 2.1.2 <\\/h4>\\n<ul>\\n<li>Elements: Fix custom field value in dynamic container links<\\/li>\\n<li>Elements: Fix block widths in the editor<\\/li>\\n<li>General: Fix double slashes in dashboard file request<\\/li>\\n<li>General: Fix missing Customizer translations<\\/li>\\n<\\/ul>\\n<h4> 2.1.1 <\\/h4>\\n<ul>\\n<li>Menu Plus: Fix mobile header sticky auto hide<\\/li>\\n<li>Site Library: Fix broken CSS variables on import<\\/li>\\n<\\/ul>\\n<h4> 2.1.0 <\\/h4>\\n<ul>\\n<li>Blog: Fix masonry JS error if no archive pagination exists<\\/li>\\n<li>Blog: Fix full width featured blog column<\\/li>\\n<li>Colors: Deprecate module if using GP 3.1.0<\\/li>\\n<li>Elements: Add custom class option to dynamic image block<\\/li>\\n<li>Elements: Add support for post_type array in display rules<\\/li>\\n<li>Elements: Fix container link option when targeting next\\/previous posts<\\/li>\\n<li>Menu Plus: Integrate off-canvas panel with new dynamic typography system<\\/li>\\n<li>Menu Plus: Integrate off-canvas panel with new color system<\\/li>\\n<li>Menu Plus: Integrate mobile header HTML attributes with new HTML attribute system<\\/li>\\n<li>Menu Plus: Integrate mobile header and off-canvas panel with new generate_has_active_menu filter<\\/li>\\n<li>Menu Plus: Fix broken inline CSS when using floated sticky navigation<\\/li>\\n<li>Menu Plus: Add logo dimensions to navigation logo<\\/li>\\n<li>Secondary Navigation: Integrate with new color system<\\/li>\\n<li>Secondary Navigation: Integrate with new generate_has_active_menu filter<\\/li>\\n<li>Secondary Navigation: Integrate with new dynamic typography system<\\/li>\\n<li>Secondary Navigation: Reduce box-shadow to match main navigation<\\/li>\\n<li>Secondary Navigation: Change direction of sub-menu box-shadow when opening left<\\/li>\\n<li>Secondary Navigation: Fix sub-menu overlap when using dropdown click\\/mobile<\\/li>\\n<li>Secondary Navigation: Replace box-shadow with border-bottom when sub-menu opens down<\\/li>\\n<li>Site Library: Add site author attribution<\\/li>\\n<li>Typography: Deprecate module if using dynamic typography in GP 3.1.0<\\/li>\\n<li>WooCommerce: Integrate with new dynamic typography system<\\/li>\\n<li>WooCommerce: Integrate with new colors system<\\/li>\\n<li>WooCommerce: Remove category title\\/description if using page hero with title disabled<\\/li>\\n<li>WooCommerce: Remove \\\"speak\\\" CSS properties<\\/li>\\n<li>WooCommerce: Fix empty continue shopping link on mobile<\\/li>\\n<li>WooCommerce: Fix persistent sticky add to cart panel<\\/li>\\n<li>General: Integrate with new GP 3.1.0 Dashboard<\\/li>\\n<li>General: Remove featured-image-active body class if featured image is disabled<\\/li>\\n<li>General: Change date format in exported JSON filename<\\/li>\\n<li>General: Fix PHP error when license key activation returns 403<\\/li>\\n<\\/ul>\\n<h4> 2.0.3 <\\/h4>\\n<ul>\\n<li>Elements: Use block_categories_all filter in WP 5.8<\\/li>\\n<li>Elements: Remove wp-editor dependency from new widget editor<\\/li>\\n<\\/ul>\\n<h4> 2.0.2 <\\/h4>\\n<ul>\\n<li>Elements: Use blog page title for dynamic title if set<\\/li>\\n<li>Spacing: Fix reset button bug in Customizer controls<\\/li>\\n<li>WooCommerce: Fix infinite scroll applying to product taxonomy pages<\\/li>\\n<\\/ul>\\n<h4> 2.0.1 <\\/h4>\\n<ul>\\n<li>Blog: Fix infinite scroll bug on product archives<\\/li>\\n<li>Elements: Fix error in WP 4.9.x versions<\\/li>\\n<li>Menu Plus: Prevent 0x0 logo dimension attributes if no dimensions exist<\\/li>\\n<li>Site Library: Add vertical scroll ability to the Site Library control area<\\/li>\\n<\\/ul>\\n<h4> 2.0.0 <\\/h4>\\n<ul>\\n<li>Blog: Rewrite infinite scroll using vanilla javascript<\\/li>\\n<li>Blog: Rewrite masonry using vanilla javascript<\\/li>\\n<li>Blog: Add separate infinite scroll path element to footer<\\/li>\\n<li>Blog: Fix missing single\\/page featured image options when archive image disabled<\\/li>\\n<li>Blog: Add aria-label instead of screen-reader-text to read more button<\\/li>\\n<li>Colors: Fix back to top Customizer color preview<\\/li>\\n<li>Elements: New Content Template Element<\\/li>\\n<li>Elements: New Post Meta Template Element<\\/li>\\n<li>Elements: New Post Navigation Template Element<\\/li>\\n<li>Elements: New Page Hero Block Element<\\/li>\\n<li>Elements: New Archive Navigation Template Element<\\/li>\\n<li>Elements: New Editor Width option in Block Elements<\\/li>\\n<li>Elements: Move Block Elements options into editor sidebar<\\/li>\\n<li>Elements: Show Site Header options by default in Header Element<\\/li>\\n<li>Elements: Fix Classic Editor issue in Block Elements<\\/li>\\n<li>Elements: Add a list of active Elements to page editor<\\/li>\\n<li>Elements: Add a list of active Elements to the admin bar<\\/li>\\n<li>Elements: Add notices to Customizer if Elements may be overwriting options<\\/li>\\n<li>Elements: Disable mobile header menu if menu is disabled via Layout Element<\\/li>\\n<li>Elements: Improve Display Rule loading performance<\\/li>\\n<li>Elements: Add block type filter to Elements dashboard<\\/li>\\n<li>Elements: Add generate_element_display filter<\\/li>\\n<li>Elements: Add No Results as a Display Rule condition<\\/li>\\n<li>Menu Plus: Hide slideout toggle at set mobile menu breakpoint value<\\/li>\\n<li>Menu Plus: Fix sticky menu height when using navigation as header<\\/li>\\n<li>Menu Plus: Add dimensions to mobile\\/sticky logos<\\/li>\\n<li>Menu Plus: Make Off-Canvas menu take up full width of canvas<\\/li>\\n<li>Menu Plus: Fix menu bar item sticky transition<\\/li>\\n<li>Menu Plus: Prevent sticky sidebar nav if mobile header is set to sticky<\\/li>\\n<li>Secondary Nav: Fix centered secondary navigation items using flexbox<\\/li>\\n<li>Secondary Nav: Fix conflict with Nav as Header option<\\/li>\\n<li>Secondary Nav: Fix missing menu cart items when using click dropdowns<\\/li>\\n<li>Sections: Officially deprecate module<\\/li>\\n<li>Site Library: Completely rebuild Site Library using React<\\/li>\\n<li>WooCommerce: Move full width single product CSS to inline CSS<\\/li>\\n<li>WooCommerce: Use wc_get_product() instead of new WC_Product()<\\/li>\\n<li>WooCommerce: Add more checks for WC() class to prevent error logs<\\/li>\\n<li>WooCommerce: Add generate_wc_cart_panel_checkout_button_output filter<\\/li>\\n<li>WooCommerce: Add generate_wc_sticky_add_to_cart_action filter<\\/li>\\n<li>WooCommerce: Add generate_wc_show_sticky_add_to_cart filter<\\/li>\\n<li>WooCommerce: Re-write quantity button javascript to be more performant\\/extendable<\\/li>\\n<li>General: Update theme install link<\\/li>\\n<li>General: Update alpha color picker script<\\/li>\\n<li>General: Use correct URL scheme in external stylesheet URLs<\\/li>\\n<li>General: Check if FS_CHMOD_FILE is defined in external stylesheet generation<\\/li>\\n<li>General: Use inline CSS when using AMP plugin<\\/li>\\n<li>General: Update EDD_SL_Plugin_Updater class to 1.8.0<\\/li>\\n<li>General: Clean up javascript throughout plugin<\\/li>\\n<li>General: Replace deprecated jQuery functions<\\/li>\\n<\\/ul>\\n<h4> 1.12.3 <\\/h4>\\n<ul>\\n<li>WooCommerce: Fix quantity buttons in WP 5.6<\\/li>\\n<\\/ul>\\n<h4> 1.12.2 <\\/h4>\\n<ul>\\n<li>Blog: Load columns CSS when using filter to enable it anywhere<\\/li>\\n<li>Menu Plus: Fix sticky mobile header jump when using inline mobile toggle<\\/li>\\n<li>Menu Plus: Add margin to sticky nav branding when set to full width<\\/li>\\n<li>Menu Plus: Disable sticky nav container text align padding<\\/li>\\n<li>Menu Plus: Make mobile menu absolute only when smooth scroll is enabled<\\/li>\\n<li>Menu Plus: Improve nav as header\\/mobile header when using flexbox<\\/li>\\n<li>Menu Plus: Prevent off-canvas panel close button from flashing visible when closing<\\/li>\\n<li>Spacing: Fix custom nav search height<\\/li>\\n<\\/ul>\\n<h4> 1.12.1 <\\/h4>\\n<ul>\\n<li>Typography: Fix missing heading font size controls in the Customizer<\\/li>\\n<\\/ul>\\n<h4> 1.12.0 <\\/h4>\\n<ul>\\n<li>Blog: Fix column margin on mobile with some caching plugins<\\/li>\\n<li>Blog: Add post-load trigger to infinite scroll for better plugin compatibility<\\/li>\\n<li>Blog: Take generate_blog_columns filter into account when loading columns CSS<\\/li>\\n<li>Colors: Add search menu-bar-item color live preview to Customizer<\\/li>\\n<li>Elements: Fix broken custom hook field in Block Elements<\\/li>\\n<li>Elements: Integrate page hero with text container alignment in GP 3.0<\\/li>\\n<li>Elements: Better integrate Header Element colors with GP 3.0<\\/li>\\n<li>Elements: Only disable content title when {{post_title}} is present on single pages<\\/li>\\n<li>Elements: Fix  tag in metabox<\\/li>\\n<li>Elements: Add generate_elements_metabox_ajax_allow_editors filter<\\/li>\\n<li>Elements: Add new 3.0 hooks to hook selector<\\/li>\\n<li>Elements: Re-add generate_elements_custom_args filter<\\/li>\\n<li>Menu Plus: Better prepare navigation as header for GP 3.0<\\/li>\\n<li>Menu Plus: Better prepare Off-Canvas Panel for GP 3.0<\\/li>\\n<li>Menu Plus: Better prepare sticky navigation for GP 3.0<\\/li>\\n<li>Menu Plus: Add has-menu-bar-items class to mobile header if needed<\\/li>\\n<li>Menu Plus: Add is-logo-image class to all site logos<\\/li>\\n<li>Menu Plus: Fix mobile header alignment when it has menu bar items<\\/li>\\n<li>Secondary Nav: Better prepare sticky navigation for GP 3.0<\\/li>\\n<li>Secondary Nav: Fix hidden navigation widget in top bar when merged with secondary nav<\\/li>\\n<li>Sites: Improve the option-only import feature<\\/li>\\n<li>Sites: Improve the refresh sites button functionality<\\/li>\\n<li>Sites: Improve the undo site import functionality<\\/li>\\n<li>Sites: Fix Elementor site import issues<\\/li>\\n<li>Sites: Re-add Elementor sites to library<\\/li>\\n<li>Spacing: Better prepare Customizer live preview for GP 3.0<\\/li>\\n<li>Spacing: Fix blog column spacing Customizer live preview<\\/li>\\n<li>Spacing: Stop handling mobile header, widget and footer widget features added in GP 3.0<\\/li>\\n<li>Typography: Add mobile font size control for H3 (when using GP 3.0)<\\/li>\\n<li>Typography: Add mobile font size control for H4 (when using GP 3.0)<\\/li>\\n<li>Typography: Add mobile font size control for H5 (when using GP 3.0)<\\/li>\\n<li>Typography: Allow empty tablet and mobile site title font size values<\\/li>\\n<li>Typography: Make menu toggle CSS selector specific to primary navigation<\\/li>\\n<li>WooCommerce: Use CSS for secondary product image functionality instead of JS<\\/li>\\n<li>WooCommerce: Only load .js file if needed<\\/li>\\n<li>WooCommerce: Fix quantity box functionality when multiple quantity boxes exist on the page<\\/li>\\n<li>General: Improve alpha color picker script for better 5.5 compatibility<\\/li>\\n<li>General: Move child theme stylesheet after dynamic stylesheet if enabled<\\/li>\\n<li>General: Update gp-premium-de_DE.mo<\\/li>\\n<li>General: Update gp-premium-es_ES.mo<\\/li>\\n<li>General: Update gp-premium-fi.mo<\\/li>\\n<li>General: Update gp-premium-pt_PT.mo<\\/li>\\n<li>General: Update gp-premium-sv_SE.mo<\\/li>\\n<\\/ul>\\n<h4> 1.11.3 <\\/h4>\\n<ul>\\n<li>Blog: Set widths to grid-sizer element<\\/li>\\n<li>Elements: Fix legacy Page Header\\/Hooks buttons in the Elements dashboard<\\/li>\\n<li>Page Header: Replace .load() with .on(\'load\')<\\/li>\\n<li>Page Header: Fix color picker error in WP 5.5<\\/li>\\n<\\/ul>\\n<h4> 1.11.2 <\\/h4>\\n<ul>\\n<li>Blog: Remove negative featured image top margin from columns when using one container<\\/li>\\n<li>Blog: Fix infinite scroll items loading above viewport when using columns<\\/li>\\n<li>Blog: Fix infinite scroll featured images not displaying in Safari<\\/li>\\n<li>Elements: Prevent error in editor when generate_get_option() function doesn\'t exist<\\/li>\\n<li>General: Load inline CSS in previews when using external CSS option<\\/li>\\n<li>General: Update gp-premium-es_ES.mo<\\/li>\\n<li>General: Update gp-premium-pt_PT.mo<\\/li>\\n<\\/ul>\\n<h4> 1.11.1 <\\/h4>\\n<ul>\\n<li>Elements: Remove stray quote character in Layout Element metabox<\\/li>\\n<li>Sections: Fix color picker JS error in WP 5.5<\\/li>\\n<li>General: Fix external CSS option not removing inline CSS in some cases<\\/li>\\n<\\/ul>\\n<h4> 1.11.0 <\\/h4>\\n<ul>\\n<li>New: Block Elements<\\/li>\\n<li>New: Apply Layout Element options to the block editor if set<\\/li>\\n<li>New: Generate dynamic CSS in an external file<\\/li>\\n<li>Blog: Separate CSS and load only when needed<\\/li>\\n<li>Blog: Add column width classes to stylesheet<\\/li>\\n<li>Blog: Disable featured image itemprop if microdata is disabled<\\/li>\\n<li>Blog: Add generate_blog_masonry_init filter<\\/li>\\n<li>Blog: Add generate_blog_infinite_scroll_init filter<\\/li>\\n<li>Blog: Fix archive page header overlap when using no featured image padding\\/one container<\\/li>\\n<li>Blog: Replace screen reader text with aria-label in read more buttons<\\/li>\\n<li>Disable Elements: Add option to disable the Mobile Header<\\/li>\\n<li>Disable Elements: Disable top bar disables it even when combined with Secondary Nav<\\/li>\\n<li>Disable Elements: Use generate_show_post_navigation filter to disable single post navigation<\\/li>\\n<li>Elements: Use full hook name with generate_ prefix in dropdown<\\/li>\\n<li>Elements: Rebuild how Element types are chosen<\\/li>\\n<li>Elements: Add chosen hook under type column in edit.php<\\/li>\\n<li>Menu Plus: Add generate_after_mobile_header_menu_button filter<\\/li>\\n<li>Menu Plus: Add sticky placeholder only when nav becomes sticky<\\/li>\\n<li>Menu Plus: Add class to sticky nav when scrolling up<\\/li>\\n<li>Menu Plus: Fix navigation branding\\/mobile header layout when using RTL languages<\\/li>\\n<li>Page Header: Prevent PHP notices<\\/li>\\n<li>Secondary Nav: Clean up CSS<\\/li>\\n<li>Secondary Nav: Add generate_after_secondary_navigation hook<\\/li>\\n<li>Secondary Nav: Add generate_before_secondary_navigation hook<\\/li>\\n<li>Secondary Nav: Integrate with future flexbox option<\\/li>\\n<li>Secondary Nav: Add has-top-bar class if needed<\\/li>\\n<li>Secondary Nav: Add screen reader text to mobile menu toggle if no text exists<\\/li>\\n<li>Secondary Nav: Remove microdata if disabled<\\/li>\\n<li>Secondary Nav: Add generate_secondary_menu_bar_items hook<\\/li>\\n<li>Spacing: Set sidebar width in Customizer for future flexbox option<\\/li>\\n<li>WooCommerce: Add generate_woocommerce_show_add_to_cart_panel filter<\\/li>\\n<li>WooCommerce: Integrate with future flexbox option<\\/li>\\n<li>WooCommerce: Ensure WC()-&gt;cart is set<\\/li>\\n<li>WooCommerce: Remove left margin from SVG menu cart icon<\\/li>\\n<li>WooCommerce: Show sticky add to cart panel on sold individually products<\\/li>\\n<li>WooCommerce: Remove bottom margin from related\\/upsell products<\\/li>\\n<li>WooCommerce: Fix cart menu item spacing in RTL languages<\\/li>\\n<li>WooCommerce: Fix menu item cart dropdown design in RTL languages<\\/li>\\n<li>General: Update selectWoo<\\/li>\\n<li>General: Update select2<\\/li>\\n<li>General: Run all CSS through PostCSS<\\/li>\\n<li>General: Fix various text domains<\\/li>\\n<li>General: Fix JS error when toggling nav as header option without Colors\\/Typography modules<\\/li>\\n<li>General: Update all translations over 90% complete<\\/li>\\n<li>General: PHP cleanup\\/coding standards<\\/li>\\n<li>General: Add off_canvas_desktop_toggle_label to wpml-config.xml<\\/li>\\n<\\/ul>\\n<h4> 1.10.0 <\\/h4>\\n<ul>\\n<li>Blog: Remove existing on-the-fly featured image resizer (Image Processing Queue)<\\/li>\\n<li>Blog: Choose from existing image sizes for featured images<\\/li>\\n<li>Blog: Use CSS to further resize featured images if necessary<\\/li>\\n<li>Blog: Fix edge case persistent transient bug with old image resizer<\\/li>\\n<li>Elements: Fix broken closing element in metabox<\\/li>\\n<li>General: Change scroll variable to gpscroll in smooth scroll script to avoid conflicts<\\/li>\\n<li>General: Update responsive widths in Customizer<\\/li>\\n<li>General: Fix responsive Customizer views when using RTL<\\/li>\\n<li>Menu Plus: Don\'t output sticky nav branding if sticky nav is disabled<\\/li>\\n<li>Menu Plus: Fix focus when off canvas overlay is opened (a11y)<\\/li>\\n<li>Menu Plus: Fix sticky navigation jump when navigation branding is in use<\\/li>\\n<li>Sections: Fix visible block editor when Sections are enabled<\\/li>\\n<li>WooCommerce: Use minmax in grid template definitions to fix overflow issue<\\/li>\\n<li>WooCommerce: Prevent add to cart panel interfering with back to top button on mobile<\\/li>\\n<li>WooCommerce: WooCommerce: Fix secondary image position if HTML isn\'t ordered correctly<\\/li>\\n<li>General: Add\\/update all translations over 50% complete. Big thanks to all contributors!<\\/li>\\n<li>Translation: Added Arabic - thank you anass!<\\/li>\\n<li>Translation: Added Bengali - thank you gtmroy!<\\/li>\\n<li>Translation: Added Spanish (Spain) - thank you davidperez (closemarketing.es)!<\\/li>\\n<li>Translation: Added Spanish (Argentina) - thank you bratorr!<\\/li>\\n<li>Translation: Added Finnish - thank you Stedi!<\\/li>\\n<li>Translation: Add Dutch - thank you Robin!<\\/li>\\n<li>Translation: Added Ukrainian - thank you EUROMEDIA!<\\/li>\\n<li>Translation: Vietnamese added - thank you themevi!<\\/li>\\n<\\/ul>\\n<h4> 1.9.1 <\\/h4>\\n<ul>\\n<li>Blog: Fix \\\"null\\\" in infinite scroll load more button text<\\/li>\\n<li>WooCommerce: Fix hidden added to cart panel on mobile when sticky nav active<\\/li>\\n<li>WooCommerce: Fix missing SVG icon in mobile added to cart panel<\\/li>\\n<\\/ul>\\n<h4> 1.9.0 <\\/h4>\\n<ul>\\n<li>Blog: Support SVG icon feature<\\/li>\\n<li>Colors: Add navigation search color options<\\/li>\\n<li>Disable Elements: Disable mobile menu in Mobile Header if nav is disabled<\\/li>\\n<li>Elements: Add wp_body_open hook<\\/li>\\n<li>Elements: Allow 0 mobile padding in Elements<\\/li>\\n<li>Elements: Add generate_elements_admin_menu_capability filter<\\/li>\\n<li>Elements: Add generate_page_hero_css_output filter<\\/li>\\n<li>Elements: Prevent error in Header Element if taxonomy doesn\'t exist<\\/li>\\n<li>Elements: Fix double logo when Header Element has logo + using nav as header<\\/li>\\n<li>Elements: Fix mobile header logo not replacing if merge is disabled<\\/li>\\n<li>Elements: Fix missing arrow in Choose Element Type select in WP 5.3<\\/li>\\n<li>Elements: Add generate_inside_site_container hook option<\\/li>\\n<li>Elements: Add generate_after_entry_content hook option<\\/li>\\n<li>Menu Plus: Add off canvas desktop toggle label option<\\/li>\\n<li>Menu Plus: Add generate_off_canvas_toggle_output filter<\\/li>\\n<li>Menu Plus: Support SVG icon feature<\\/li>\\n<li>Menu Plus: Fix sticky navigation overlapping BB controls<\\/li>\\n<li>Menu Plus: Add align-items: center to nav as header, mobile header and sticky nav with branding<\\/li>\\n<li>Sections: Fix text\\/visual switch bug in Firefox<\\/li>\\n<li>Sites: Add option to revert site import<\\/li>\\n<li>Sites: Increase site library limit to 100<\\/li>\\n<li>Spacing: Add live preview to group container padding<\\/li>\\n<li>Typography: Add tablet site title\\/navigation font size options<\\/li>\\n<li>Typography: Add archive post title weight, transform, font size and line height<\\/li>\\n<li>Typography: Add single content title weight, transform, font size and line height<\\/li>\\n<li>Typography: Only call all google fonts once in the Customizer<\\/li>\\n<li>Typography: Get Google fonts from readable JSON list<\\/li>\\n<li>Typography: Make sure font settings aren\'t lost if list is changed<\\/li>\\n<li>Typography: Only call generate_get_all_google_fonts if needed<\\/li>\\n<li>WooCommerce: Add columns gap options (desktop, tablet, mobile)<\\/li>\\n<li>WooCommerce: Add tablet column options<\\/li>\\n<li>WooCommerce: Add related\\/upsell tablet column options<\\/li>\\n<li>WooCommerce: Support SVG icon feature<\\/li>\\n<li>WooCommerce: Prevent empty added to cart panel on single products<\\/li>\\n<li>WooCommerce: Fix woocommerce-ordering arrow in old FF versions<\\/li>\\n<li>WooCommerce: Make item\\/items string translatable<\\/li>\\n<li>General: Better customizer device widths<\\/li>\\n<li>General: Use generate_premium_get_media_query throughout modules<\\/li>\\n<li>General: Improve Customizer control styling<\\/li>\\n<\\/ul>\\n<h4> 1.8.3 <\\/h4>\\n<ul>\\n<li>Menu Plus: Use flexbox for center aligned nav with nav branding<\\/li>\\n<li>Menu Plus: Center overlay off canvas exit button on mobile<\\/li>\\n<li>Menu Plus: Add alt tag to sticky nav logo<\\/li>\\n<li>Menu Plus: Set generate_not_mobile_menu_media_query filter based on mobile menu breakpoint<\\/li>\\n<li>Sections: Remember when text tab is active<\\/li>\\n<li>Sections: Disable visual editor if turned off in profile<\\/li>\\n<li>Typography: Add generate_google_font_display filter<\\/li>\\n<li>WooCommerce: Fix single product sidebar layout metabox option<\\/li>\\n<li>WooCommerce: Reduce carousel thumbnail max-width to 100px to match new thumbnail sizes<\\/li>\\n<\\/ul>\\n<h4> 1.8.2 <\\/h4>\\n<ul>\\n<li>Elements: Use Page Hero site title color for mobile header site title<\\/li>\\n<li>Menu Plus: Give mobile header site title more left spacing<\\/li>\\n<li>Menu Plus: Fix nav search icon in sticky navigation when using nav branding in Firefox<\\/li>\\n<li>Site Library: Show Site Library tab even if no sites exist<\\/li>\\n<li>Site Library: Show an error message in Site Library if no sites exist<\\/li>\\n<li>Typography: Remove reference to generate_get_navigation_location() function<\\/li>\\n<li>WooCommerce: Remove quantity field arrows when using quantity buttons in Firefox<\\/li>\\n<li>WooCommerce: Remove extra border when loading quantity buttons<\\/li>\\n<li>WooCommerce: Use get_price_html() is sticky add to cart panel<\\/li>\\n<\\/ul>\\n<h4> 1.8.1 <\\/h4>\\n<ul>\\n<li>Menu Plus: Revert sticky nav duplicate ID fix due to Cyrillic script bug<\\/li>\\n<\\/ul>\\n<h4> 1.8 <\\/h4>\\n<ul>\\n<li>Blog: Apply columns filter to masonry grid sizer<\\/li>\\n<li>Colors: Merge Footer Widgets and Footer controls in Color panel<\\/li>\\n<li>Colors: Remove edit_theme_options capability to Customizer controls (set by default)<\\/li>\\n<li>Disable Elements: Make sure mobile header is disabled when primary navigation is disabled<\\/li>\\n<li>Elements: Add content width option in Layout Element<\\/li>\\n<li>Elements: Fix mobile header logo when mobile menu toggled<\\/li>\\n<li>Elements: Add generate_page_hero_location filter<\\/li>\\n<li>Elements: Add generate_elements_show_object_ids filter to show IDs in Display Rule values<\\/li>\\n<li>Elements: Prevent merged header wrap from conflicting with Elementor controls<\\/li>\\n<li>Elements: Change Container tab name to Content<\\/li>\\n<li>Elements: Add woocommerce_share option to Hooks<\\/li>\\n<li>Elements: Improve WPML compatibility<\\/li>\\n<li>Elements: Improve Polylang compatibility<\\/li>\\n<li>Elements: Prevent PHP notices when adding taxonomy locations to non-existent archives<\\/li>\\n<li>Elements: Add generate_mobile_cart_items hook to hook list<\\/li>\\n<li>Elements: Add generate_element_post_id filter<\\/li>\\n<li>Elements: Escape HTML elements inside Element textarea<\\/li>\\n<li>Elements: Add Beaver Builder templates to the Display Rules<\\/li>\\n<li>Menu Plus: Add mobile header breakpoint option<\\/li>\\n<li>Menu Plus: Add off canvas overlay option<\\/li>\\n<li>Menu Plus: Add navigation as header option<\\/li>\\n<li>Menu Plus: Remove navigation logo option if navigation as header set<\\/li>\\n<li>Menu Plus: Add sticky navigation logo option<\\/li>\\n<li>Menu Plus: Allow site title in mobile header instead of logo<\\/li>\\n<li>Menu Plus: Add option to move exit button inside the off canvas panel<\\/li>\\n<li>Menu Plus: Change Slideout Navigation name to Off Canvas Panel<\\/li>\\n<li>Menu Plus: Only re-focus after slideout close on escape key<\\/li>\\n<li>Menu Plus: Give close slideout event a name so it can be removed<\\/li>\\n<li>Menu Plus: Remove invalid transition-delay<\\/li>\\n<li>Menu Plus: Improve slideout overlay transition<\\/li>\\n<li>Menu Plus: Add mobile open\\/close icons to GPP font<\\/li>\\n<li>Menu Plus: Allow dynamic widget classes in off canvas panel (fixes WC range slider widget issue)<\\/li>\\n<li>Menu Plus: Basic compatibility with future SVG icons<\\/li>\\n<li>Menu Plus: Prevent duplicate IDs when sticky navigation is cloned<\\/li>\\n<li>Secondary Nav: Add dropdown direction option<\\/li>\\n<li>Secondary Nav: Basic compatibility with future SVG icons<\\/li>\\n<li>Sections: Fix section editor issues in WP 5.0<\\/li>\\n<li>Sections: Show Better Font Awesome icon in editor<\\/li>\\n<li>Sites: Re-design UI<\\/li>\\n<li>Sites: Add option to activate as a module like all the other modules<\\/li>\\n<li>Sites: Don\'t show backup options button if no options exist<\\/li>\\n<li>Sites: Make JS action classes more specific to the site library<\\/li>\\n<li>Sites: Set mime types of content.xml and widgets.wie<\\/li>\\n<li>Spacing: Add header padding option for mobile<\\/li>\\n<li>Spacing: Add widget padding option for mobile<\\/li>\\n<li>Spacing: Add footer widgets padding option for mobile<\\/li>\\n<li>Spacing: Add content separator option<\\/li>\\n<li>Spacing: Apply mobile menu item width to mobile bar only<\\/li>\\n<li>WooCommerce: Add option for mini cart in the menu<\\/li>\\n<li>WooCommerce: Add option to open off overlay panel on add to cart<\\/li>\\n<li>WooCommerce: Add option to open sticky add to cart panel on single products<\\/li>\\n<li>WooCommerce: Add option to add +\\/- buttons to the quantity fields<\\/li>\\n<li>WooCommerce: Add option to show number of items in cart menu item<\\/li>\\n<li>WooCommerce: Add option to choose single product image area width<\\/li>\\n<li>WooCommerce: Add color options for price slider widget<\\/li>\\n<li>WooCommerce: Use CSS grid for the product archives<\\/li>\\n<li>WooCommerce: Horizontally align add to cart buttons<\\/li>\\n<li>WooCommerce: Re-design the cart widget<\\/li>\\n<li>WooCommerce: Tighten up product info spacing<\\/li>\\n<li>WooCommerce: Improve product tab design to look more like tabs<\\/li>\\n<li>WooCommerce: Simplify single product image display<\\/li>\\n<li>WooCommerce: Use flexbox for quantity\\/add to cart alignment<\\/li>\\n<li>WooCommerce: Improve rating star styles<\\/li>\\n<li>WooCommerce: Use product alignment setting for related\\/upsell products<\\/li>\\n<li>WooCommerce: Remove bottom margin from product image<\\/li>\\n<li>WooCommerce: Organize colors in the Customizer<\\/li>\\n<li>WooCommerce: Remove title attribute from menu cart item<\\/li>\\n<li>WooCommerce: Improve coupon field design<\\/li>\\n<li>WooCommerce: Improve result count\\/ordering styling<\\/li>\\n<li>WooCommerce: Add gap around WC single product images<\\/li>\\n<li>WooCommerce: Remove arrow from checkout button<\\/li>\\n<li>WooCommerce: Hide view cart link on add to cart click<\\/li>\\n<li>WooCommerce: Organize CSS<\\/li>\\n<li>Introduce in-Customizer shortcuts<\\/li>\\n<li>Add generate_disable_customizer_shortcuts filter<\\/li>\\n<\\/ul>\"},\"banners\":{\"high\":\"\",\"low\":\"\"},\"icons\":{\"1x\":\"https:\\/\\/generatepress.com\\/wp-content\\/uploads\\/edd\\/2020\\/05\\/icon-128x128.png\",\"2x\":\"https:\\/\\/generatepress.com\\/wp-content\\/uploads\\/edd\\/2020\\/05\\/icon-256x256.png\"},\"msg\":\"No license key has been provided.\",\"stable_tag\":\"2.4.1\",\"tested\":\"6.6.1\",\"description\":[\"<p>The entire collection of GeneratePress premium modules. Once activated, each module extends certain aspects of GeneratePress, giving you more options to build your website.<\\/p>\\n<h4> Documentation <\\/h4>\\n<p>Check out our <a href=\\\"https:\\/\\/docs.generatepress.com\\\">documentation<\\/a> for more information on each module and how to use them.<\\/p>\"],\"changelog\":[\"<h4> 2.4.1 <\\/h4>\\n<ul>\\n<li>Security: Harden variable against XSS attacks<\\/li>\\n<\\/ul>\\n<h4> 2.4.0 <\\/h4>\\n<ul>\\n<li>Security: Disallow scripts in custom field template tags<\\/li>\\n<li>Important: Requires PHP 7.2 or greater<\\/li>\\n<li>Feature: Improve Site Library filters<\\/li>\\n<li>Feature: Add search capability in Site Library<\\/li>\\n<li>Feature: Allow author searching in Site Library<\\/li>\\n<li>Feature: Add <code>generate_smooth_scroll_offset<\\/code> filter<\\/li>\\n<li>Feature: Use built-in read more text filters<\\/li>\\n<li>Fix: PHP 8.1 notices<\\/li>\\n<li>Fix: Display posts in columns option changes Query Loop blocks<\\/li>\\n<li>Fix: Remove no-csstransforms3d CSS from off canvas panel<\\/li>\\n<li>Fix: Display Rules taxonomies missing when has_archive disabled<\\/li>\\n<li>Fix: Navigation logo undefined array keys<\\/li>\\n<li>Tweak: Update Content Template templates<\\/li>\\n<li>Tweak: Update Archive Navigation templates<\\/li>\\n<li>Tweak: Update Page Hero templates<\\/li>\\n<li>Tweak: Update post meta templates<\\/li>\\n<li>Tweak: Update post navigation templates<\\/li>\\n<li>Tweak: Update site footer templates<\\/li>\\n<li>Tweak: Remove deprecated filter_input functions<\\/li>\\n<li>General: Updated translations<\\/li>\\n<\\/ul>\\n<h4> 2.3.2 <\\/h4>\\n<ul>\\n<li>Tweak: Remove deprecated wp_get_loading_attr_default function<\\/li>\\n<\\/ul>\\n<h4> 2.3.1 <\\/h4>\\n<ul>\\n<li>Fix: SelectSearch component infinite loop<\\/li>\\n<li>Fix: Block widths inside Block Elements<\\/li>\\n<\\/ul>\\n<h4> 2.3.0 <\\/h4>\\n<ul>\\n<li>Feature: Add Search Modal Element type<\\/li>\\n<li>Fix: Inline post meta feature in GenerateBlocks 1.7<\\/li>\\n<li>Fix: Close \\\"Choose Element Type\\\" modal with ESC key<\\/li>\\n<li>Fix: Replace WooCommerce secondary image attachment size<\\/li>\\n<li>Fix: WP Filesystem error missing credentials<\\/li>\\n<li>Fix: Undefined array keys in dynamic Container URL<\\/li>\\n<li>Fix: Author avatar in Header\\/Block Element titles<\\/li>\\n<li>Fix: Infinite loop error when autosaving with dynamic content block<\\/li>\\n<li>Fix: Add aria-label to off-canvas panel button<\\/li>\\n<li>Fix: WooCommerce button dynamic typography<\\/li>\\n<li>Fix: Empty WooCommerce quantity fields<\\/li>\\n<li>Fix: PHP 8.1 notice using disable elements in Customizer<\\/li>\\n<li>Tweak: Improve license key area<\\/li>\\n<li>Tweak: Improve off-canvas transitions<\\/li>\\n<li>Tweak: Check for WooCommerce functions<\\/li>\\n<li>Tweak: Open off-canvas using space bar<\\/li>\\n<li>Tweak: Use image ID in mobile header\\/sticky nav logos<\\/li>\\n<li>Tweak: Improve Elements hook selection dropdown UI<\\/li>\\n<li>Tweak: Add site library check for min GenerateBlocks version<\\/li>\\n<li>Tweak: Add Loop Template to Custom Post Type dropdown filters<\\/li>\\n<\\/ul>\\n<h4> 2.2.2 <\\/h4>\\n<ul>\\n<li>Fix: Off Canvas anchor links not working<\\/li>\\n<\\/ul>\\n<h4> 2.2.1 <\\/h4>\\n<ul>\\n<li>Fix: Add value to off-canvas aria-hidden attribute<\\/li>\\n<li>Tweak: Remove\\/add aria-hidden to off-canvas on toggle<\\/li>\\n<\\/ul>\\n<h4> 2.2.0 <\\/h4>\\n<ul>\\n<li>Feature: Allow block element autosave<\\/li>\\n<li>Feature: Add revisions to block elements<\\/li>\\n<li>Feature: Add Loop Template block element<\\/li>\\n<li>Feature: Dont display the raw license key in the Dashboard<\\/li>\\n<li>Feature: Add \\\"Paginated Results\\\" to Element Display Rules<\\/li>\\n<li>Fix: Element post navigation template PHP warning when not using GB Pro<\\/li>\\n<li>Fix: Remove unnecessary zoom CSS from featured images<\\/li>\\n<li>Fix: Font icon CSS order<\\/li>\\n<li>Fix: Load more button showing in product tax archives<\\/li>\\n<li>Fix: Prevent tabbing in hidden off-canvas panel<\\/li>\\n<li>Fix: Hide hidden off-canvas panel from screen readers<\\/li>\\n<li>Fix: menu-toggle aria-controls when using off-canvas panel<\\/li>\\n<li>Fix: Focus first focusable element when opening off-canvas panel<\\/li>\\n<li>Fix: Focus slideout toggle when closing off-canvas panel<\\/li>\\n<li>Fix: Off-Canvas Panel sub-menu a11y<\\/li>\\n<li>Fix: Prevent secondary nav legacy typography CSS<\\/li>\\n<li>Fix: Fix dynamic term meta link<\\/li>\\n<li>Fix: Block margins in the block element editor<\\/li>\\n<li>Fix: Embeds in Block Elements<\\/li>\\n<li>Fix: Apply display rules to editor with no ID<\\/li>\\n<li>Fix: Navigation background image applying to secondary nav<\\/li>\\n<li>Fix: WooCommerce order received page float issue<\\/li>\\n<li>Fix: Block element editor error in GenerateBlocks 1.7<\\/li>\\n<li>Tweak: Remove jquery-migrate from sticky script<\\/li>\\n<li>Tweak: Add message in Blog section about Loop Template<\\/li>\\n<\\/ul>\\n<h4> 2.1.2 <\\/h4>\\n<ul>\\n<li>Elements: Fix custom field value in dynamic container links<\\/li>\\n<li>Elements: Fix block widths in the editor<\\/li>\\n<li>General: Fix double slashes in dashboard file request<\\/li>\\n<li>General: Fix missing Customizer translations<\\/li>\\n<\\/ul>\\n<h4> 2.1.1 <\\/h4>\\n<ul>\\n<li>Menu Plus: Fix mobile header sticky auto hide<\\/li>\\n<li>Site Library: Fix broken CSS variables on import<\\/li>\\n<\\/ul>\\n<h4> 2.1.0 <\\/h4>\\n<ul>\\n<li>Blog: Fix masonry JS error if no archive pagination exists<\\/li>\\n<li>Blog: Fix full width featured blog column<\\/li>\\n<li>Colors: Deprecate module if using GP 3.1.0<\\/li>\\n<li>Elements: Add custom class option to dynamic image block<\\/li>\\n<li>Elements: Add support for post_type array in display rules<\\/li>\\n<li>Elements: Fix container link option when targeting next\\/previous posts<\\/li>\\n<li>Menu Plus: Integrate off-canvas panel with new dynamic typography system<\\/li>\\n<li>Menu Plus: Integrate off-canvas panel with new color system<\\/li>\\n<li>Menu Plus: Integrate mobile header HTML attributes with new HTML attribute system<\\/li>\\n<li>Menu Plus: Integrate mobile header and off-canvas panel with new generate_has_active_menu filter<\\/li>\\n<li>Menu Plus: Fix broken inline CSS when using floated sticky navigation<\\/li>\\n<li>Menu Plus: Add logo dimensions to navigation logo<\\/li>\\n<li>Secondary Navigation: Integrate with new color system<\\/li>\\n<li>Secondary Navigation: Integrate with new generate_has_active_menu filter<\\/li>\\n<li>Secondary Navigation: Integrate with new dynamic typography system<\\/li>\\n<li>Secondary Navigation: Reduce box-shadow to match main navigation<\\/li>\\n<li>Secondary Navigation: Change direction of sub-menu box-shadow when opening left<\\/li>\\n<li>Secondary Navigation: Fix sub-menu overlap when using dropdown click\\/mobile<\\/li>\\n<li>Secondary Navigation: Replace box-shadow with border-bottom when sub-menu opens down<\\/li>\\n<li>Site Library: Add site author attribution<\\/li>\\n<li>Typography: Deprecate module if using dynamic typography in GP 3.1.0<\\/li>\\n<li>WooCommerce: Integrate with new dynamic typography system<\\/li>\\n<li>WooCommerce: Integrate with new colors system<\\/li>\\n<li>WooCommerce: Remove category title\\/description if using page hero with title disabled<\\/li>\\n<li>WooCommerce: Remove \\\"speak\\\" CSS properties<\\/li>\\n<li>WooCommerce: Fix empty continue shopping link on mobile<\\/li>\\n<li>WooCommerce: Fix persistent sticky add to cart panel<\\/li>\\n<li>General: Integrate with new GP 3.1.0 Dashboard<\\/li>\\n<li>General: Remove featured-image-active body class if featured image is disabled<\\/li>\\n<li>General: Change date format in exported JSON filename<\\/li>\\n<li>General: Fix PHP error when license key activation returns 403<\\/li>\\n<\\/ul>\\n<h4> 2.0.3 <\\/h4>\\n<ul>\\n<li>Elements: Use block_categories_all filter in WP 5.8<\\/li>\\n<li>Elements: Remove wp-editor dependency from new widget editor<\\/li>\\n<\\/ul>\\n<h4> 2.0.2 <\\/h4>\\n<ul>\\n<li>Elements: Use blog page title for dynamic title if set<\\/li>\\n<li>Spacing: Fix reset button bug in Customizer controls<\\/li>\\n<li>WooCommerce: Fix infinite scroll applying to product taxonomy pages<\\/li>\\n<\\/ul>\\n<h4> 2.0.1 <\\/h4>\\n<ul>\\n<li>Blog: Fix infinite scroll bug on product archives<\\/li>\\n<li>Elements: Fix error in WP 4.9.x versions<\\/li>\\n<li>Menu Plus: Prevent 0x0 logo dimension attributes if no dimensions exist<\\/li>\\n<li>Site Library: Add vertical scroll ability to the Site Library control area<\\/li>\\n<\\/ul>\\n<h4> 2.0.0 <\\/h4>\\n<ul>\\n<li>Blog: Rewrite infinite scroll using vanilla javascript<\\/li>\\n<li>Blog: Rewrite masonry using vanilla javascript<\\/li>\\n<li>Blog: Add separate infinite scroll path element to footer<\\/li>\\n<li>Blog: Fix missing single\\/page featured image options when archive image disabled<\\/li>\\n<li>Blog: Add aria-label instead of screen-reader-text to read more button<\\/li>\\n<li>Colors: Fix back to top Customizer color preview<\\/li>\\n<li>Elements: New Content Template Element<\\/li>\\n<li>Elements: New Post Meta Template Element<\\/li>\\n<li>Elements: New Post Navigation Template Element<\\/li>\\n<li>Elements: New Page Hero Block Element<\\/li>\\n<li>Elements: New Archive Navigation Template Element<\\/li>\\n<li>Elements: New Editor Width option in Block Elements<\\/li>\\n<li>Elements: Move Block Elements options into editor sidebar<\\/li>\\n<li>Elements: Show Site Header options by default in Header Element<\\/li>\\n<li>Elements: Fix Classic Editor issue in Block Elements<\\/li>\\n<li>Elements: Add a list of active Elements to page editor<\\/li>\\n<li>Elements: Add a list of active Elements to the admin bar<\\/li>\\n<li>Elements: Add notices to Customizer if Elements may be overwriting options<\\/li>\\n<li>Elements: Disable mobile header menu if menu is disabled via Layout Element<\\/li>\\n<li>Elements: Improve Display Rule loading performance<\\/li>\\n<li>Elements: Add block type filter to Elements dashboard<\\/li>\\n<li>Elements: Add generate_element_display filter<\\/li>\\n<li>Elements: Add No Results as a Display Rule condition<\\/li>\\n<li>Menu Plus: Hide slideout toggle at set mobile menu breakpoint value<\\/li>\\n<li>Menu Plus: Fix sticky menu height when using navigation as header<\\/li>\\n<li>Menu Plus: Add dimensions to mobile\\/sticky logos<\\/li>\\n<li>Menu Plus: Make Off-Canvas menu take up full width of canvas<\\/li>\\n<li>Menu Plus: Fix menu bar item sticky transition<\\/li>\\n<li>Menu Plus: Prevent sticky sidebar nav if mobile header is set to sticky<\\/li>\\n<li>Secondary Nav: Fix centered secondary navigation items using flexbox<\\/li>\\n<li>Secondary Nav: Fix conflict with Nav as Header option<\\/li>\\n<li>Secondary Nav: Fix missing menu cart items when using click dropdowns<\\/li>\\n<li>Sections: Officially deprecate module<\\/li>\\n<li>Site Library: Completely rebuild Site Library using React<\\/li>\\n<li>WooCommerce: Move full width single product CSS to inline CSS<\\/li>\\n<li>WooCommerce: Use wc_get_product() instead of new WC_Product()<\\/li>\\n<li>WooCommerce: Add more checks for WC() class to prevent error logs<\\/li>\\n<li>WooCommerce: Add generate_wc_cart_panel_checkout_button_output filter<\\/li>\\n<li>WooCommerce: Add generate_wc_sticky_add_to_cart_action filter<\\/li>\\n<li>WooCommerce: Add generate_wc_show_sticky_add_to_cart filter<\\/li>\\n<li>WooCommerce: Re-write quantity button javascript to be more performant\\/extendable<\\/li>\\n<li>General: Update theme install link<\\/li>\\n<li>General: Update alpha color picker script<\\/li>\\n<li>General: Use correct URL scheme in external stylesheet URLs<\\/li>\\n<li>General: Check if FS_CHMOD_FILE is defined in external stylesheet generation<\\/li>\\n<li>General: Use inline CSS when using AMP plugin<\\/li>\\n<li>General: Update EDD_SL_Plugin_Updater class to 1.8.0<\\/li>\\n<li>General: Clean up javascript throughout plugin<\\/li>\\n<li>General: Replace deprecated jQuery functions<\\/li>\\n<\\/ul>\\n<h4> 1.12.3 <\\/h4>\\n<ul>\\n<li>WooCommerce: Fix quantity buttons in WP 5.6<\\/li>\\n<\\/ul>\\n<h4> 1.12.2 <\\/h4>\\n<ul>\\n<li>Blog: Load columns CSS when using filter to enable it anywhere<\\/li>\\n<li>Menu Plus: Fix sticky mobile header jump when using inline mobile toggle<\\/li>\\n<li>Menu Plus: Add margin to sticky nav branding when set to full width<\\/li>\\n<li>Menu Plus: Disable sticky nav container text align padding<\\/li>\\n<li>Menu Plus: Make mobile menu absolute only when smooth scroll is enabled<\\/li>\\n<li>Menu Plus: Improve nav as header\\/mobile header when using flexbox<\\/li>\\n<li>Menu Plus: Prevent off-canvas panel close button from flashing visible when closing<\\/li>\\n<li>Spacing: Fix custom nav search height<\\/li>\\n<\\/ul>\\n<h4> 1.12.1 <\\/h4>\\n<ul>\\n<li>Typography: Fix missing heading font size controls in the Customizer<\\/li>\\n<\\/ul>\\n<h4> 1.12.0 <\\/h4>\\n<ul>\\n<li>Blog: Fix column margin on mobile with some caching plugins<\\/li>\\n<li>Blog: Add post-load trigger to infinite scroll for better plugin compatibility<\\/li>\\n<li>Blog: Take generate_blog_columns filter into account when loading columns CSS<\\/li>\\n<li>Colors: Add search menu-bar-item color live preview to Customizer<\\/li>\\n<li>Elements: Fix broken custom hook field in Block Elements<\\/li>\\n<li>Elements: Integrate page hero with text container alignment in GP 3.0<\\/li>\\n<li>Elements: Better integrate Header Element colors with GP 3.0<\\/li>\\n<li>Elements: Only disable content title when {{post_title}} is present on single pages<\\/li>\\n<li>Elements: Fix  tag in metabox<\\/li>\\n<li>Elements: Add generate_elements_metabox_ajax_allow_editors filter<\\/li>\\n<li>Elements: Add new 3.0 hooks to hook selector<\\/li>\\n<li>Elements: Re-add generate_elements_custom_args filter<\\/li>\\n<li>Menu Plus: Better prepare navigation as header for GP 3.0<\\/li>\\n<li>Menu Plus: Better prepare Off-Canvas Panel for GP 3.0<\\/li>\\n<li>Menu Plus: Better prepare sticky navigation for GP 3.0<\\/li>\\n<li>Menu Plus: Add has-menu-bar-items class to mobile header if needed<\\/li>\\n<li>Menu Plus: Add is-logo-image class to all site logos<\\/li>\\n<li>Menu Plus: Fix mobile header alignment when it has menu bar items<\\/li>\\n<li>Secondary Nav: Better prepare sticky navigation for GP 3.0<\\/li>\\n<li>Secondary Nav: Fix hidden navigation widget in top bar when merged with secondary nav<\\/li>\\n<li>Sites: Improve the option-only import feature<\\/li>\\n<li>Sites: Improve the refresh sites button functionality<\\/li>\\n<li>Sites: Improve the undo site import functionality<\\/li>\\n<li>Sites: Fix Elementor site import issues<\\/li>\\n<li>Sites: Re-add Elementor sites to library<\\/li>\\n<li>Spacing: Better prepare Customizer live preview for GP 3.0<\\/li>\\n<li>Spacing: Fix blog column spacing Customizer live preview<\\/li>\\n<li>Spacing: Stop handling mobile header, widget and footer widget features added in GP 3.0<\\/li>\\n<li>Typography: Add mobile font size control for H3 (when using GP 3.0)<\\/li>\\n<li>Typography: Add mobile font size control for H4 (when using GP 3.0)<\\/li>\\n<li>Typography: Add mobile font size control for H5 (when using GP 3.0)<\\/li>\\n<li>Typography: Allow empty tablet and mobile site title font size values<\\/li>\\n<li>Typography: Make menu toggle CSS selector specific to primary navigation<\\/li>\\n<li>WooCommerce: Use CSS for secondary product image functionality instead of JS<\\/li>\\n<li>WooCommerce: Only load .js file if needed<\\/li>\\n<li>WooCommerce: Fix quantity box functionality when multiple quantity boxes exist on the page<\\/li>\\n<li>General: Improve alpha color picker script for better 5.5 compatibility<\\/li>\\n<li>General: Move child theme stylesheet after dynamic stylesheet if enabled<\\/li>\\n<li>General: Update gp-premium-de_DE.mo<\\/li>\\n<li>General: Update gp-premium-es_ES.mo<\\/li>\\n<li>General: Update gp-premium-fi.mo<\\/li>\\n<li>General: Update gp-premium-pt_PT.mo<\\/li>\\n<li>General: Update gp-premium-sv_SE.mo<\\/li>\\n<\\/ul>\\n<h4> 1.11.3 <\\/h4>\\n<ul>\\n<li>Blog: Set widths to grid-sizer element<\\/li>\\n<li>Elements: Fix legacy Page Header\\/Hooks buttons in the Elements dashboard<\\/li>\\n<li>Page Header: Replace .load() with .on(\'load\')<\\/li>\\n<li>Page Header: Fix color picker error in WP 5.5<\\/li>\\n<\\/ul>\\n<h4> 1.11.2 <\\/h4>\\n<ul>\\n<li>Blog: Remove negative featured image top margin from columns when using one container<\\/li>\\n<li>Blog: Fix infinite scroll items loading above viewport when using columns<\\/li>\\n<li>Blog: Fix infinite scroll featured images not displaying in Safari<\\/li>\\n<li>Elements: Prevent error in editor when generate_get_option() function doesn\'t exist<\\/li>\\n<li>General: Load inline CSS in previews when using external CSS option<\\/li>\\n<li>General: Update gp-premium-es_ES.mo<\\/li>\\n<li>General: Update gp-premium-pt_PT.mo<\\/li>\\n<\\/ul>\\n<h4> 1.11.1 <\\/h4>\\n<ul>\\n<li>Elements: Remove stray quote character in Layout Element metabox<\\/li>\\n<li>Sections: Fix color picker JS error in WP 5.5<\\/li>\\n<li>General: Fix external CSS option not removing inline CSS in some cases<\\/li>\\n<\\/ul>\\n<h4> 1.11.0 <\\/h4>\\n<ul>\\n<li>New: Block Elements<\\/li>\\n<li>New: Apply Layout Element options to the block editor if set<\\/li>\\n<li>New: Generate dynamic CSS in an external file<\\/li>\\n<li>Blog: Separate CSS and load only when needed<\\/li>\\n<li>Blog: Add column width classes to stylesheet<\\/li>\\n<li>Blog: Disable featured image itemprop if microdata is disabled<\\/li>\\n<li>Blog: Add generate_blog_masonry_init filter<\\/li>\\n<li>Blog: Add generate_blog_infinite_scroll_init filter<\\/li>\\n<li>Blog: Fix archive page header overlap when using no featured image padding\\/one container<\\/li>\\n<li>Blog: Replace screen reader text with aria-label in read more buttons<\\/li>\\n<li>Disable Elements: Add option to disable the Mobile Header<\\/li>\\n<li>Disable Elements: Disable top bar disables it even when combined with Secondary Nav<\\/li>\\n<li>Disable Elements: Use generate_show_post_navigation filter to disable single post navigation<\\/li>\\n<li>Elements: Use full hook name with generate_ prefix in dropdown<\\/li>\\n<li>Elements: Rebuild how Element types are chosen<\\/li>\\n<li>Elements: Add chosen hook under type column in edit.php<\\/li>\\n<li>Menu Plus: Add generate_after_mobile_header_menu_button filter<\\/li>\\n<li>Menu Plus: Add sticky placeholder only when nav becomes sticky<\\/li>\\n<li>Menu Plus: Add class to sticky nav when scrolling up<\\/li>\\n<li>Menu Plus: Fix navigation branding\\/mobile header layout when using RTL languages<\\/li>\\n<li>Page Header: Prevent PHP notices<\\/li>\\n<li>Secondary Nav: Clean up CSS<\\/li>\\n<li>Secondary Nav: Add generate_after_secondary_navigation hook<\\/li>\\n<li>Secondary Nav: Add generate_before_secondary_navigation hook<\\/li>\\n<li>Secondary Nav: Integrate with future flexbox option<\\/li>\\n<li>Secondary Nav: Add has-top-bar class if needed<\\/li>\\n<li>Secondary Nav: Add screen reader text to mobile menu toggle if no text exists<\\/li>\\n<li>Secondary Nav: Remove microdata if disabled<\\/li>\\n<li>Secondary Nav: Add generate_secondary_menu_bar_items hook<\\/li>\\n<li>Spacing: Set sidebar width in Customizer for future flexbox option<\\/li>\\n<li>WooCommerce: Add generate_woocommerce_show_add_to_cart_panel filter<\\/li>\\n<li>WooCommerce: Integrate with future flexbox option<\\/li>\\n<li>WooCommerce: Ensure WC()-&gt;cart is set<\\/li>\\n<li>WooCommerce: Remove left margin from SVG menu cart icon<\\/li>\\n<li>WooCommerce: Show sticky add to cart panel on sold individually products<\\/li>\\n<li>WooCommerce: Remove bottom margin from related\\/upsell products<\\/li>\\n<li>WooCommerce: Fix cart menu item spacing in RTL languages<\\/li>\\n<li>WooCommerce: Fix menu item cart dropdown design in RTL languages<\\/li>\\n<li>General: Update selectWoo<\\/li>\\n<li>General: Update select2<\\/li>\\n<li>General: Run all CSS through PostCSS<\\/li>\\n<li>General: Fix various text domains<\\/li>\\n<li>General: Fix JS error when toggling nav as header option without Colors\\/Typography modules<\\/li>\\n<li>General: Update all translations over 90% complete<\\/li>\\n<li>General: PHP cleanup\\/coding standards<\\/li>\\n<li>General: Add off_canvas_desktop_toggle_label to wpml-config.xml<\\/li>\\n<\\/ul>\\n<h4> 1.10.0 <\\/h4>\\n<ul>\\n<li>Blog: Remove existing on-the-fly featured image resizer (Image Processing Queue)<\\/li>\\n<li>Blog: Choose from existing image sizes for featured images<\\/li>\\n<li>Blog: Use CSS to further resize featured images if necessary<\\/li>\\n<li>Blog: Fix edge case persistent transient bug with old image resizer<\\/li>\\n<li>Elements: Fix broken closing element in metabox<\\/li>\\n<li>General: Change scroll variable to gpscroll in smooth scroll script to avoid conflicts<\\/li>\\n<li>General: Update responsive widths in Customizer<\\/li>\\n<li>General: Fix responsive Customizer views when using RTL<\\/li>\\n<li>Menu Plus: Don\'t output sticky nav branding if sticky nav is disabled<\\/li>\\n<li>Menu Plus: Fix focus when off canvas overlay is opened (a11y)<\\/li>\\n<li>Menu Plus: Fix sticky navigation jump when navigation branding is in use<\\/li>\\n<li>Sections: Fix visible block editor when Sections are enabled<\\/li>\\n<li>WooCommerce: Use minmax in grid template definitions to fix overflow issue<\\/li>\\n<li>WooCommerce: Prevent add to cart panel interfering with back to top button on mobile<\\/li>\\n<li>WooCommerce: WooCommerce: Fix secondary image position if HTML isn\'t ordered correctly<\\/li>\\n<li>General: Add\\/update all translations over 50% complete. Big thanks to all contributors!<\\/li>\\n<li>Translation: Added Arabic - thank you anass!<\\/li>\\n<li>Translation: Added Bengali - thank you gtmroy!<\\/li>\\n<li>Translation: Added Spanish (Spain) - thank you davidperez (closemarketing.es)!<\\/li>\\n<li>Translation: Added Spanish (Argentina) - thank you bratorr!<\\/li>\\n<li>Translation: Added Finnish - thank you Stedi!<\\/li>\\n<li>Translation: Add Dutch - thank you Robin!<\\/li>\\n<li>Translation: Added Ukrainian - thank you EUROMEDIA!<\\/li>\\n<li>Translation: Vietnamese added - thank you themevi!<\\/li>\\n<\\/ul>\\n<h4> 1.9.1 <\\/h4>\\n<ul>\\n<li>Blog: Fix \\\"null\\\" in infinite scroll load more button text<\\/li>\\n<li>WooCommerce: Fix hidden added to cart panel on mobile when sticky nav active<\\/li>\\n<li>WooCommerce: Fix missing SVG icon in mobile added to cart panel<\\/li>\\n<\\/ul>\\n<h4> 1.9.0 <\\/h4>\\n<ul>\\n<li>Blog: Support SVG icon feature<\\/li>\\n<li>Colors: Add navigation search color options<\\/li>\\n<li>Disable Elements: Disable mobile menu in Mobile Header if nav is disabled<\\/li>\\n<li>Elements: Add wp_body_open hook<\\/li>\\n<li>Elements: Allow 0 mobile padding in Elements<\\/li>\\n<li>Elements: Add generate_elements_admin_menu_capability filter<\\/li>\\n<li>Elements: Add generate_page_hero_css_output filter<\\/li>\\n<li>Elements: Prevent error in Header Element if taxonomy doesn\'t exist<\\/li>\\n<li>Elements: Fix double logo when Header Element has logo + using nav as header<\\/li>\\n<li>Elements: Fix mobile header logo not replacing if merge is disabled<\\/li>\\n<li>Elements: Fix missing arrow in Choose Element Type select in WP 5.3<\\/li>\\n<li>Elements: Add generate_inside_site_container hook option<\\/li>\\n<li>Elements: Add generate_after_entry_content hook option<\\/li>\\n<li>Menu Plus: Add off canvas desktop toggle label option<\\/li>\\n<li>Menu Plus: Add generate_off_canvas_toggle_output filter<\\/li>\\n<li>Menu Plus: Support SVG icon feature<\\/li>\\n<li>Menu Plus: Fix sticky navigation overlapping BB controls<\\/li>\\n<li>Menu Plus: Add align-items: center to nav as header, mobile header and sticky nav with branding<\\/li>\\n<li>Sections: Fix text\\/visual switch bug in Firefox<\\/li>\\n<li>Sites: Add option to revert site import<\\/li>\\n<li>Sites: Increase site library limit to 100<\\/li>\\n<li>Spacing: Add live preview to group container padding<\\/li>\\n<li>Typography: Add tablet site title\\/navigation font size options<\\/li>\\n<li>Typography: Add archive post title weight, transform, font size and line height<\\/li>\\n<li>Typography: Add single content title weight, transform, font size and line height<\\/li>\\n<li>Typography: Only call all google fonts once in the Customizer<\\/li>\\n<li>Typography: Get Google fonts from readable JSON list<\\/li>\\n<li>Typography: Make sure font settings aren\'t lost if list is changed<\\/li>\\n<li>Typography: Only call generate_get_all_google_fonts if needed<\\/li>\\n<li>WooCommerce: Add columns gap options (desktop, tablet, mobile)<\\/li>\\n<li>WooCommerce: Add tablet column options<\\/li>\\n<li>WooCommerce: Add related\\/upsell tablet column options<\\/li>\\n<li>WooCommerce: Support SVG icon feature<\\/li>\\n<li>WooCommerce: Prevent empty added to cart panel on single products<\\/li>\\n<li>WooCommerce: Fix woocommerce-ordering arrow in old FF versions<\\/li>\\n<li>WooCommerce: Make item\\/items string translatable<\\/li>\\n<li>General: Better customizer device widths<\\/li>\\n<li>General: Use generate_premium_get_media_query throughout modules<\\/li>\\n<li>General: Improve Customizer control styling<\\/li>\\n<\\/ul>\\n<h4> 1.8.3 <\\/h4>\\n<ul>\\n<li>Menu Plus: Use flexbox for center aligned nav with nav branding<\\/li>\\n<li>Menu Plus: Center overlay off canvas exit button on mobile<\\/li>\\n<li>Menu Plus: Add alt tag to sticky nav logo<\\/li>\\n<li>Menu Plus: Set generate_not_mobile_menu_media_query filter based on mobile menu breakpoint<\\/li>\\n<li>Sections: Remember when text tab is active<\\/li>\\n<li>Sections: Disable visual editor if turned off in profile<\\/li>\\n<li>Typography: Add generate_google_font_display filter<\\/li>\\n<li>WooCommerce: Fix single product sidebar layout metabox option<\\/li>\\n<li>WooCommerce: Reduce carousel thumbnail max-width to 100px to match new thumbnail sizes<\\/li>\\n<\\/ul>\\n<h4> 1.8.2 <\\/h4>\\n<ul>\\n<li>Elements: Use Page Hero site title color for mobile header site title<\\/li>\\n<li>Menu Plus: Give mobile header site title more left spacing<\\/li>\\n<li>Menu Plus: Fix nav search icon in sticky navigation when using nav branding in Firefox<\\/li>\\n<li>Site Library: Show Site Library tab even if no sites exist<\\/li>\\n<li>Site Library: Show an error message in Site Library if no sites exist<\\/li>\\n<li>Typography: Remove reference to generate_get_navigation_location() function<\\/li>\\n<li>WooCommerce: Remove quantity field arrows when using quantity buttons in Firefox<\\/li>\\n<li>WooCommerce: Remove extra border when loading quantity buttons<\\/li>\\n<li>WooCommerce: Use get_price_html() is sticky add to cart panel<\\/li>\\n<\\/ul>\\n<h4> 1.8.1 <\\/h4>\\n<ul>\\n<li>Menu Plus: Revert sticky nav duplicate ID fix due to Cyrillic script bug<\\/li>\\n<\\/ul>\\n<h4> 1.8 <\\/h4>\\n<ul>\\n<li>Blog: Apply columns filter to masonry grid sizer<\\/li>\\n<li>Colors: Merge Footer Widgets and Footer controls in Color panel<\\/li>\\n<li>Colors: Remove edit_theme_options capability to Customizer controls (set by default)<\\/li>\\n<li>Disable Elements: Make sure mobile header is disabled when primary navigation is disabled<\\/li>\\n<li>Elements: Add content width option in Layout Element<\\/li>\\n<li>Elements: Fix mobile header logo when mobile menu toggled<\\/li>\\n<li>Elements: Add generate_page_hero_location filter<\\/li>\\n<li>Elements: Add generate_elements_show_object_ids filter to show IDs in Display Rule values<\\/li>\\n<li>Elements: Prevent merged header wrap from conflicting with Elementor controls<\\/li>\\n<li>Elements: Change Container tab name to Content<\\/li>\\n<li>Elements: Add woocommerce_share option to Hooks<\\/li>\\n<li>Elements: Improve WPML compatibility<\\/li>\\n<li>Elements: Improve Polylang compatibility<\\/li>\\n<li>Elements: Prevent PHP notices when adding taxonomy locations to non-existent archives<\\/li>\\n<li>Elements: Add generate_mobile_cart_items hook to hook list<\\/li>\\n<li>Elements: Add generate_element_post_id filter<\\/li>\\n<li>Elements: Escape HTML elements inside Element textarea<\\/li>\\n<li>Elements: Add Beaver Builder templates to the Display Rules<\\/li>\\n<li>Menu Plus: Add mobile header breakpoint option<\\/li>\\n<li>Menu Plus: Add off canvas overlay option<\\/li>\\n<li>Menu Plus: Add navigation as header option<\\/li>\\n<li>Menu Plus: Remove navigation logo option if navigation as header set<\\/li>\\n<li>Menu Plus: Add sticky navigation logo option<\\/li>\\n<li>Menu Plus: Allow site title in mobile header instead of logo<\\/li>\\n<li>Menu Plus: Add option to move exit button inside the off canvas panel<\\/li>\\n<li>Menu Plus: Change Slideout Navigation name to Off Canvas Panel<\\/li>\\n<li>Menu Plus: Only re-focus after slideout close on escape key<\\/li>\\n<li>Menu Plus: Give close slideout event a name so it can be removed<\\/li>\\n<li>Menu Plus: Remove invalid transition-delay<\\/li>\\n<li>Menu Plus: Improve slideout overlay transition<\\/li>\\n<li>Menu Plus: Add mobile open\\/close icons to GPP font<\\/li>\\n<li>Menu Plus: Allow dynamic widget classes in off canvas panel (fixes WC range slider widget issue)<\\/li>\\n<li>Menu Plus: Basic compatibility with future SVG icons<\\/li>\\n<li>Menu Plus: Prevent duplicate IDs when sticky navigation is cloned<\\/li>\\n<li>Secondary Nav: Add dropdown direction option<\\/li>\\n<li>Secondary Nav: Basic compatibility with future SVG icons<\\/li>\\n<li>Sections: Fix section editor issues in WP 5.0<\\/li>\\n<li>Sections: Show Better Font Awesome icon in editor<\\/li>\\n<li>Sites: Re-design UI<\\/li>\\n<li>Sites: Add option to activate as a module like all the other modules<\\/li>\\n<li>Sites: Don\'t show backup options button if no options exist<\\/li>\\n<li>Sites: Make JS action classes more specific to the site library<\\/li>\\n<li>Sites: Set mime types of content.xml and widgets.wie<\\/li>\\n<li>Spacing: Add header padding option for mobile<\\/li>\\n<li>Spacing: Add widget padding option for mobile<\\/li>\\n<li>Spacing: Add footer widgets padding option for mobile<\\/li>\\n<li>Spacing: Add content separator option<\\/li>\\n<li>Spacing: Apply mobile menu item width to mobile bar only<\\/li>\\n<li>WooCommerce: Add option for mini cart in the menu<\\/li>\\n<li>WooCommerce: Add option to open off overlay panel on add to cart<\\/li>\\n<li>WooCommerce: Add option to open sticky add to cart panel on single products<\\/li>\\n<li>WooCommerce: Add option to add +\\/- buttons to the quantity fields<\\/li>\\n<li>WooCommerce: Add option to show number of items in cart menu item<\\/li>\\n<li>WooCommerce: Add option to choose single product image area width<\\/li>\\n<li>WooCommerce: Add color options for price slider widget<\\/li>\\n<li>WooCommerce: Use CSS grid for the product archives<\\/li>\\n<li>WooCommerce: Horizontally align add to cart buttons<\\/li>\\n<li>WooCommerce: Re-design the cart widget<\\/li>\\n<li>WooCommerce: Tighten up product info spacing<\\/li>\\n<li>WooCommerce: Improve product tab design to look more like tabs<\\/li>\\n<li>WooCommerce: Simplify single product image display<\\/li>\\n<li>WooCommerce: Use flexbox for quantity\\/add to cart alignment<\\/li>\\n<li>WooCommerce: Improve rating star styles<\\/li>\\n<li>WooCommerce: Use product alignment setting for related\\/upsell products<\\/li>\\n<li>WooCommerce: Remove bottom margin from product image<\\/li>\\n<li>WooCommerce: Organize colors in the Customizer<\\/li>\\n<li>WooCommerce: Remove title attribute from menu cart item<\\/li>\\n<li>WooCommerce: Improve coupon field design<\\/li>\\n<li>WooCommerce: Improve result count\\/ordering styling<\\/li>\\n<li>WooCommerce: Add gap around WC single product images<\\/li>\\n<li>WooCommerce: Remove arrow from checkout button<\\/li>\\n<li>WooCommerce: Hide view cart link on add to cart click<\\/li>\\n<li>WooCommerce: Organize CSS<\\/li>\\n<li>Introduce in-Customizer shortcuts<\\/li>\\n<li>Add generate_disable_customizer_shortcuts filter<\\/li>\\n<\\/ul>\"],\"plugin\":\"gp-premium\\/gp-premium.php\",\"id\":\"gp-premium\\/gp-premium.php\"}\";}","off"),
("166","generateblocks_pro_licensing","a:2:{s:6:\"status\";s:5:\"valid\";s:3:\"key\";s:32:\"GPL001122334455AA6677BB8899CC000\";}","auto"),
("171","current_theme","GeneratePress","auto"),
("173","theme_switched","","auto"),
("178","generate_db_version","3.4.0","auto"),
("182","generateblocks_dynamic_css_posts","a:8:{i:1592;b:1;i:1590;b:1;i:3;b:1;i:1586;b:1;i:32;b:1;i:36;b:1;i:1541;b:1;i:29;b:1;}","on"),
("183","generateblocks_dynamic_css_time","1728980211","on"),
("185","generateblocks_version","1.9.1","auto"),
("186","generateblocks_pro_version","1.6.0","auto"),
("187","gen_premium_license_key_status","valid","auto"),
("188","gen_premium_license_key","0ecbbb50c32d43766e0bddaa16299941","auto"),
("189","edd_sl_2f02cf0f1dd6dc1fbe6ef0988165b88e","a:2:{s:7:\"timeout\";i:1740971754;s:5:\"value\";s:272:\"{\"new_version\":\"\",\"stable_version\":\"\",\"sections\":\"\",\"license_check\":\"\",\"msg\":\"License key is not valid for GenerateBlocks Pro\",\"homepage\":\"\",\"package\":\"\",\"icons\":[],\"banners\":[],\"plugin\":\"generateblocks-pro\\/plugin.php\",\"id\":\"generateblocks-pro\\/plugin.php\",\"tested\":null}\";}","off"),
("192","generate_package_site_library","activated","auto"),
("193","generatepress_sites","a:100:{s:7:\"Harmony\";a:16:{s:4:\"name\";s:7:\"Harmony\";s:9:\"directory\";s:32:\"https://gpsites.co/files/harmony\";s:11:\"preview_url\";s:26:\"https://gpsites.co/harmony\";s:11:\"author_name\";s:15:\"Kyle Van Deusen\";s:10:\"author_url\";s:25:\"https://kylevandeusen.com\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:134:\"{\"GenerateBlocks Pro\":\"generateblocks-pro/plugin.php\",\"GenerateBlocks\":\"generateblocks/plugin.php\",\"Safe SVG\":\"safe-svg/safe-svg.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:11:\"SimpliCloud\";a:16:{s:4:\"name\";s:11:\"SimpliCloud\";s:9:\"directory\";s:36:\"https://gpsites.co/files/simplicloud\";s:11:\"preview_url\";s:30:\"https://gpsites.co/simplicloud\";s:11:\"author_name\";s:15:\"Kyle Van Deusen\";s:10:\"author_url\";s:25:\"https://kylevandeusen.com\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:134:\"{\"GenerateBlocks Pro\":\"generateblocks-pro/plugin.php\",\"GenerateBlocks\":\"generateblocks/plugin.php\",\"Safe SVG\":\"safe-svg/safe-svg.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:6:\"Search\";a:16:{s:4:\"name\";s:6:\"Search\";s:9:\"directory\";s:31:\"https://gpsites.co/files/search\";s:11:\"preview_url\";s:25:\"https://gpsites.co/search\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:21:\"https://mikeoliver.me\";s:11:\"description\";s:79:\"Search is a lightweight and modern site for agencies built with GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:9:\"Freelance\";a:16:{s:4:\"name\";s:9:\"Freelance\";s:9:\"directory\";s:34:\"https://gpsites.co/files/freelance\";s:11:\"preview_url\";s:28:\"https://gpsites.co/freelance\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:21:\"https://mikeoliver.me\";s:11:\"description\";s:51:\"A freelancer-based site built using GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:4:\"Shop\";a:16:{s:4:\"name\";s:4:\"Shop\";s:9:\"directory\";s:29:\"https://gpsites.co/files/shop\";s:11:\"preview_url\";s:23:\"https://gpsites.co/shop\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:22:\"https://mikeoliver.me/\";s:11:\"description\";s:64:\"A simple and modern WooCommerce store built with GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:10:\"e-Commerce\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:90:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\",\"WooCommerce\":\"woocommerce/woocommerce.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:7:\"Realtor\";a:16:{s:4:\"name\";s:7:\"Realtor\";s:9:\"directory\";s:32:\"https://gpsites.co/files/realtor\";s:11:\"preview_url\";s:26:\"https://gpsites.co/realtor\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:21:\"https://mikeoliver.me\";s:11:\"description\";s:51:\"A realtor-based website built using GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Mason\";a:16:{s:4:\"name\";s:5:\"Mason\";s:9:\"directory\";s:30:\"https://gpsites.co/files/mason\";s:11:\"preview_url\";s:24:\"https://gpsites.co/mason\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:21:\"https://mikeoliver.me\";s:11:\"description\";s:131:\"Mason is a clean and minimalistic site perfect for architecture firms, commercial and residential developers or interior designers.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Coach\";a:16:{s:4:\"name\";s:5:\"Coach\";s:9:\"directory\";s:30:\"https://gpsites.co/files/coach\";s:11:\"preview_url\";s:24:\"https://gpsites.co/coach\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:22:\"https://mikeoliver.me/\";s:11:\"description\";s:134:\"Coach is built with GenerateBlocks and is perfect for any consultant, entrepreneur, coach or author looking for a lightweight website.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:8:\"Engineer\";a:16:{s:4:\"name\";s:8:\"Engineer\";s:9:\"directory\";s:33:\"https://gpsites.co/files/engineer\";s:11:\"preview_url\";s:28:\"https://gpsites.co/engineer/\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Solar\";a:16:{s:4:\"name\";s:5:\"Solar\";s:9:\"directory\";s:30:\"https://gpsites.co/files/solar\";s:11:\"preview_url\";s:25:\"https://gpsites.co/solar/\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:22:\"https://leohsiang.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:4:\"Lens\";a:16:{s:4:\"name\";s:4:\"Lens\";s:9:\"directory\";s:29:\"https://gpsites.co/files/lens\";s:11:\"preview_url\";s:24:\"https://gpsites.co/lens/\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:22:\"https://leohsiang.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:4:\"Chef\";a:16:{s:4:\"name\";s:4:\"Chef\";s:9:\"directory\";s:29:\"https://gpsites.co/files/chef\";s:11:\"preview_url\";s:24:\"https://gpsites.co/chef/\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:9:\"PoolSwift\";a:16:{s:4:\"name\";s:9:\"PoolSwift\";s:9:\"directory\";s:34:\"https://gpsites.co/files/poolswift\";s:11:\"preview_url\";s:29:\"https://gpsites.co/poolswift/\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:6:\"Events\";a:16:{s:4:\"name\";s:6:\"Events\";s:9:\"directory\";s:31:\"https://gpsites.co/files/events\";s:11:\"preview_url\";s:26:\"https://gpsites.co/events/\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:22:\"https://leohsiang.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:7:\"Journal\";a:16:{s:4:\"name\";s:7:\"Journal\";s:9:\"directory\";s:32:\"https://gpsites.co/files/journal\";s:11:\"preview_url\";s:27:\"https://gpsites.co/journal/\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:22:\"https://leohsiang.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Sweet\";a:16:{s:4:\"name\";s:5:\"Sweet\";s:9:\"directory\";s:30:\"https://gpsites.co/files/sweet\";s:11:\"preview_url\";s:25:\"https://gpsites.co/sweet/\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:22:\"https://leohsiang.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Kicks\";a:16:{s:4:\"name\";s:5:\"Kicks\";s:9:\"directory\";s:30:\"https://gpsites.co/files/kicks\";s:11:\"preview_url\";s:25:\"https://gpsites.co/kicks/\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:22:\"https://leohsiang.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:10:\"e-Commerce\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:90:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\",\"WooCommerce\":\"woocommerce/woocommerce.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:6:\"Wander\";a:16:{s:4:\"name\";s:6:\"Wander\";s:9:\"directory\";s:31:\"https://gpsites.co/files/wander\";s:11:\"preview_url\";s:26:\"https://gpsites.co/wander/\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:22:\"https://leohsiang.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:10:\"e-Commerce\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:183:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\",\"WooCommerce Blocks\":\"woo-gutenberg-products-block/woocommerce-gutenberg-products-block.php\",\"WooCommerce\":\"woocommerce/woocommerce.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:6:\"Travel\";a:16:{s:4:\"name\";s:6:\"Travel\";s:9:\"directory\";s:31:\"https://gpsites.co/files/travel\";s:11:\"preview_url\";s:26:\"https://gpsites.co/travel/\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:22:\"https://leohsiang.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Voice\";a:16:{s:4:\"name\";s:5:\"Voice\";s:9:\"directory\";s:30:\"https://gpsites.co/files/voice\";s:11:\"preview_url\";s:25:\"https://gpsites.co/voice/\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:6:\"Flavor\";a:16:{s:4:\"name\";s:6:\"Flavor\";s:9:\"directory\";s:31:\"https://gpsites.co/files/flavor\";s:11:\"preview_url\";s:26:\"https://gpsites.co/flavor/\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:10:\"e-Commerce\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:90:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\",\"WooCommerce\":\"woocommerce/woocommerce.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:7:\"Elegant\";a:16:{s:4:\"name\";s:7:\"Elegant\";s:9:\"directory\";s:32:\"https://gpsites.co/files/elegant\";s:11:\"preview_url\";s:27:\"https://gpsites.co/elegant/\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:10:\"SafeWheels\";a:16:{s:4:\"name\";s:10:\"SafeWheels\";s:9:\"directory\";s:35:\"https://gpsites.co/files/safewheels\";s:11:\"preview_url\";s:30:\"https://gpsites.co/safewheels/\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:8:\"Arborist\";a:16:{s:4:\"name\";s:8:\"Arborist\";s:9:\"directory\";s:33:\"https://gpsites.co/files/arborist\";s:11:\"preview_url\";s:28:\"https://gpsites.co/arborist/\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:7:\"Explore\";a:16:{s:4:\"name\";s:7:\"Explore\";s:9:\"directory\";s:32:\"https://gpsites.co/files/explore\";s:11:\"preview_url\";s:27:\"https://gpsites.co/explore/\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:21:\"https://mikeoliver.me\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Brand\";a:16:{s:4:\"name\";s:5:\"Brand\";s:9:\"directory\";s:30:\"https://gpsites.co/files/brand\";s:11:\"preview_url\";s:25:\"https://gpsites.co/brand/\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:21:\"https://mikeoliver.me\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:8:\"Newsroom\";a:16:{s:4:\"name\";s:8:\"Newsroom\";s:9:\"directory\";s:33:\"https://gpsites.co/files/newsroom\";s:11:\"preview_url\";s:28:\"https://gpsites.co/newsroom/\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:7:\"InBound\";a:16:{s:4:\"name\";s:7:\"InBound\";s:9:\"directory\";s:32:\"https://gpsites.co/files/inbound\";s:11:\"preview_url\";s:27:\"https://gpsites.co/inbound/\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:8:\"Botanist\";a:16:{s:4:\"name\";s:8:\"Botanist\";s:9:\"directory\";s:33:\"https://gpsites.co/files/botanist\";s:11:\"preview_url\";s:28:\"https://gpsites.co/botanist/\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:10:\"e-Commerce\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:90:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\",\"WooCommerce\":\"woocommerce/woocommerce.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:4:\"Info\";a:16:{s:4:\"name\";s:4:\"Info\";s:9:\"directory\";s:29:\"https://gpsites.co/files/info\";s:11:\"preview_url\";s:23:\"https://gpsites.co/info\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:21:\"https://leohsiang.com\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:7:\"Workout\";a:16:{s:4:\"name\";s:7:\"Workout\";s:9:\"directory\";s:32:\"https://gpsites.co/files/workout\";s:11:\"preview_url\";s:26:\"https://gpsites.co/workout\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:6:\"Clinic\";a:16:{s:4:\"name\";s:6:\"Clinic\";s:9:\"directory\";s:31:\"https://gpsites.co/files/clinic\";s:11:\"preview_url\";s:25:\"https://gpsites.co/clinic\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:53:\"A healthcare-related site built using GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"myPet\";a:16:{s:4:\"name\";s:5:\"myPet\";s:9:\"directory\";s:30:\"https://gpsites.co/files/mypet\";s:11:\"preview_url\";s:24:\"https://gpsites.co/mypet\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:47:\"A pet-inspired site built using GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:10:\"e-Commerce\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:90:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\",\"WooCommerce\":\"woocommerce/woocommerce.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:6:\"Scribe\";a:16:{s:4:\"name\";s:6:\"Scribe\";s:9:\"directory\";s:31:\"https://gpsites.co/files/scribe\";s:11:\"preview_url\";s:25:\"https://gpsites.co/scribe\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:21:\"https://mikeoliver.me\";s:11:\"description\";s:81:\"A clean blog site built using GenerateBlocks and GeneratePress Content Templates.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:8:\"Marketer\";a:16:{s:4:\"name\";s:8:\"Marketer\";s:9:\"directory\";s:33:\"https://gpsites.co/files/marketer\";s:11:\"preview_url\";s:27:\"https://gpsites.co/marketer\";s:11:\"author_name\";s:13:\"GeneratePress\";s:10:\"author_url\";s:25:\"https://generatepress.com\";s:11:\"description\";s:43:\"A blog for affiliate marketers and writers.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Avery\";a:16:{s:4:\"name\";s:5:\"Avery\";s:9:\"directory\";s:30:\"https://gpsites.co/files/avery\";s:11:\"preview_url\";s:25:\"https://gpsites.co/avery/\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:22:\"https://mikeoliver.me/\";s:11:\"description\";s:127:\"Avery is a feminine style blog you can use to jumpstart your personal website. Built with GenerateBlocks and the block editor. \";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:6:\"Donate\";a:16:{s:4:\"name\";s:6:\"Donate\";s:9:\"directory\";s:31:\"https://gpsites.co/files/donate\";s:11:\"preview_url\";s:25:\"https://gpsites.co/donate\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:21:\"https://mikeoliver.me\";s:11:\"description\";s:84:\"Donate is the perfect site for charitable organizations looking to accept donations.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:3:\"Dev\";a:16:{s:4:\"name\";s:3:\"Dev\";s:9:\"directory\";s:28:\"https://gpsites.co/files/dev\";s:11:\"preview_url\";s:23:\"https://gpsites.co/dev/\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:22:\"https://mikeoliver.me/\";s:11:\"description\";s:125:\"Dev is a clean and modern site created for agencies and development studios. Built with GenerateBlocks and the block editor. \";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:7:\"Plumber\";a:16:{s:4:\"name\";s:7:\"Plumber\";s:9:\"directory\";s:32:\"https://gpsites.co/files/plumber\";s:11:\"preview_url\";s:26:\"https://gpsites.co/plumber\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:11:\"Connections\";a:16:{s:4:\"name\";s:11:\"Connections\";s:9:\"directory\";s:36:\"https://gpsites.co/files/connections\";s:11:\"preview_url\";s:30:\"https://gpsites.co/connections\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:51:\"A wedding-inspired site built using GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:10:\"e-Commerce\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:90:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\",\"WooCommerce\":\"woocommerce/woocommerce.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:6:\"Driver\";a:16:{s:4:\"name\";s:6:\"Driver\";s:9:\"directory\";s:31:\"https://gpsites.co/files/driver\";s:11:\"preview_url\";s:25:\"https://gpsites.co/driver\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:58:\"A driving school inspired site built using GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:6:\"Crypto\";a:16:{s:4:\"name\";s:6:\"Crypto\";s:9:\"directory\";s:31:\"https://gpsites.co/files/crypto\";s:11:\"preview_url\";s:25:\"https://gpsites.co/crypto\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:49:\"A cryptocurrency-based site using GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:12:\"Construction\";a:16:{s:4:\"name\";s:12:\"Construction\";s:9:\"directory\";s:37:\"https://gpsites.co/files/construction\";s:11:\"preview_url\";s:31:\"https://gpsites.co/construction\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:52:\"A construction-based site built with GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:8:\"Security\";a:16:{s:4:\"name\";s:8:\"Security\";s:9:\"directory\";s:33:\"https://gpsites.co/files/security\";s:11:\"preview_url\";s:27:\"https://gpsites.co/security\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:6:\"Health\";a:16:{s:4:\"name\";s:6:\"Health\";s:9:\"directory\";s:32:\"https://gpsites.co/files/health/\";s:11:\"preview_url\";s:25:\"https://gpsites.co/health\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:21:\"https://mikeoliver.me\";s:11:\"description\";s:65:\"A healthcare-focused site using GeneratePress and GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Cloud\";a:16:{s:4:\"name\";s:5:\"Cloud\";s:9:\"directory\";s:30:\"https://gpsites.co/files/cloud\";s:11:\"preview_url\";s:24:\"https://gpsites.co/cloud\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:21:\"https://mikeoliver.me\";s:11:\"description\";s:44:\"An IT-based site built using GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Relay\";a:16:{s:4:\"name\";s:5:\"Relay\";s:9:\"directory\";s:30:\"https://gpsites.co/files/relay\";s:11:\"preview_url\";s:24:\"https://gpsites.co/relay\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:49:\"A small business site built using GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:6:\"Stream\";a:16:{s:4:\"name\";s:6:\"Stream\";s:9:\"directory\";s:31:\"https://gpsites.co/files/stream\";s:11:\"preview_url\";s:25:\"https://gpsites.co/stream\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:21:\"https://mikeoliver.me\";s:11:\"description\";s:77:\"Promote your podcast &amp; attract new subscribers with GeneratePress Stream.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:11:\"Summer Camp\";a:16:{s:4:\"name\";s:11:\"Summer Camp\";s:9:\"directory\";s:36:\"https://gpsites.co/files/summer-camp\";s:11:\"preview_url\";s:30:\"https://gpsites.co/summer-camp\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:46:\"A summer-camp site built using GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:8:\"Movement\";a:16:{s:4:\"name\";s:8:\"Movement\";s:9:\"directory\";s:33:\"https://gpsites.co/files/movement\";s:11:\"preview_url\";s:27:\"https://gpsites.co/movement\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:58:\"A site for organized movements built using GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:7:\"Capital\";a:16:{s:4:\"name\";s:7:\"Capital\";s:9:\"directory\";s:32:\"https://gpsites.co/files/capital\";s:11:\"preview_url\";s:26:\"https://gpsites.co/capital\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:50:\"A financial-based site built using GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:4:\"Vibe\";a:16:{s:4:\"name\";s:4:\"Vibe\";s:9:\"directory\";s:29:\"https://gpsites.co/files/vibe\";s:11:\"preview_url\";s:24:\"https://gpsites.co/vibe/\";s:11:\"author_name\";s:10:\"Flint Skin\";s:10:\"author_url\";s:22:\"https://flintskin.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:51:\"https://gpsites.co/vibe/wp-content/uploads/sites/40\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:9:\"Portfolio\";a:16:{s:4:\"name\";s:9:\"Portfolio\";s:9:\"directory\";s:35:\"https://gpsites.co/files/portfolio/\";s:11:\"preview_url\";s:28:\"https://gpsites.co/portfolio\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:22:\"https://mikeoliver.me/\";s:11:\"description\";s:75:\"Portfolio is a professional portfolio-style site built with GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:4:\"Geek\";a:16:{s:4:\"name\";s:4:\"Geek\";s:9:\"directory\";s:29:\"https://gpsites.co/files/geek\";s:11:\"preview_url\";s:23:\"https://gpsites.co/geek\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:21:\"https://leohsiang.com\";s:11:\"description\";s:39:\"A blog site built using GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:4:\"Bold\";a:16:{s:4:\"name\";s:4:\"Bold\";s:9:\"directory\";s:29:\"https://gpsites.co/files/bold\";s:11:\"preview_url\";s:24:\"https://gpsites.co/bold/\";s:11:\"author_name\";s:10:\"Flint Skin\";s:10:\"author_url\";s:22:\"https://flintskin.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:51:\"https://gpsites.co/bold/wp-content/uploads/sites/41\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Frame\";a:16:{s:4:\"name\";s:5:\"Frame\";s:9:\"directory\";s:30:\"https://gpsites.co/files/frame\";s:11:\"preview_url\";s:24:\"https://gpsites.co/frame\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:21:\"https://leohsiang.com\";s:11:\"description\";s:47:\"A construction site built using GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:4:\"Flow\";a:16:{s:4:\"name\";s:4:\"Flow\";s:9:\"directory\";s:29:\"https://gpsites.co/files/flow\";s:11:\"preview_url\";s:23:\"https://gpsites.co/flow\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:21:\"https://leohsiang.com\";s:11:\"description\";s:102:\"Flow is site made for Yoga, wellness studios and gym. It is built with GenerateBlocks and minimal CSS.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:7:\"Vinyasa\";a:16:{s:4:\"name\";s:7:\"Vinyasa\";s:9:\"directory\";s:32:\"https://gpsites.co/files/vinyasa\";s:11:\"preview_url\";s:27:\"https://gpsites.co/vinyasa/\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:22:\"https://mikeoliver.me/\";s:11:\"description\";s:124:\"Vinyasa is a clean and zen site made for yoga, pilates and wellness studios. Built with GenerateBlocks and the block editor.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:7:\"Tmrland\";a:16:{s:4:\"name\";s:7:\"Tmrland\";s:9:\"directory\";s:32:\"https://gpsites.co/files/tmrland\";s:11:\"preview_url\";s:27:\"https://gpsites.co/tmrland/\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:21:\"https://leohsiang.com\";s:11:\"description\";s:49:\"A small business site built using GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:4:\"Solo\";a:16:{s:4:\"name\";s:4:\"Solo\";s:9:\"directory\";s:29:\"https://gpsites.co/files/solo\";s:11:\"preview_url\";s:23:\"https://gpsites.co/solo\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:48:\"A music-based landing page using GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:7:\"Emerald\";a:16:{s:4:\"name\";s:7:\"Emerald\";s:9:\"directory\";s:33:\"https://gpsites.co/files/emerald/\";s:11:\"preview_url\";s:27:\"https://gpsites.co/emerald/\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:22:\"https://leohsiang.com/\";s:11:\"description\";s:77:\"Emerald is a clean e-commerce site built with WooCommerce and GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:10:\"e-Commerce\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:183:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\",\"WooCommerce Blocks\":\"woo-gutenberg-products-block/woocommerce-gutenberg-products-block.php\",\"WooCommerce\":\"woocommerce/woocommerce.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:4:\"Idea\";a:16:{s:4:\"name\";s:4:\"Idea\";s:9:\"directory\";s:29:\"https://gpsites.co/files/idea\";s:11:\"preview_url\";s:23:\"https://gpsites.co/idea\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:22:\"https://leohsiang.com/\";s:11:\"description\";s:51:\"A project-based website built using GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:3:\"App\";a:16:{s:4:\"name\";s:3:\"App\";s:9:\"directory\";s:28:\"https://gpsites.co/files/app\";s:11:\"preview_url\";s:22:\"https://gpsites.co/app\";s:11:\"author_name\";s:17:\"George Mitropapas\";s:10:\"author_url\";s:28:\"https://www.gmitropapas.com/\";s:11:\"description\";s:64:\"App is a simple landing page website built using GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Ethos\";a:16:{s:4:\"name\";s:5:\"Ethos\";s:9:\"directory\";s:30:\"https://gpsites.co/files/ethos\";s:11:\"preview_url\";s:24:\"https://gpsites.co/ethos\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:22:\"https://mikeoliver.me/\";s:11:\"description\";s:79:\"Ethos is a lightweight block based site built for attorney’s &amp; law firms.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:7:\"Landing\";a:16:{s:4:\"name\";s:7:\"Landing\";s:9:\"directory\";s:32:\"https://gpsites.co/files/landing\";s:11:\"preview_url\";s:26:\"https://gpsites.co/landing\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:22:\"https://mikeoliver.me/\";s:11:\"description\";s:81:\"Landing is a vibrant landing page built with GenerateBlocks and the block editor.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Wired\";a:16:{s:4:\"name\";s:5:\"Wired\";s:9:\"directory\";s:31:\"https://gpsites.co/files/wired/\";s:11:\"preview_url\";s:24:\"https://gpsites.co/wired\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:21:\"https://mikeoliver.me\";s:11:\"description\";s:91:\"Wired is a series of monochrome block templates you can use to jumpstart your next website.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Decor\";a:16:{s:4:\"name\";s:5:\"Decor\";s:9:\"directory\";s:30:\"https://gpsites.co/files/decor\";s:11:\"preview_url\";s:24:\"https://gpsites.co/decor\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:22:\"https://leohsiang.com/\";s:11:\"description\";s:76:\"Decor is a simple e-commerce site built with WooCommerce and GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:10:\"e-Commerce\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:183:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\",\"WooCommerce Blocks\":\"woo-gutenberg-products-block/woocommerce-gutenberg-products-block.php\",\"WooCommerce\":\"woocommerce/woocommerce.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:8:\"Studio 7\";a:16:{s:4:\"name\";s:8:\"Studio 7\";s:9:\"directory\";s:33:\"https://gpsites.co/files/studio-7\";s:11:\"preview_url\";s:27:\"https://gpsites.co/studio-7\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:21:\"https://leohsiang.com\";s:11:\"description\";s:115:\"Studio 7 is a abstract style site made for studios and agencies. It is built with GenerateBlocks and no custom CSS.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:7:\"Feather\";a:16:{s:4:\"name\";s:7:\"Feather\";s:9:\"directory\";s:32:\"https://gpsites.co/files/feather\";s:11:\"preview_url\";s:26:\"https://gpsites.co/feather\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:22:\"https://leohsiang.com/\";s:11:\"description\";s:62:\"An abstract style WooCommerce store built with GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:10:\"e-Commerce\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:90:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\",\"WooCommerce\":\"woocommerce/woocommerce.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Aroma\";a:16:{s:4:\"name\";s:5:\"Aroma\";s:9:\"directory\";s:30:\"https://gpsites.co/files/aroma\";s:11:\"preview_url\";s:24:\"https://gpsites.co/aroma\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:22:\"https://leohsiang.com/\";s:11:\"description\";s:84:\"A clean and modern eCommerce store built with GenerateBlocks and WooCommerce blocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:10:\"e-Commerce\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:138:\"{\"WooCommerce Blocks\":\"woo-gutenberg-products-block/woocommerce-gutenberg-products-block.php\",\"WooCommerce\":\"woocommerce/woocommerce.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Split\";a:16:{s:4:\"name\";s:5:\"Split\";s:9:\"directory\";s:30:\"https://gpsites.co/files/split\";s:11:\"preview_url\";s:24:\"https://gpsites.co/split\";s:11:\"author_name\";s:13:\"GeneratePress\";s:10:\"author_url\";s:25:\"https://generatepress.com\";s:11:\"description\";s:51:\"A simple multipurpose site with a split navigation.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Dance\";a:16:{s:4:\"name\";s:5:\"Dance\";s:9:\"directory\";s:30:\"https://gpsites.co/files/dance\";s:11:\"preview_url\";s:24:\"https://gpsites.co/dance\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:22:\"https://leohsiang.com/\";s:11:\"description\";s:61:\"A modern blog built with content template and GenerateBlocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:4:\"Read\";a:16:{s:4:\"name\";s:4:\"Read\";s:9:\"directory\";s:29:\"https://gpsites.co/files/read\";s:11:\"preview_url\";s:23:\"https://gpsites.co/read\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:22:\"https://mikeoliver.me/\";s:11:\"description\";s:81:\"Read is a simple magazine-style blog built with GenerateBlocks and WP Show Posts.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:6:\"Agency\";a:16:{s:4:\"name\";s:6:\"Agency\";s:9:\"directory\";s:31:\"https://gpsites.co/files/agency\";s:11:\"preview_url\";s:25:\"https://gpsites.co/agency\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:22:\"https://mikeoliver.me/\";s:11:\"description\";s:119:\"Agency was created for designers and businesses to showcase their work. Built with GenerateBlocks and the block editor.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Niche\";a:16:{s:4:\"name\";s:5:\"Niche\";s:9:\"directory\";s:30:\"https://gpsites.co/files/niche\";s:11:\"preview_url\";s:25:\"https://gpsites.co/niche/\";s:11:\"author_name\";s:10:\"Flint Skin\";s:10:\"author_url\";s:22:\"https://flintskin.com/\";s:11:\"description\";s:94:\"Niche is a minimalist shop design with a focus on product images. Simple with no distractions.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:10:\"e-Commerce\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:45:\"{\"WooCommerce\":\"woocommerce/woocommerce.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:8:\"Slideout\";a:16:{s:4:\"name\";s:8:\"Slideout\";s:9:\"directory\";s:33:\"https://gpsites.co/files/slideout\";s:11:\"preview_url\";s:27:\"https://gpsites.co/slideout\";s:11:\"author_name\";s:13:\"GeneratePress\";s:10:\"author_url\";s:25:\"https://generatepress.com\";s:11:\"description\";s:72:\"A simple modern design with a fixed side bar that opens a slideout area.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:158:\"{\"Menu Icons\":\"menu-icons/menu-icons.php\",\"Recent Posts Widget With Thumbnails\":\"recent-posts-widget-with-thumbnails/recent-posts-widget-with-thumbnails.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:4:\"Java\";a:16:{s:4:\"name\";s:4:\"Java\";s:9:\"directory\";s:29:\"https://gpsites.co/files/java\";s:11:\"preview_url\";s:24:\"https://gpsites.co/java/\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:22:\"https://mikeoliver.me/\";s:11:\"description\";s:132:\"Java is perfect for any restaurant, café or coffee shop looking to show their menu. Built with GenerateBlocks and the block editor.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:6:\"Arctic\";a:16:{s:4:\"name\";s:6:\"Arctic\";s:9:\"directory\";s:31:\"https://gpsites.co/files/arctic\";s:11:\"preview_url\";s:25:\"https://gpsites.co/arctic\";s:11:\"author_name\";s:13:\"GeneratePress\";s:10:\"author_url\";s:25:\"https://generatepress.com\";s:11:\"description\";s:68:\"A super lightweight, adaptable site with no plugins and minimal CSS.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:2:\"[]\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:7:\"Service\";a:16:{s:4:\"name\";s:7:\"Service\";s:9:\"directory\";s:32:\"https://gpsites.co/files/service\";s:11:\"preview_url\";s:27:\"https://gpsites.co/service/\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:22:\"https://mikeoliver.me/\";s:11:\"description\";s:123:\"Service is a multi-purpose business site to promote the services you offer. Built with GenerateBlocks and the block editor.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:129:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\",\"Lightweight Social Icons\":\"lightweight-social-icons/lightweight-social-icons.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:7:\"Imprint\";a:16:{s:4:\"name\";s:7:\"Imprint\";s:9:\"directory\";s:32:\"https://gpsites.co/files/imprint\";s:11:\"preview_url\";s:27:\"https://gpsites.co/imprint/\";s:11:\"author_name\";s:10:\"Flint Skin\";s:10:\"author_url\";s:22:\"https://flintskin.com/\";s:11:\"description\";s:118:\"Imprint is a super minimalist GeneratePress Shop Site. Designed for selling posters, prints and single image products.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:10:\"e-Commerce\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:45:\"{\"WooCommerce\":\"woocommerce/woocommerce.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:6:\"Access\";a:16:{s:4:\"name\";s:6:\"Access\";s:9:\"directory\";s:31:\"https://gpsites.co/files/access\";s:11:\"preview_url\";s:26:\"https://gpsites.co/access/\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:22:\"https://mikeoliver.me/\";s:11:\"description\";s:126:\"Access is a smooth scroll landing page created to help you grow your audience. Built with GenerateBlocks and the block editor.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:8:\"Vacation\";a:16:{s:4:\"name\";s:8:\"Vacation\";s:9:\"directory\";s:33:\"https://gpsites.co/files/vacation\";s:11:\"preview_url\";s:27:\"https://gpsites.co/vacation\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:22:\"https://leohsiang.com/\";s:11:\"description\";s:137:\"A site for vacation rental companies or any small businesses to show case their services. It\'s built with GenerateBlocks and minimal CSS.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:6:\"Mentor\";a:16:{s:4:\"name\";s:6:\"Mentor\";s:9:\"directory\";s:31:\"https://gpsites.co/files/mentor\";s:11:\"preview_url\";s:25:\"https://gpsites.co/mentor\";s:11:\"author_name\";s:10:\"Flint Skin\";s:10:\"author_url\";s:22:\"https://flintskin.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:7:\"LearnEd\";a:16:{s:4:\"name\";s:7:\"LearnEd\";s:9:\"directory\";s:32:\"https://gpsites.co/files/learned\";s:11:\"preview_url\";s:26:\"https://gpsites.co/learned\";s:11:\"author_name\";s:10:\"Flint Skin\";s:10:\"author_url\";s:22:\"https://flintskin.com/\";s:11:\"description\";s:83:\"Built with Elementor (free), LearnEd is a sign-up landing page for course creators.\";s:12:\"page_builder\";a:1:{i:0;s:9:\"Elementor\";}s:8:\"category\";a:0:{}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:74:\"{\"Elementor\":\"elementor/elementor.php\",\"Safe SVG\":\"safe-svg/safe-svg.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:6:\"Volume\";a:16:{s:4:\"name\";s:6:\"Volume\";s:9:\"directory\";s:31:\"https://gpsites.co/files/volume\";s:11:\"preview_url\";s:25:\"https://gpsites.co/volume\";s:11:\"author_name\";s:10:\"Flint Skin\";s:10:\"author_url\";s:22:\"https://flintskin.com/\";s:11:\"description\";s:103:\"A clean canvas site for content creators. Featuring custom navigation, author box and bold page heroes.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:6:\"Mellow\";a:16:{s:4:\"name\";s:6:\"Mellow\";s:9:\"directory\";s:31:\"https://gpsites.co/files/mellow\";s:11:\"preview_url\";s:25:\"https://gpsites.co/mellow\";s:11:\"author_name\";s:13:\"GeneratePress\";s:10:\"author_url\";s:25:\"https://generatepress.com\";s:11:\"description\";s:50:\"A stylish multipurpose site with bold hero images.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:8:\"Abstract\";a:16:{s:4:\"name\";s:8:\"Abstract\";s:9:\"directory\";s:33:\"https://gpsites.co/files/abstract\";s:11:\"preview_url\";s:27:\"https://gpsites.co/abstract\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:22:\"https://mikeoliver.me/\";s:11:\"description\";s:130:\"Abstract is a BW minimal portfolio site for freelancers, artist and photographers. Built with GenerateBlocks and the block editor.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:252:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\",\"Lightweight Social Icons\":\"lightweight-social-icons/lightweight-social-icons.php\",\"MC4WP: Mailchimp for WordPress\":\"mailchimp-for-wp/mailchimp-for-wp.php\",\"WP Show Posts\":\"wp-show-posts/wp-show-posts.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:8:\"Spacious\";a:16:{s:4:\"name\";s:8:\"Spacious\";s:9:\"directory\";s:33:\"https://gpsites.co/files/spacious\";s:11:\"preview_url\";s:27:\"https://gpsites.co/spacious\";s:11:\"author_name\";s:13:\"GeneratePress\";s:10:\"author_url\";s:25:\"https://generatepress.com\";s:11:\"description\";s:96:\"A spacious layout with a unique menu/sidebar. This site makes your content the number one focus.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:140:\"{\"Lightweight Social Icons\":\"lightweight-social-icons/lightweight-social-icons.php\",\"WP Featherlight\":\"wp-featherlight/wp-featherlight.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:7:\"Article\";a:16:{s:4:\"name\";s:7:\"Article\";s:9:\"directory\";s:32:\"https://gpsites.co/files/article\";s:11:\"preview_url\";s:26:\"https://gpsites.co/article\";s:11:\"author_name\";s:13:\"GeneratePress\";s:10:\"author_url\";s:25:\"https://generatepress.com\";s:11:\"description\";s:45:\"A bold site for writers and small businesses.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:6:\"Charge\";a:16:{s:4:\"name\";s:6:\"Charge\";s:9:\"directory\";s:31:\"https://gpsites.co/files/charge\";s:11:\"preview_url\";s:25:\"https://gpsites.co/charge\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:22:\"https://leohsiang.com/\";s:11:\"description\";s:74:\"A stylish multipurpose site with full-body CSS gradient and hover effects.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Tasty\";a:16:{s:4:\"name\";s:5:\"Tasty\";s:9:\"directory\";s:30:\"https://gpsites.co/files/tasty\";s:11:\"preview_url\";s:24:\"https://gpsites.co/tasty\";s:11:\"author_name\";s:13:\"GeneratePress\";s:10:\"author_url\";s:25:\"https://generatepress.com\";s:11:\"description\";s:64:\"A simple recipe site that focuses on typography and white space.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:273:\"{\"Lightweight Social Icons\":\"lightweight-social-icons/lightweight-social-icons.php\",\"MC4WP: Mailchimp for WordPress\":\"mailchimp-for-wp/mailchimp-for-wp.php\",\"Recent Posts Widget With Thumbnails\":\"recent-posts-widget-with-thumbnails/recent-posts-widget-with-thumbnails.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Grill\";a:16:{s:4:\"name\";s:5:\"Grill\";s:9:\"directory\";s:30:\"https://gpsites.co/files/grill\";s:11:\"preview_url\";s:25:\"https://gpsites.co/grill/\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:21:\"https://leohsiang.com\";s:11:\"description\";s:87:\"A site for restaurants utilizing GP features and GenerateBlocks with no additional CSS.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:9:\"Broadcast\";a:16:{s:4:\"name\";s:9:\"Broadcast\";s:9:\"directory\";s:34:\"https://gpsites.co/files/broadcast\";s:11:\"preview_url\";s:29:\"https://gpsites.co/broadcast/\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:21:\"https://leohsiang.com\";s:11:\"description\";s:64:\"A modern style blog with simple CSS hover effects and gradients.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:6:\"Rumour\";a:16:{s:4:\"name\";s:6:\"Rumour\";s:9:\"directory\";s:31:\"https://gpsites.co/files/rumour\";s:11:\"preview_url\";s:26:\"https://gpsites.co/rumour/\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:21:\"https://leohsiang.com\";s:11:\"description\";s:62:\"A dark theme style news/magazine layout blog with minimal CSS.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Merch\";a:16:{s:4:\"name\";s:5:\"Merch\";s:9:\"directory\";s:30:\"https://gpsites.co/files/merch\";s:11:\"preview_url\";s:24:\"https://gpsites.co/merch\";s:11:\"author_name\";s:10:\"Flint Skin\";s:10:\"author_url\";s:22:\"https://flintskin.com/\";s:11:\"description\";s:97:\"A Woo Shop sporting all the great GPP 1.8 features with a custom blog and Gutenberg landing page.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:10:\"e-Commerce\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:211:\"{\"Advanced Woo Search\":\"advanced-woo-search/advanced-woo-search.php\",\"Happyforms (free)\":\"happyforms/happyforms.php\",\"WooCommerce\":\"woocommerce/woocommerce.php\",\"WP Show Posts\":\"wp-show-posts/wp-show-posts.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:7:\"Liberte\";a:16:{s:4:\"name\";s:7:\"Liberte\";s:9:\"directory\";s:32:\"https://gpsites.co/files/liberte\";s:11:\"preview_url\";s:27:\"https://gpsites.co/liberte/\";s:11:\"author_name\";s:10:\"Flint Skin\";s:10:\"author_url\";s:22:\"https://flintskin.com/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:4:\"Blog\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:54:\"https://gpsites.co/liberte/wp-content/uploads/sites/39\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Prime\";a:16:{s:4:\"name\";s:5:\"Prime\";s:9:\"directory\";s:30:\"https://gpsites.co/files/prime\";s:11:\"preview_url\";s:24:\"https://gpsites.co/prime\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:22:\"https://leohsiang.com/\";s:11:\"description\";s:61:\"An Amazon-inspired online shop built with WooCommerce Blocks.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:10:\"e-Commerce\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:90:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\",\"WooCommerce\":\"woocommerce/woocommerce.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Trade\";a:16:{s:4:\"name\";s:5:\"Trade\";s:9:\"directory\";s:30:\"https://gpsites.co/files/trade\";s:11:\"preview_url\";s:24:\"https://gpsites.co/trade\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:22:\"https://mikeoliver.me/\";s:11:\"description\";s:156:\"Designed for service based businesses and tradesman, Trade has all the elements for any small business looking to increase leads and promote their services.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:5:\"Pivot\";a:16:{s:4:\"name\";s:5:\"Pivot\";s:9:\"directory\";s:30:\"https://gpsites.co/files/pivot\";s:11:\"preview_url\";s:28:\"https://gpsites.co/pivot-gb/\";s:11:\"author_name\";s:11:\"Mike Oliver\";s:10:\"author_url\";s:22:\"https://mikeoliver.me/\";s:11:\"description\";s:0:\"\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:8:\"Business\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:46:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}s:6:\"Target\";a:16:{s:4:\"name\";s:6:\"Target\";s:9:\"directory\";s:31:\"https://gpsites.co/files/target\";s:11:\"preview_url\";s:25:\"https://gpsites.co/target\";s:11:\"author_name\";s:9:\"LH Studio\";s:10:\"author_url\";s:22:\"https://leohsiang.com/\";s:11:\"description\";s:160:\"A simple, modern style Woocommerce site to showcase your products. It\'s integrated with GenerateBlocks, WP Show Posts, Lightweight Social Icons, and MailChimps.\";s:12:\"page_builder\";a:1:{i:0;s:15:\"No Page Builder\";}s:8:\"category\";a:1:{i:0;s:10:\"e-Commerce\";}s:11:\"min_version\";s:5:\"2.4.0\";s:17:\"min_theme_version\";s:5:\"3.4.0\";s:26:\"min_generateblocks_version\";s:5:\"1.7.0\";s:11:\"uploads_url\";s:0:\"\";s:7:\"plugins\";s:90:\"{\"GenerateBlocks\":\"generateblocks/plugin.php\",\"WooCommerce\":\"woocommerce/woocommerce.php\"}\";s:13:\"documentation\";s:0:\"\";s:11:\"image_width\";i:600;s:12:\"image_height\";i:600;}}","off");

INSERT IGNORE INTO `wp_options` VALUES 
("194","generatepress_sites_expiration","1724074040","off"),
("195","edd_sl_3507e13764e25ba1399670b192cbf676","a:2:{s:7:\"timeout\";i:1740971755;s:5:\"value\";s:65212:\"{\"new_version\":\"2.5.1\",\"stable_version\":\"2.5.1\",\"name\":\"GP Premium\",\"slug\":\"gp-premium\",\"url\":\"https:\\/\\/generatepress.com\\/downloads\\/gp-premium\\/?changelog=1\",\"last_updated\":\"2025-02-12 17:12:05\",\"homepage\":\"https:\\/\\/generatepress.com\\/downloads\\/gp-premium\\/\",\"package\":\"https:\\/\\/generatepress.com\\/edd-sl\\/package_download\\/MTc0MTAyMjE1NTowZWNiYmI1MGMzMmQ0Mzc2NmUwYmRkYWExNjI5OTk0MToyNTQ0MTpkNjA5YWVmNWQxNDJmODk1ZGJlNDUyMDM3MWM4YjBlMzpodHRwc0AvL2Jlc3QtdWx0cmF3aW4uY29tOjA=\",\"download_link\":\"https:\\/\\/generatepress.com\\/edd-sl\\/package_download\\/MTc0MTAyMjE1NTowZWNiYmI1MGMzMmQ0Mzc2NmUwYmRkYWExNjI5OTk0MToyNTQ0MTpkNjA5YWVmNWQxNDJmODk1ZGJlNDUyMDM3MWM4YjBlMzpodHRwc0AvL2Jlc3QtdWx0cmF3aW4uY29tOjA=\",\"sections\":{\"description\":\"<p>The entire collection of GeneratePress premium modules. Once activated, each module extends certain aspects of GeneratePress, giving you more options to build your website.<\\/p>\\n<h4> Documentation <\\/h4>\\n<p>Check out our <a href=\\\"https:\\/\\/docs.generatepress.com\\\">documentation<\\/a> for more information on each module and how to use them.<\\/p>\",\"changelog\":\"<h4> 2.5.1 <\\/h4>\\n<ul>\\n<li>Feature: Serve new GenerateBlocks 2.0 sites in the Site Library<\\/li>\\n<li>Feature: Add more GenerateBlocks 2.0 dynamic tags if GB Pro is not active<\\/li>\\n<li>Feature: Add support for Font Library when importing starter sites<\\/li>\\n<li>Fix: Missing Elements Display Rules in some configurations<\\/li>\\n<\\/ul>\\n<h4> 2.5.0 <\\/h4>\\n<ul>\\n<li>Feature: Font Library<\\/li>\\n<li>Feature: Install Google Fonts locally<\\/li>\\n<li>Feature: Upload custom fonts locally<\\/li>\\n<li>Fix: Apply button color settings to WooCommerce block buttons<\\/li>\\n<li>Fix: WooCommerce button typography<\\/li>\\n<li>Fix: Check if <code>DISALLOW_FILE_EDIT<\\/code> is set to true for PHP Elements<\\/li>\\n<li>Fix: Use up to date react render functions<\\/li>\\n<li>Tweak: Allow Display Rules metabox to collapse<\\/li>\\n<li>Accessibility: Add aria-label to secondary navigation<\\/li>\\n<\\/ul>\\n<h4> 2.4.1 <\\/h4>\\n<ul>\\n<li>Security: Harden variable against XSS attacks<\\/li>\\n<\\/ul>\\n<h4> 2.4.0 <\\/h4>\\n<ul>\\n<li>Security: Disallow scripts in custom field template tags<\\/li>\\n<li>Important: Requires PHP 7.2 or greater<\\/li>\\n<li>Feature: Improve Site Library filters<\\/li>\\n<li>Feature: Add search capability in Site Library<\\/li>\\n<li>Feature: Allow author searching in Site Library<\\/li>\\n<li>Feature: Add <code>generate_smooth_scroll_offset<\\/code> filter<\\/li>\\n<li>Feature: Use built-in read more text filters<\\/li>\\n<li>Fix: PHP 8.1 notices<\\/li>\\n<li>Fix: Display posts in columns option changes Query Loop blocks<\\/li>\\n<li>Fix: Remove no-csstransforms3d CSS from off canvas panel<\\/li>\\n<li>Fix: Display Rules taxonomies missing when has_archive disabled<\\/li>\\n<li>Fix: Navigation logo undefined array keys<\\/li>\\n<li>Tweak: Update Content Template templates<\\/li>\\n<li>Tweak: Update Archive Navigation templates<\\/li>\\n<li>Tweak: Update Page Hero templates<\\/li>\\n<li>Tweak: Update post meta templates<\\/li>\\n<li>Tweak: Update post navigation templates<\\/li>\\n<li>Tweak: Update site footer templates<\\/li>\\n<li>Tweak: Remove deprecated filter_input functions<\\/li>\\n<li>General: Updated translations<\\/li>\\n<\\/ul>\\n<h4> 2.3.2 <\\/h4>\\n<ul>\\n<li>Tweak: Remove deprecated wp_get_loading_attr_default function<\\/li>\\n<\\/ul>\\n<h4> 2.3.1 <\\/h4>\\n<ul>\\n<li>Fix: SelectSearch component infinite loop<\\/li>\\n<li>Fix: Block widths inside Block Elements<\\/li>\\n<\\/ul>\\n<h4> 2.3.0 <\\/h4>\\n<ul>\\n<li>Feature: Add Search Modal Element type<\\/li>\\n<li>Fix: Inline post meta feature in GenerateBlocks 1.7<\\/li>\\n<li>Fix: Close \\\"Choose Element Type\\\" modal with ESC key<\\/li>\\n<li>Fix: Replace WooCommerce secondary image attachment size<\\/li>\\n<li>Fix: WP Filesystem error missing credentials<\\/li>\\n<li>Fix: Undefined array keys in dynamic Container URL<\\/li>\\n<li>Fix: Author avatar in Header\\/Block Element titles<\\/li>\\n<li>Fix: Infinite loop error when autosaving with dynamic content block<\\/li>\\n<li>Fix: Add aria-label to off-canvas panel button<\\/li>\\n<li>Fix: WooCommerce button dynamic typography<\\/li>\\n<li>Fix: Empty WooCommerce quantity fields<\\/li>\\n<li>Fix: PHP 8.1 notice using disable elements in Customizer<\\/li>\\n<li>Tweak: Improve license key area<\\/li>\\n<li>Tweak: Improve off-canvas transitions<\\/li>\\n<li>Tweak: Check for WooCommerce functions<\\/li>\\n<li>Tweak: Open off-canvas using space bar<\\/li>\\n<li>Tweak: Use image ID in mobile header\\/sticky nav logos<\\/li>\\n<li>Tweak: Improve Elements hook selection dropdown UI<\\/li>\\n<li>Tweak: Add site library check for min GenerateBlocks version<\\/li>\\n<li>Tweak: Add Loop Template to Custom Post Type dropdown filters<\\/li>\\n<\\/ul>\\n<h4> 2.2.2 <\\/h4>\\n<ul>\\n<li>Fix: Off Canvas anchor links not working<\\/li>\\n<\\/ul>\\n<h4> 2.2.1 <\\/h4>\\n<ul>\\n<li>Fix: Add value to off-canvas aria-hidden attribute<\\/li>\\n<li>Tweak: Remove\\/add aria-hidden to off-canvas on toggle<\\/li>\\n<\\/ul>\\n<h4> 2.2.0 <\\/h4>\\n<ul>\\n<li>Feature: Allow block element autosave<\\/li>\\n<li>Feature: Add revisions to block elements<\\/li>\\n<li>Feature: Add Loop Template block element<\\/li>\\n<li>Feature: Dont display the raw license key in the Dashboard<\\/li>\\n<li>Feature: Add \\\"Paginated Results\\\" to Element Display Rules<\\/li>\\n<li>Fix: Element post navigation template PHP warning when not using GB Pro<\\/li>\\n<li>Fix: Remove unnecessary zoom CSS from featured images<\\/li>\\n<li>Fix: Font icon CSS order<\\/li>\\n<li>Fix: Load more button showing in product tax archives<\\/li>\\n<li>Fix: Prevent tabbing in hidden off-canvas panel<\\/li>\\n<li>Fix: Hide hidden off-canvas panel from screen readers<\\/li>\\n<li>Fix: menu-toggle aria-controls when using off-canvas panel<\\/li>\\n<li>Fix: Focus first focusable element when opening off-canvas panel<\\/li>\\n<li>Fix: Focus slideout toggle when closing off-canvas panel<\\/li>\\n<li>Fix: Off-Canvas Panel sub-menu a11y<\\/li>\\n<li>Fix: Prevent secondary nav legacy typography CSS<\\/li>\\n<li>Fix: Fix dynamic term meta link<\\/li>\\n<li>Fix: Block margins in the block element editor<\\/li>\\n<li>Fix: Embeds in Block Elements<\\/li>\\n<li>Fix: Apply display rules to editor with no ID<\\/li>\\n<li>Fix: Navigation background image applying to secondary nav<\\/li>\\n<li>Fix: WooCommerce order received page float issue<\\/li>\\n<li>Fix: Block element editor error in GenerateBlocks 1.7<\\/li>\\n<li>Tweak: Remove jquery-migrate from sticky script<\\/li>\\n<li>Tweak: Add message in Blog section about Loop Template<\\/li>\\n<\\/ul>\\n<h4> 2.1.2 <\\/h4>\\n<ul>\\n<li>Elements: Fix custom field value in dynamic container links<\\/li>\\n<li>Elements: Fix block widths in the editor<\\/li>\\n<li>General: Fix double slashes in dashboard file request<\\/li>\\n<li>General: Fix missing Customizer translations<\\/li>\\n<\\/ul>\\n<h4> 2.1.1 <\\/h4>\\n<ul>\\n<li>Menu Plus: Fix mobile header sticky auto hide<\\/li>\\n<li>Site Library: Fix broken CSS variables on import<\\/li>\\n<\\/ul>\\n<h4> 2.1.0 <\\/h4>\\n<ul>\\n<li>Blog: Fix masonry JS error if no archive pagination exists<\\/li>\\n<li>Blog: Fix full width featured blog column<\\/li>\\n<li>Colors: Deprecate module if using GP 3.1.0<\\/li>\\n<li>Elements: Add custom class option to dynamic image block<\\/li>\\n<li>Elements: Add support for post_type array in display rules<\\/li>\\n<li>Elements: Fix container link option when targeting next\\/previous posts<\\/li>\\n<li>Menu Plus: Integrate off-canvas panel with new dynamic typography system<\\/li>\\n<li>Menu Plus: Integrate off-canvas panel with new color system<\\/li>\\n<li>Menu Plus: Integrate mobile header HTML attributes with new HTML attribute system<\\/li>\\n<li>Menu Plus: Integrate mobile header and off-canvas panel with new generate_has_active_menu filter<\\/li>\\n<li>Menu Plus: Fix broken inline CSS when using floated sticky navigation<\\/li>\\n<li>Menu Plus: Add logo dimensions to navigation logo<\\/li>\\n<li>Secondary Navigation: Integrate with new color system<\\/li>\\n<li>Secondary Navigation: Integrate with new generate_has_active_menu filter<\\/li>\\n<li>Secondary Navigation: Integrate with new dynamic typography system<\\/li>\\n<li>Secondary Navigation: Reduce box-shadow to match main navigation<\\/li>\\n<li>Secondary Navigation: Change direction of sub-menu box-shadow when opening left<\\/li>\\n<li>Secondary Navigation: Fix sub-menu overlap when using dropdown click\\/mobile<\\/li>\\n<li>Secondary Navigation: Replace box-shadow with border-bottom when sub-menu opens down<\\/li>\\n<li>Site Library: Add site author attribution<\\/li>\\n<li>Typography: Deprecate module if using dynamic typography in GP 3.1.0<\\/li>\\n<li>WooCommerce: Integrate with new dynamic typography system<\\/li>\\n<li>WooCommerce: Integrate with new colors system<\\/li>\\n<li>WooCommerce: Remove category title\\/description if using page hero with title disabled<\\/li>\\n<li>WooCommerce: Remove \\\"speak\\\" CSS properties<\\/li>\\n<li>WooCommerce: Fix empty continue shopping link on mobile<\\/li>\\n<li>WooCommerce: Fix persistent sticky add to cart panel<\\/li>\\n<li>General: Integrate with new GP 3.1.0 Dashboard<\\/li>\\n<li>General: Remove featured-image-active body class if featured image is disabled<\\/li>\\n<li>General: Change date format in exported JSON filename<\\/li>\\n<li>General: Fix PHP error when license key activation returns 403<\\/li>\\n<\\/ul>\\n<h4> 2.0.3 <\\/h4>\\n<ul>\\n<li>Elements: Use block_categories_all filter in WP 5.8<\\/li>\\n<li>Elements: Remove wp-editor dependency from new widget editor<\\/li>\\n<\\/ul>\\n<h4> 2.0.2 <\\/h4>\\n<ul>\\n<li>Elements: Use blog page title for dynamic title if set<\\/li>\\n<li>Spacing: Fix reset button bug in Customizer controls<\\/li>\\n<li>WooCommerce: Fix infinite scroll applying to product taxonomy pages<\\/li>\\n<\\/ul>\\n<h4> 2.0.1 <\\/h4>\\n<ul>\\n<li>Blog: Fix infinite scroll bug on product archives<\\/li>\\n<li>Elements: Fix error in WP 4.9.x versions<\\/li>\\n<li>Menu Plus: Prevent 0x0 logo dimension attributes if no dimensions exist<\\/li>\\n<li>Site Library: Add vertical scroll ability to the Site Library control area<\\/li>\\n<\\/ul>\\n<h4> 2.0.0 <\\/h4>\\n<ul>\\n<li>Blog: Rewrite infinite scroll using vanilla javascript<\\/li>\\n<li>Blog: Rewrite masonry using vanilla javascript<\\/li>\\n<li>Blog: Add separate infinite scroll path element to footer<\\/li>\\n<li>Blog: Fix missing single\\/page featured image options when archive image disabled<\\/li>\\n<li>Blog: Add aria-label instead of screen-reader-text to read more button<\\/li>\\n<li>Colors: Fix back to top Customizer color preview<\\/li>\\n<li>Elements: New Content Template Element<\\/li>\\n<li>Elements: New Post Meta Template Element<\\/li>\\n<li>Elements: New Post Navigation Template Element<\\/li>\\n<li>Elements: New Page Hero Block Element<\\/li>\\n<li>Elements: New Archive Navigation Template Element<\\/li>\\n<li>Elements: New Editor Width option in Block Elements<\\/li>\\n<li>Elements: Move Block Elements options into editor sidebar<\\/li>\\n<li>Elements: Show Site Header options by default in Header Element<\\/li>\\n<li>Elements: Fix Classic Editor issue in Block Elements<\\/li>\\n<li>Elements: Add a list of active Elements to page editor<\\/li>\\n<li>Elements: Add a list of active Elements to the admin bar<\\/li>\\n<li>Elements: Add notices to Customizer if Elements may be overwriting options<\\/li>\\n<li>Elements: Disable mobile header menu if menu is disabled via Layout Element<\\/li>\\n<li>Elements: Improve Display Rule loading performance<\\/li>\\n<li>Elements: Add block type filter to Elements dashboard<\\/li>\\n<li>Elements: Add generate_element_display filter<\\/li>\\n<li>Elements: Add No Results as a Display Rule condition<\\/li>\\n<li>Menu Plus: Hide slideout toggle at set mobile menu breakpoint value<\\/li>\\n<li>Menu Plus: Fix sticky menu height when using navigation as header<\\/li>\\n<li>Menu Plus: Add dimensions to mobile\\/sticky logos<\\/li>\\n<li>Menu Plus: Make Off-Canvas menu take up full width of canvas<\\/li>\\n<li>Menu Plus: Fix menu bar item sticky transition<\\/li>\\n<li>Menu Plus: Prevent sticky sidebar nav if mobile header is set to sticky<\\/li>\\n<li>Secondary Nav: Fix centered secondary navigation items using flexbox<\\/li>\\n<li>Secondary Nav: Fix conflict with Nav as Header option<\\/li>\\n<li>Secondary Nav: Fix missing menu cart items when using click dropdowns<\\/li>\\n<li>Sections: Officially deprecate module<\\/li>\\n<li>Site Library: Completely rebuild Site Library using React<\\/li>\\n<li>WooCommerce: Move full width single product CSS to inline CSS<\\/li>\\n<li>WooCommerce: Use wc_get_product() instead of new WC_Product()<\\/li>\\n<li>WooCommerce: Add more checks for WC() class to prevent error logs<\\/li>\\n<li>WooCommerce: Add generate_wc_cart_panel_checkout_button_output filter<\\/li>\\n<li>WooCommerce: Add generate_wc_sticky_add_to_cart_action filter<\\/li>\\n<li>WooCommerce: Add generate_wc_show_sticky_add_to_cart filter<\\/li>\\n<li>WooCommerce: Re-write quantity button javascript to be more performant\\/extendable<\\/li>\\n<li>General: Update theme install link<\\/li>\\n<li>General: Update alpha color picker script<\\/li>\\n<li>General: Use correct URL scheme in external stylesheet URLs<\\/li>\\n<li>General: Check if FS_CHMOD_FILE is defined in external stylesheet generation<\\/li>\\n<li>General: Use inline CSS when using AMP plugin<\\/li>\\n<li>General: Update EDD_SL_Plugin_Updater class to 1.8.0<\\/li>\\n<li>General: Clean up javascript throughout plugin<\\/li>\\n<li>General: Replace deprecated jQuery functions<\\/li>\\n<\\/ul>\\n<h4> 1.12.3 <\\/h4>\\n<ul>\\n<li>WooCommerce: Fix quantity buttons in WP 5.6<\\/li>\\n<\\/ul>\\n<h4> 1.12.2 <\\/h4>\\n<ul>\\n<li>Blog: Load columns CSS when using filter to enable it anywhere<\\/li>\\n<li>Menu Plus: Fix sticky mobile header jump when using inline mobile toggle<\\/li>\\n<li>Menu Plus: Add margin to sticky nav branding when set to full width<\\/li>\\n<li>Menu Plus: Disable sticky nav container text align padding<\\/li>\\n<li>Menu Plus: Make mobile menu absolute only when smooth scroll is enabled<\\/li>\\n<li>Menu Plus: Improve nav as header\\/mobile header when using flexbox<\\/li>\\n<li>Menu Plus: Prevent off-canvas panel close button from flashing visible when closing<\\/li>\\n<li>Spacing: Fix custom nav search height<\\/li>\\n<\\/ul>\\n<h4> 1.12.1 <\\/h4>\\n<ul>\\n<li>Typography: Fix missing heading font size controls in the Customizer<\\/li>\\n<\\/ul>\\n<h4> 1.12.0 <\\/h4>\\n<ul>\\n<li>Blog: Fix column margin on mobile with some caching plugins<\\/li>\\n<li>Blog: Add post-load trigger to infinite scroll for better plugin compatibility<\\/li>\\n<li>Blog: Take generate_blog_columns filter into account when loading columns CSS<\\/li>\\n<li>Colors: Add search menu-bar-item color live preview to Customizer<\\/li>\\n<li>Elements: Fix broken custom hook field in Block Elements<\\/li>\\n<li>Elements: Integrate page hero with text container alignment in GP 3.0<\\/li>\\n<li>Elements: Better integrate Header Element colors with GP 3.0<\\/li>\\n<li>Elements: Only disable content title when {{post_title}} is present on single pages<\\/li>\\n<li>Elements: Fix  tag in metabox<\\/li>\\n<li>Elements: Add generate_elements_metabox_ajax_allow_editors filter<\\/li>\\n<li>Elements: Add new 3.0 hooks to hook selector<\\/li>\\n<li>Elements: Re-add generate_elements_custom_args filter<\\/li>\\n<li>Menu Plus: Better prepare navigation as header for GP 3.0<\\/li>\\n<li>Menu Plus: Better prepare Off-Canvas Panel for GP 3.0<\\/li>\\n<li>Menu Plus: Better prepare sticky navigation for GP 3.0<\\/li>\\n<li>Menu Plus: Add has-menu-bar-items class to mobile header if needed<\\/li>\\n<li>Menu Plus: Add is-logo-image class to all site logos<\\/li>\\n<li>Menu Plus: Fix mobile header alignment when it has menu bar items<\\/li>\\n<li>Secondary Nav: Better prepare sticky navigation for GP 3.0<\\/li>\\n<li>Secondary Nav: Fix hidden navigation widget in top bar when merged with secondary nav<\\/li>\\n<li>Sites: Improve the option-only import feature<\\/li>\\n<li>Sites: Improve the refresh sites button functionality<\\/li>\\n<li>Sites: Improve the undo site import functionality<\\/li>\\n<li>Sites: Fix Elementor site import issues<\\/li>\\n<li>Sites: Re-add Elementor sites to library<\\/li>\\n<li>Spacing: Better prepare Customizer live preview for GP 3.0<\\/li>\\n<li>Spacing: Fix blog column spacing Customizer live preview<\\/li>\\n<li>Spacing: Stop handling mobile header, widget and footer widget features added in GP 3.0<\\/li>\\n<li>Typography: Add mobile font size control for H3 (when using GP 3.0)<\\/li>\\n<li>Typography: Add mobile font size control for H4 (when using GP 3.0)<\\/li>\\n<li>Typography: Add mobile font size control for H5 (when using GP 3.0)<\\/li>\\n<li>Typography: Allow empty tablet and mobile site title font size values<\\/li>\\n<li>Typography: Make menu toggle CSS selector specific to primary navigation<\\/li>\\n<li>WooCommerce: Use CSS for secondary product image functionality instead of JS<\\/li>\\n<li>WooCommerce: Only load .js file if needed<\\/li>\\n<li>WooCommerce: Fix quantity box functionality when multiple quantity boxes exist on the page<\\/li>\\n<li>General: Improve alpha color picker script for better 5.5 compatibility<\\/li>\\n<li>General: Move child theme stylesheet after dynamic stylesheet if enabled<\\/li>\\n<li>General: Update gp-premium-de_DE.mo<\\/li>\\n<li>General: Update gp-premium-es_ES.mo<\\/li>\\n<li>General: Update gp-premium-fi.mo<\\/li>\\n<li>General: Update gp-premium-pt_PT.mo<\\/li>\\n<li>General: Update gp-premium-sv_SE.mo<\\/li>\\n<\\/ul>\\n<h4> 1.11.3 <\\/h4>\\n<ul>\\n<li>Blog: Set widths to grid-sizer element<\\/li>\\n<li>Elements: Fix legacy Page Header\\/Hooks buttons in the Elements dashboard<\\/li>\\n<li>Page Header: Replace .load() with .on(\'load\')<\\/li>\\n<li>Page Header: Fix color picker error in WP 5.5<\\/li>\\n<\\/ul>\\n<h4> 1.11.2 <\\/h4>\\n<ul>\\n<li>Blog: Remove negative featured image top margin from columns when using one container<\\/li>\\n<li>Blog: Fix infinite scroll items loading above viewport when using columns<\\/li>\\n<li>Blog: Fix infinite scroll featured images not displaying in Safari<\\/li>\\n<li>Elements: Prevent error in editor when generate_get_option() function doesn\'t exist<\\/li>\\n<li>General: Load inline CSS in previews when using external CSS option<\\/li>\\n<li>General: Update gp-premium-es_ES.mo<\\/li>\\n<li>General: Update gp-premium-pt_PT.mo<\\/li>\\n<\\/ul>\\n<h4> 1.11.1 <\\/h4>\\n<ul>\\n<li>Elements: Remove stray quote character in Layout Element metabox<\\/li>\\n<li>Sections: Fix color picker JS error in WP 5.5<\\/li>\\n<li>General: Fix external CSS option not removing inline CSS in some cases<\\/li>\\n<\\/ul>\\n<h4> 1.11.0 <\\/h4>\\n<ul>\\n<li>New: Block Elements<\\/li>\\n<li>New: Apply Layout Element options to the block editor if set<\\/li>\\n<li>New: Generate dynamic CSS in an external file<\\/li>\\n<li>Blog: Separate CSS and load only when needed<\\/li>\\n<li>Blog: Add column width classes to stylesheet<\\/li>\\n<li>Blog: Disable featured image itemprop if microdata is disabled<\\/li>\\n<li>Blog: Add generate_blog_masonry_init filter<\\/li>\\n<li>Blog: Add generate_blog_infinite_scroll_init filter<\\/li>\\n<li>Blog: Fix archive page header overlap when using no featured image padding\\/one container<\\/li>\\n<li>Blog: Replace screen reader text with aria-label in read more buttons<\\/li>\\n<li>Disable Elements: Add option to disable the Mobile Header<\\/li>\\n<li>Disable Elements: Disable top bar disables it even when combined with Secondary Nav<\\/li>\\n<li>Disable Elements: Use generate_show_post_navigation filter to disable single post navigation<\\/li>\\n<li>Elements: Use full hook name with generate_ prefix in dropdown<\\/li>\\n<li>Elements: Rebuild how Element types are chosen<\\/li>\\n<li>Elements: Add chosen hook under type column in edit.php<\\/li>\\n<li>Menu Plus: Add generate_after_mobile_header_menu_button filter<\\/li>\\n<li>Menu Plus: Add sticky placeholder only when nav becomes sticky<\\/li>\\n<li>Menu Plus: Add class to sticky nav when scrolling up<\\/li>\\n<li>Menu Plus: Fix navigation branding\\/mobile header layout when using RTL languages<\\/li>\\n<li>Page Header: Prevent PHP notices<\\/li>\\n<li>Secondary Nav: Clean up CSS<\\/li>\\n<li>Secondary Nav: Add generate_after_secondary_navigation hook<\\/li>\\n<li>Secondary Nav: Add generate_before_secondary_navigation hook<\\/li>\\n<li>Secondary Nav: Integrate with future flexbox option<\\/li>\\n<li>Secondary Nav: Add has-top-bar class if needed<\\/li>\\n<li>Secondary Nav: Add screen reader text to mobile menu toggle if no text exists<\\/li>\\n<li>Secondary Nav: Remove microdata if disabled<\\/li>\\n<li>Secondary Nav: Add generate_secondary_menu_bar_items hook<\\/li>\\n<li>Spacing: Set sidebar width in Customizer for future flexbox option<\\/li>\\n<li>WooCommerce: Add generate_woocommerce_show_add_to_cart_panel filter<\\/li>\\n<li>WooCommerce: Integrate with future flexbox option<\\/li>\\n<li>WooCommerce: Ensure WC()-&gt;cart is set<\\/li>\\n<li>WooCommerce: Remove left margin from SVG menu cart icon<\\/li>\\n<li>WooCommerce: Show sticky add to cart panel on sold individually products<\\/li>\\n<li>WooCommerce: Remove bottom margin from related\\/upsell products<\\/li>\\n<li>WooCommerce: Fix cart menu item spacing in RTL languages<\\/li>\\n<li>WooCommerce: Fix menu item cart dropdown design in RTL languages<\\/li>\\n<li>General: Update selectWoo<\\/li>\\n<li>General: Update select2<\\/li>\\n<li>General: Run all CSS through PostCSS<\\/li>\\n<li>General: Fix various text domains<\\/li>\\n<li>General: Fix JS error when toggling nav as header option without Colors\\/Typography modules<\\/li>\\n<li>General: Update all translations over 90% complete<\\/li>\\n<li>General: PHP cleanup\\/coding standards<\\/li>\\n<li>General: Add off_canvas_desktop_toggle_label to wpml-config.xml<\\/li>\\n<\\/ul>\\n<h4> 1.10.0 <\\/h4>\\n<ul>\\n<li>Blog: Remove existing on-the-fly featured image resizer (Image Processing Queue)<\\/li>\\n<li>Blog: Choose from existing image sizes for featured images<\\/li>\\n<li>Blog: Use CSS to further resize featured images if necessary<\\/li>\\n<li>Blog: Fix edge case persistent transient bug with old image resizer<\\/li>\\n<li>Elements: Fix broken closing element in metabox<\\/li>\\n<li>General: Change scroll variable to gpscroll in smooth scroll script to avoid conflicts<\\/li>\\n<li>General: Update responsive widths in Customizer<\\/li>\\n<li>General: Fix responsive Customizer views when using RTL<\\/li>\\n<li>Menu Plus: Don\'t output sticky nav branding if sticky nav is disabled<\\/li>\\n<li>Menu Plus: Fix focus when off canvas overlay is opened (a11y)<\\/li>\\n<li>Menu Plus: Fix sticky navigation jump when navigation branding is in use<\\/li>\\n<li>Sections: Fix visible block editor when Sections are enabled<\\/li>\\n<li>WooCommerce: Use minmax in grid template definitions to fix overflow issue<\\/li>\\n<li>WooCommerce: Prevent add to cart panel interfering with back to top button on mobile<\\/li>\\n<li>WooCommerce: WooCommerce: Fix secondary image position if HTML isn\'t ordered correctly<\\/li>\\n<li>General: Add\\/update all translations over 50% complete. Big thanks to all contributors!<\\/li>\\n<li>Translation: Added Arabic - thank you anass!<\\/li>\\n<li>Translation: Added Bengali - thank you gtmroy!<\\/li>\\n<li>Translation: Added Spanish (Spain) - thank you davidperez (closemarketing.es)!<\\/li>\\n<li>Translation: Added Spanish (Argentina) - thank you bratorr!<\\/li>\\n<li>Translation: Added Finnish - thank you Stedi!<\\/li>\\n<li>Translation: Add Dutch - thank you Robin!<\\/li>\\n<li>Translation: Added Ukrainian - thank you EUROMEDIA!<\\/li>\\n<li>Translation: Vietnamese added - thank you themevi!<\\/li>\\n<\\/ul>\\n<h4> 1.9.1 <\\/h4>\\n<ul>\\n<li>Blog: Fix \\\"null\\\" in infinite scroll load more button text<\\/li>\\n<li>WooCommerce: Fix hidden added to cart panel on mobile when sticky nav active<\\/li>\\n<li>WooCommerce: Fix missing SVG icon in mobile added to cart panel<\\/li>\\n<\\/ul>\\n<h4> 1.9.0 <\\/h4>\\n<ul>\\n<li>Blog: Support SVG icon feature<\\/li>\\n<li>Colors: Add navigation search color options<\\/li>\\n<li>Disable Elements: Disable mobile menu in Mobile Header if nav is disabled<\\/li>\\n<li>Elements: Add wp_body_open hook<\\/li>\\n<li>Elements: Allow 0 mobile padding in Elements<\\/li>\\n<li>Elements: Add generate_elements_admin_menu_capability filter<\\/li>\\n<li>Elements: Add generate_page_hero_css_output filter<\\/li>\\n<li>Elements: Prevent error in Header Element if taxonomy doesn\'t exist<\\/li>\\n<li>Elements: Fix double logo when Header Element has logo + using nav as header<\\/li>\\n<li>Elements: Fix mobile header logo not replacing if merge is disabled<\\/li>\\n<li>Elements: Fix missing arrow in Choose Element Type select in WP 5.3<\\/li>\\n<li>Elements: Add generate_inside_site_container hook option<\\/li>\\n<li>Elements: Add generate_after_entry_content hook option<\\/li>\\n<li>Menu Plus: Add off canvas desktop toggle label option<\\/li>\\n<li>Menu Plus: Add generate_off_canvas_toggle_output filter<\\/li>\\n<li>Menu Plus: Support SVG icon feature<\\/li>\\n<li>Menu Plus: Fix sticky navigation overlapping BB controls<\\/li>\\n<li>Menu Plus: Add align-items: center to nav as header, mobile header and sticky nav with branding<\\/li>\\n<li>Sections: Fix text\\/visual switch bug in Firefox<\\/li>\\n<li>Sites: Add option to revert site import<\\/li>\\n<li>Sites: Increase site library limit to 100<\\/li>\\n<li>Spacing: Add live preview to group container padding<\\/li>\\n<li>Typography: Add tablet site title\\/navigation font size options<\\/li>\\n<li>Typography: Add archive post title weight, transform, font size and line height<\\/li>\\n<li>Typography: Add single content title weight, transform, font size and line height<\\/li>\\n<li>Typography: Only call all google fonts once in the Customizer<\\/li>\\n<li>Typography: Get Google fonts from readable JSON list<\\/li>\\n<li>Typography: Make sure font settings aren\'t lost if list is changed<\\/li>\\n<li>Typography: Only call generate_get_all_google_fonts if needed<\\/li>\\n<li>WooCommerce: Add columns gap options (desktop, tablet, mobile)<\\/li>\\n<li>WooCommerce: Add tablet column options<\\/li>\\n<li>WooCommerce: Add related\\/upsell tablet column options<\\/li>\\n<li>WooCommerce: Support SVG icon feature<\\/li>\\n<li>WooCommerce: Prevent empty added to cart panel on single products<\\/li>\\n<li>WooCommerce: Fix woocommerce-ordering arrow in old FF versions<\\/li>\\n<li>WooCommerce: Make item\\/items string translatable<\\/li>\\n<li>General: Better customizer device widths<\\/li>\\n<li>General: Use generate_premium_get_media_query throughout modules<\\/li>\\n<li>General: Improve Customizer control styling<\\/li>\\n<\\/ul>\\n<h4> 1.8.3 <\\/h4>\\n<ul>\\n<li>Menu Plus: Use flexbox for center aligned nav with nav branding<\\/li>\\n<li>Menu Plus: Center overlay off canvas exit button on mobile<\\/li>\\n<li>Menu Plus: Add alt tag to sticky nav logo<\\/li>\\n<li>Menu Plus: Set generate_not_mobile_menu_media_query filter based on mobile menu breakpoint<\\/li>\\n<li>Sections: Remember when text tab is active<\\/li>\\n<li>Sections: Disable visual editor if turned off in profile<\\/li>\\n<li>Typography: Add generate_google_font_display filter<\\/li>\\n<li>WooCommerce: Fix single product sidebar layout metabox option<\\/li>\\n<li>WooCommerce: Reduce carousel thumbnail max-width to 100px to match new thumbnail sizes<\\/li>\\n<\\/ul>\\n<h4> 1.8.2 <\\/h4>\\n<ul>\\n<li>Elements: Use Page Hero site title color for mobile header site title<\\/li>\\n<li>Menu Plus: Give mobile header site title more left spacing<\\/li>\\n<li>Menu Plus: Fix nav search icon in sticky navigation when using nav branding in Firefox<\\/li>\\n<li>Site Library: Show Site Library tab even if no sites exist<\\/li>\\n<li>Site Library: Show an error message in Site Library if no sites exist<\\/li>\\n<li>Typography: Remove reference to generate_get_navigation_location() function<\\/li>\\n<li>WooCommerce: Remove quantity field arrows when using quantity buttons in Firefox<\\/li>\\n<li>WooCommerce: Remove extra border when loading quantity buttons<\\/li>\\n<li>WooCommerce: Use get_price_html() is sticky add to cart panel<\\/li>\\n<\\/ul>\\n<h4> 1.8.1 <\\/h4>\\n<ul>\\n<li>Menu Plus: Revert sticky nav duplicate ID fix due to Cyrillic script bug<\\/li>\\n<\\/ul>\\n<h4> 1.8 <\\/h4>\\n<ul>\\n<li>Blog: Apply columns filter to masonry grid sizer<\\/li>\\n<li>Colors: Merge Footer Widgets and Footer controls in Color panel<\\/li>\\n<li>Colors: Remove edit_theme_options capability to Customizer controls (set by default)<\\/li>\\n<li>Disable Elements: Make sure mobile header is disabled when primary navigation is disabled<\\/li>\\n<li>Elements: Add content width option in Layout Element<\\/li>\\n<li>Elements: Fix mobile header logo when mobile menu toggled<\\/li>\\n<li>Elements: Add generate_page_hero_location filter<\\/li>\\n<li>Elements: Add generate_elements_show_object_ids filter to show IDs in Display Rule values<\\/li>\\n<li>Elements: Prevent merged header wrap from conflicting with Elementor controls<\\/li>\\n<li>Elements: Change Container tab name to Content<\\/li>\\n<li>Elements: Add woocommerce_share option to Hooks<\\/li>\\n<li>Elements: Improve WPML compatibility<\\/li>\\n<li>Elements: Improve Polylang compatibility<\\/li>\\n<li>Elements: Prevent PHP notices when adding taxonomy locations to non-existent archives<\\/li>\\n<li>Elements: Add generate_mobile_cart_items hook to hook list<\\/li>\\n<li>Elements: Add generate_element_post_id filter<\\/li>\\n<li>Elements: Escape HTML elements inside Element textarea<\\/li>\\n<li>Elements: Add Beaver Builder templates to the Display Rules<\\/li>\\n<li>Menu Plus: Add mobile header breakpoint option<\\/li>\\n<li>Menu Plus: Add off canvas overlay option<\\/li>\\n<li>Menu Plus: Add navigation as header option<\\/li>\\n<li>Menu Plus: Remove navigation logo option if navigation as header set<\\/li>\\n<li>Menu Plus: Add sticky navigation logo option<\\/li>\\n<li>Menu Plus: Allow site title in mobile header instead of logo<\\/li>\\n<li>Menu Plus: Add option to move exit button inside the off canvas panel<\\/li>\\n<li>Menu Plus: Change Slideout Navigation name to Off Canvas Panel<\\/li>\\n<li>Menu Plus: Only re-focus after slideout close on escape key<\\/li>\\n<li>Menu Plus: Give close slideout event a name so it can be removed<\\/li>\\n<li>Menu Plus: Remove invalid transition-delay<\\/li>\\n<li>Menu Plus: Improve slideout overlay transition<\\/li>\\n<li>Menu Plus: Add mobile open\\/close icons to GPP font<\\/li>\\n<li>Menu Plus: Allow dynamic widget classes in off canvas panel (fixes WC range slider widget issue)<\\/li>\\n<li>Menu Plus: Basic compatibility with future SVG icons<\\/li>\\n<li>Menu Plus: Prevent duplicate IDs when sticky navigation is cloned<\\/li>\\n<li>Secondary Nav: Add dropdown direction option<\\/li>\\n<li>Secondary Nav: Basic compatibility with future SVG icons<\\/li>\\n<li>Sections: Fix section editor issues in WP 5.0<\\/li>\\n<li>Sections: Show Better Font Awesome icon in editor<\\/li>\\n<li>Sites: Re-design UI<\\/li>\\n<li>Sites: Add option to activate as a module like all the other modules<\\/li>\\n<li>Sites: Don\'t show backup options button if no options exist<\\/li>\\n<li>Sites: Make JS action classes more specific to the site library<\\/li>\\n<li>Sites: Set mime types of content.xml and widgets.wie<\\/li>\\n<li>Spacing: Add header padding option for mobile<\\/li>\\n<li>Spacing: Add widget padding option for mobile<\\/li>\\n<li>Spacing: Add footer widgets padding option for mobile<\\/li>\\n<li>Spacing: Add content separator option<\\/li>\\n<li>Spacing: Apply mobile menu item width to mobile bar only<\\/li>\\n<li>WooCommerce: Add option for mini cart in the menu<\\/li>\\n<li>WooCommerce: Add option to open off overlay panel on add to cart<\\/li>\\n<li>WooCommerce: Add option to open sticky add to cart panel on single products<\\/li>\\n<li>WooCommerce: Add option to add +\\/- buttons to the quantity fields<\\/li>\\n<li>WooCommerce: Add option to show number of items in cart menu item<\\/li>\\n<li>WooCommerce: Add option to choose single product image area width<\\/li>\\n<li>WooCommerce: Add color options for price slider widget<\\/li>\\n<li>WooCommerce: Use CSS grid for the product archives<\\/li>\\n<li>WooCommerce: Horizontally align add to cart buttons<\\/li>\\n<li>WooCommerce: Re-design the cart widget<\\/li>\\n<li>WooCommerce: Tighten up product info spacing<\\/li>\\n<li>WooCommerce: Improve product tab design to look more like tabs<\\/li>\\n<li>WooCommerce: Simplify single product image display<\\/li>\\n<li>WooCommerce: Use flexbox for quantity\\/add to cart alignment<\\/li>\\n<li>WooCommerce: Improve rating star styles<\\/li>\\n<li>WooCommerce: Use product alignment setting for related\\/upsell products<\\/li>\\n<li>WooCommerce: Remove bottom margin from product image<\\/li>\\n<li>WooCommerce: Organize colors in the Customizer<\\/li>\\n<li>WooCommerce: Remove title attribute from menu cart item<\\/li>\\n<li>WooCommerce: Improve coupon field design<\\/li>\\n<li>WooCommerce: Improve result count\\/ordering styling<\\/li>\\n<li>WooCommerce: Add gap around WC single product images<\\/li>\\n<li>WooCommerce: Remove arrow from checkout button<\\/li>\\n<li>WooCommerce: Hide view cart link on add to cart click<\\/li>\\n<li>WooCommerce: Organize CSS<\\/li>\\n<li>Introduce in-Customizer shortcuts<\\/li>\\n<li>Add generate_disable_customizer_shortcuts filter<\\/li>\\n<\\/ul>\"},\"banners\":{\"high\":\"\",\"low\":\"\"},\"icons\":{\"1x\":\"https:\\/\\/generatepress.com\\/wp-content\\/uploads\\/edd\\/2020\\/05\\/icon-128x128.png\",\"2x\":\"https:\\/\\/generatepress.com\\/wp-content\\/uploads\\/edd\\/2020\\/05\\/icon-256x256.png\"},\"stable_tag\":\"2.5.1\",\"tested\":\"6.6\",\"description\":[\"<p>The entire collection of GeneratePress premium modules. Once activated, each module extends certain aspects of GeneratePress, giving you more options to build your website.<\\/p>\\n<h4> Documentation <\\/h4>\\n<p>Check out our <a href=\\\"https:\\/\\/docs.generatepress.com\\\">documentation<\\/a> for more information on each module and how to use them.<\\/p>\"],\"changelog\":[\"<h4> 2.5.1 <\\/h4>\\n<ul>\\n<li>Feature: Serve new GenerateBlocks 2.0 sites in the Site Library<\\/li>\\n<li>Feature: Add more GenerateBlocks 2.0 dynamic tags if GB Pro is not active<\\/li>\\n<li>Feature: Add support for Font Library when importing starter sites<\\/li>\\n<li>Fix: Missing Elements Display Rules in some configurations<\\/li>\\n<\\/ul>\\n<h4> 2.5.0 <\\/h4>\\n<ul>\\n<li>Feature: Font Library<\\/li>\\n<li>Feature: Install Google Fonts locally<\\/li>\\n<li>Feature: Upload custom fonts locally<\\/li>\\n<li>Fix: Apply button color settings to WooCommerce block buttons<\\/li>\\n<li>Fix: WooCommerce button typography<\\/li>\\n<li>Fix: Check if <code>DISALLOW_FILE_EDIT<\\/code> is set to true for PHP Elements<\\/li>\\n<li>Fix: Use up to date react render functions<\\/li>\\n<li>Tweak: Allow Display Rules metabox to collapse<\\/li>\\n<li>Accessibility: Add aria-label to secondary navigation<\\/li>\\n<\\/ul>\\n<h4> 2.4.1 <\\/h4>\\n<ul>\\n<li>Security: Harden variable against XSS attacks<\\/li>\\n<\\/ul>\\n<h4> 2.4.0 <\\/h4>\\n<ul>\\n<li>Security: Disallow scripts in custom field template tags<\\/li>\\n<li>Important: Requires PHP 7.2 or greater<\\/li>\\n<li>Feature: Improve Site Library filters<\\/li>\\n<li>Feature: Add search capability in Site Library<\\/li>\\n<li>Feature: Allow author searching in Site Library<\\/li>\\n<li>Feature: Add <code>generate_smooth_scroll_offset<\\/code> filter<\\/li>\\n<li>Feature: Use built-in read more text filters<\\/li>\\n<li>Fix: PHP 8.1 notices<\\/li>\\n<li>Fix: Display posts in columns option changes Query Loop blocks<\\/li>\\n<li>Fix: Remove no-csstransforms3d CSS from off canvas panel<\\/li>\\n<li>Fix: Display Rules taxonomies missing when has_archive disabled<\\/li>\\n<li>Fix: Navigation logo undefined array keys<\\/li>\\n<li>Tweak: Update Content Template templates<\\/li>\\n<li>Tweak: Update Archive Navigation templates<\\/li>\\n<li>Tweak: Update Page Hero templates<\\/li>\\n<li>Tweak: Update post meta templates<\\/li>\\n<li>Tweak: Update post navigation templates<\\/li>\\n<li>Tweak: Update site footer templates<\\/li>\\n<li>Tweak: Remove deprecated filter_input functions<\\/li>\\n<li>General: Updated translations<\\/li>\\n<\\/ul>\\n<h4> 2.3.2 <\\/h4>\\n<ul>\\n<li>Tweak: Remove deprecated wp_get_loading_attr_default function<\\/li>\\n<\\/ul>\\n<h4> 2.3.1 <\\/h4>\\n<ul>\\n<li>Fix: SelectSearch component infinite loop<\\/li>\\n<li>Fix: Block widths inside Block Elements<\\/li>\\n<\\/ul>\\n<h4> 2.3.0 <\\/h4>\\n<ul>\\n<li>Feature: Add Search Modal Element type<\\/li>\\n<li>Fix: Inline post meta feature in GenerateBlocks 1.7<\\/li>\\n<li>Fix: Close \\\"Choose Element Type\\\" modal with ESC key<\\/li>\\n<li>Fix: Replace WooCommerce secondary image attachment size<\\/li>\\n<li>Fix: WP Filesystem error missing credentials<\\/li>\\n<li>Fix: Undefined array keys in dynamic Container URL<\\/li>\\n<li>Fix: Author avatar in Header\\/Block Element titles<\\/li>\\n<li>Fix: Infinite loop error when autosaving with dynamic content block<\\/li>\\n<li>Fix: Add aria-label to off-canvas panel button<\\/li>\\n<li>Fix: WooCommerce button dynamic typography<\\/li>\\n<li>Fix: Empty WooCommerce quantity fields<\\/li>\\n<li>Fix: PHP 8.1 notice using disable elements in Customizer<\\/li>\\n<li>Tweak: Improve license key area<\\/li>\\n<li>Tweak: Improve off-canvas transitions<\\/li>\\n<li>Tweak: Check for WooCommerce functions<\\/li>\\n<li>Tweak: Open off-canvas using space bar<\\/li>\\n<li>Tweak: Use image ID in mobile header\\/sticky nav logos<\\/li>\\n<li>Tweak: Improve Elements hook selection dropdown UI<\\/li>\\n<li>Tweak: Add site library check for min GenerateBlocks version<\\/li>\\n<li>Tweak: Add Loop Template to Custom Post Type dropdown filters<\\/li>\\n<\\/ul>\\n<h4> 2.2.2 <\\/h4>\\n<ul>\\n<li>Fix: Off Canvas anchor links not working<\\/li>\\n<\\/ul>\\n<h4> 2.2.1 <\\/h4>\\n<ul>\\n<li>Fix: Add value to off-canvas aria-hidden attribute<\\/li>\\n<li>Tweak: Remove\\/add aria-hidden to off-canvas on toggle<\\/li>\\n<\\/ul>\\n<h4> 2.2.0 <\\/h4>\\n<ul>\\n<li>Feature: Allow block element autosave<\\/li>\\n<li>Feature: Add revisions to block elements<\\/li>\\n<li>Feature: Add Loop Template block element<\\/li>\\n<li>Feature: Dont display the raw license key in the Dashboard<\\/li>\\n<li>Feature: Add \\\"Paginated Results\\\" to Element Display Rules<\\/li>\\n<li>Fix: Element post navigation template PHP warning when not using GB Pro<\\/li>\\n<li>Fix: Remove unnecessary zoom CSS from featured images<\\/li>\\n<li>Fix: Font icon CSS order<\\/li>\\n<li>Fix: Load more button showing in product tax archives<\\/li>\\n<li>Fix: Prevent tabbing in hidden off-canvas panel<\\/li>\\n<li>Fix: Hide hidden off-canvas panel from screen readers<\\/li>\\n<li>Fix: menu-toggle aria-controls when using off-canvas panel<\\/li>\\n<li>Fix: Focus first focusable element when opening off-canvas panel<\\/li>\\n<li>Fix: Focus slideout toggle when closing off-canvas panel<\\/li>\\n<li>Fix: Off-Canvas Panel sub-menu a11y<\\/li>\\n<li>Fix: Prevent secondary nav legacy typography CSS<\\/li>\\n<li>Fix: Fix dynamic term meta link<\\/li>\\n<li>Fix: Block margins in the block element editor<\\/li>\\n<li>Fix: Embeds in Block Elements<\\/li>\\n<li>Fix: Apply display rules to editor with no ID<\\/li>\\n<li>Fix: Navigation background image applying to secondary nav<\\/li>\\n<li>Fix: WooCommerce order received page float issue<\\/li>\\n<li>Fix: Block element editor error in GenerateBlocks 1.7<\\/li>\\n<li>Tweak: Remove jquery-migrate from sticky script<\\/li>\\n<li>Tweak: Add message in Blog section about Loop Template<\\/li>\\n<\\/ul>\\n<h4> 2.1.2 <\\/h4>\\n<ul>\\n<li>Elements: Fix custom field value in dynamic container links<\\/li>\\n<li>Elements: Fix block widths in the editor<\\/li>\\n<li>General: Fix double slashes in dashboard file request<\\/li>\\n<li>General: Fix missing Customizer translations<\\/li>\\n<\\/ul>\\n<h4> 2.1.1 <\\/h4>\\n<ul>\\n<li>Menu Plus: Fix mobile header sticky auto hide<\\/li>\\n<li>Site Library: Fix broken CSS variables on import<\\/li>\\n<\\/ul>\\n<h4> 2.1.0 <\\/h4>\\n<ul>\\n<li>Blog: Fix masonry JS error if no archive pagination exists<\\/li>\\n<li>Blog: Fix full width featured blog column<\\/li>\\n<li>Colors: Deprecate module if using GP 3.1.0<\\/li>\\n<li>Elements: Add custom class option to dynamic image block<\\/li>\\n<li>Elements: Add support for post_type array in display rules<\\/li>\\n<li>Elements: Fix container link option when targeting next\\/previous posts<\\/li>\\n<li>Menu Plus: Integrate off-canvas panel with new dynamic typography system<\\/li>\\n<li>Menu Plus: Integrate off-canvas panel with new color system<\\/li>\\n<li>Menu Plus: Integrate mobile header HTML attributes with new HTML attribute system<\\/li>\\n<li>Menu Plus: Integrate mobile header and off-canvas panel with new generate_has_active_menu filter<\\/li>\\n<li>Menu Plus: Fix broken inline CSS when using floated sticky navigation<\\/li>\\n<li>Menu Plus: Add logo dimensions to navigation logo<\\/li>\\n<li>Secondary Navigation: Integrate with new color system<\\/li>\\n<li>Secondary Navigation: Integrate with new generate_has_active_menu filter<\\/li>\\n<li>Secondary Navigation: Integrate with new dynamic typography system<\\/li>\\n<li>Secondary Navigation: Reduce box-shadow to match main navigation<\\/li>\\n<li>Secondary Navigation: Change direction of sub-menu box-shadow when opening left<\\/li>\\n<li>Secondary Navigation: Fix sub-menu overlap when using dropdown click\\/mobile<\\/li>\\n<li>Secondary Navigation: Replace box-shadow with border-bottom when sub-menu opens down<\\/li>\\n<li>Site Library: Add site author attribution<\\/li>\\n<li>Typography: Deprecate module if using dynamic typography in GP 3.1.0<\\/li>\\n<li>WooCommerce: Integrate with new dynamic typography system<\\/li>\\n<li>WooCommerce: Integrate with new colors system<\\/li>\\n<li>WooCommerce: Remove category title\\/description if using page hero with title disabled<\\/li>\\n<li>WooCommerce: Remove \\\"speak\\\" CSS properties<\\/li>\\n<li>WooCommerce: Fix empty continue shopping link on mobile<\\/li>\\n<li>WooCommerce: Fix persistent sticky add to cart panel<\\/li>\\n<li>General: Integrate with new GP 3.1.0 Dashboard<\\/li>\\n<li>General: Remove featured-image-active body class if featured image is disabled<\\/li>\\n<li>General: Change date format in exported JSON filename<\\/li>\\n<li>General: Fix PHP error when license key activation returns 403<\\/li>\\n<\\/ul>\\n<h4> 2.0.3 <\\/h4>\\n<ul>\\n<li>Elements: Use block_categories_all filter in WP 5.8<\\/li>\\n<li>Elements: Remove wp-editor dependency from new widget editor<\\/li>\\n<\\/ul>\\n<h4> 2.0.2 <\\/h4>\\n<ul>\\n<li>Elements: Use blog page title for dynamic title if set<\\/li>\\n<li>Spacing: Fix reset button bug in Customizer controls<\\/li>\\n<li>WooCommerce: Fix infinite scroll applying to product taxonomy pages<\\/li>\\n<\\/ul>\\n<h4> 2.0.1 <\\/h4>\\n<ul>\\n<li>Blog: Fix infinite scroll bug on product archives<\\/li>\\n<li>Elements: Fix error in WP 4.9.x versions<\\/li>\\n<li>Menu Plus: Prevent 0x0 logo dimension attributes if no dimensions exist<\\/li>\\n<li>Site Library: Add vertical scroll ability to the Site Library control area<\\/li>\\n<\\/ul>\\n<h4> 2.0.0 <\\/h4>\\n<ul>\\n<li>Blog: Rewrite infinite scroll using vanilla javascript<\\/li>\\n<li>Blog: Rewrite masonry using vanilla javascript<\\/li>\\n<li>Blog: Add separate infinite scroll path element to footer<\\/li>\\n<li>Blog: Fix missing single\\/page featured image options when archive image disabled<\\/li>\\n<li>Blog: Add aria-label instead of screen-reader-text to read more button<\\/li>\\n<li>Colors: Fix back to top Customizer color preview<\\/li>\\n<li>Elements: New Content Template Element<\\/li>\\n<li>Elements: New Post Meta Template Element<\\/li>\\n<li>Elements: New Post Navigation Template Element<\\/li>\\n<li>Elements: New Page Hero Block Element<\\/li>\\n<li>Elements: New Archive Navigation Template Element<\\/li>\\n<li>Elements: New Editor Width option in Block Elements<\\/li>\\n<li>Elements: Move Block Elements options into editor sidebar<\\/li>\\n<li>Elements: Show Site Header options by default in Header Element<\\/li>\\n<li>Elements: Fix Classic Editor issue in Block Elements<\\/li>\\n<li>Elements: Add a list of active Elements to page editor<\\/li>\\n<li>Elements: Add a list of active Elements to the admin bar<\\/li>\\n<li>Elements: Add notices to Customizer if Elements may be overwriting options<\\/li>\\n<li>Elements: Disable mobile header menu if menu is disabled via Layout Element<\\/li>\\n<li>Elements: Improve Display Rule loading performance<\\/li>\\n<li>Elements: Add block type filter to Elements dashboard<\\/li>\\n<li>Elements: Add generate_element_display filter<\\/li>\\n<li>Elements: Add No Results as a Display Rule condition<\\/li>\\n<li>Menu Plus: Hide slideout toggle at set mobile menu breakpoint value<\\/li>\\n<li>Menu Plus: Fix sticky menu height when using navigation as header<\\/li>\\n<li>Menu Plus: Add dimensions to mobile\\/sticky logos<\\/li>\\n<li>Menu Plus: Make Off-Canvas menu take up full width of canvas<\\/li>\\n<li>Menu Plus: Fix menu bar item sticky transition<\\/li>\\n<li>Menu Plus: Prevent sticky sidebar nav if mobile header is set to sticky<\\/li>\\n<li>Secondary Nav: Fix centered secondary navigation items using flexbox<\\/li>\\n<li>Secondary Nav: Fix conflict with Nav as Header option<\\/li>\\n<li>Secondary Nav: Fix missing menu cart items when using click dropdowns<\\/li>\\n<li>Sections: Officially deprecate module<\\/li>\\n<li>Site Library: Completely rebuild Site Library using React<\\/li>\\n<li>WooCommerce: Move full width single product CSS to inline CSS<\\/li>\\n<li>WooCommerce: Use wc_get_product() instead of new WC_Product()<\\/li>\\n<li>WooCommerce: Add more checks for WC() class to prevent error logs<\\/li>\\n<li>WooCommerce: Add generate_wc_cart_panel_checkout_button_output filter<\\/li>\\n<li>WooCommerce: Add generate_wc_sticky_add_to_cart_action filter<\\/li>\\n<li>WooCommerce: Add generate_wc_show_sticky_add_to_cart filter<\\/li>\\n<li>WooCommerce: Re-write quantity button javascript to be more performant\\/extendable<\\/li>\\n<li>General: Update theme install link<\\/li>\\n<li>General: Update alpha color picker script<\\/li>\\n<li>General: Use correct URL scheme in external stylesheet URLs<\\/li>\\n<li>General: Check if FS_CHMOD_FILE is defined in external stylesheet generation<\\/li>\\n<li>General: Use inline CSS when using AMP plugin<\\/li>\\n<li>General: Update EDD_SL_Plugin_Updater class to 1.8.0<\\/li>\\n<li>General: Clean up javascript throughout plugin<\\/li>\\n<li>General: Replace deprecated jQuery functions<\\/li>\\n<\\/ul>\\n<h4> 1.12.3 <\\/h4>\\n<ul>\\n<li>WooCommerce: Fix quantity buttons in WP 5.6<\\/li>\\n<\\/ul>\\n<h4> 1.12.2 <\\/h4>\\n<ul>\\n<li>Blog: Load columns CSS when using filter to enable it anywhere<\\/li>\\n<li>Menu Plus: Fix sticky mobile header jump when using inline mobile toggle<\\/li>\\n<li>Menu Plus: Add margin to sticky nav branding when set to full width<\\/li>\\n<li>Menu Plus: Disable sticky nav container text align padding<\\/li>\\n<li>Menu Plus: Make mobile menu absolute only when smooth scroll is enabled<\\/li>\\n<li>Menu Plus: Improve nav as header\\/mobile header when using flexbox<\\/li>\\n<li>Menu Plus: Prevent off-canvas panel close button from flashing visible when closing<\\/li>\\n<li>Spacing: Fix custom nav search height<\\/li>\\n<\\/ul>\\n<h4> 1.12.1 <\\/h4>\\n<ul>\\n<li>Typography: Fix missing heading font size controls in the Customizer<\\/li>\\n<\\/ul>\\n<h4> 1.12.0 <\\/h4>\\n<ul>\\n<li>Blog: Fix column margin on mobile with some caching plugins<\\/li>\\n<li>Blog: Add post-load trigger to infinite scroll for better plugin compatibility<\\/li>\\n<li>Blog: Take generate_blog_columns filter into account when loading columns CSS<\\/li>\\n<li>Colors: Add search menu-bar-item color live preview to Customizer<\\/li>\\n<li>Elements: Fix broken custom hook field in Block Elements<\\/li>\\n<li>Elements: Integrate page hero with text container alignment in GP 3.0<\\/li>\\n<li>Elements: Better integrate Header Element colors with GP 3.0<\\/li>\\n<li>Elements: Only disable content title when {{post_title}} is present on single pages<\\/li>\\n<li>Elements: Fix  tag in metabox<\\/li>\\n<li>Elements: Add generate_elements_metabox_ajax_allow_editors filter<\\/li>\\n<li>Elements: Add new 3.0 hooks to hook selector<\\/li>\\n<li>Elements: Re-add generate_elements_custom_args filter<\\/li>\\n<li>Menu Plus: Better prepare navigation as header for GP 3.0<\\/li>\\n<li>Menu Plus: Better prepare Off-Canvas Panel for GP 3.0<\\/li>\\n<li>Menu Plus: Better prepare sticky navigation for GP 3.0<\\/li>\\n<li>Menu Plus: Add has-menu-bar-items class to mobile header if needed<\\/li>\\n<li>Menu Plus: Add is-logo-image class to all site logos<\\/li>\\n<li>Menu Plus: Fix mobile header alignment when it has menu bar items<\\/li>\\n<li>Secondary Nav: Better prepare sticky navigation for GP 3.0<\\/li>\\n<li>Secondary Nav: Fix hidden navigation widget in top bar when merged with secondary nav<\\/li>\\n<li>Sites: Improve the option-only import feature<\\/li>\\n<li>Sites: Improve the refresh sites button functionality<\\/li>\\n<li>Sites: Improve the undo site import functionality<\\/li>\\n<li>Sites: Fix Elementor site import issues<\\/li>\\n<li>Sites: Re-add Elementor sites to library<\\/li>\\n<li>Spacing: Better prepare Customizer live preview for GP 3.0<\\/li>\\n<li>Spacing: Fix blog column spacing Customizer live preview<\\/li>\\n<li>Spacing: Stop handling mobile header, widget and footer widget features added in GP 3.0<\\/li>\\n<li>Typography: Add mobile font size control for H3 (when using GP 3.0)<\\/li>\\n<li>Typography: Add mobile font size control for H4 (when using GP 3.0)<\\/li>\\n<li>Typography: Add mobile font size control for H5 (when using GP 3.0)<\\/li>\\n<li>Typography: Allow empty tablet and mobile site title font size values<\\/li>\\n<li>Typography: Make menu toggle CSS selector specific to primary navigation<\\/li>\\n<li>WooCommerce: Use CSS for secondary product image functionality instead of JS<\\/li>\\n<li>WooCommerce: Only load .js file if needed<\\/li>\\n<li>WooCommerce: Fix quantity box functionality when multiple quantity boxes exist on the page<\\/li>\\n<li>General: Improve alpha color picker script for better 5.5 compatibility<\\/li>\\n<li>General: Move child theme stylesheet after dynamic stylesheet if enabled<\\/li>\\n<li>General: Update gp-premium-de_DE.mo<\\/li>\\n<li>General: Update gp-premium-es_ES.mo<\\/li>\\n<li>General: Update gp-premium-fi.mo<\\/li>\\n<li>General: Update gp-premium-pt_PT.mo<\\/li>\\n<li>General: Update gp-premium-sv_SE.mo<\\/li>\\n<\\/ul>\\n<h4> 1.11.3 <\\/h4>\\n<ul>\\n<li>Blog: Set widths to grid-sizer element<\\/li>\\n<li>Elements: Fix legacy Page Header\\/Hooks buttons in the Elements dashboard<\\/li>\\n<li>Page Header: Replace .load() with .on(\'load\')<\\/li>\\n<li>Page Header: Fix color picker error in WP 5.5<\\/li>\\n<\\/ul>\\n<h4> 1.11.2 <\\/h4>\\n<ul>\\n<li>Blog: Remove negative featured image top margin from columns when using one container<\\/li>\\n<li>Blog: Fix infinite scroll items loading above viewport when using columns<\\/li>\\n<li>Blog: Fix infinite scroll featured images not displaying in Safari<\\/li>\\n<li>Elements: Prevent error in editor when generate_get_option() function doesn\'t exist<\\/li>\\n<li>General: Load inline CSS in previews when using external CSS option<\\/li>\\n<li>General: Update gp-premium-es_ES.mo<\\/li>\\n<li>General: Update gp-premium-pt_PT.mo<\\/li>\\n<\\/ul>\\n<h4> 1.11.1 <\\/h4>\\n<ul>\\n<li>Elements: Remove stray quote character in Layout Element metabox<\\/li>\\n<li>Sections: Fix color picker JS error in WP 5.5<\\/li>\\n<li>General: Fix external CSS option not removing inline CSS in some cases<\\/li>\\n<\\/ul>\\n<h4> 1.11.0 <\\/h4>\\n<ul>\\n<li>New: Block Elements<\\/li>\\n<li>New: Apply Layout Element options to the block editor if set<\\/li>\\n<li>New: Generate dynamic CSS in an external file<\\/li>\\n<li>Blog: Separate CSS and load only when needed<\\/li>\\n<li>Blog: Add column width classes to stylesheet<\\/li>\\n<li>Blog: Disable featured image itemprop if microdata is disabled<\\/li>\\n<li>Blog: Add generate_blog_masonry_init filter<\\/li>\\n<li>Blog: Add generate_blog_infinite_scroll_init filter<\\/li>\\n<li>Blog: Fix archive page header overlap when using no featured image padding\\/one container<\\/li>\\n<li>Blog: Replace screen reader text with aria-label in read more buttons<\\/li>\\n<li>Disable Elements: Add option to disable the Mobile Header<\\/li>\\n<li>Disable Elements: Disable top bar disables it even when combined with Secondary Nav<\\/li>\\n<li>Disable Elements: Use generate_show_post_navigation filter to disable single post navigation<\\/li>\\n<li>Elements: Use full hook name with generate_ prefix in dropdown<\\/li>\\n<li>Elements: Rebuild how Element types are chosen<\\/li>\\n<li>Elements: Add chosen hook under type column in edit.php<\\/li>\\n<li>Menu Plus: Add generate_after_mobile_header_menu_button filter<\\/li>\\n<li>Menu Plus: Add sticky placeholder only when nav becomes sticky<\\/li>\\n<li>Menu Plus: Add class to sticky nav when scrolling up<\\/li>\\n<li>Menu Plus: Fix navigation branding\\/mobile header layout when using RTL languages<\\/li>\\n<li>Page Header: Prevent PHP notices<\\/li>\\n<li>Secondary Nav: Clean up CSS<\\/li>\\n<li>Secondary Nav: Add generate_after_secondary_navigation hook<\\/li>\\n<li>Secondary Nav: Add generate_before_secondary_navigation hook<\\/li>\\n<li>Secondary Nav: Integrate with future flexbox option<\\/li>\\n<li>Secondary Nav: Add has-top-bar class if needed<\\/li>\\n<li>Secondary Nav: Add screen reader text to mobile menu toggle if no text exists<\\/li>\\n<li>Secondary Nav: Remove microdata if disabled<\\/li>\\n<li>Secondary Nav: Add generate_secondary_menu_bar_items hook<\\/li>\\n<li>Spacing: Set sidebar width in Customizer for future flexbox option<\\/li>\\n<li>WooCommerce: Add generate_woocommerce_show_add_to_cart_panel filter<\\/li>\\n<li>WooCommerce: Integrate with future flexbox option<\\/li>\\n<li>WooCommerce: Ensure WC()-&gt;cart is set<\\/li>\\n<li>WooCommerce: Remove left margin from SVG menu cart icon<\\/li>\\n<li>WooCommerce: Show sticky add to cart panel on sold individually products<\\/li>\\n<li>WooCommerce: Remove bottom margin from related\\/upsell products<\\/li>\\n<li>WooCommerce: Fix cart menu item spacing in RTL languages<\\/li>\\n<li>WooCommerce: Fix menu item cart dropdown design in RTL languages<\\/li>\\n<li>General: Update selectWoo<\\/li>\\n<li>General: Update select2<\\/li>\\n<li>General: Run all CSS through PostCSS<\\/li>\\n<li>General: Fix various text domains<\\/li>\\n<li>General: Fix JS error when toggling nav as header option without Colors\\/Typography modules<\\/li>\\n<li>General: Update all translations over 90% complete<\\/li>\\n<li>General: PHP cleanup\\/coding standards<\\/li>\\n<li>General: Add off_canvas_desktop_toggle_label to wpml-config.xml<\\/li>\\n<\\/ul>\\n<h4> 1.10.0 <\\/h4>\\n<ul>\\n<li>Blog: Remove existing on-the-fly featured image resizer (Image Processing Queue)<\\/li>\\n<li>Blog: Choose from existing image sizes for featured images<\\/li>\\n<li>Blog: Use CSS to further resize featured images if necessary<\\/li>\\n<li>Blog: Fix edge case persistent transient bug with old image resizer<\\/li>\\n<li>Elements: Fix broken closing element in metabox<\\/li>\\n<li>General: Change scroll variable to gpscroll in smooth scroll script to avoid conflicts<\\/li>\\n<li>General: Update responsive widths in Customizer<\\/li>\\n<li>General: Fix responsive Customizer views when using RTL<\\/li>\\n<li>Menu Plus: Don\'t output sticky nav branding if sticky nav is disabled<\\/li>\\n<li>Menu Plus: Fix focus when off canvas overlay is opened (a11y)<\\/li>\\n<li>Menu Plus: Fix sticky navigation jump when navigation branding is in use<\\/li>\\n<li>Sections: Fix visible block editor when Sections are enabled<\\/li>\\n<li>WooCommerce: Use minmax in grid template definitions to fix overflow issue<\\/li>\\n<li>WooCommerce: Prevent add to cart panel interfering with back to top button on mobile<\\/li>\\n<li>WooCommerce: WooCommerce: Fix secondary image position if HTML isn\'t ordered correctly<\\/li>\\n<li>General: Add\\/update all translations over 50% complete. Big thanks to all contributors!<\\/li>\\n<li>Translation: Added Arabic - thank you anass!<\\/li>\\n<li>Translation: Added Bengali - thank you gtmroy!<\\/li>\\n<li>Translation: Added Spanish (Spain) - thank you davidperez (closemarketing.es)!<\\/li>\\n<li>Translation: Added Spanish (Argentina) - thank you bratorr!<\\/li>\\n<li>Translation: Added Finnish - thank you Stedi!<\\/li>\\n<li>Translation: Add Dutch - thank you Robin!<\\/li>\\n<li>Translation: Added Ukrainian - thank you EUROMEDIA!<\\/li>\\n<li>Translation: Vietnamese added - thank you themevi!<\\/li>\\n<\\/ul>\\n<h4> 1.9.1 <\\/h4>\\n<ul>\\n<li>Blog: Fix \\\"null\\\" in infinite scroll load more button text<\\/li>\\n<li>WooCommerce: Fix hidden added to cart panel on mobile when sticky nav active<\\/li>\\n<li>WooCommerce: Fix missing SVG icon in mobile added to cart panel<\\/li>\\n<\\/ul>\\n<h4> 1.9.0 <\\/h4>\\n<ul>\\n<li>Blog: Support SVG icon feature<\\/li>\\n<li>Colors: Add navigation search color options<\\/li>\\n<li>Disable Elements: Disable mobile menu in Mobile Header if nav is disabled<\\/li>\\n<li>Elements: Add wp_body_open hook<\\/li>\\n<li>Elements: Allow 0 mobile padding in Elements<\\/li>\\n<li>Elements: Add generate_elements_admin_menu_capability filter<\\/li>\\n<li>Elements: Add generate_page_hero_css_output filter<\\/li>\\n<li>Elements: Prevent error in Header Element if taxonomy doesn\'t exist<\\/li>\\n<li>Elements: Fix double logo when Header Element has logo + using nav as header<\\/li>\\n<li>Elements: Fix mobile header logo not replacing if merge is disabled<\\/li>\\n<li>Elements: Fix missing arrow in Choose Element Type select in WP 5.3<\\/li>\\n<li>Elements: Add generate_inside_site_container hook option<\\/li>\\n<li>Elements: Add generate_after_entry_content hook option<\\/li>\\n<li>Menu Plus: Add off canvas desktop toggle label option<\\/li>\\n<li>Menu Plus: Add generate_off_canvas_toggle_output filter<\\/li>\\n<li>Menu Plus: Support SVG icon feature<\\/li>\\n<li>Menu Plus: Fix sticky navigation overlapping BB controls<\\/li>\\n<li>Menu Plus: Add align-items: center to nav as header, mobile header and sticky nav with branding<\\/li>\\n<li>Sections: Fix text\\/visual switch bug in Firefox<\\/li>\\n<li>Sites: Add option to revert site import<\\/li>\\n<li>Sites: Increase site library limit to 100<\\/li>\\n<li>Spacing: Add live preview to group container padding<\\/li>\\n<li>Typography: Add tablet site title\\/navigation font size options<\\/li>\\n<li>Typography: Add archive post title weight, transform, font size and line height<\\/li>\\n<li>Typography: Add single content title weight, transform, font size and line height<\\/li>\\n<li>Typography: Only call all google fonts once in the Customizer<\\/li>\\n<li>Typography: Get Google fonts from readable JSON list<\\/li>\\n<li>Typography: Make sure font settings aren\'t lost if list is changed<\\/li>\\n<li>Typography: Only call generate_get_all_google_fonts if needed<\\/li>\\n<li>WooCommerce: Add columns gap options (desktop, tablet, mobile)<\\/li>\\n<li>WooCommerce: Add tablet column options<\\/li>\\n<li>WooCommerce: Add related\\/upsell tablet column options<\\/li>\\n<li>WooCommerce: Support SVG icon feature<\\/li>\\n<li>WooCommerce: Prevent empty added to cart panel on single products<\\/li>\\n<li>WooCommerce: Fix woocommerce-ordering arrow in old FF versions<\\/li>\\n<li>WooCommerce: Make item\\/items string translatable<\\/li>\\n<li>General: Better customizer device widths<\\/li>\\n<li>General: Use generate_premium_get_media_query throughout modules<\\/li>\\n<li>General: Improve Customizer control styling<\\/li>\\n<\\/ul>\\n<h4> 1.8.3 <\\/h4>\\n<ul>\\n<li>Menu Plus: Use flexbox for center aligned nav with nav branding<\\/li>\\n<li>Menu Plus: Center overlay off canvas exit button on mobile<\\/li>\\n<li>Menu Plus: Add alt tag to sticky nav logo<\\/li>\\n<li>Menu Plus: Set generate_not_mobile_menu_media_query filter based on mobile menu breakpoint<\\/li>\\n<li>Sections: Remember when text tab is active<\\/li>\\n<li>Sections: Disable visual editor if turned off in profile<\\/li>\\n<li>Typography: Add generate_google_font_display filter<\\/li>\\n<li>WooCommerce: Fix single product sidebar layout metabox option<\\/li>\\n<li>WooCommerce: Reduce carousel thumbnail max-width to 100px to match new thumbnail sizes<\\/li>\\n<\\/ul>\\n<h4> 1.8.2 <\\/h4>\\n<ul>\\n<li>Elements: Use Page Hero site title color for mobile header site title<\\/li>\\n<li>Menu Plus: Give mobile header site title more left spacing<\\/li>\\n<li>Menu Plus: Fix nav search icon in sticky navigation when using nav branding in Firefox<\\/li>\\n<li>Site Library: Show Site Library tab even if no sites exist<\\/li>\\n<li>Site Library: Show an error message in Site Library if no sites exist<\\/li>\\n<li>Typography: Remove reference to generate_get_navigation_location() function<\\/li>\\n<li>WooCommerce: Remove quantity field arrows when using quantity buttons in Firefox<\\/li>\\n<li>WooCommerce: Remove extra border when loading quantity buttons<\\/li>\\n<li>WooCommerce: Use get_price_html() is sticky add to cart panel<\\/li>\\n<\\/ul>\\n<h4> 1.8.1 <\\/h4>\\n<ul>\\n<li>Menu Plus: Revert sticky nav duplicate ID fix due to Cyrillic script bug<\\/li>\\n<\\/ul>\\n<h4> 1.8 <\\/h4>\\n<ul>\\n<li>Blog: Apply columns filter to masonry grid sizer<\\/li>\\n<li>Colors: Merge Footer Widgets and Footer controls in Color panel<\\/li>\\n<li>Colors: Remove edit_theme_options capability to Customizer controls (set by default)<\\/li>\\n<li>Disable Elements: Make sure mobile header is disabled when primary navigation is disabled<\\/li>\\n<li>Elements: Add content width option in Layout Element<\\/li>\\n<li>Elements: Fix mobile header logo when mobile menu toggled<\\/li>\\n<li>Elements: Add generate_page_hero_location filter<\\/li>\\n<li>Elements: Add generate_elements_show_object_ids filter to show IDs in Display Rule values<\\/li>\\n<li>Elements: Prevent merged header wrap from conflicting with Elementor controls<\\/li>\\n<li>Elements: Change Container tab name to Content<\\/li>\\n<li>Elements: Add woocommerce_share option to Hooks<\\/li>\\n<li>Elements: Improve WPML compatibility<\\/li>\\n<li>Elements: Improve Polylang compatibility<\\/li>\\n<li>Elements: Prevent PHP notices when adding taxonomy locations to non-existent archives<\\/li>\\n<li>Elements: Add generate_mobile_cart_items hook to hook list<\\/li>\\n<li>Elements: Add generate_element_post_id filter<\\/li>\\n<li>Elements: Escape HTML elements inside Element textarea<\\/li>\\n<li>Elements: Add Beaver Builder templates to the Display Rules<\\/li>\\n<li>Menu Plus: Add mobile header breakpoint option<\\/li>\\n<li>Menu Plus: Add off canvas overlay option<\\/li>\\n<li>Menu Plus: Add navigation as header option<\\/li>\\n<li>Menu Plus: Remove navigation logo option if navigation as header set<\\/li>\\n<li>Menu Plus: Add sticky navigation logo option<\\/li>\\n<li>Menu Plus: Allow site title in mobile header instead of logo<\\/li>\\n<li>Menu Plus: Add option to move exit button inside the off canvas panel<\\/li>\\n<li>Menu Plus: Change Slideout Navigation name to Off Canvas Panel<\\/li>\\n<li>Menu Plus: Only re-focus after slideout close on escape key<\\/li>\\n<li>Menu Plus: Give close slideout event a name so it can be removed<\\/li>\\n<li>Menu Plus: Remove invalid transition-delay<\\/li>\\n<li>Menu Plus: Improve slideout overlay transition<\\/li>\\n<li>Menu Plus: Add mobile open\\/close icons to GPP font<\\/li>\\n<li>Menu Plus: Allow dynamic widget classes in off canvas panel (fixes WC range slider widget issue)<\\/li>\\n<li>Menu Plus: Basic compatibility with future SVG icons<\\/li>\\n<li>Menu Plus: Prevent duplicate IDs when sticky navigation is cloned<\\/li>\\n<li>Secondary Nav: Add dropdown direction option<\\/li>\\n<li>Secondary Nav: Basic compatibility with future SVG icons<\\/li>\\n<li>Sections: Fix section editor issues in WP 5.0<\\/li>\\n<li>Sections: Show Better Font Awesome icon in editor<\\/li>\\n<li>Sites: Re-design UI<\\/li>\\n<li>Sites: Add option to activate as a module like all the other modules<\\/li>\\n<li>Sites: Don\'t show backup options button if no options exist<\\/li>\\n<li>Sites: Make JS action classes more specific to the site library<\\/li>\\n<li>Sites: Set mime types of content.xml and widgets.wie<\\/li>\\n<li>Spacing: Add header padding option for mobile<\\/li>\\n<li>Spacing: Add widget padding option for mobile<\\/li>\\n<li>Spacing: Add footer widgets padding option for mobile<\\/li>\\n<li>Spacing: Add content separator option<\\/li>\\n<li>Spacing: Apply mobile menu item width to mobile bar only<\\/li>\\n<li>WooCommerce: Add option for mini cart in the menu<\\/li>\\n<li>WooCommerce: Add option to open off overlay panel on add to cart<\\/li>\\n<li>WooCommerce: Add option to open sticky add to cart panel on single products<\\/li>\\n<li>WooCommerce: Add option to add +\\/- buttons to the quantity fields<\\/li>\\n<li>WooCommerce: Add option to show number of items in cart menu item<\\/li>\\n<li>WooCommerce: Add option to choose single product image area width<\\/li>\\n<li>WooCommerce: Add color options for price slider widget<\\/li>\\n<li>WooCommerce: Use CSS grid for the product archives<\\/li>\\n<li>WooCommerce: Horizontally align add to cart buttons<\\/li>\\n<li>WooCommerce: Re-design the cart widget<\\/li>\\n<li>WooCommerce: Tighten up product info spacing<\\/li>\\n<li>WooCommerce: Improve product tab design to look more like tabs<\\/li>\\n<li>WooCommerce: Simplify single product image display<\\/li>\\n<li>WooCommerce: Use flexbox for quantity\\/add to cart alignment<\\/li>\\n<li>WooCommerce: Improve rating star styles<\\/li>\\n<li>WooCommerce: Use product alignment setting for related\\/upsell products<\\/li>\\n<li>WooCommerce: Remove bottom margin from product image<\\/li>\\n<li>WooCommerce: Organize colors in the Customizer<\\/li>\\n<li>WooCommerce: Remove title attribute from menu cart item<\\/li>\\n<li>WooCommerce: Improve coupon field design<\\/li>\\n<li>WooCommerce: Improve result count\\/ordering styling<\\/li>\\n<li>WooCommerce: Add gap around WC single product images<\\/li>\\n<li>WooCommerce: Remove arrow from checkout button<\\/li>\\n<li>WooCommerce: Hide view cart link on add to cart click<\\/li>\\n<li>WooCommerce: Organize CSS<\\/li>\\n<li>Introduce in-Customizer shortcuts<\\/li>\\n<li>Add generate_disable_customizer_shortcuts filter<\\/li>\\n<\\/ul>\"],\"plugin\":\"gp-premium\\/gp-premium.php\",\"id\":\"gp-premium\\/gp-premium.php\"}\";}","off"),
("198","generate_package_colors","activated","auto"),
("199","generate_package_elements","activated","auto"),
("200","generate_package_menu_plus","activated","auto"),
("201","generate_package_spacing","activated","auto"),
("202","generate_package_typography","activated","auto"),
("203","generate_settings","a:78:{s:22:\"content_layout_setting\";s:13:\"one-container\";s:15:\"underline_links\";s:5:\"never\";s:22:\"use_dynamic_typography\";b:1;s:16:\"background_color\";s:13:\"var(--base-2)\";s:10:\"text_color\";s:17:\"var(--contrast-3)\";s:10:\"link_color\";s:15:\"var(--accent-2)\";s:16:\"link_color_hover\";s:15:\"var(--accent-3)\";s:23:\"header_background_color\";s:0:\"\";s:16:\"site_title_color\";s:11:\"var(--base)\";s:18:\"site_tagline_color\";s:17:\"var(--contrast-4)\";s:27:\"navigation_background_color\";s:15:\"var(--contrast)\";s:33:\"navigation_background_hover_color\";s:0:\"\";s:35:\"navigation_background_current_color\";s:0:\"\";s:21:\"navigation_text_color\";s:11:\"var(--base)\";s:27:\"navigation_text_hover_color\";s:15:\"var(--accent-3)\";s:29:\"navigation_text_current_color\";s:15:\"var(--accent-3)\";s:30:\"subnavigation_background_color\";s:11:\"var(--base)\";s:36:\"subnavigation_background_hover_color\";s:17:\"var(--contrast-3)\";s:38:\"subnavigation_background_current_color\";s:17:\"var(--contrast-3)\";s:24:\"subnavigation_text_color\";s:0:\"\";s:30:\"subnavigation_text_hover_color\";s:0:\"\";s:32:\"subnavigation_text_current_color\";s:0:\"\";s:24:\"content_background_color\";s:11:\"var(--base)\";s:21:\"blog_post_title_color\";s:15:\"var(--contrast)\";s:27:\"blog_post_title_hover_color\";s:17:\"var(--contrast-2)\";s:21:\"entry_meta_text_color\";s:17:\"var(--contrast-2)\";s:31:\"sidebar_widget_background_color\";s:13:\"var(--base-2)\";s:30:\"footer_widget_background_color\";s:13:\"var(--base-2)\";s:25:\"footer_widget_title_color\";s:15:\"var(--contrast)\";s:23:\"footer_background_color\";s:15:\"var(--contrast)\";s:17:\"footer_text_color\";s:13:\"var(--base-2)\";s:17:\"footer_link_color\";s:17:\"var(--contrast-3)\";s:23:\"footer_link_hover_color\";s:13:\"var(--base-2)\";s:21:\"form_background_color\";s:11:\"var(--base)\";s:15:\"form_text_color\";s:17:\"var(--contrast-2)\";s:27:\"form_background_color_focus\";s:13:\"var(--base-2)\";s:21:\"form_text_color_focus\";s:17:\"var(--contrast-2)\";s:17:\"form_border_color\";s:17:\"var(--contrast-3)\";s:23:\"form_border_color_focus\";s:17:\"var(--contrast-3)\";s:12:\"font_manager\";a:2:{i:0;a:5:{s:10:\"fontFamily\";s:5:\"Rubik\";s:10:\"googleFont\";b:1;s:13:\"googleFontApi\";i:1;s:18:\"googleFontCategory\";s:10:\"sans-serif\";s:18:\"googleFontVariants\";s:111:\"300, regular, 500, 600, 700, 800, 900, 300italic, italic, 500italic, 600italic, 700italic, 800italic, 900italic\";}i:1;a:5:{s:10:\"fontFamily\";s:7:\"DM Sans\";s:10:\"googleFont\";b:1;s:13:\"googleFontApi\";i:1;s:18:\"googleFontCategory\";s:10:\"sans-serif\";s:18:\"googleFontVariants\";s:47:\"regular, italic, 500, 500italic, 700, 700italic\";}}s:10:\"typography\";a:10:{i:0;a:20:{s:8:\"selector\";s:4:\"body\";s:14:\"customSelector\";s:0:\"\";s:10:\"fontFamily\";s:5:\"Rubik\";s:10:\"fontWeight\";s:0:\"\";s:13:\"textTransform\";s:0:\"\";s:8:\"fontSize\";s:0:\"\";s:14:\"fontSizeTablet\";s:0:\"\";s:14:\"fontSizeMobile\";s:0:\"\";s:12:\"fontSizeUnit\";s:0:\"\";s:10:\"lineHeight\";s:3:\"1.7\";s:16:\"lineHeightTablet\";s:0:\"\";s:16:\"lineHeightMobile\";s:0:\"\";s:14:\"lineHeightUnit\";s:0:\"\";s:13:\"letterSpacing\";s:0:\"\";s:19:\"letterSpacingTablet\";s:0:\"\";s:19:\"letterSpacingMobile\";s:0:\"\";s:17:\"letterSpacingUnit\";s:0:\"\";s:16:\"marginBottomUnit\";s:0:\"\";s:6:\"module\";s:4:\"core\";s:5:\"group\";s:4:\"base\";}i:1;a:23:{s:8:\"selector\";s:18:\"primary-menu-items\";s:14:\"customSelector\";s:0:\"\";s:10:\"fontFamily\";s:7:\"inherit\";s:10:\"fontWeight\";s:3:\"500\";s:13:\"textTransform\";s:9:\"uppercase\";s:8:\"fontSize\";s:4:\"14px\";s:14:\"fontSizeTablet\";s:0:\"\";s:14:\"fontSizeMobile\";s:0:\"\";s:12:\"fontSizeUnit\";s:0:\"\";s:10:\"lineHeight\";s:0:\"\";s:16:\"lineHeightTablet\";s:0:\"\";s:16:\"lineHeightMobile\";s:0:\"\";s:14:\"lineHeightUnit\";s:0:\"\";s:13:\"letterSpacing\";s:0:\"\";s:19:\"letterSpacingTablet\";s:0:\"\";s:19:\"letterSpacingMobile\";s:0:\"\";s:17:\"letterSpacingUnit\";s:0:\"\";s:12:\"marginBottom\";s:0:\"\";s:18:\"marginBottomTablet\";s:0:\"\";s:18:\"marginBottomMobile\";s:0:\"\";s:16:\"marginBottomUnit\";s:0:\"\";s:6:\"module\";s:4:\"core\";s:5:\"group\";s:17:\"primaryNavigation\";}i:2;a:23:{s:8:\"selector\";s:10:\"main-title\";s:14:\"customSelector\";s:0:\"\";s:10:\"fontFamily\";s:7:\"inherit\";s:10:\"fontWeight\";s:6:\"normal\";s:13:\"textTransform\";s:0:\"\";s:8:\"fontSize\";s:4:\"34px\";s:14:\"fontSizeTablet\";s:0:\"\";s:14:\"fontSizeMobile\";s:0:\"\";s:12:\"fontSizeUnit\";s:0:\"\";s:10:\"lineHeight\";s:0:\"\";s:16:\"lineHeightTablet\";s:0:\"\";s:16:\"lineHeightMobile\";s:0:\"\";s:14:\"lineHeightUnit\";s:0:\"\";s:13:\"letterSpacing\";s:0:\"\";s:19:\"letterSpacingTablet\";s:0:\"\";s:19:\"letterSpacingMobile\";s:0:\"\";s:17:\"letterSpacingUnit\";s:0:\"\";s:12:\"marginBottom\";s:0:\"\";s:18:\"marginBottomTablet\";s:0:\"\";s:18:\"marginBottomMobile\";s:0:\"\";s:16:\"marginBottomUnit\";s:0:\"\";s:6:\"module\";s:4:\"core\";s:5:\"group\";s:6:\"header\";}i:3;a:20:{s:8:\"selector\";s:2:\"h1\";s:14:\"customSelector\";s:0:\"\";s:10:\"fontFamily\";s:7:\"DM Sans\";s:10:\"fontWeight\";s:3:\"500\";s:13:\"textTransform\";s:0:\"\";s:8:\"fontSize\";s:45:\"clamp(2.125rem, 1.292rem + 3.704vw, 4.625rem)\";s:14:\"fontSizeTablet\";s:0:\"\";s:14:\"fontSizeMobile\";s:0:\"\";s:12:\"fontSizeUnit\";s:0:\"\";s:10:\"lineHeight\";s:5:\"1.2em\";s:16:\"lineHeightTablet\";s:0:\"\";s:16:\"lineHeightMobile\";s:0:\"\";s:14:\"lineHeightUnit\";s:0:\"\";s:13:\"letterSpacing\";s:0:\"\";s:19:\"letterSpacingTablet\";s:0:\"\";s:19:\"letterSpacingMobile\";s:0:\"\";s:17:\"letterSpacingUnit\";s:0:\"\";s:16:\"marginBottomUnit\";s:0:\"\";s:6:\"module\";s:4:\"core\";s:5:\"group\";s:7:\"content\";}i:4;a:20:{s:8:\"selector\";s:2:\"h2\";s:14:\"customSelector\";s:0:\"\";s:10:\"fontFamily\";s:7:\"DM Sans\";s:10:\"fontWeight\";s:3:\"500\";s:13:\"textTransform\";s:0:\"\";s:8:\"fontSize\";s:45:\"clamp(1.563rem, 0.804rem + 2.024vw, 2.625rem)\";s:14:\"fontSizeTablet\";s:0:\"\";s:14:\"fontSizeMobile\";s:0:\"\";s:12:\"fontSizeUnit\";s:0:\"\";s:10:\"lineHeight\";s:5:\"1.5em\";s:16:\"lineHeightTablet\";s:0:\"\";s:16:\"lineHeightMobile\";s:0:\"\";s:14:\"lineHeightUnit\";s:0:\"\";s:13:\"letterSpacing\";s:0:\"\";s:19:\"letterSpacingTablet\";s:0:\"\";s:19:\"letterSpacingMobile\";s:0:\"\";s:17:\"letterSpacingUnit\";s:0:\"\";s:16:\"marginBottomUnit\";s:0:\"\";s:6:\"module\";s:4:\"core\";s:5:\"group\";s:7:\"content\";}i:5;a:20:{s:8:\"selector\";s:2:\"h3\";s:14:\"customSelector\";s:0:\"\";s:10:\"fontFamily\";s:7:\"DM Sans\";s:10:\"fontWeight\";s:3:\"500\";s:13:\"textTransform\";s:0:\"\";s:8:\"fontSize\";s:0:\"\";s:14:\"fontSizeTablet\";s:0:\"\";s:14:\"fontSizeMobile\";s:4:\"24px\";s:12:\"fontSizeUnit\";s:0:\"\";s:10:\"lineHeight\";s:5:\"1.5em\";s:16:\"lineHeightTablet\";s:0:\"\";s:16:\"lineHeightMobile\";s:0:\"\";s:14:\"lineHeightUnit\";s:0:\"\";s:13:\"letterSpacing\";s:0:\"\";s:19:\"letterSpacingTablet\";s:0:\"\";s:19:\"letterSpacingMobile\";s:0:\"\";s:17:\"letterSpacingUnit\";s:0:\"\";s:16:\"marginBottomUnit\";s:0:\"\";s:6:\"module\";s:4:\"core\";s:5:\"group\";s:7:\"content\";}i:6;a:20:{s:8:\"selector\";s:2:\"h4\";s:14:\"customSelector\";s:0:\"\";s:10:\"fontFamily\";s:7:\"DM Sans\";s:10:\"fontWeight\";s:3:\"500\";s:13:\"textTransform\";s:0:\"\";s:8:\"fontSize\";s:0:\"\";s:14:\"fontSizeTablet\";s:0:\"\";s:14:\"fontSizeMobile\";s:4:\"22px\";s:12:\"fontSizeUnit\";s:0:\"\";s:10:\"lineHeight\";s:0:\"\";s:16:\"lineHeightTablet\";s:0:\"\";s:16:\"lineHeightMobile\";s:0:\"\";s:14:\"lineHeightUnit\";s:0:\"\";s:13:\"letterSpacing\";s:0:\"\";s:19:\"letterSpacingTablet\";s:0:\"\";s:19:\"letterSpacingMobile\";s:0:\"\";s:17:\"letterSpacingUnit\";s:0:\"\";s:16:\"marginBottomUnit\";s:0:\"\";s:6:\"module\";s:4:\"core\";s:5:\"group\";s:7:\"content\";}i:7;a:20:{s:8:\"selector\";s:2:\"h5\";s:14:\"customSelector\";s:0:\"\";s:10:\"fontFamily\";s:7:\"DM Sans\";s:10:\"fontWeight\";s:3:\"500\";s:13:\"textTransform\";s:0:\"\";s:8:\"fontSize\";s:0:\"\";s:14:\"fontSizeTablet\";s:0:\"\";s:14:\"fontSizeMobile\";s:4:\"19px\";s:12:\"fontSizeUnit\";s:0:\"\";s:10:\"lineHeight\";s:0:\"\";s:16:\"lineHeightTablet\";s:0:\"\";s:16:\"lineHeightMobile\";s:0:\"\";s:14:\"lineHeightUnit\";s:0:\"\";s:13:\"letterSpacing\";s:0:\"\";s:19:\"letterSpacingTablet\";s:0:\"\";s:19:\"letterSpacingMobile\";s:0:\"\";s:17:\"letterSpacingUnit\";s:0:\"\";s:16:\"marginBottomUnit\";s:0:\"\";s:6:\"module\";s:4:\"core\";s:5:\"group\";s:7:\"content\";}i:8;a:20:{s:8:\"selector\";s:2:\"h6\";s:14:\"customSelector\";s:0:\"\";s:10:\"fontFamily\";s:7:\"DM Sans\";s:10:\"fontWeight\";s:3:\"500\";s:13:\"textTransform\";s:0:\"\";s:8:\"fontSize\";s:4:\"18px\";s:14:\"fontSizeTablet\";s:0:\"\";s:14:\"fontSizeMobile\";s:4:\"17px\";s:12:\"fontSizeUnit\";s:0:\"\";s:10:\"lineHeight\";s:0:\"\";s:16:\"lineHeightTablet\";s:0:\"\";s:16:\"lineHeightMobile\";s:0:\"\";s:14:\"lineHeightUnit\";s:0:\"\";s:13:\"letterSpacing\";s:0:\"\";s:19:\"letterSpacingTablet\";s:0:\"\";s:19:\"letterSpacingMobile\";s:0:\"\";s:17:\"letterSpacingUnit\";s:0:\"\";s:16:\"marginBottomUnit\";s:0:\"\";s:6:\"module\";s:4:\"core\";s:5:\"group\";s:7:\"content\";}i:9;a:23:{s:8:\"selector\";s:6:\"footer\";s:14:\"customSelector\";s:0:\"\";s:10:\"fontFamily\";s:7:\"inherit\";s:10:\"fontWeight\";s:0:\"\";s:13:\"textTransform\";s:0:\"\";s:8:\"fontSize\";s:4:\"14px\";s:14:\"fontSizeTablet\";s:0:\"\";s:14:\"fontSizeMobile\";s:0:\"\";s:12:\"fontSizeUnit\";s:0:\"\";s:10:\"lineHeight\";s:0:\"\";s:16:\"lineHeightTablet\";s:0:\"\";s:16:\"lineHeightMobile\";s:0:\"\";s:14:\"lineHeightUnit\";s:0:\"\";s:13:\"letterSpacing\";s:0:\"\";s:19:\"letterSpacingTablet\";s:0:\"\";s:19:\"letterSpacingMobile\";s:0:\"\";s:17:\"letterSpacingUnit\";s:0:\"\";s:12:\"marginBottom\";s:0:\"\";s:18:\"marginBottomTablet\";s:0:\"\";s:18:\"marginBottomMobile\";s:0:\"\";s:16:\"marginBottomUnit\";s:0:\"\";s:6:\"module\";s:4:\"core\";s:5:\"group\";s:6:\"footer\";}}s:13:\"global_colors\";a:10:{i:0;a:3:{s:4:\"name\";s:8:\"contrast\";s:4:\"slug\";s:8:\"contrast\";s:5:\"color\";s:7:\"#0F0C1B\";}i:1;a:3:{s:4:\"name\";s:10:\"contrast-2\";s:4:\"slug\";s:10:\"contrast-2\";s:5:\"color\";s:7:\"#0b0813\";}i:2;a:3:{s:4:\"name\";s:10:\"contrast-3\";s:4:\"slug\";s:10:\"contrast-3\";s:5:\"color\";s:7:\"#bebebe\";}i:3;a:3:{s:4:\"name\";s:4:\"base\";s:4:\"slug\";s:4:\"base\";s:5:\"color\";s:7:\"#f7f7f7\";}i:4;a:3:{s:4:\"name\";s:6:\"base-2\";s:4:\"slug\";s:6:\"base-2\";s:5:\"color\";s:7:\"#ffffff\";}i:5;a:3:{s:4:\"name\";s:6:\"accent\";s:4:\"slug\";s:6:\"accent\";s:5:\"color\";s:7:\"#FF34DF\";}i:6;a:3:{s:4:\"name\";s:8:\"accent-2\";s:4:\"slug\";s:8:\"accent-2\";s:5:\"color\";s:7:\"#3ACCF6\";}i:7;a:3:{s:4:\"name\";s:8:\"accent-3\";s:4:\"slug\";s:8:\"accent-3\";s:5:\"color\";s:7:\"#FDB600\";}i:8;a:3:{s:4:\"name\";s:8:\"uw-light\";s:4:\"slug\";s:8:\"uw-light\";s:5:\"color\";s:7:\"#01fafe\";}i:9;a:3:{s:4:\"name\";s:8:\"uw-green\";s:4:\"slug\";s:8:\"uw-green\";s:5:\"color\";s:7:\"#008c95\";}}s:15:\"container_width\";i:1300;s:14:\"layout_setting\";s:10:\"no-sidebar\";s:19:\"blog_layout_setting\";s:10:\"no-sidebar\";s:24:\"header_alignment_setting\";s:5:\"right\";s:20:\"nav_position_setting\";s:15:\"nav-float-right\";s:20:\"site_title_font_size\";i:25;s:21:\"nav_alignment_setting\";s:4:\"left\";s:10:\"nav_search\";s:7:\"disable\";s:18:\"header_inner_width\";s:10:\"full-width\";s:8:\"h1_color\";s:15:\"var(--contrast)\";s:8:\"h2_color\";s:15:\"var(--contrast)\";s:8:\"h3_color\";s:15:\"var(--contrast)\";s:8:\"h4_color\";s:15:\"var(--contrast)\";s:8:\"h5_color\";s:15:\"var(--contrast)\";s:8:\"h6_color\";s:15:\"var(--contrast)\";s:28:\"form_button_background_color\";s:15:\"var(--accent-2)\";s:34:\"form_button_background_color_hover\";s:13:\"var(--base-2)\";s:22:\"form_button_text_color\";s:13:\"var(--base-2)\";s:28:\"form_button_text_color_hover\";s:13:\"var(--base-2)\";s:18:\"content_link_color\";s:15:\"var(--accent-2)\";s:24:\"content_link_hover_color\";s:15:\"var(--accent-3)\";s:25:\"slideout_background_color\";s:15:\"var(--contrast)\";s:19:\"slideout_text_color\";s:0:\"\";s:33:\"slideout_submenu_background_color\";s:0:\"\";s:27:\"slideout_submenu_text_color\";s:0:\"\";s:28:\"navigation_search_text_color\";s:17:\"var(--contrast-2)\";s:34:\"navigation_search_background_color\";s:11:\"var(--base)\";s:31:\"slideout_background_hover_color\";s:0:\"\";s:18:\"content_text_color\";s:15:\"var(--contrast)\";s:17:\"dynamic_css_cache\";b:1;s:16:\"nav_search_modal\";b:1;s:21:\"search_modal_bg_color\";s:13:\"var(--base-2)\";s:10:\"hide_title\";b:1;s:12:\"hide_tagline\";b:1;s:10:\"logo_width\";i:90;s:11:\"retina_logo\";s:0:\"\";}","on"),
("204","generate_spacing_settings","a:15:{s:11:\"content_top\";i:100;s:14:\"content_bottom\";i:100;s:18:\"mobile_content_top\";i:60;s:21:\"mobile_content_bottom\";i:60;s:16:\"menu_item_height\";i:60;s:10:\"header_top\";i:20;s:13:\"header_bottom\";i:20;s:12:\"header_right\";i:40;s:11:\"header_left\";i:40;s:23:\"sticky_menu_item_height\";s:0:\"\";s:27:\"off_canvas_menu_item_height\";i:60;s:17:\"mobile_header_top\";i:20;s:19:\"mobile_header_right\";i:20;s:20:\"mobile_header_bottom\";i:20;s:18:\"mobile_header_left\";i:20;}","on"),
("205","generate_menu_plus_settings","a:13:{s:20:\"navigation_as_header\";b:0;s:13:\"slideout_menu\";s:6:\"mobile\";s:18:\"slideout_menu_side\";s:4:\"left\";s:22:\"mobile_menu_breakpoint\";i:860;s:21:\"slideout_close_button\";s:6:\"inside\";s:11:\"sticky_menu\";s:5:\"false\";s:13:\"mobile_header\";s:7:\"disable\";s:22:\"mobile_header_branding\";s:5:\"title\";s:20:\"mobile_header_sticky\";s:6:\"enable\";s:18:\"sticky_menu_effect\";s:5:\"slide\";s:22:\"sticky_navigation_logo\";s:0:\"\";s:30:\"mobile_header_auto_hide_sticky\";b:1;s:17:\"mobile_menu_label\";s:0:\"\";}","on"),
("206","theme_mods_generatepress","a:3:{s:18:\"nav_menu_locations\";a:2:{s:7:\"primary\";i:4;s:8:\"slideout\";i:4;}s:18:\"custom_css_post_id\";i:8;s:11:\"custom_logo\";i:1228;}","auto"),
("207","generatepress_dynamic_css_data","a:0:{}","auto"),
("208","_generatepress_site_library_backup","a:5:{s:13:\"theme_options\";a:2:{s:4:\"mods\";a:29:{s:18:\"font_body_variants\";b:0;s:18:\"font_body_category\";b:0;s:24:\"font_site_title_variants\";b:0;s:24:\"font_site_title_category\";b:0;s:26:\"font_site_tagline_variants\";b:0;s:26:\"font_site_tagline_category\";b:0;s:24:\"font_navigation_variants\";b:0;s:24:\"font_navigation_category\";b:0;s:34:\"font_secondary_navigation_variants\";b:0;s:34:\"font_secondary_navigation_category\";b:0;s:21:\"font_buttons_variants\";b:0;s:21:\"font_buttons_category\";b:0;s:23:\"font_heading_1_variants\";b:0;s:23:\"font_heading_1_category\";b:0;s:23:\"font_heading_2_variants\";b:0;s:23:\"font_heading_2_category\";b:0;s:23:\"font_heading_3_variants\";b:0;s:23:\"font_heading_3_category\";b:0;s:23:\"font_heading_4_variants\";b:0;s:23:\"font_heading_4_category\";b:0;s:23:\"font_heading_5_variants\";b:0;s:23:\"font_heading_5_category\";b:0;s:23:\"font_heading_6_variants\";b:0;s:23:\"font_heading_6_category\";b:0;s:26:\"font_widget_title_variants\";b:0;s:26:\"font_widget_title_category\";b:0;s:20:\"font_footer_variants\";b:0;s:20:\"font_footer_category\";b:0;s:18:\"generate_copyright\";b:0;}s:7:\"options\";a:8:{s:17:\"generate_settings\";b:0;s:28:\"generate_background_settings\";b:0;s:22:\"generate_blog_settings\";b:0;s:29:\"generate_page_header_settings\";b:0;s:31:\"generate_secondary_nav_settings\";b:0;s:25:\"generate_spacing_settings\";b:0;s:27:\"generate_menu_plus_settings\";b:0;s:29:\"generate_woocommerce_settings\";b:0;}}s:7:\"modules\";a:2:{s:11:\"Backgrounds\";s:28:\"generate_package_backgrounds\";s:9:\"Copyright\";s:26:\"generate_package_copyright\";}s:12:\"site_options\";a:5:{s:18:\"nav_menu_locations\";a:0:{}s:11:\"custom_logo\";b:0;s:13:\"show_on_front\";s:5:\"posts\";s:13:\"page_on_front\";s:1:\"0\";s:14:\"page_for_posts\";s:1:\"0\";}s:7:\"plugins\";a:3:{i:0;s:29:\"generateblocks-pro/plugin.php\";i:1;s:25:\"generateblocks/plugin.php\";i:2;s:25:\"gp-premium/gp-premium.php\";}s:7:\"content\";b:1;}","auto"),
("211","generate_migration_settings","a:2:{s:22:\"footer_padding_updated\";s:4:\"true\";s:30:\"mobile_content_padding_updated\";s:4:\"true\";}","auto"),
("212","category_children","a:0:{}","auto"),
("213","generatepress_sites_mapped_ids_driver","a:46:{i:30;i:30;i:118;i:118;i:202;i:202;i:255;i:255;i:294;i:294;i:295;i:295;i:297;i:297;i:341;i:341;i:345;i:345;i:348;i:348;i:399;i:399;i:412;i:412;i:413;i:413;i:467;i:467;i:696;i:696;i:708;i:708;i:709;i:709;i:716;i:716;i:725;i:725;i:964;i:964;i:2;i:965;i:3;i:966;i:25;i:25;i:29;i:29;i:42;i:42;i:43;i:43;i:44;i:44;i:45;i:45;i:46;i:46;i:49;i:49;i:64;i:64;i:66;i:66;i:78;i:78;i:102;i:102;i:461;i:461;i:808;i:808;i:965;i:967;i:967;i:968;i:1021;i:1021;i:1216;i:1216;i:32;i:32;i:34;i:34;i:36;i:36;i:38;i:38;i:40;i:40;i:1046;i:1046;}","off"),
("216","show_on_front","page","auto"),
("217","generate_dynamic_css_output","body{background-color:var(--base-2);color:var(--contrast-3);}a{color:var(--accent-2);}a:hover, a:focus, a:active{color:var(--accent-3);}.grid-container{max-width:1300px;}.wp-block-group__inner-container{max-width:1300px;margin-left:auto;margin-right:auto;}.site-header .header-image{width:90px;}:root{--contrast:#0F0C1B;--contrast-2:#0b0813;--contrast-3:#bebebe;--base:#f7f7f7;--base-2:#ffffff;--accent:#FF34DF;--accent-2:#3ACCF6;--accent-3:#FDB600;--uw-light:#01fafe;--uw-green:#008c95;}:root .has-contrast-color{color:var(--contrast);}:root .has-contrast-background-color{background-color:var(--contrast);}:root .has-contrast-2-color{color:var(--contrast-2);}:root .has-contrast-2-background-color{background-color:var(--contrast-2);}:root .has-contrast-3-color{color:var(--contrast-3);}:root .has-contrast-3-background-color{background-color:var(--contrast-3);}:root .has-base-color{color:var(--base);}:root .has-base-background-color{background-color:var(--base);}:root .has-base-2-color{color:var(--base-2);}:root .has-base-2-background-color{background-color:var(--base-2);}:root .has-accent-color{color:var(--accent);}:root .has-accent-background-color{background-color:var(--accent);}:root .has-accent-2-color{color:var(--accent-2);}:root .has-accent-2-background-color{background-color:var(--accent-2);}:root .has-accent-3-color{color:var(--accent-3);}:root .has-accent-3-background-color{background-color:var(--accent-3);}:root .has-uw-light-color{color:var(--uw-light);}:root .has-uw-light-background-color{background-color:var(--uw-light);}:root .has-uw-green-color{color:var(--uw-green);}:root .has-uw-green-background-color{background-color:var(--uw-green);}.gp-modal:not(.gp-modal--open):not(.gp-modal--transition){display:none;}.gp-modal--transition:not(.gp-modal--open){pointer-events:none;}.gp-modal-overlay:not(.gp-modal-overlay--open):not(.gp-modal--transition){display:none;}.gp-modal__overlay{display:none;position:fixed;top:0;left:0;right:0;bottom:0;background:rgba(0,0,0,0.2);display:flex;justify-content:center;align-items:center;z-index:10000;backdrop-filter:blur(3px);transition:opacity 500ms ease;opacity:0;}.gp-modal--open:not(.gp-modal--transition) .gp-modal__overlay{opacity:1;}.gp-modal__container{max-width:100%;max-height:100vh;transform:scale(0.9);transition:transform 500ms ease;padding:0 10px;}.gp-modal--open:not(.gp-modal--transition) .gp-modal__container{transform:scale(1);}.search-modal-fields{display:flex;}.gp-search-modal .gp-modal__overlay{align-items:flex-start;padding-top:25vh;background:var(--gp-search-modal-overlay-bg-color);}.search-modal-form{width:500px;max-width:100%;background-color:var(--gp-search-modal-bg-color);color:var(--gp-search-modal-text-color);}.search-modal-form .search-field, .search-modal-form .search-field:focus{width:100%;height:60px;background-color:transparent;border:0;appearance:none;color:currentColor;}.search-modal-fields button, .search-modal-fields button:active, .search-modal-fields button:focus, .search-modal-fields button:hover{background-color:transparent;border:0;color:currentColor;width:60px;}body, button, input, select, textarea{font-family:Rubik, sans-serif;}body{line-height:1.7;}.main-navigation a, .main-navigation .menu-toggle, .main-navigation .menu-bar-items{font-family:inherit;font-weight:500;text-transform:uppercase;font-size:14px;}.main-title{font-family:inherit;font-weight:normal;font-size:34px;}h1{font-family:DM Sans, sans-serif;font-weight:500;font-size:clamp(2.125rem, 1.292rem + 3.704vw, 4.625rem);line-height:1.2em;}h2{font-family:DM Sans, sans-serif;font-weight:500;font-size:clamp(1.563rem, 0.804rem + 2.024vw, 2.625rem);line-height:1.5em;}h3{font-family:DM Sans, sans-serif;font-weight:500;line-height:1.5em;}@media (max-width:768px){h3{font-size:24px;}}h4{font-family:DM Sans, sans-serif;font-weight:500;}@media (max-width:768px){h4{font-size:22px;}}h5{font-family:DM Sans, sans-serif;font-weight:500;}@media (max-width:768px){h5{font-size:19px;}}h6{font-family:DM Sans, sans-serif;font-weight:500;font-size:18px;}@media (max-width:768px){h6{font-size:17px;}}.site-info{font-family:inherit;font-size:14px;}.top-bar{background-color:#636363;color:#ffffff;}.top-bar a{color:#ffffff;}.top-bar a:hover{color:#303030;}.main-title a,.main-title a:hover{color:var(--base);}.site-description{color:var(--contrast-4);}.main-navigation,.main-navigation ul ul{background-color:var(--contrast);}.main-navigation .main-nav ul li a, .main-navigation .menu-toggle, .main-navigation .menu-bar-items{color:var(--base);}.main-navigation .main-nav ul li:not([class*=\"current-menu-\"]):hover > a, .main-navigation .main-nav ul li:not([class*=\"current-menu-\"]):focus > a, .main-navigation .main-nav ul li.sfHover:not([class*=\"current-menu-\"]) > a, .main-navigation .menu-bar-item:hover > a, .main-navigation .menu-bar-item.sfHover > a{color:var(--accent-3);}button.menu-toggle:hover,button.menu-toggle:focus{color:var(--base);}.main-navigation .main-nav ul li[class*=\"current-menu-\"] > a{color:var(--accent-3);}.navigation-search input[type=\"search\"],.navigation-search input[type=\"search\"]:active, .navigation-search input[type=\"search\"]:focus, .main-navigation .main-nav ul li.search-item.active > a, .main-navigation .menu-bar-items .search-item.active > a{color:var(--contrast-2);background-color:var(--base);opacity:1;}.main-navigation ul ul{background-color:var(--base);}.main-navigation .main-nav ul ul li:not([class*=\"current-menu-\"]):hover > a,.main-navigation .main-nav ul ul li:not([class*=\"current-menu-\"]):focus > a, .main-navigation .main-nav ul ul li.sfHover:not([class*=\"current-menu-\"]) > a{background-color:var(--contrast-3);}.main-navigation .main-nav ul ul li[class*=\"current-menu-\"] > a{background-color:var(--contrast-3);}.separate-containers .inside-article, .separate-containers .comments-area, .separate-containers .page-header, .one-container .container, .separate-containers .paging-navigation, .inside-page-header{color:var(--contrast);background-color:var(--base);}.inside-article a,.paging-navigation a,.comments-area a,.page-header a{color:var(--accent-2);}.inside-article a:hover,.paging-navigation a:hover,.comments-area a:hover,.page-header a:hover{color:var(--accent-3);}.entry-title a{color:var(--contrast);}.entry-title a:hover{color:var(--contrast-2);}.entry-meta{color:var(--contrast-2);}h1{color:var(--contrast);}h2{color:var(--contrast);}h3{color:var(--contrast);}h4{color:var(--contrast);}h5{color:var(--contrast);}h6{color:var(--contrast);}.sidebar .widget{background-color:var(--base-2);}.footer-widgets{background-color:var(--base-2);}.footer-widgets .widget-title{color:var(--contrast);}.site-info{color:var(--base-2);background-color:var(--contrast);}.site-info a{color:var(--contrast-3);}.site-info a:hover{color:var(--base-2);}.footer-bar .widget_nav_menu .current-menu-item a{color:var(--base-2);}input[type=\"text\"],input[type=\"email\"],input[type=\"url\"],input[type=\"password\"],input[type=\"search\"],input[type=\"tel\"],input[type=\"number\"],textarea,select{color:var(--contrast-2);background-color:var(--base);border-color:var(--contrast-3);}input[type=\"text\"]:focus,input[type=\"email\"]:focus,input[type=\"url\"]:focus,input[type=\"password\"]:focus,input[type=\"search\"]:focus,input[type=\"tel\"]:focus,input[type=\"number\"]:focus,textarea:focus,select:focus{color:var(--contrast-2);background-color:var(--base-2);border-color:var(--contrast-3);}button,html input[type=\"button\"],input[type=\"reset\"],input[type=\"submit\"],a.button,a.wp-block-button__link:not(.has-background){color:var(--base-2);background-color:var(--accent-2);}button:hover,html input[type=\"button\"]:hover,input[type=\"reset\"]:hover,input[type=\"submit\"]:hover,a.button:hover,button:focus,html input[type=\"button\"]:focus,input[type=\"reset\"]:focus,input[type=\"submit\"]:focus,a.button:focus,a.wp-block-button__link:not(.has-background):active,a.wp-block-button__link:not(.has-background):focus,a.wp-block-button__link:not(.has-background):hover{color:var(--base-2);background-color:var(--base-2);}a.generate-back-to-top{background-color:rgba( 0,0,0,0.4 );color:#ffffff;}a.generate-back-to-top:hover,a.generate-back-to-top:focus{background-color:rgba( 0,0,0,0.6 );color:#ffffff;}:root{--gp-search-modal-bg-color:var(--base-2);--gp-search-modal-text-color:var(--contrast);--gp-search-modal-overlay-bg-color:rgba(0,0,0,0.2);}@media (max-width: 860px){.main-navigation .menu-bar-item:hover > a, .main-navigation .menu-bar-item.sfHover > a{background:none;color:var(--base);}}.nav-below-header .main-navigation .inside-navigation.grid-container, .nav-above-header .main-navigation .inside-navigation.grid-container{padding:0px 20px 0px 20px;}.separate-containers .inside-article, .separate-containers .comments-area, .separate-containers .page-header, .separate-containers .paging-navigation, .one-container .site-content, .inside-page-header{padding:100px 40px 100px 40px;}.site-main .wp-block-group__inner-container{padding:100px 40px 100px 40px;}.separate-containers .paging-navigation{padding-top:20px;padding-bottom:20px;}.entry-content .alignwide, body:not(.no-sidebar) .entry-content .alignfull{margin-left:-40px;width:calc(100% + 80px);max-width:calc(100% + 80px);}.one-container.archive .post:not(:last-child):not(.is-loop-template-item), .one-container.blog .post:not(:last-child):not(.is-loop-template-item){padding-bottom:100px;}.rtl .menu-item-has-children .dropdown-menu-toggle{padding-left:20px;}.rtl .main-navigation .main-nav ul li.menu-item-has-children > a{padding-right:20px;}@media (max-width:768px){.separate-containers .inside-article, .separate-containers .comments-area, .separate-containers .page-header, .separate-containers .paging-navigation, .one-container .site-content, .inside-page-header{padding:60px 30px 60px 30px;}.site-main .wp-block-group__inner-container{padding:60px 30px 60px 30px;}.inside-top-bar{padding-right:30px;padding-left:30px;}.inside-header{padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px;}.widget-area .widget{padding-top:30px;padding-right:30px;padding-bottom:30px;padding-left:30px;}.footer-widgets-container{padding-top:30px;padding-right:30px;padding-bottom:30px;padding-left:30px;}.inside-site-info{padding-right:30px;padding-left:30px;}.entry-content .alignwide, body:not(.no-sidebar) .entry-content .alignfull{margin-left:-30px;width:calc(100% + 60px);max-width:calc(100% + 60px);}.one-container .site-main .paging-navigation{margin-bottom:20px;}}","auto"),
("218","generate_dynamic_css_cached_version","3.4.0","auto"),
("223","generate_package_copyright","activated","auto"),
("224","generate_package_backgrounds","activated","auto"),
("225","generateblocks_global_styles","a:1:{i:1224;a:1:{s:7:\"content\";s:397:\"<!-- wp:generateblocks/container {\"uniqueId\":\"351e9067\",\"isDynamic\":true,\"blockVersion\":4,\"spacing\":{\"paddingTop\":\"clamp(1.875rem, 0.536rem + 3.571vw, 3.75rem)\",\"paddingBottom\":\"clamp(1.875rem, 0.536rem + 3.571vw, 3.75rem)\",\"paddingLeft\":\"clamp(1.25rem, 0.179rem + 2.857vw, 2.75rem)\",\"paddingRight\":\"clamp(1.25rem, 0.179rem + 2.857vw, 2.75rem)\"},\"isGlobalStyle\":true,\"globalStyleLabel\":\"Box\"} /-->\";}}","auto"),
("226","generateblocks_global_style_attrs","a:1:{i:1224;a:1:{s:3:\"ids\";a:1:{s:9:\"container\";a:1:{s:8:\"351e9067\";a:29:{s:8:\"uniqueId\";s:8:\"351e9067\";s:9:\"isDynamic\";b:1;s:12:\"blockVersion\";i:4;s:7:\"spacing\";a:4:{s:10:\"paddingTop\";s:44:\"clamp(1.875rem, 0.536rem + 3.571vw, 3.75rem)\";s:13:\"paddingBottom\";s:44:\"clamp(1.875rem, 0.536rem + 3.571vw, 3.75rem)\";s:11:\"paddingLeft\";s:43:\"clamp(1.25rem, 0.179rem + 2.857vw, 2.75rem)\";s:12:\"paddingRight\";s:43:\"clamp(1.25rem, 0.179rem + 2.857vw, 2.75rem)\";}s:13:\"isGlobalStyle\";b:1;s:16:\"globalStyleLabel\";s:3:\"Box\";s:7:\"tagName\";s:3:\"div\";s:16:\"gradientSelector\";s:7:\"element\";s:9:\"bgOptions\";a:7:{s:8:\"selector\";s:7:\"element\";s:7:\"opacity\";i:1;s:7:\"overlay\";b:0;s:8:\"position\";s:13:\"center center\";s:4:\"size\";s:5:\"cover\";s:6:\"repeat\";s:9:\"no-repeat\";s:10:\"attachment\";s:0:\"\";}s:11:\"bgImageSize\";s:4:\"full\";s:14:\"containerWidth\";i:1300;s:14:\"outerContainer\";s:4:\"full\";s:14:\"innerContainer\";s:9:\"contained\";s:13:\"minHeightUnit\";s:2:\"px\";s:19:\"minHeightUnitTablet\";s:2:\"px\";s:19:\"minHeightUnitMobile\";s:2:\"px\";s:13:\"flexBasisUnit\";s:2:\"px\";s:23:\"verticalAlignmentTablet\";s:7:\"inherit\";s:23:\"verticalAlignmentMobile\";s:7:\"inherit\";s:18:\"borderColorOpacity\";i:1;s:22:\"backgroundColorOpacity\";i:1;s:12:\"fontSizeUnit\";s:2:\"px\";s:10:\"marginUnit\";s:2:\"px\";s:11:\"paddingUnit\";s:2:\"px\";s:16:\"borderRadiusUnit\";s:2:\"px\";s:15:\"gpDynamicSource\";s:12:\"current-post\";s:27:\"backgroundColorHoverOpacity\";i:1;s:23:\"borderColorHoverOpacity\";i:1;s:8:\"linkType\";s:11:\"hidden-link\";}}}}}","auto"),
("252","action_scheduler_hybrid_store_demarkation","1259","auto"),
("253","schema-ActionScheduler_StoreSchema","7.0.1723905641","auto"),
("254","schema-ActionScheduler_LoggerSchema","3.0.1723905641","auto"),
("255","rank_math_known_post_types","a:3:{s:4:\"post\";s:4:\"post\";s:4:\"page\";s:4:\"page\";s:10:\"attachment\";s:10:\"attachment\";}","auto"),
("256","rank_math_modules","a:12:{i:0;s:12:\"link-counter\";i:1;s:9:\"analytics\";i:2;s:12:\"seo-analysis\";i:3;s:7:\"sitemap\";i:4;s:12:\"rich-snippet\";i:5;s:11:\"woocommerce\";i:6;s:10:\"buddypress\";i:7;s:7:\"bbpress\";i:8;s:3:\"acf\";i:9;s:11:\"web-stories\";i:10;s:10:\"content-ai\";i:11;s:16:\"instant-indexing\";}","auto"),
("257","rank-math-options-general","a:52:{s:19:\"strip_category_base\";s:3:\"off\";s:24:\"attachment_redirect_urls\";s:2:\"on\";s:27:\"attachment_redirect_default\";s:25:\"https://best-ultrawin.com\";s:23:\"nofollow_external_links\";s:3:\"off\";s:20:\"nofollow_image_links\";s:3:\"off\";s:25:\"new_window_external_links\";s:2:\"on\";s:11:\"add_img_alt\";s:3:\"off\";s:14:\"img_alt_format\";s:11:\" %filename%\";s:13:\"add_img_title\";s:3:\"off\";s:16:\"img_title_format\";s:22:\"%title% %count(title)%\";s:11:\"breadcrumbs\";s:3:\"off\";s:21:\"breadcrumbs_separator\";s:1:\"-\";s:16:\"breadcrumbs_home\";s:2:\"on\";s:22:\"breadcrumbs_home_label\";s:4:\"Home\";s:26:\"breadcrumbs_archive_format\";s:15:\"Archives for %s\";s:25:\"breadcrumbs_search_format\";s:14:\"Results for %s\";s:21:\"breadcrumbs_404_label\";s:25:\"404 Error: page not found\";s:31:\"breadcrumbs_ancestor_categories\";s:3:\"off\";s:21:\"breadcrumbs_blog_page\";s:3:\"off\";s:16:\"404_monitor_mode\";s:6:\"simple\";s:17:\"404_monitor_limit\";i:100;s:35:\"404_monitor_ignore_query_parameters\";s:2:\"on\";s:24:\"redirections_header_code\";s:3:\"301\";s:18:\"redirections_debug\";s:3:\"off\";s:23:\"console_caching_control\";s:2:\"90\";s:21:\"console_email_reports\";b:0;s:23:\"console_email_frequency\";s:7:\"monthly\";s:27:\"link_builder_links_per_page\";s:1:\"7\";s:29:\"link_builder_links_per_target\";s:1:\"1\";s:22:\"wc_remove_product_base\";s:3:\"off\";s:23:\"wc_remove_category_base\";s:3:\"off\";s:31:\"wc_remove_category_parent_slugs\";s:3:\"off\";s:18:\"rss_before_content\";s:0:\"\";s:17:\"rss_after_content\";s:0:\"\";s:19:\"wc_remove_generator\";s:2:\"on\";s:24:\"remove_shop_snippet_data\";s:2:\"on\";s:18:\"frontend_seo_score\";s:3:\"off\";s:29:\"frontend_seo_score_post_types\";a:1:{i:0;s:4:\"post\";}s:27:\"frontend_seo_score_position\";s:3:\"top\";s:10:\"setup_mode\";s:8:\"advanced\";s:21:\"content_ai_post_types\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:18:\"content_ai_country\";s:3:\"all\";s:15:\"content_ai_tone\";s:6:\"Formal\";s:19:\"content_ai_audience\";s:16:\"General Audience\";s:19:\"content_ai_language\";s:10:\"US English\";s:15:\"analytics_stats\";s:2:\"on\";s:15:\"toc_block_title\";s:17:\"Table of Contents\";s:20:\"toc_block_list_style\";s:2:\"ul\";s:14:\"google_updates\";s:2:\"on\";s:13:\"podcast_title\";s:10:\"%sitename%\";s:19:\"podcast_description\";s:10:\"%sitedesc%\";s:29:\"podcast_tipodcast_explicittle\";s:3:\"off\";}","auto"),
("258","rank-math-options-titles","a:111:{s:24:\"noindex_empty_taxonomies\";s:2:\"on\";s:15:\"title_separator\";s:1:\"-\";s:17:\"capitalize_titles\";s:3:\"off\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:19:\"knowledgegraph_type\";s:6:\"person\";s:19:\"knowledgegraph_name\";s:10:\"Site Title\";s:12:\"website_name\";s:10:\"Site Title\";s:19:\"local_business_type\";s:12:\"Organization\";s:20:\"local_address_format\";s:43:\"{address} {locality}, {region} {postalcode}\";s:13:\"opening_hours\";a:7:{i:0;a:2:{s:3:\"day\";s:6:\"Monday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:1;a:2:{s:3:\"day\";s:7:\"Tuesday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:2;a:2:{s:3:\"day\";s:9:\"Wednesday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:3;a:2:{s:3:\"day\";s:8:\"Thursday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:4;a:2:{s:3:\"day\";s:6:\"Friday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:5;a:2:{s:3:\"day\";s:8:\"Saturday\";s:4:\"time\";s:11:\"09:00-17:00\";}i:6;a:2:{s:3:\"day\";s:6:\"Sunday\";s:4:\"time\";s:11:\"09:00-17:00\";}}s:20:\"opening_hours_format\";s:3:\"off\";s:14:\"homepage_title\";s:34:\"%sitename% %page% %sep% %sitedesc%\";s:20:\"homepage_description\";s:0:\"\";s:22:\"homepage_custom_robots\";s:3:\"off\";s:23:\"disable_author_archives\";s:3:\"off\";s:15:\"url_author_base\";s:6:\"author\";s:20:\"author_custom_robots\";s:2:\"on\";s:13:\"author_robots\";a:1:{i:0;s:7:\"noindex\";}s:20:\"author_archive_title\";s:30:\"%name% %sep% %sitename% %page%\";s:19:\"author_add_meta_box\";s:2:\"on\";s:21:\"disable_date_archives\";s:2:\"on\";s:18:\"date_archive_title\";s:30:\"%date% %page% %sep% %sitename%\";s:12:\"search_title\";s:38:\"%search_query% %page% %sep% %sitename%\";s:9:\"404_title\";s:31:\"Page Not Found %sep% %sitename%\";s:19:\"date_archive_robots\";a:1:{i:0;s:7:\"noindex\";}s:14:\"noindex_search\";s:2:\"on\";s:24:\"noindex_archive_subpages\";s:3:\"off\";s:26:\"noindex_password_protected\";s:3:\"off\";s:32:\"pt_download_default_rich_snippet\";s:7:\"product\";s:29:\"author_slack_enhanced_sharing\";s:2:\"on\";s:13:\"pt_post_title\";s:24:\"%title% %sep% %sitename%\";s:19:\"pt_post_description\";s:9:\"%excerpt%\";s:14:\"pt_post_robots\";a:0:{}s:21:\"pt_post_custom_robots\";s:3:\"off\";s:28:\"pt_post_default_rich_snippet\";s:7:\"article\";s:28:\"pt_post_default_article_type\";s:11:\"BlogPosting\";s:28:\"pt_post_default_snippet_name\";s:11:\"%seo_title%\";s:28:\"pt_post_default_snippet_desc\";s:17:\"%seo_description%\";s:30:\"pt_post_slack_enhanced_sharing\";s:2:\"on\";s:17:\"pt_post_ls_use_fk\";s:6:\"titles\";s:20:\"pt_post_add_meta_box\";s:2:\"on\";s:20:\"pt_post_bulk_editing\";s:7:\"editing\";s:24:\"pt_post_link_suggestions\";s:2:\"on\";s:24:\"pt_post_primary_taxonomy\";s:8:\"category\";s:13:\"pt_page_title\";s:24:\"%title% %sep% %sitename%\";s:19:\"pt_page_description\";s:9:\"%excerpt%\";s:14:\"pt_page_robots\";a:0:{}s:21:\"pt_page_custom_robots\";s:3:\"off\";s:28:\"pt_page_default_rich_snippet\";s:7:\"article\";s:28:\"pt_page_default_article_type\";s:7:\"Article\";s:28:\"pt_page_default_snippet_name\";s:11:\"%seo_title%\";s:28:\"pt_page_default_snippet_desc\";s:17:\"%seo_description%\";s:30:\"pt_page_slack_enhanced_sharing\";s:2:\"on\";s:17:\"pt_page_ls_use_fk\";s:6:\"titles\";s:20:\"pt_page_add_meta_box\";s:2:\"on\";s:20:\"pt_page_bulk_editing\";s:7:\"editing\";s:24:\"pt_page_link_suggestions\";s:2:\"on\";s:19:\"pt_attachment_title\";s:24:\"%title% %sep% %sitename%\";s:25:\"pt_attachment_description\";s:9:\"%excerpt%\";s:20:\"pt_attachment_robots\";a:1:{i:0;s:7:\"noindex\";}s:27:\"pt_attachment_custom_robots\";s:2:\"on\";s:34:\"pt_attachment_default_rich_snippet\";s:3:\"off\";s:34:\"pt_attachment_default_article_type\";s:7:\"Article\";s:34:\"pt_attachment_default_snippet_name\";s:11:\"%seo_title%\";s:34:\"pt_attachment_default_snippet_desc\";s:17:\"%seo_description%\";s:36:\"pt_attachment_slack_enhanced_sharing\";s:3:\"off\";s:26:\"pt_attachment_add_meta_box\";s:3:\"off\";s:16:\"pt_product_title\";s:24:\"%title% %sep% %sitename%\";s:22:\"pt_product_description\";s:9:\"%excerpt%\";s:17:\"pt_product_robots\";a:0:{}s:24:\"pt_product_custom_robots\";s:3:\"off\";s:31:\"pt_product_default_rich_snippet\";s:7:\"product\";s:31:\"pt_product_default_article_type\";s:7:\"Article\";s:31:\"pt_product_default_snippet_name\";s:11:\"%seo_title%\";s:31:\"pt_product_default_snippet_desc\";s:17:\"%seo_description%\";s:33:\"pt_product_slack_enhanced_sharing\";s:2:\"on\";s:20:\"pt_product_ls_use_fk\";s:6:\"titles\";s:23:\"pt_product_add_meta_box\";s:2:\"on\";s:23:\"pt_product_bulk_editing\";s:7:\"editing\";s:27:\"pt_product_link_suggestions\";s:2:\"on\";s:27:\"pt_product_primary_taxonomy\";s:11:\"product_cat\";s:18:\"pt_web-story_title\";s:24:\"%title% %sep% %sitename%\";s:24:\"pt_web-story_description\";s:9:\"%excerpt%\";s:19:\"pt_web-story_robots\";a:0:{}s:26:\"pt_web-story_custom_robots\";s:3:\"off\";s:33:\"pt_web-story_default_rich_snippet\";s:7:\"article\";s:33:\"pt_web-story_default_article_type\";s:7:\"Article\";s:33:\"pt_web-story_default_snippet_name\";s:11:\"%seo_title%\";s:33:\"pt_web-story_default_snippet_desc\";s:17:\"%seo_description%\";s:35:\"pt_web-story_slack_enhanced_sharing\";s:3:\"off\";s:25:\"pt_web-story_add_meta_box\";s:3:\"off\";s:18:\"tax_category_title\";s:23:\"%term% %sep% %sitename%\";s:19:\"tax_category_robots\";a:0:{}s:25:\"tax_category_add_meta_box\";s:2:\"on\";s:26:\"tax_category_custom_robots\";s:3:\"off\";s:24:\"tax_category_description\";s:18:\"%term_description%\";s:35:\"tax_category_slack_enhanced_sharing\";s:2:\"on\";s:18:\"tax_post_tag_title\";s:23:\"%term% %sep% %sitename%\";s:19:\"tax_post_tag_robots\";a:1:{i:0;s:7:\"noindex\";}s:25:\"tax_post_tag_add_meta_box\";s:2:\"on\";s:26:\"tax_post_tag_custom_robots\";s:2:\"on\";s:24:\"tax_post_tag_description\";s:18:\"%term_description%\";s:35:\"tax_post_tag_slack_enhanced_sharing\";s:2:\"on\";s:21:\"tax_post_format_title\";s:23:\"%term% %sep% %sitename%\";s:22:\"tax_post_format_robots\";a:1:{i:0;s:7:\"noindex\";}s:28:\"tax_post_format_add_meta_box\";s:2:\"on\";s:29:\"tax_post_format_custom_robots\";s:2:\"on\";s:27:\"tax_post_format_description\";s:18:\"%term_description%\";s:38:\"tax_post_format_slack_enhanced_sharing\";s:2:\"on\";s:31:\"remove_product_cat_snippet_data\";s:2:\"on\";s:31:\"remove_product_tag_snippet_data\";s:2:\"on\";}","auto"),
("259","rank-math-options-sitemap","a:17:{s:14:\"items_per_page\";i:200;s:14:\"include_images\";s:2:\"on\";s:22:\"include_featured_image\";s:3:\"off\";s:13:\"exclude_roles\";a:2:{i:0;s:11:\"contributor\";i:1;s:10:\"subscriber\";}s:12:\"html_sitemap\";s:2:\"on\";s:20:\"html_sitemap_display\";s:9:\"shortcode\";s:17:\"html_sitemap_sort\";s:9:\"published\";s:23:\"html_sitemap_seo_titles\";s:6:\"titles\";s:15:\"authors_sitemap\";s:2:\"on\";s:15:\"pt_post_sitemap\";s:2:\"on\";s:15:\"pt_page_sitemap\";s:2:\"on\";s:21:\"pt_attachment_sitemap\";s:3:\"off\";s:18:\"pt_product_sitemap\";s:2:\"on\";s:20:\"pt_web-story_sitemap\";s:3:\"off\";s:20:\"tax_category_sitemap\";s:2:\"on\";s:20:\"tax_post_tag_sitemap\";s:3:\"off\";s:23:\"tax_post_format_sitemap\";s:3:\"off\";}","auto"),
("260","rank-math-options-instant-indexing","a:2:{s:15:\"bing_post_types\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:16:\"indexnow_api_key\";s:32:\"9f66f3462e594246b98426bafe049bb6\";}","auto"),
("263","rank_math_version","1.0.226","off"),
("264","rank_math_db_version","1","auto"),
("265","rank_math_install_date","1723905642","auto"),
("267","action_scheduler_lock_async-request-runner","67c4f64d2534c3.28604385|1740961417","no"),
("272","rank_math_registration_skip","1","auto"),
("273","rank_math_review_notice_date","1725115246","off"),
("274","rank_math_pro_notice_date","1724769646","off"),
("275","rank_math_review_posts_converted","1","auto"),
("277","rank_math_wizard_completed","1","off"),
("279","rank_math_google_analytic_profile","a:3:{s:7:\"country\";b:0;s:7:\"profile\";b:0;s:19:\"enable_index_status\";b:0;}","auto"),
("280","rank_math_google_analytic_options","a:11:{s:10:\"adsense_id\";b:0;s:10:\"account_id\";b:0;s:11:\"property_id\";b:0;s:7:\"view_id\";b:0;s:14:\"measurement_id\";b:0;s:11:\"stream_name\";b:0;s:7:\"country\";b:0;s:12:\"install_code\";b:0;s:12:\"anonymize_ip\";b:0;s:11:\"local_ga_js\";b:0;s:16:\"exclude_loggedin\";b:0;}","auto"),
("282","rank_math_is_configured","1","off"),
("285","rank_math_viewed_seo_analyer","1","off"),
("289","rank_math_indexnow_log","a:100:{i:0;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723920709;}i:1;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723920847;}i:2;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723920937;}i:3;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723921025;}i:4;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723921143;}i:5;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723921241;}i:6;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723921277;}i:7;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723921630;}i:8;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723921663;}i:9;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723922574;}i:10;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723922644;}i:11;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723922703;}i:12;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723922736;}i:13;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723922912;}i:14;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723923024;}i:15;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723923064;}i:16;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723985491;}i:17;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723985509;}i:18;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723986664;}i:19;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723986679;}i:20;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723986911;}i:21;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723987632;}i:22;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723988006;}i:23;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723988041;}i:24;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723988527;}i:25;a:5:{s:3:\"url\";s:38:\"https://best-ultrawin.com/hello-world/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723994997;}i:26;a:5:{s:3:\"url\";s:38:\"https://best-ultrawin.com/style-guide/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723995027;}i:27;a:5:{s:3:\"url\";s:38:\"https://best-ultrawin.com/sample-page/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723995039;}i:28;a:5:{s:3:\"url\";s:38:\"https://best-ultrawin.com/instructors/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723995096;}i:29;a:5:{s:3:\"url\";s:34:\"https://best-ultrawin.com/credits/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723995126;}i:30;a:5:{s:3:\"url\";s:32:\"https://best-ultrawin.com/about/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723995148;}i:31;a:5:{s:3:\"url\";s:37:\"https://best-ultrawin.com/contact-us/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723995148;}i:32;a:5:{s:3:\"url\";s:34:\"https://best-ultrawin.com/courses/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723995149;}i:33;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723995844;}i:34;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723995986;}i:35;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1723998600;}i:36;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724005800;}i:37;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724025787;}i:38;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724026492;}i:39;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724026531;}i:40;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724026551;}i:41;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724026563;}i:42;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724026580;}i:43;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724026587;}i:44;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724026623;}i:45;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724026761;}i:46;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724026793;}i:47;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724026808;}i:48;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724026820;}i:49;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724026831;}i:50;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724026843;}i:51;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724027047;}i:52;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724027129;}i:53;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724027139;}i:54;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724027198;}i:55;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724027221;}i:56;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724027267;}i:57;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724027292;}i:58;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724027583;}i:59;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724027598;}i:60;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724027734;}i:61;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724027890;}i:62;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724027900;}i:63;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724028328;}i:64;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:403;s:17:\"manual_submission\";b:0;s:7:\"message\";s:9:\"Forbidden\";s:4:\"time\";i:1724028357;}i:65;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:202;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724029103;}i:66;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724029195;}i:67;a:5:{s:3:\"url\";s:41:\"https://best-ultrawin.com/privacy-policy/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724243448;}i:68;a:5:{s:3:\"url\";s:41:\"https://best-ultrawin.com/privacy-policy/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724243545;}i:69;a:5:{s:3:\"url\";s:41:\"https://best-ultrawin.com/privacy-policy/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724243574;}i:70;a:5:{s:3:\"url\";s:41:\"https://best-ultrawin.com/privacy-policy/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724243624;}i:71;a:5:{s:3:\"url\";s:37:\"https://best-ultrawin.com/contact-us/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724243802;}i:72;a:5:{s:3:\"url\";s:47:\"https://best-ultrawin.com/terms-and-conditions/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724244029;}i:73;a:5:{s:3:\"url\";s:47:\"https://best-ultrawin.com/terms-and-conditions/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724244181;}i:74;a:5:{s:3:\"url\";s:32:\"https://best-ultrawin.com/about/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724244287;}i:75;a:5:{s:3:\"url\";s:34:\"https://best-ultrawin.com/support/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724244392;}i:76;a:5:{s:3:\"url\";s:45:\"https://best-ultrawin.com/responsible-gaming/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724244620;}i:77;a:5:{s:3:\"url\";s:34:\"https://best-ultrawin.com/support/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724244801;}i:78;a:5:{s:3:\"url\";s:37:\"https://best-ultrawin.com/contact-us/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724244944;}i:79;a:5:{s:3:\"url\";s:37:\"https://best-ultrawin.com/contact-us/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724244973;}i:80;a:5:{s:3:\"url\";s:32:\"https://best-ultrawin.com/about/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724245205;}i:81;a:5:{s:3:\"url\";s:37:\"https://best-ultrawin.com/contact-us/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724245209;}i:82;a:5:{s:3:\"url\";s:41:\"https://best-ultrawin.com/privacy-policy/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724245217;}i:83;a:5:{s:3:\"url\";s:45:\"https://best-ultrawin.com/responsible-gaming/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724245223;}i:84;a:5:{s:3:\"url\";s:47:\"https://best-ultrawin.com/terms-and-conditions/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724245243;}i:85;a:5:{s:3:\"url\";s:32:\"https://best-ultrawin.com/about/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724245306;}i:86;a:5:{s:3:\"url\";s:37:\"https://best-ultrawin.com/contact-us/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724245319;}i:87;a:5:{s:3:\"url\";s:41:\"https://best-ultrawin.com/privacy-policy/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724245334;}i:88;a:5:{s:3:\"url\";s:45:\"https://best-ultrawin.com/responsible-gaming/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724245348;}i:89;a:5:{s:3:\"url\";s:34:\"https://best-ultrawin.com/support/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724245358;}i:90;a:5:{s:3:\"url\";s:47:\"https://best-ultrawin.com/terms-and-conditions/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724245374;}i:91;a:5:{s:3:\"url\";s:32:\"https://best-ultrawin.com/about/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724245412;}i:92;a:5:{s:3:\"url\";s:37:\"https://best-ultrawin.com/contact-us/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724245484;}i:93;a:5:{s:3:\"url\";s:41:\"https://best-ultrawin.com/privacy-policy/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724245511;}i:94;a:5:{s:3:\"url\";s:45:\"https://best-ultrawin.com/responsible-gaming/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724245537;}i:95;a:5:{s:3:\"url\";s:34:\"https://best-ultrawin.com/support/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724245570;}i:96;a:5:{s:3:\"url\";s:47:\"https://best-ultrawin.com/terms-and-conditions/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724245606;}i:97;a:5:{s:3:\"url\";s:39:\"https://best-ultrawin.com/app-download/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724245685;}i:98;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724245796;}i:99;a:5:{s:3:\"url\";s:26:\"https://best-ultrawin.com/\";s:6:\"status\";i:200;s:17:\"manual_submission\";b:0;s:7:\"message\";s:2:\"OK\";s:4:\"time\";i:1724264420;}}","off"),
("291","rank_math_content_ai_viewed","1","off"),
("459","site_logo","1228","auto"),
("676","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","off"),
("1039","ai1wm_backups_path","/home/best-ultrawin/htdocs/best-ultrawin.com/wp-content/ai1wm-backups","auto"),
("1041","swift_performance_plugin_organizer","a:0:{}","auto"),
("1042","jetpack_active_modules","a:0:{}","auto"),
("1054","ai1wm_updater","a:2:{s:40:\"all-in-one-wp-migration-gdrive-extension\";a:13:{s:4:\"name\";s:22:\"Google Drive Extension\";s:4:\"slug\";s:22:\"google-drive-extension\";s:8:\"homepage\";s:54:\"https://servmask.com/extensions/google-drive-extension\";s:13:\"download_link\";s:29:\"https://servmask.com/purchase\";s:7:\"version\";s:4:\"2.89\";s:6:\"author\";s:8:\"ServMask\";s:15:\"author_homepage\";s:20:\"https://servmask.com\";s:8:\"sections\";a:1:{s:11:\"description\";s:394:\"<ul class=\"description\"><li>Export and import to and from Google Drive</li><li>Fully compatible with Google One</li><li>Use on any number of websites that you own</li><li>Backup scheduler with hourly, daily and weekly options</li><li>Reset Hub: Reset tools for efficient site management new</li><li>Unlimited Extension included</li><li>WP CLI commands included</li><li>Premium support</li></ul>\";}s:7:\"banners\";a:2:{s:3:\"low\";s:68:\"https://servmask.com/img/products/google-drive-extension-772x250.png\";s:4:\"high\";s:69:\"https://servmask.com/img/products/google-drive-extension-1544x500.png\";}s:5:\"icons\";a:3:{s:2:\"1x\";s:68:\"https://servmask.com/img/products/google-drive-extension-128x128.png\";s:2:\"2x\";s:68:\"https://servmask.com/img/products/google-drive-extension-256x256.png\";s:7:\"default\";s:68:\"https://servmask.com/img/products/google-drive-extension-256x256.png\";}s:6:\"rating\";i:99;s:11:\"num_ratings\";i:509;s:10:\"downloaded\";i:50188;}s:43:\"all-in-one-wp-migration-unlimited-extension\";a:13:{s:4:\"name\";s:19:\"Unlimited Extension\";s:4:\"slug\";s:19:\"unlimited-extension\";s:8:\"homepage\";s:49:\"https://servmask.com/products/unlimited-extension\";s:13:\"download_link\";s:29:\"https://servmask.com/purchase\";s:7:\"version\";s:4:\"2.65\";s:6:\"author\";s:8:\"ServMask\";s:15:\"author_homepage\";s:20:\"https://servmask.com\";s:8:\"sections\";a:1:{s:11:\"description\";s:266:\"<ul class=\"description\"><li>Remove upload limits</li><li>Use on any number of websites that you own</li><li>Restore backup from server</li><li>Reset Hub: Reset tools for efficient site management new</li><li>WP CLI commands included</li><li>Premium support</li></ul>\";}s:7:\"banners\";a:2:{s:3:\"low\";s:119:\"https://d1zsuv05404qm1.cloudfront.net/33301824-2c87-4049-bef5-8fd130d06a3a/img/products/unlimited-extension-772x250.png\";s:4:\"high\";s:120:\"https://d1zsuv05404qm1.cloudfront.net/33301824-2c87-4049-bef5-8fd130d06a3a/img/products/unlimited-extension-1544x500.png\";}s:5:\"icons\";a:3:{s:2:\"1x\";s:119:\"https://d1zsuv05404qm1.cloudfront.net/33301824-2c87-4049-bef5-8fd130d06a3a/img/products/unlimited-extension-128x128.png\";s:2:\"2x\";s:119:\"https://d1zsuv05404qm1.cloudfront.net/33301824-2c87-4049-bef5-8fd130d06a3a/img/products/unlimited-extension-256x256.png\";s:7:\"default\";s:119:\"https://d1zsuv05404qm1.cloudfront.net/33301824-2c87-4049-bef5-8fd130d06a3a/img/products/unlimited-extension-256x256.png\";}s:6:\"rating\";i:99;s:11:\"num_ratings\";i:509;s:10:\"downloaded\";i:50188;}}","auto"),
("2136","seraph_accel_RmtCfg","{\"data\":{\"Info\":{\"LastVersion\":\"2.27.2\"},\"Links\":{\"UrlProductDownload\":\"https:\\/\\/www.s-sols.com\\/data\\/products\\/wordpress\\/accelerator\\/Accelerator.zip\",\"UrlProductInfo\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/products\\/wordpress\\/accelerator?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"UrlProductBuy\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/products\\/wordpress\\/accelerator?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#offer\",\"UrlProductFeatures\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/products\\/wordpress\\/accelerator?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#features\",\"UrlUserPurchases\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/myaccount?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"UrlEula\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/wordpress-plugins-eula-2?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"UrlRatingAboutUs\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/about?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"UrlMorePlugins\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/pcats\\/wordpress?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"UrlMain\":\"https:\\/\\/www.s-sols.com{SiteLang}?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"UrlSupport\":\"mailto:support@s-sols.com\",\"UrlProductDocs\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/getting-started-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"UrlProductReqs\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/getting-started-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#reqs\",\"UrlProductSupport\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/support?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"UrlProductLastChanges\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/news\\/wordpress\\/accelerator\\/new-ver-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"UrlHostingInfo\":\"https:\\/\\/hosting.s-sols.com\\/\",\"UrlRateIt\":\"https:\\/\\/wordpress.org\\/support\\/plugin\\/seraphinite-accelerator\\/reviews?rate=5#new-post\",\"FrontendBannerUrl\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/products\\/wordpress\\/accelerator?utm_source=usersite&utm_medium=banner&utm_campaign=free_lim_ver&utm_term=accel\"},\"Prms\":{\"UrlLicMgr\":\"https:\\/\\/www.s-sols.com\\/api\\/licmgr\",\"UrlSpecialApi\":\"https:\\/\\/www.s-sols.com\\/api\\/special\",\"FullProductDownloadPath\":\"Accelerator.zip\",\"RateItSpanTime\":2880,\"RateItSpanTimeNext\":10080,\"BinDownloadPath\":\"https:\\/\\/www.s-sols.com\\/data\\/bin\",\"HostingBannerShow-Base\":true,\"HostingBannerShow-Ext\":true,\"HostingBannerShow-Full\":true,\"WarningChangeVersions\":[\"1.8\",\"2.0\",\"2.3\",\"2.5\",\"2.5.1\",\"2.8\"],\"LocaleToSiteLang\":{\"ru\":\"\\/ru\"}},\"Help\":{\"Manage_Status\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/status-and-operations-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#status\",\"Manage_Stat\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/status-and-operations-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#stat\",\"Manage_Operate\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/status-and-operations-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#operate\",\"Manage_Queue\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/status-and-operations-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#queue\",\"Manage_HtmlChecker\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/status-and-operations-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#html_checker\",\"Settings_Cache\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-cache-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"Settings_Cache_Gen\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-cache-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#general\",\"Settings_Cache_Encodings\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-cache-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#encodings\",\"Settings_Cache_Compression\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-cache-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#compression\",\"Settings_Cache_Sep\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-cache-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#separation\",\"Settings_Cache_Headers\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-cache-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#headers\",\"Settings_Cache_Revalidate\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-revalidation-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"Settings_Cache_Revalidate_Cmn\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-revalidation-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#general\",\"Settings_Cache_Revalidate_UpdPost\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-revalidation-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#posts\",\"Settings_Cache_Revalidate_UpdGlobs\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-revalidation-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#globs\",\"Settings_Cache_Revalidate_UpdAll\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-revalidation-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#all\",\"Settings_Cache_Revalidate_Proc\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-revalidation-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#proc\",\"Settings_Cache_Revalidate_Intervals\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-revalidation-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#int\",\"Settings_Cache_Revalidate_Fresh\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-revalidation-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#fresh\",\"Settings_Cache_Revalidate_Sche\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-revalidation-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#sche\",\"Settings_CacheBrowser\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-browser-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"Settings_CacheBrowser_Gen\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-browser-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#general\",\"Settings_CacheData\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-requests-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"Settings_CacheData_Enable\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-requests-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#enable\",\"Settings_CacheData_Pattern\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-requests-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#pattern\",\"Settings_CacheData_Revalidation\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-requests-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#revalidation\",\"Settings_CacheObj\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-objects-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"Settings_CacheObj_Gen\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-objects-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#general\",\"Settings_CacheObj_Groups\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-objects-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#groups\",\"Settings_Cache_Srv\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-server-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"Settings_Cache_Srv_Gen\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-server-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#general\",\"Settings_Cache_Srv_Nginx\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-server-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#nginx\",\"Settings_Exclusions\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-exclusions-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"Settings_Exclusions_Paths\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-exclusions-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#paths\",\"Settings_Exclusions_Args\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-exclusions-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#arguments\",\"Settings_Exclusions_Agents\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-exclusions-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#agents\",\"Settings_Exclusions_Cookies\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-exclusions-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#cookies\",\"Settings_Exclusions_Conts\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-exclusions-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#conts\",\"Settings_Views\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-views-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"Settings_Views_Gen\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-views-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#general\",\"Settings_Views_Devices\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-views-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#devices\",\"Settings_Views_Devices_Item_Enabled\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-views-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#devices_enable\",\"Settings_Views_Devices_Item_Name\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-views-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#devices_name\",\"Settings_Views_Devices_Item_Agents\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-views-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#devices_agents\",\"Settings_Views_Compat\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-views-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#compat\",\"Settings_Views_Compat_Item_Enabled\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-views-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#compat_enable\",\"Settings_Views_Compat_Item_Agents\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-views-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#compat_agents\",\"Settings_Views_Grp\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-views-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#parameters\",\"Settings_Ctx\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-users-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"Settings_Ctx_Gen\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-users-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#cache\",\"Settings_Ctx_Revalidate\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-users-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#revalidation\",\"Settings_Ctx_Grp\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-users-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#dep_grp\",\"Settings_Ctx_Grp_Enable\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-users-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#dep_grp_enable\",\"Settings_Ctx_Grp_Name\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-users-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#dep_grp_name\",\"Settings_Ctx_Grp_Cookies\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-users-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#dep_grp_cookies\",\"Settings_Ctx_Grp_Args\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-users-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#dep_grp_args\",\"Settings_Ctx_Grp_Tbl\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-users-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#dep_grp_tbl\",\"Settings_Ctx_Grp_Tbl_Name\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-users-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#dep_grp_tbl_name\",\"Settings_Ctx_Grp_Tbl_Col\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-users-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#dep_grp_tbl_col\",\"Settings_Ctx_Grp_Tbl_NameRel\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-users-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#dep_grp_tbl_namerel\",\"Settings_Ctx_Grp_Tbl_ColRel\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-users-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#dep_grp_tbl_colrel\",\"Settings_Ctx_Grp_Tbl_ColRelLink\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-users-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#dep_grp_tbl_colrellink\",\"Settings_Ctx_Grp_Tbl_Cond\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-users-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#dep_grp_tbl_cond\",\"Settings_Html\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-html-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"Settings_Html_Gen\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-html-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#general\",\"Settings_Html_Fix\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-html-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#fix\",\"Settings_Html_Cln\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-html-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#cln\",\"Settings_Html_Rpl\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-html-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#repl\",\"Settings_Html_Lazy\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-html-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#lazy\",\"Settings_Html_Fresh\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-html-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#fresh\",\"Settings_Images_CacheExt\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-html-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#cache_ext\",\"Settings_Images\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-images-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"Settings_Images_Gen\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-images-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#general\",\"Settings_Images_Compr\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-images-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#compr\",\"Settings_Images_Adapt\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-images-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#adapt\",\"Settings_Images_Lazy\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-images-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#lazy_load\",\"Settings_Frames\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-frames-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"Settings_Frames_Lazy\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-frames-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#lazy_load\",\"Settings_Frames_ContParts\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-frames-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#cp\",\"Settings_Frames_Excl\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-frames-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#excl\",\"Settings_Scripts\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-scripts-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"Settings_Scripts_Gen\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-scripts-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#general\",\"Settings_Scripts_Group\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-scripts-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#group\",\"Settings_Scripts_Interact\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-scripts-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#interact\",\"Settings_Scripts_Min\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-scripts-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#minify\",\"Settings_Scripts_CritSpecial\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-scripts-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#critspecial\",\"Settings_Scripts_NotCrit\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-scripts-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#non_critical\",\"Settings_Scripts_Special\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-scripts-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#special\",\"Settings_Scripts_Skip\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-scripts-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#skip\",\"Settings_Scripts_Other\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-scripts-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#other\",\"Settings_Styles\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-styles-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"Settings_Styles_Gen\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-styles-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#general\",\"Settings_Styles_Fonts\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-styles-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#fonts\",\"Settings_NotCrit\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-styles-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#not_critical\",\"Settings_Styles_Skip\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-styles-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#skip\",\"Settings_Styles_Custom\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-styles-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#custom\",\"Settings_Cdn\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-cdn-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"Settings_Cdn_Enabled\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-cdn-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#enabled\",\"Settings_Cdn_Addr\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-cdn-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#address\",\"Settings_Cdn_Types\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-cdn-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#types\",\"Settings_Cdn_Incls\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-cdn-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#includes\",\"Settings_Cdn_Excls\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-cdn-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#excludes\",\"Settings_Group\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-groups-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"Settings_Group_Enabled\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-groups-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#enable\",\"Settings_Group_Scope\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-groups-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#scope\",\"Settings_Group_UrisIncl\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-groups-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#uris_incl\",\"Settings_Group_ArgsIncl\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-groups-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#args_incl\",\"Settings_Group_Patterns\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-groups-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#patterns\",\"Settings_Group_Views\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-groups-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#views\",\"Settings_Group_Settings\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-groups-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#settings\",\"Settings_Group_Learn\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-groups-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#learn\",\"Settings_Advanced\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-advanced-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel\",\"Settings_Advanced_Gen\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-advanced-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#general\",\"Settings_Advanced_ExtCron\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-advanced-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#ext_cron\",\"Settings_Advanced_Cron\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-advanced-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#cron\",\"Settings_Advanced_Bots\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-advanced-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#bots\",\"Settings_Advanced_Debug\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-advanced-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#debug\",\"Settings_Advanced_Test\":\"https:\\/\\/www.s-sols.com{SiteLang}\\/docs\\/wordpress\\/accelerator\\/settings-advanced-accel?utm_source=product&utm_medium=ui&utm_campaign=inproduct_links&utm_term=accel#test\",\"SettingsWiz_ExtCronSetup\":\"https:\\/\\/www.s-sols.com\\/docs\\/wordpress\\/accelerator\\/getting-started-accel\\/wordpress\\/external-cron-setup-wp\",\"\":\"\"}},\"updTime\":1740960932,\"v\":1,\"vPrev\":0,\"mdfTime\":1740826751,\"plgVer\":\"2.22.3\",\"plgPk\":\"Full\"}","auto");

INSERT IGNORE INTO `wp_options` VALUES 
("2137","seraph_accel_State","{\"v\":1,\"vPrev\":0,\"eulaAcceptedVer\":1,\"firstUseTimeStamp\":1724250985,\"rateItRemind\":28740396}","auto"),
("2138","seraph_accel_Sett","{\"full\":true,\"cache\":{\"enable\":true,\"normAgent\":true,\"chkNotMdfSince\":true,\"cntLen\":true,\"srv\":false,\"srvClr\":false,\"nginx\":{\"fastCgiDir\":\"\",\"fastCgiLevels\":\"1:2\"},\"sucuri\":{\"apiKey\":\"\",\"apiSecret\":\"\"},\"cron\":true,\"forceAdvCache\":false,\"lazyInv\":true,\"lazyInvInitTmp\":true,\"lazyInvForcedTmp\":false,\"lazyInvTmp\":false,\"updPost\":true,\"updPostDelay\":0,\"updPostOp\":0,\"updPostDeps\":[\"@home\",\"@post@{ID}:@pageNums\",\"@post@{ID}:@commentPageNums\",\"@postsBase@{post_type}:<|@pageNums|@commentPageNums>\",\"@termsOfClass@categories@{post_type}@{ID}:<|@pageNums|@commentPageNums>\"],\"updPostMeta\":false,\"updPostMetaExcl\":[\"@^\\\\d+$@\",\"@^_edit_lock$@\",\"@^classic-editor-remember$@\",\"@post_views_@\",\"@^import_started_at@\"],\"updTerms\":false,\"updTermsOp\":2,\"updTermsDeps\":[\"category\",\"product_cat\",\"course_cat\"],\"updAllDeps\":[\"@home\",\"@postsViewable:<|@pageNums|@commentPageNums>\"],\"updSche\":{\"def\":{\"enable\":false,\"op\":0,\"prior\":7,\"period\":24,\"periodN\":1,\"times\":[{\"m\":0,\"tm\":0}],\"deps\":[\"@home\"]}},\"updByTimeout\":true,\"maxProc\":2,\"procInterval\":0,\"procIntervalShort\":0,\"procMemLim\":2048,\"procTmLim\":570,\"procWorkInt\":0,\"procPauseInt\":0,\"autoProc\":true,\"timeout\":1440,\"timeoutFr\":60,\"timeoutCln\":262080,\"ctxTimeoutCln\":21600,\"autoClnPeriod\":1440,\"useTimeoutClnForWpNonce\":true,\"encs\":[\"\",\"gzip\",\"deflate\",\"compress\"],\"dataCompr\":[\"deflate\"],\"dataLvl\":[],\"useDataComprAssets\":true,\"chunks\":{\"enable\":true,\"js\":true,\"css\":true,\"seps\":[{\"enable\":true,\"sel\":\".\\/\\/header[1]\",\"side\":3},{\"enable\":true,\"sel\":\".\\/\\/footer[last()]\",\"side\":3},{\"enable\":true,\"sel\":\".\\/\\/div[contains(concat(\\\" \\\", normalize-space(@class), \\\" \\\"), \\\" header \\\")][1]\",\"side\":3},{\"enable\":true,\"sel\":\".\\/\\/div[contains(concat(\\\" \\\", normalize-space(@class), \\\" \\\"), \\\" footer \\\")][last()]\",\"side\":3},{\"enable\":true,\"sel\":\".\\/\\/div[@id=\\\"comments\\\" and contains(concat(\\\" \\\", normalize-space(@class), \\\" \\\"), \\\" comments-area \\\")]\",\"side\":3},{\"enable\":true,\"sel\":\".\\/\\/section[@id=\\\"comment-wrap\\\"]\",\"side\":3},{\"enable\":true,\"sel\":\".\\/\\/div[@data-elementor-type=\\\"header\\\"]\",\"side\":3},{\"enable\":true,\"sel\":\".\\/\\/div[@data-elementor-type=\\\"footer\\\"]\",\"side\":3},{\"enable\":true,\"sel\":\".\\/\\/div[contains(concat(\\\" \\\", normalize-space(@class), \\\" \\\"), \\\" tdc-header-wrap \\\")]\",\"side\":3},{\"enable\":true,\"sel\":\".\\/\\/div[contains(concat(\\\" \\\", normalize-space(@class), \\\" \\\"), \\\" tdc-footer-wrap \\\")]\",\"side\":3},{\"enable\":true,\"sel\":\".\\/\\/div[contains(concat(\\\" \\\", normalize-space(@class), \\\" \\\"), \\\" td-header-template-wrap \\\")]\",\"side\":3},{\"enable\":true,\"sel\":\".\\/\\/div[contains(concat(\\\" \\\", normalize-space(@class), \\\" \\\"), \\\" td-footer-template-wrap \\\")]\",\"side\":3},{\"enable\":true,\"sel\":\".\\/\\/div[contains(concat(\\\" \\\", normalize-space(@class), \\\" \\\"), \\\" fusion-tb-header \\\")]\",\"side\":3},{\"enable\":true,\"sel\":\".\\/\\/div[contains(concat(\\\" \\\", normalize-space(@class), \\\" \\\"), \\\" fusion-tb-footer \\\")]\",\"side\":3},{\"enable\":true,\"sel\":\".\\/\\/*[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" et_pb_comments_module \\\")]\",\"side\":3}]},\"urisExcl\":[\"\\/checkout\\/\",\"@.*sitemap\\\\.xsl$@\"],\"exclAgents\":[\"printfriendly\"],\"exclCookies\":[],\"exclArgsAll\":true,\"exclArgs\":[\"aiosp_sitemap_path\",\"aiosp_sitemap_page\",\"xml_sitemap\",\"seopress_sitemap\",\"seopress_news\",\"seopress_video\",\"seopress_cpt\",\"seopress_paged\",\"sitemap\",\"sitemap_n\"],\"skipArgsAll\":false,\"skipArgs\":[\"redirect_to\",\"utm_source\",\"utm_medium\",\"utm_campaign\",\"utm_content\",\"utm_term\",\"fbclid\",\"story_fbid\",\"mibextid\",\"gclid\",\"wbraid\",\"gbraid\",\"_ga\",\"yclid\"],\"exclConts\":[],\"hdrs\":[\"@^Set-Cookie\\\\s*:\\\\s*wordpress_test_cookie\\\\s*=@i\",\"@^X-XSS-Protection\\\\s*:@i\",\"@^X-Frame-Options\\\\s*:@i\",\"@^Content-Security-Policy\\\\s*:@i\",\"@^Referrer-Policy\\\\s*:@i\",\"@^Feature-Policy\\\\s*:@i\",\"@^Permissions-Policy\\\\s*:@i\"],\"views\":true,\"viewsDeviceGrps\":[{\"enable\":false,\"name\":\"\",\"id\":\"mobilehighres\",\"agents\":[\"android\",\"bada\",\"incognito\",\"maemo\",\"mobi\",\"opera mini\",\"s8000\",\"series60\",\"ucbrowser\",\"ucweb\",\"webmate\",\"webos\"]},{\"enable\":false,\"name\":\"\",\"id\":\"mobilelowres\",\"agents\":[\"240x320\",\"2.0 mmp\",\"\\\\bppc\\\\b\",\"alcatel\",\"amoi\",\"asus\",\"au-mic\",\"audiovox\",\"avantgo\",\"benq\",\"bird\",\"blackberry\",\"blazer\",\"cdm\",\"cellphone\",\"danger\",\"ddipocket\",\"docomo\",\"dopod\",\"elaine\\/3.0\",\"ericsson\",\"eudoraweb\",\"fly\",\"haier\",\"hiptop\",\"hp.ipaq\",\"htc\",\"huawei\",\"i-mobile\",\"iemobile\",\"iemobile\\/7\",\"iemobile\\/9\",\"j-phone\",\"kddi\",\"konka\",\"kwc\",\"kyocera\\/wx310k\",\"lenovo\",\"lg\",\"lg\\/u990\",\"lge vx\",\"midp\",\"midp-2.0\",\"mmef20\",\"mmp\",\"mobilephone\",\"mot-v\",\"motorola\",\"msie 10.0\",\"netfront\",\"newgen\",\"newt\",\"nintendo ds\",\"nintendo wii\",\"nitro\",\"nokia\",\"novarra\",\"o2\",\"openweb\",\"opera mobi\",\"opera.mobi\",\"p160u\",\"palm\",\"panasonic\",\"pantech\",\"pdxgw\",\"pg\",\"philips\",\"phone\",\"playbook\",\"playstation portable\",\"portalmmm\",\"proxinet\",\"psp\",\"qtek\",\"sagem\",\"samsung\",\"sanyo\",\"sch\",\"sch-i800\",\"sec\",\"sendo\",\"sgh\",\"sharp\",\"sharp-tq-gx10\",\"small\",\"smartphone\",\"softbank\",\"sonyericsson\",\"sph\",\"symbian\",\"symbian os\",\"symbianos\",\"toshiba\",\"treo\",\"ts21i-10\",\"up.browser\",\"up.link\",\"uts\",\"vertu\",\"vodafone\",\"wap\",\"willcome\",\"windows ce\",\"windows.ce\",\"winwap\",\"xda\",\"xoom\",\"zte\"]},{\"enable\":false,\"name\":\"\",\"id\":\"mobile\",\"agents\":[\"mobile\",\"android\",\"silk\\/\",\"blackberry\",\"opera mini\",\"opera mobi\"]}],\"viewsGeo\":{\"enable\":false},\"viewsCompatGrps\":[{\"enable\":true,\"id\":\"c\",\"agents\":[\"@\\\\Wmsie \\\\d+\\\\.\\\\d+\\\\W@\",\"@\\\\Wtrident\\/\\\\d+\\\\.\\\\d+\\\\W@\",\"@\\\\Wyandexmetrika\\/\\\\d+\\\\.\\\\d+\\\\W@\",\"@\\\\Wgoogleadsenseinfeed\\\\W@\",\"!@\\\\Wchrome\\/\\\\d+\\\\W@ & @(?:\\\\W|^)safari\\/([\\\\d\\\\.]+)(?:\\\\W|$)@ < 603.3.8\",\"@\\\\sMac\\\\sOS\\\\sX\\\\s([\\\\d\\\\_]+)@i < 10.12.6\"]},{\"enable\":false,\"id\":\"cm\",\"agents\":[\"@\\\\Wbingbot\\/\\\\d+\\\\.\\\\d+\\\\W@\"]}],\"viewsGrps\":[{\"enable\":true,\"name\":\"AMP\",\"cookies\":[],\"args\":[\"amp\"]},{\"enable\":true,\"name\":\"WPML\",\"cookies\":[\"wp_wcml_currency\",\"wcml_client_currency\"],\"args\":[\"lang\"]},{\"enable\":true,\"name\":\"WPtouch\",\"cookies\":[\"wptouch-pro-cache-state\",\"wptouch-pro-view\"],\"args\":[]},{\"enable\":true,\"name\":\"VillaTheme WooCommerce Multi Currency\",\"cookies\":[\"wmc_current_currency\"]},{\"enable\":true,\"name\":\"YITH Multi Currency Switcher for WooCommerce\",\"cookies\":[\"yith_wcmcs_currency\"]},{\"enable\":true,\"name\":\"GDPR Cookie Consent\",\"cookies\":[\"viewed_cookie_policy\",\"cli_user_preference\"]},{\"enable\":true,\"name\":\"Pixelmate Cookie Banner\",\"cookies\":[\"pixelmate\"]},{\"enable\":true,\"name\":\"OneCom Cookie Banner\",\"cookies\":[\"onecom_cookie_consent\"]},{\"enable\":true,\"name\":\"us_cookie_notice\",\"cookies\":[\"us_cookie_notice_accepted\"]}],\"ctx\":false,\"ctxSkip\":false,\"ctxSessSep\":true,\"ctxContPr\":true,\"ctxCliRefresh\":true,\"ctxGrps\":{\"common\":{\"enable\":true,\"name\":\"Common\",\"cookies\":[\"wp-postpass_\",\"comment_author_\",\"sc_commented_posts\"],\"args\":[\"key\"],\"tables\":[{\"name\":\"%PREFIX%users\",\"col\":\"ID\"},{\"name\":\"%PREFIX%usermeta\",\"col\":\"user_id\"}]},\"wordpress-social-login\":{\"enable\":true,\"name\":\"Social Login\",\"args\":[\"action\"]},\"theme_woodmart\":{\"enable\":true,\"name\":\"WoodMart Theme\",\"cookies\":[\"woodmart_wishlist_products\"]},\"jet-cw\":{\"enable\":true,\"name\":\"Jet\",\"cookies\":[\"jet-wish-list\",\"jet-compare-list\"]},\"woocommerce\":{\"enable\":true,\"name\":\"WooCommerce\",\"cookies\":[\"woocommerce_cart_hash\",\"wp_woocommerce_session_\",\"yith_wcwl_session_\"],\"args\":[\"add-to-cart\",\"remove_item\",\"removed_item\",\"undo_item\",\"update_cart\",\"proceed\",\"order_again\",\"apply_coupon\",\"remove_coupon\"],\"tables\":[{\"name\":\"%PREFIX%woocommerce_sessions\",\"col\":\"session_key\"},{\"name\":\"%PREFIX%posts\",\"col\":\"ID\",\"nameRel\":\"%PREFIX%postmeta\",\"colRel\":\"meta_value\",\"colRelLink\":\"post_id\",\"condRel\":{\"meta_key\":[\"_customer_user\"]}},{\"name\":\"%PREFIX%postmeta\",\"col\":\"post_id\",\"nameRel\":\"%PREFIX%postmeta\",\"colRel\":\"meta_value\",\"colRelLink\":\"post_id\",\"condRel\":{\"meta_key\":[\"_customer_user\"]}}]},\"easy-digital-downloads\":{\"enable\":true,\"name\":\"Easy Digital Downloads\",\"cookies\":[\"@^edd_items_in_cart$@ > 0 & @^PHPSESSID$@i\"]},\"lifterlms\":{\"enable\":true,\"name\":\"LMS by LifterLMS\",\"tables\":[{\"name\":\"%PREFIX%lifterlms_sessions\",\"col\":\"session_key\"},{\"name\":\"%PREFIX%posts\",\"col\":\"ID\",\"nameRel\":\"%PREFIX%lifterlms_user_postmeta\",\"colRel\":\"user_id\",\"colRelLink\":\"post_id\"},{\"name\":\"%PREFIX%postmeta\",\"col\":\"post_id\",\"nameRel\":\"%PREFIX%lifterlms_user_postmeta\",\"colRel\":\"user_id\",\"colRelLink\":\"post_id\"}]},\"wp-recall\":{\"enable\":true,\"name\":\"WP-Recall\",\"tables\":[{\"name\":\"%PREFIX%rcl_bookmarks\",\"col\":\"user_id\"},{\"name\":\"%PREFIX%rcl_bookmarks_gr\",\"col\":\"user_gr\"},{\"name\":\"%PREFIX%rcl_chat_messages\",\"col\":\"user_id\"},{\"name\":\"%PREFIX%rcl_chat_messagemeta\",\"col\":\"message_id\",\"nameRel\":\"%PREFIX%rcl_chat_messages\",\"colRel\":\"user_id\",\"colRelLink\":\"message_id\"},{\"name\":\"%PREFIX%rcl_chat_users\",\"col\":\"user_id\"},{\"name\":\"%PREFIX%rcl_chats\",\"col\":\"chat_id\",\"nameRel\":\"%PREFIX%rcl_chat_users\",\"colRel\":\"user_id\",\"colRelLink\":\"chat_id\"},{\"name\":\"%PREFIX%rcl_feeds\",\"col\":\"user_id\"},{\"name\":\"%PREFIX%rcl_groups_users\",\"col\":\"user_id\"},{\"name\":\"%PREFIX%rcl_groups_options\",\"col\":\"group_id\",\"nameRel\":\"%PREFIX%rcl_groups_users\",\"colRel\":\"user_id\",\"colRelLink\":\"group_id\"},{\"name\":\"%PREFIX%rcl_groups\",\"col\":\"ID\",\"nameRel\":\"%PREFIX%rcl_groups_users\",\"colRel\":\"user_id\",\"colRelLink\":\"group_id\"},{\"name\":\"%PREFIX%rcl_notifications\",\"col\":\"user_id\"},{\"name\":\"%PREFIX%rcl_orders\",\"col\":\"user_id\"},{\"name\":\"%PREFIX%rcl_order_items\",\"col\":\"order_id\",\"nameRel\":\"%PREFIX%rcl_orders\",\"colRel\":\"user_id\",\"colRelLink\":\"order_id\"},{\"name\":\"%PREFIX%rcl_rating_values\",\"col\":\"user_id\"},{\"name\":\"%PREFIX%rcl_rating_totals\",\"col\":\"object_id\",\"nameRel\":\"%PREFIX%rcl_rating_values\",\"colRel\":\"user_id\",\"colRelLink\":\"object_id\"},{\"name\":\"%PREFIX%rcl_rating_users\",\"col\":\"user_id\"},{\"name\":\"%PREFIX%rcl_temp_media\",\"col\":\"user_id\"},{\"name\":\"%PREFIX%rcl_user_action\",\"col\":\"user\"},{\"name\":\"%PREFIX%rcl_uw_shares\",\"col\":\"author_id\"}]}}},\"cacheBr\":{\"enable\":true,\"timeout\":43200},\"contPr\":{\"enable\":true,\"normalize\":3,\"normUrl\":false,\"normUrlMode\":2,\"min\":true,\"cln\":{\"cmts\":true,\"cmtsExcl\":[\"@^\\\\s*\\/?noindex\\\\s*$@i\",\"@\\\\[et-ajax\\\\]@i\"],\"items\":[]},\"rpl\":{\"items\":[]},\"lazy\":{\"items\":[],\"bjs\":true,\"p\":false},\"fresh\":{\"smoothAppear\":true,\"items\":[\"sa:.\\/\\/*[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" wpforms-container \\\")]\",\"sa:.\\/\\/*[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" wfacp_checkout_form \\\")]\"]},\"earlyPaint\":true,\"img\":{\"srcAddLm\":false,\"sysFlt\":false,\"inlSml\":true,\"inlSmlSize\":1024,\"deinlLrg\":true,\"deinlLrgSize\":2048,\"redirOwn\":false,\"redirCacheAdapt\":false,\"webp\":{\"enable\":true,\"redir\":true,\"prms\":{\"q\":80}},\"avif\":{\"enable\":false,\"redir\":false,\"prms\":{\"q\":52,\"s\":6}},\"szAdaptImg\":false,\"szAdaptBg\":false,\"szAdaptExcl\":[],\"szAdaptBgCxMin\":0,\"szAdaptDpr\":true,\"excl\":[\".\\/\\/svg[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" lottgen \\\")][contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" js-lzl-ing \\\")]\\/image\"],\"lazy\":{\"setSize\":false,\"load\":true,\"smoothAppear\":true,\"del3rd\":true,\"excl\":[\".\\/\\/img[contains(concat(\' \',normalize-space(@class),\' \'),\' jetpack-lazy-image \')]\",\".\\/\\/img[@data-opt-src]\",\".\\/\\/img[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" rev-slidebg \\\")]\",\".\\/\\/sr7-module\\/\\/img\",\".\\/\\/img[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" a3-notlazy \\\")]\",\".\\/\\/*[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" t-bgimg \\\")]\",\".\\/\\/*[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" posts-container \\\")][@data-load-animation]\\/\\/*[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" post-featured-img \\\")]\\/\\/img\",\".\\/\\/*[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" dani-lzl \\\")]\\/\\/img\"]},\"cacheExt\":[\"crit:@\\\\.cdninstagram\\\\.com\\/@\",\"crit:@\\\\.googleusercontent\\\\.com\\/@\",\"@\\\\.ytimg\\\\.com\\/@\",\"@\\\\.vimeocdn\\\\.com\\/@\"]},\"frm\":{\"lazy\":{\"enable\":true,\"yt\":true,\"vm\":true,\"elmntrBg\":true,\"youTubeFeed\":true}},\"cp\":{\"sldBdt\":true,\"swBdt\":true,\"vidJs\":true,\"elmntrAni\":true,\"elmntrSpltAni\":true,\"elmntrTrxAni\":true,\"elmntrBgSldshw\":true,\"elmntrVids\":true,\"qodefApprAni\":true,\"prtThSkel\":true,\"astrRsp\":true,\"ntBlueThRspnsv\":true,\"mdknThRspnsv\":true,\"fltsmThBgFill\":true,\"fltsmThAni\":true,\"ukSldshw\":true,\"ukBgImg\":true,\"ukAni\":true,\"ukGrid\":true,\"ukModal\":true,\"ukHghtVwp\":true,\"ukNavBar\":true,\"tmHdr\":true,\"fusionBgVid\":true,\"fsnEqHghtCols\":true,\"fsnAni\":true,\"thrvAni\":true,\"phloxThRspnsv\":true,\"phloxThAni\":true,\"sldN2Ss\":true,\"sldRev\":true,\"sldRev_SmthLd\":true,\"sldRev7\":true,\"tdThumbCss\":true,\"elmsKitImgCmp\":true,\"elmsKitLott\":true,\"haCrsl\":true,\"jetCrsl\":true,\"jetCrslPst\":true,\"elmntrTabs\":true,\"elmntrAccrdn\":true,\"elmntrAdvTabs\":true,\"elmntrNavMenu\":true,\"elmntrPremNavMenu\":true,\"elmntrPremScrl\":true,\"elmntrPremTabs\":true,\"elmntrPremCrsl\":true,\"elmntrWdgtGal\":true,\"elmntrWdgtImgCrsl\":true,\"elmntrWdgtWooPrdImgs\":true,\"elmntrWdgtCntr\":true,\"elmntrWdgtAvoShcs\":true,\"elmntrWdgtLott\":true,\"elmntrWdgtPrmLott\":true,\"elmntrStck\":false,\"elmntrShe\":false,\"elmntrStrtch\":true,\"xooelTabs\":true,\"phtncThmb\":true,\"jetMobMenu\":true,\"jetLott\":true,\"diviMvImg\":true,\"diviMvText\":true,\"diviMvSld\":true,\"diviMvFwHdr\":true,\"diviVidBox\":true,\"diviVidBg\":true,\"diviVidFr\":true,\"diviDsmGal\":true,\"diviLzStls\":true,\"diviPrld\":true,\"diviStck\":true,\"diviAni\":true,\"diviDataAni\":true,\"diviHdr\":true,\"brcksAni\":true,\"kdncThAni\":true,\"scrlSeq\":true,\"mkImgSrcSet\":true,\"woodmartPrcFlt\":true,\"wooPrcFlt\":true,\"wbwPrdFlt\":true,\"wooJs\":true,\"wpStrs\":true,\"txpTagGrps\":true,\"eaelSmpMnu\":true,\"wprAniTxt\":true,\"wprTabs\":true,\"suTabs\":true,\"upbAni\":true,\"upbBgImg\":true,\"upbCntVid\":true,\"ultRspnsv\":true,\"ultVcHd\":true,\"ultAni\":true,\"the7Ani\":true,\"the7MblHdr\":true,\"sbThAni\":true,\"esntlsThAni\":true,\"beThAni\":true,\"merimagBgImg\":true,\"mdcrLdng\":true,\"prmmprssLzStls\":true,\"mnmgImg\":true,\"tldBgImg\":true,\"jqVide\":true,\"jqSldNivo\":true,\"wooSctrCntDwnTmr\":true,\"lottGen\":true,\"sprflMenu\":true,\"jqJpPlr\":true,\"prstPlr\":true},\"js\":{\"groupCritSpec\":false,\"groupNonCrit\":false,\"groupExclMdls\":true,\"groupExcls\":[\"src:@stripe@\",\"src:@\\\\.hsforms\\\\.net\\\\W@\",\"src:@\\/\\/cdnjs\\\\.cloudflare\\\\.com\\/ajax\\/libs\\/bodymovin\\/[\\\\d\\\\.]+\\/lottie\\\\.@\"],\"min\":false,\"minExcls\":[],\"other\":{\"incl\":[\".\\/\\/iframe[@id=\'likes-master\' and contains(@src,\'\\/\\/widgets.wp.com\\/likes\\/master.html?\')]\"]},\"cprRem\":false,\"optLoad\":true,\"cplxDelay\":false,\"preLoadEarly\":false,\"loadFast\":false,\"aniDelay\":1000,\"scrlDelay\":500,\"clk\":{\"delay\":250,\"excl\":[\".\\/\\/*[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" cpel-switcher__lang \\\")]\",\".\\/\\/*[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" cpel-switcher__lang \\\")]\\/\\/a\"],\"exclDef\":[\".\\/\\/a[@href=\\\"#\\\"]\",\".\\/\\/a[@href=\\\"#link-popup\\\"]\",\".\\/\\/*[starts-with(@href,\\\"#elementor-action\\\")]\",\".\\/\\/a[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" mobile-menu \\\")]\",\".\\/\\/a[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" elementor-button \\\")][not(self::node()[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" elementor-button-link \\\")])]\",\".\\/\\/a[@e-action-hash]\",\".\\/\\/a[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" elementor-toggle-title \\\")]\",\".\\/\\/a[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" sby_video_thumbnail \\\")]\",\".\\/\\/a[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" ui-tabs-anchor \\\")]\",\".\\/\\/a[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" elementor-icon \\\")]\",\".\\/\\/a[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" wd-open-popup \\\")]\",\".\\/\\/a[starts-with(@href,\\\"#grve-\\\")]\",\".\\/\\/button[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" elementskit-menu-toggler \\\")]\",\".\\/\\/a[starts-with(@href,\\\"#\\\")][contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" infinite-mm-menu-button \\\")]\",\".\\/\\/a[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" jet-button__instance \\\")]\",\".\\/\\/*[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" jet-menu-item \\\")]\\/a[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" menu-link \\\")]\",\".\\/\\/a[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" ajax_add_to_cart \\\")]\",\".\\/\\/button[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" single_add_to_cart_button \\\")]\",\".\\/\\/a[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" dt-mobile-menu-icon \\\")]\",\".\\/\\/a[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" submit \\\")]\",\".\\/\\/a[@uk-toggle]\",\".\\/\\/a[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" woodmart-nav-link \\\")]\",\".\\/\\/a[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" et_pb_video_play \\\")]\",\".\\/\\/*[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" et-menu \\\")]\\/li\\/a[starts-with(@href,\\\"#\\\")]\",\".\\/\\/a[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" et_pb_button \\\")]\",\".\\/\\/a[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" meanmenu-reveal \\\")]\",\".\\/\\/*[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" wpforms-icon-choices-item \\\")]\",\".\\/\\/a[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" wd-el-video-link \\\")]\",\".\\/\\/*[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" product-video-button \\\")]\\/a\",\".\\/\\/button[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" menu-toggle \\\")]\",\".\\/\\/a[@data-fslightbox=\\\"gallery\\\"]\",\".\\/\\/a[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" dvmm_button \\\")]\",\".\\/\\/div[@data-thumb]\\/\\/a\",\".\\/\\/a[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" searchOpen \\\")]\",\".\\/\\/button[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" uicore-toggle \\\")]\",\".\\/\\/a[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" bricks-button \\\")]\",\".\\/\\/button[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" e-n-menu-toggle \\\")]\"]},\"nonCrit\":{\"inl\":true,\"int\":true,\"ext\":true,\"excl\":true,\"items\":[\"body:@\\\\Wfunction\\\\s+et_core_page_resource_fallback\\\\W@\",\"body:@\\\\WTRINITY_TTS_WP_CONFIG\\\\W@\",\"id:@^spai_js$@\",\"src:@\\/depicter\\/@\",\"body:@\\\\WDepicter\\\\W@\",\"src:@\\\\.github\\\\.com@\",\"body:@window\\\\.jetMenuMobileWidgetRenderData@\"],\"timeout\":{\"enable\":true,\"v\":4500}},\"critSpec\":{\"timeout\":{\"enable\":true,\"v\":0},\"items\":[\"src:@\\\\.cookiebot\\\\.com@\"]},\"spec\":{\"timeout\":{\"enable\":false,\"v\":500},\"items\":[\"@googletagmanager\\\\.com@i\",\"@(?:^|\\\\W)gtag\\\\s*\\\\(\\\\s*[\'\\\"]@\",\"@google-analytics\\\\.com@i\",\"@(?:^|\\\\W)ga\\\\s*\\\\(\\\\s*[\'\\\"]create\\\\W@\",\"@(?:^|\\\\W)ga\\\\s*\\\\(\\\\s*[\'\\\"][^\'\\\"]*\\\\.?send\\\\W@\",\"@\\\\Wgoogleadservices\\\\.com\\\\W@i\",\"@\\\\Wgooglesyndication\\\\.com\\/pagead\\/js\\/adsbygoogle\\\\.js(?:$|\\\\W)@\",\"@(?:^|\\\\W)window\\\\s*.\\\\s*adsbygoogle(?:$|\\\\W)@\",\"@\\\\Wgstatic\\\\.com\\\\W@\",\"id:@^wpforms-recaptcha-js-after@\",\"src:@\\/plugins\\/contact-form-7\\/modules\\/recaptcha\\/@\",\"@\\/\\/apis\\\\.google\\\\.com\\/js\\/plusone\\\\.js$@\",\"@\\/\\/apis\\\\.google\\\\.com\\/js\\/platform\\\\.js$@\",\"!body:@elementor@i & src,body:@connect\\\\.facebook\\\\.net@i\",\"@(?:^|\\\\W)fbq\\\\s*\\\\(\\\\s*[\'\\\"]@\",\"@static\\\\.hotjar\\\\.com@i\",\"src:@\\\\Wtrinitymedia\\\\.ai\\/player\\\\W@\",\"@mc.yandex.ru\\/metrika@i\",\"@(?:^|\\\\W)ym\\\\s*\\\\(\\\\s*\\\\d@\",\"@\\\\Wyastatic\\\\.net\\\\W@i\",\"@\\\\Wcdn\\\\.jsdelivr\\\\.net\\/npm\\/yandex-metrica-watch\\/[\\\\w\\\\-]+\\\\.js@\",\"@\\\\Wsite\\\\.yandex\\\\.net\\/v[\\\\d\\\\.]+\\/js\\/all\\\\.js\\\\W@s\",\"@\\\\Wyandex\\\\.st\\/share\\/share\\\\.js@\",\"@\\\\Wapi-maps\\\\.yandex\\\\.ru\\/services\\/constructor\\\\W@i\",\"body:@\\\\Wymaps\\\\W@\",\"@top-fwz1\\\\.mail\\\\.ru@i\",\"@(?:^|\\\\W)_tmr\\\\s*\\\\.@\",\"@\\\\Wconnect\\\\.ok\\\\.ru\\/connect\\\\.js\\\\W@\",\"@\\\\Wlc2ads\\\\.ru\\/js\\/adv_out\\\\.js@\",\"@counter\\\\.yadro\\\\.ru\\/hit\\\\?@i\",\"@\\\\Wadvertur\\\\.ru\\\\W@\",\"@\\\\Wapi\\\\.content-ad\\\\.net\\\\W@\",\"@\\\\Wuptolike\\\\.com\\\\W@i\",\"@\\\\Wshare\\\\.pluso\\\\.ru\\\\W@\",\"@\\\\Wsendpulse\\\\.com\\/js\\/push\\/@\",\"@\\\\Wmediametrics\\\\.ru\\/partner\\/inject\\/inject\\\\.js@\",\"@code[\\\\w-]*\\\\.jivosite\\\\.com@i\",\"@\\\\Wtawk\\\\.to\\\\W@\",\"@\\\\Wgetbutton\\\\.io\\\\W@\",\"@bigreal\\\\.org\\/@i\",\"@\\\\.realbig\\\\.media\\/@i\",\"@\\\\Wtruenat\\\\.bid\\\\W@i\",\"@\\\\Wnewup\\\\.bid\\\\W@i\",\"@\\\\Wnewrrb\\\\.bid\\\\W@i\",\"@\\\\Wrb_ajaxurl\\\\W@\",\"@\\\\Wcontent_rb\\\\W@\",\"@gi\\\\[\'ads\'\\\\]\\\\[\'siteAdBlock\'\\\\]&&gi\\\\[\'ads\'\\\\]\\\\[\'blockAdBlock\'\\\\]&&gh\\\\[\'setAttribute\'\\\\]\\\\(\'data-ad-block\'@\",\"@\\\\Wgismeteo\\\\.ru\\/api\\/informer\\/getinformer\\/@\",\"@\\\\Wvk\\\\.com\\/js\\/api\\/openapi\\\\.js\\\\W@\",\"@(?:^|\\\\W)VK\\\\s*\\\\.\\\\s*Widgets\\\\W@s\",\"@(?:^|\\\\W)VK\\\\s*\\\\.\\\\s*init\\\\s*\\\\(@s\",\"@\\\\.addtoany\\\\.com\\\\W@i\",\"@\\\\Wtravelpayouts\\\\.com\\\\W@i\",\"src:@\\\\Wcalendly\\\\.com@\",\"@\\/woocommerce-gateway-stripe\\/assets\\/js\\/stripe(?:\\\\.|\\\\.min\\\\.)js\\\\W@\",\"@\\/amp\\\\-analytics\\\\-@i\",\"@\\\\w*\\\\.write\\\\s*\\\\(\\\\s*[\'\\\"]<a\\\\s*[^>]*href\\\\s*=\\\\s*[\'\\\"][^\'\\\"]*www\\\\.liveinternet\\\\.ru\\\\W@\",\"@\\\\w*\\\\.write\\\\s*\\\\(\\\\s*[\'\\\"]<img\\\\s*[^>]*src\\\\s*=\\\\s*[\'\\\"][^\'\\\"]*\\\\Wcounter\\\\.yadro\\\\.ru\\\\W@\",\"@\\\\Wadvertur\\\\.ru\\/v\\\\d+\\/code\\\\.js\\\\?id=\\\\d+@\",\"@\\\\.googlesyndication\\\\.com\\/pagead\\/show_ads\\\\.js$@\",\"@(?:^|\\\\W)amzn_assoc_placement\\\\s*=\\\\s*[\\\\\'\\\"][\\\\w\\\\-]+[\\\\\'\\\"]@\",\"@\\\\Wamazon-adsystem\\\\.com\\/widgets\\/onejs\\\\W@\",\"@\\\\.\\\\s*write\\\\s*\\\\(.+<div.+div>.+\\\\Wuptolike\\\\.com\\\\W@s\",\"@\\\\Wbeeketing\\\\.com\\\\W@\",\"@counter\\\\.rambler\\\\.ru\\/top100\\\\.jcn\\\\?@\",\"body:@function\\\\(c,h,i,m,p\\\\)@\",\"src:@\\\\.popt\\\\.in\\\\W@\",\"src:@\\/interactive-geo-maps\\/@\",\"src:@amcharts\\\\.com@\",\"@\\\\.chatbase\\\\.co@i\",\"src:@\\\\.hsforms\\\\.net\\\\W@\",\"body:@hbspt\\\\.forms\\\\.create\\\\(@\",\"src:@\\\\.visitiq\\\\.io@\",\"body:@vpixel\\\\.piximage@\"]},\"skips\":[]},\"css\":{\"corrErr\":true,\"group\":true,\"groupCombine\":false,\"groupNonCrit\":true,\"groupNonCritCombine\":false,\"groupFont\":true,\"groupFontCombine\":true,\"font\":{\"deinlLrg\":false,\"deinlLrgSize\":512,\"optLoadNameExpr\":\"\"},\"fontPreload\":false,\"sepImp\":true,\"min\":true,\"optLoad\":true,\"inlAsSrc\":false,\"inlCrit\":true,\"inlNonCrit\":false,\"delayNonCritWithJs\":true,\"bfrJs\":false,\"nonCrit\":{\"auto\":true,\"autoExcls\":[\"@depicter@\",\"@\\\\.show-mobile-header@\",\"@\\\\.uk-modal@\",\"@#cr_floatingtrustbadge@\",\"@(?:^|\\\\s)br(?:$|[\\\\s\\\\.#\\\\[])@\"],\"inl\":true,\"int\":true,\"ext\":true,\"excl\":false,\"items\":[]},\"fontOptLoad\":true,\"fontOptLoadDisp\":\"swap\",\"fontCrit\":false,\"skips\":[\"id:@^reycore-critical-css$@\"],\"custom\":{\"0\":{\"enable\":true,\"data\":\"\"},\"jet-menu\":{\"enable\":false,\"descr\":\"Jet Menu\",\"data\":\".seraph-accel-js-lzl-ing ul.jet-menu > li[id^=jet-menu-item-] {\\n\\tdisplay: none!important;\\n}\"},\"jet-testimonials\":{\"enable\":true,\"descr\":\"Jet Testimonials\",\"data\":\".jet-testimonials__instance:not(.slick-initialized) .jet-testimonials__item {\\r\\n\\tmax-width: 100%;\\r\\n}\\r\\n\\r\\n.jet-testimonials__instance:not(.slick-initialized) .jet-testimonials__item:nth-child(n+4) {\\r\\n\\tdisplay: none !important;\\r\\n}\"},\"xo-slider\":{\"enable\":true,\"descr\":\"XO Slider\",\"data\":\".xo-slider .slide-content {\\n\\tdisplay: unset!important;\\n}\"},\"jqSldNivo\":{\"enable\":true,\"descr\":\"Nivo Slider for jQuery\",\"data\":\"body:is(.seraph-accel-js-lzl-ing, .seraph-accel-js-lzl-ing-ani) .nivo-caption {\\r\\n\\topacity: 1 !important;\\r\\n}\\r\\n\\r\\n.nivo-caption {\\r\\n\\tdisplay: none;\\r\\n}\"},\"owl-carousel\":{\"enable\":true,\"descr\":\"OWL Carousel\",\"data\":\".owl-carousel:not(.wd-owl):not(.owl-loaded) {\\r\\n\\tdisplay: block !important;\\r\\n\\tvisibility: visible !important;\\r\\n}\\r\\n\\r\\n.owl-carousel:not(.wd-owl):not(.owl-loaded) > *:not(:first-child) {\\r\\n\\tdisplay: none;\\r\\n}\\r\\n\\r\\n.owl-carousel:not(.wd-owl) .container.full-screen {\\r\\n\\theight: 100vh;\\r\\n}\"},\"ult-carousel\":{\"enable\":true,\"descr\":\"Ultimate Carousel\",\"data\":\".seraph-accel-js-lzl-ing .ult-carousel-wrapper {\\n\\tvisibility:initial!important;\\n}\\n\\n.seraph-accel-js-lzl-ing .ult-carousel-wrapper .ult-item-wrap:not(:first-child) {\\n\\tdisplay:none;\\n}\"},\"bdt-slideshow\":{\"enable\":true,\"descr\":\"Airtech Plumber Slider\",\"data\":\".seraph-accel-js-lzl-ing .bdt-prime-slider-previous, .seraph-accel-js-lzl-ing .bdt-prime-slider-next {\\r\\n\\tdisplay: none !important;\\r\\n}\\r\\n\\r\\n.seraph-accel-js-lzl-ing .bdt-post-slider-item:first-child {\\r\\n\\tdisplay: unset !important;\\r\\n}\"},\"n2-ss-slider\":{\"enable\":true,\"descr\":\"Smart Slider\",\"data\":\"ss3-force-full-width, ss3-fullpage {\\r\\n\\ttransform: none !important;\\r\\n\\topacity: 1 !important;\\r\\n\\twidth: var(--seraph-accel-client-width) !important;\\r\\n\\tmargin-left: calc((100% - var(--seraph-accel-client-width)) \\/ 2);\\r\\n}\\r\\n\\r\\nss3-fullpage {\\r\\n\\theight: 100vh !important;\\r\\n}\\r\\n\\r\\nbody.seraph-accel-js-lzl-ing .n2-ss-align {\\r\\n\\toverflow: visible !important;\\r\\n}\\r\\n\\r\\n.n2-ss-slider:not(.n2-ss-loaded):not([data-ss-carousel]) .n2-ss-slide-backgrounds [data-public-id][data-lzl-first=\\\"1\\\"],\\r\\n.n2-ss-slider:not(.n2-ss-loaded):not([data-ss-carousel]) [data-slide-public-id][data-lzl-first=\\\"1\\\"] {\\r\\n\\ttransform: translate3d(0px, 0px, 0px) !important;\\r\\n}\\r\\n\\r\\n.n2-ss-slider:not(.n2-ss-loaded):not([data-ss-carousel]) .n2-ss-slide:not([data-slide-public-id][data-lzl-first=\\\"1\\\"]),\\r\\n.n2-ss-slider:not(.n2-ss-loaded) .n2-ss-layer.js-lzl-n-ing,\\r\\n.n2-ss-slider:not(.n2-ss-loaded):not([style*=ss-responsive-scale]) [data-responsiveposition],\\r\\n.n2-ss-slider:not(.n2-ss-loaded):not([style*=ss-responsive-scale]) [data-responsivesize],\\r\\n.n2-ss-slider.n2-ss-loaded .n2-ss-layer.js-lzl-ing {\\r\\n\\tvisibility: hidden !important;\\r\\n}\\r\\n\\r\\n.n2-ss-slider:not(.n2-ss-loaded):not([data-ss-carousel]) [data-slide-public-id][data-lzl-first=\\\"1\\\"] .n2-ss-layers-container,\\r\\n.n2-ss-slider:not(.n2-ss-loaded):not([data-ss-carousel]) .n2-ss-slide-backgrounds [data-public-id][data-lzl-first=\\\"1\\\"],\\r\\n.n2-ss-slider:not(.n2-ss-loaded) .n2-ss-slider-controls-advanced {\\r\\n\\topacity: 1 !important;\\r\\n}\\r\\n\\r\\n.n2-ss-slider[data-ss-carousel]:not(.n2-ss-loaded) .n2-ss-layers-container {\\r\\n\\topacity: 1 !important;\\r\\n\\tvisibility: visible !important;\\r\\n}\\r\\n\\r\\n.n2-ss-slider-pane {\\r\\n\\topacity: 1 !important;\\r\\n\\tanimation-name: none !important;\\r\\n\\t--self-side-margin: auto !important;\\r\\n\\t--slide-width: 100% !important;\\r\\n}\\r\\n\\r\\n\\/*.n2-ss-showcase-slides:not(.n2-ss-showcase-slides--ready) {\\r\\n\\topacity: 1 !important;\\r\\n\\ttransform: none !important;\\r\\n}*\\/\"},\"wp-block-ultimate-post-slider\":{\"enable\":true,\"descr\":\"Block Ultimate Post Slider\",\"data\":\"[class*=wp-block-ultimate-post-post-slider] .ultp-block-items-wrap:not(.slick-initialized) > .ultp-block-item:not(:first-child)\\n{\\n\\tdisplay: none!important;\\n}\"},\"preloaders\":{\"enable\":true,\"descr\":\"Preloaders\",\"data\":\"#preloader, #page_preloader, #page-preloader, #loader-wrapper, #royal_preloader, #loftloader-wrapper, #page-loading, #the7-body > #load, #loader, #loaded, #loader-container,\\r\\n.rokka-loader, .page-preloader-cover, .apus-page-loading, .medizco-preloder, e-page-transition, .loadercontent, .shadepro-preloader-wrap, .tslg-screen, .page-preloader, .pre-loading, .preloader-outer, .page-loader, .martfury-preloader, body.theme-dotdigital > .preloader, .loader-wrap {\\r\\n\\tdisplay: none !important;\\r\\n}\\r\\n\\r\\nbody.royal_preloader {\\r\\n\\tvisibility: hidden !important;\\r\\n}\"},\"elementor-vis\":{\"enable\":false,\"descr\":\"Elementor (visibility and animation)\",\"data\":\"body.seraph-accel-js-lzl-ing-ani .elementor-invisible {\\r\\n\\tvisibility: visible !important;\\r\\n}\\r\\n\\r\\n.elementor-element[data-settings*=\\\"animation\\\\\\\"\\\"] {\\r\\n\\tanimation-name: none !important;\\r\\n}\"},\"elementor\":{\"enable\":true,\"descr\":\"Elementor\",\"data\":\".vc_row[data-vc-full-width] {\\r\\n\\tposition: relative;\\r\\n\\twidth: var(--seraph-accel-client-width) !important;\\r\\n}\\r\\n\\r\\nhtml:not([dir=rtl]) .vc_row[data-vc-full-width] {\\r\\n\\tleft: calc((100% - var(--seraph-accel-client-width)) \\/ 2) !important;\\r\\n\\tmargin-left: 0 !important;\\r\\n}\\r\\n\\r\\nhtml[dir=rtl] .vc_row[data-vc-full-width] {\\r\\n\\tright: calc((100% - var(--seraph-accel-client-width)) \\/ 2) !important;\\r\\n\\tmargin-right: 0 !important;\\r\\n}\\r\\n\\r\\n.vc_row.wpb_row[data-vc-full-width]:not([data-vc-stretch-content=\\\"true\\\"]), .vc_row.mpc-row[data-vc-full-width]:not([data-vc-stretch-content=\\\"true\\\"]) {\\r\\n\\t--pdd: calc((var(--seraph-accel-client-width) - (100% + 2*15px)) \\/ 2);\\r\\n\\tpadding-left: var(--pdd) !important;\\r\\n\\tpadding-right: var(--pdd) !important;\\r\\n}\\r\\n\\r\\n.elementor-top-section.elementor-section-stretched[data-settings*=\\\"section-stretched\\\"] {\\r\\n\\twidth: var(--seraph-accel-client-width) !important;\\r\\n}\\r\\n\\r\\nhtml:not([dir=rtl]) .elementor-top-section.elementor-section-stretched[data-settings*=\\\"section-stretched\\\"] {\\r\\n\\tleft: calc(-1 * var(--lzl-strtch-offs-x)) !important;\\r\\n}\\r\\n\\r\\nhtml[dir=rtl] .elementor-top-section.elementor-section-stretched[data-settings*=\\\"section-stretched\\\"] {\\r\\n\\tright: calc(-1 * var(--lzl-strtch-offs-x)) !important;\\r\\n}\\r\\n\\r\\nbody.seraph-accel-js-lzl-ing-ani .elementor-headline-dynamic-text.elementor-headline-text-active {\\r\\n\\topacity: 1;\\r\\n}\"},\"et\":{\"enable\":true,\"descr\":\"Divi\",\"data\":\".et_animated:not(.et_pb_sticky_placeholder,.dani-lzl) {\\r\\n\\topacity: 1 !important;\\r\\n}\\r\\n\\r\\n.et_pb_section_video_bg > video {\\r\\n\\theight: 100%;\\r\\n}\\r\\n\\r\\n.et_pb_preload .et_pb_section_video_bg, .et_pb_preload > div {\\r\\n\\tvisibility: visible !important;\\r\\n}\\r\\n\\r\\nbody:is(.seraph-accel-js-lzl-ing, .seraph-accel-js-lzl-ing-ani) .et_pb_gallery_grid .et_pb_gallery_item {\\r\\n\\tdisplay: block !important;\\r\\n}\\r\\n\\r\\n\\/* Slider *\\/\\r\\n\\/*.et_pb_slider:not([data-active-slide]) {\\r\\n\\theight: 1px;\\r\\n}*\\/\\r\\n\\r\\n.et_pb_slider:not([data-active-slide]) .et_pb_slides,\\r\\n.et_pb_slider:not([data-active-slide]) .et_pb_slide:first-child,\\r\\n.et_pb_slider:not([data-active-slide]) .et_pb_slide:first-child .et_pb_container {\\r\\n\\theight: 100%;\\r\\n}\"},\"tag-div\":{\"enable\":true,\"descr\":\"tagDiv\",\"data\":\"body.td-animation-stack-type0 .td-animation-stack .entry-thumb,\\nbody.td-animation-stack-type0 .post img:not(.woocommerce-product-gallery img):not(.rs-pzimg),\\nbody.td-animation-stack-type0 .td-animation-stack .td-lazy-img,\\n.tdb_header_menu .tdb-menu-items-pulldown.tdb-menu-items-pulldown-inactive {\\n\\topacity: 1!important;\\n}\"},\"photonic-thumb\":{\"enable\":true,\"descr\":\"Photonic Photo Gallery\",\"data\":\".photonic-thumb,\\r\\n.photonic-thumb a img {\\r\\n\\tdisplay: unset !important;\\r\\n}\\r\\n\\r\\n.photonic-loading {\\r\\n\\tdisplay: none !important;\\r\\n}\\r\\n\\r\\n.photonic-stream * {\\r\\n\\tanimation-name: none !important;\\r\\n}\"},\"avia-slideshow\":{\"enable\":true,\"descr\":\"Avia Slideshow\",\"data\":\".avia-slideshow.av-default-height-applied .avia-slideshow-inner > li:first-child {\\r\\n\\topacity: 1 !important;\\r\\n\\tvisibility: visible !important;\\r\\n}\\r\\n\"},\"rev-slider\":{\"enable\":true,\"descr\":\"Revolution Slider\",\"data\":\"rs-module-wrap:has(rs-module[data-lzl-layout=\\\"fullwidth\\\"]), rs-module-wrap:has(rs-module[data-lzl-layout=\\\"fullscreen\\\"]), rs-fullwidth-wrap, rs-fullwidth-wrap > rs-module-wrap {\\r\\n\\twidth: var(--seraph-accel-client-width) !important;\\r\\n\\tleft: calc((100% - var(--seraph-accel-client-width)) \\/ 2) !important;\\r\\n}\\r\\n\\r\\nrs-module[data-lzl-layout=\\\"fullscreen\\\"] {\\r\\n\\theight: calc(var(--seraph-accel-dvh) - var(--lzl-rs-offs-y)) !important;\\r\\n}\\r\\n\\r\\nrs-module[data-lzl-layout=\\\"fullscreen\\\"].js-lzl-ing {\\r\\n\\tmargin-top: calc(-1*var(--seraph-accel-dvh) + var(--lzl-rs-offs-y)) !important;\\r\\n}\"},\"fusion-vis\":{\"enable\":false,\"descr\":\"Fusion (visibility and animation)\",\"data\":\".fusion-animated {\\n\\tvisibility: visible;\\n}\\n\"},\"fusion-menu\":{\"enable\":true,\"descr\":\"Fusion Menu\",\"data\":\".fusion-menu-element-wrapper.loading {\\n\\topacity: 1;\\n}\\n\\n@media (max-width: 1024px) {\\n\\t.fusion-menu-element-wrapper.loading .fusion-menu {\\n\\t\\tdisplay: none;\\n\\t}\\n\\n\\t.fusion-menu-element-wrapper.loading button {\\n\\t\\tdisplay: block !important;\\n\\t}\\n\\n\\t.fusion-menu-element-wrapper.loading {\\n\\t\\tdisplay: flex;\\n\\t}\\n}\"},\"jnews\":{\"enable\":true,\"descr\":\"JNews Theme\",\"data\":\".thumbnail-container.animate-lazy > img {\\n\\topacity: 1!important;\\n}\"},\"grve\":{\"enable\":true,\"descr\":\"GROVE Theme\",\"data\":\".grve-bg-image {\\r\\n\\topacity: 1 !important;\\r\\n}\\r\\n\\r\\nbody.seraph-accel-js-lzl-ing-ani .grve-animated-item {\\r\\n\\tanimation-fill-mode: both;\\r\\n\\tanimation-duration: .8s;\\r\\n}\\r\\n\\r\\nbody.seraph-accel-js-lzl-ing-ani .grve-fade-in-left {\\r\\n\\tanimation-name: grve_fade_in_left;\\r\\n}\\r\\n\\r\\nbody.seraph-accel-js-lzl-ing-ani .grve-fade-in {\\r\\n\\tanimation-name: grve_fade_in;\\r\\n}\\r\\n\\r\\nbody.seraph-accel-js-lzl-ing-ani .grve-fade-in-up {\\r\\n\\tanimation-name: grve_fade_in_up;\\r\\n}\\r\\n\"},\"wpb\":{\"enable\":true,\"descr\":\"WPBakery\",\"data\":\".upb_row_bg[data-bg-override=\\\"browser_size\\\"],\\r\\n.upb_row_bg[data-bg-override*=\\\"full\\\"],\\r\\n.ult-vc-seperator[data-full-width=\\\"true\\\"] {\\r\\n\\twidth: var(--seraph-accel-client-width) !important;\\r\\n}\\r\\n\\r\\n.ult-vc-seperator[data-full-width=\\\"true\\\"] .ult-main-seperator-inner {\\r\\n\\twidth: 100% !important;\\r\\n\\tmargin-left: 0 !important;\\r\\n\\tmargin-right: 0 !important;\\r\\n}\\r\\n\\r\\nhtml:not([dir=rtl]) .upb_row_bg[data-bg-override=\\\"browser_size\\\"],\\r\\nhtml:not([dir=rtl]) .upb_row_bg[data-bg-override*=\\\"full\\\"],\\r\\nhtml:not([dir=rtl]) .ult-vc-seperator[data-full-width=\\\"true\\\"] {\\r\\n\\tmargin-left: calc((100% - var(--seraph-accel-client-width)) \\/ 2) !important;\\r\\n\\tleft: 0 !important;\\r\\n}\\r\\n\\r\\nhtml[dir=rtl] .upb_row_bg[data-bg-override=\\\"browser_size\\\"],\\r\\nhtml[dir=rtl] .upb_row_bg[data-bg-override*=\\\"full\\\"],\\r\\nhtml[dir=rtl] .ult-vc-seperator[data-full-width=\\\"true\\\"] {\\r\\n\\tmargin-right: calc((100% - var(--seraph-accel-client-width)) \\/ 2) !important;\\r\\n\\tright: 0 !important;\\r\\n}\"},\"tm\":{\"enable\":true,\"descr\":\"Yoo Theme\",\"data\":\".tm-header-placeholder {\\r\\n\\theight: calc(1px*var(--uk-header-placeholder-cy));\\r\\n}\\r\\n\"},\"packery\":{\"enable\":true,\"descr\":\"Packery\",\"data\":\"[data-packery-options].row.row-grid > .col:not([style*=\\\"position\\\"]),\\r\\n[data-packery-options].row.row-masonry > .col:not([style*=\\\"position\\\"]) {\\r\\n\\tfloat: unset;\\r\\n\\tdisplay: inline-block !important;\\r\\n\\tvertical-align: top;\\r\\n}\"},\"htmlGen\":{\"enable\":true,\"descr\":\"Generic HTML\",\"data\":\"html, body {\\r\\n\\tdisplay: block !important;\\r\\n\\topacity: 1 !important;\\r\\n\\tvisibility: unset !important;\\r\\n}\"},\"cookie-law-info\":{\"enable\":true,\"descr\":\"CookieYes\",\"data\":\".cky-consent-container.cky-hide ~ .cky-consent-container {\\r\\n\\tdisplay: none;\\r\\n}\"}}},\"cdn\":{\"items\":[{\"enable\":true,\"addr\":\"\",\"types\":[\"js\",\"css\",\"less\",\"gif\",\"jpeg\",\"jpg\",\"bmp\",\"png\",\"svg\",\"webp\",\"avif\",\"eot\",\"aac\",\"mp3\",\"mp4\",\"ogg\",\"pdf\",\"docx\",\"otf\",\"ttf\",\"woff\"],\"uris\":[\"wp-content\",\"wp-includes\"],\"urisExcl\":[]}]},\"grps\":{\"items\":{\"home\":{\"enable\":0,\"name\":\"Home\",\"urisIncl\":[],\"argsIncl\":[],\"patterns\":[\".\\/\\/body[contains(concat(\\\" \\\",normalize-space(@class),\\\" \\\"),\\\" home \\\")]\"],\"views\":[],\"sklExcl\":[],\"contPr\":{\"enable\":true,\"jsOvr\":true,\"js\":{\"optLoad\":true,\"nonCrit\":{\"timeout\":{\"enable\":false,\"v\":0},\"inl\":true,\"int\":true,\"ext\":true,\"excl\":true,\"items\":[]},\"spec\":{\"timeout\":{\"enable\":false,\"v\":4500}}},\"jsNonCritScopeOvr\":false,\"cssOvr\":false,\"css\":{\"nonCrit\":{\"auto\":false}}}},\"@\":{\"enable\":2,\"name\":\"Common\",\"urisIncl\":[],\"argsIncl\":[],\"patterns\":[],\"views\":[],\"sklSrch\":true,\"sklExcl\":[\".\\/\\/br\",\".\\/\\/script\",\".\\/\\/style\",\".\\/\\/link\",\".\\/\\/head\",\".\\/\\/svg[@width=\\\"0\\\"][@height=\\\"0\\\"]\"],\"sklCssSelExcl\":[\"@[\\\\.#][\\\\w\\\\-]*[\\\\-_]([\\\\da-f]+)[\\\\W_]@i\",\"@\\\\.(?:product_cat|product_tag|category|tag|pa|woocommerce-product-attributes-item--attribute|comment-author)[\\\\-_]([\\\\w\\\\-]+)@i\"]},\"desktop\":{\"enable\":0,\"name\":\"Desktop\",\"urisIncl\":[],\"argsIncl\":[],\"patterns\":[],\"views\":[\"cmn\"],\"sklSrch\":false,\"sklExcl\":[],\"sklCssSelExcl\":[],\"contPr\":{\"enable\":true,\"jsOvr\":true,\"js\":{\"optLoad\":true,\"nonCrit\":{\"timeout\":{\"enable\":true,\"v\":4500},\"inl\":true,\"int\":true,\"ext\":true,\"excl\":true,\"items\":[]},\"spec\":{\"timeout\":{\"enable\":false,\"v\":4500}}},\"jsNonCritScopeOvr\":false,\"cssOvr\":false,\"css\":{\"nonCrit\":{\"auto\":false}}}}}}},\"bots\":{\"agents\":[\"@\\\\Wcompatible\\\\W@i\",\"facebookexternalhit\",\"go-http-client\",\"google-adwords-instant\",\"adsbot-google\",\"googlebot\",\"googleyoutube\",\"ioncrawl\",\"chrome-lighthouse\",\"gtmetrix\",\"rankmathapi\",\"validator.w3.org\",\"zoominfobot\",\"freshpingbot\",\"wordpress\\/\",\"applebot\\/\",\"python-requests\\/\",\"slackbot\",\"uptimemonitor\",\"crawler_eb\",\"@\\\\s+web\\\\s+spider\\\\W@i\",\"dnbcrawler\",\"stormcrawler\",\"@df\\\\s+bot@\",\"webprosbot\",\"researchoftheweb\",\"siteanalyzerbot\",\"@2ip\\\\s+bot@\",\"ahrefs\",\"mj12bot\",\"bsbot\",\"okhttp\",\"phxbot\",\"sansanbot\",\"scrapy\",\"researchscan\"]},\"test\":{\"contDelay\":false,\"contDelayTimeout\":5000,\"contExtra\":false,\"contExtraSize\":524288},\"hdrTrace\":false,\"debugInfo\":false,\"debug\":false,\"emojiIcons\":false,\"log\":false,\"logScope\":{\"upd\":false,\"srvClr\":false,\"request\":false,\"requestSkipped\":true,\"requestSkippedAdmin\":true,\"requestBots\":true},\"asyncUseCron\":true,\"asyncMode\":\"\",\"v\":135}","auto"),
("2139","seraph_accel_Data","{\"v\":1,\"vPrev\":0,\"queueDbVer\":4}","auto"),
("2140","seraph_accel_Lic","{\"data\":\"os3:aYsDUGliWOJ2Qn2nuF5eRRftNeNZ09lmRmNkFSbhHSvv50Kw+DkQgLgj4oegc52Uu4E3\\/ek3wBRUy75DULNRYKLhUm4o7a7xhQGISkU27+huJ5l0n2aT3Q3DS9QoFdd2MN4V+T+vHQXwiSnADYHLEA==\",\"v\":1,\"vPrev\":0}","auto"),
("2142","seraph_secretKey","xw#ug83R`ySswU#hvH{ekxI0-h=7Qd5S=j[0+0P6L~Sin5az:EAWZOp4~pchLveK","auto"),
("2155","seraph_accel_procEndLastTime","0","off"),
("2156","seraph_accel_queueProcessItemNext","1740926996","off"),
("2162","code_snippets_version","3.6.5.1","auto"),
("2163","code_snippets_settings","a:3:{s:5:\"debug\";a:0:{}s:7:\"general\";a:8:{s:19:\"activate_by_default\";b:1;s:11:\"enable_tags\";b:1;s:18:\"enable_description\";b:1;s:18:\"visual_editor_rows\";i:5;s:10:\"list_order\";s:12:\"priority-asc\";s:13:\"disable_prism\";b:0;s:17:\"hide_upgrade_menu\";b:0;s:18:\"complete_uninstall\";b:0;}s:6:\"editor\";a:11:{s:5:\"theme\";s:7:\"default\";s:16:\"indent_with_tabs\";b:1;s:8:\"tab_size\";i:4;s:11:\"indent_unit\";i:4;s:10:\"wrap_lines\";b:1;s:12:\"code_folding\";b:1;s:12:\"line_numbers\";b:1;s:19:\"auto_close_brackets\";b:1;s:27:\"highlight_selection_matches\";b:1;s:21:\"highlight_active_line\";b:1;s:6:\"keymap\";s:7:\"default\";}}","auto"),
("2315","mainwp_child_update_version","1.6","on"),
("2316","mainwp_child_plugin_version","5.1.1","on"),
("2317","mainwp_child_auth","a:7:{i:5;s:32:\"55faf731301265f52c0c991facb52b08\";s:4:\"last\";i:1740960894;i:4;s:32:\"fc39f4a652790266b55178af3d3d20f3\";i:3;s:32:\"c7bb27c96874c9dac06ebbac2ce24b82\";i:2;s:32:\"ad9ffcce153042f55e41d1b629e39a14\";i:1;s:32:\"792a91efc379af27006dba7aabf2f85f\";i:0;s:32:\"839b16f2ea2609f0180ae1b1484141c4\";}","on"),
("2318","mainwp_child_branding_settings","a:4:{s:13:\"contact_label\";s:15:\"Contact Support\";s:18:\"cancelled_branding\";b:0;s:23:\"branding_preserve_title\";s:0:\"\";s:21:\"branding_disconnected\";s:0:\"\";}","off"),
("2319","mainwp_child_activated_once","1","off"),
("2320","mainwp_cache_control_cache_solution","Plugin Not Found","auto"),
("2321","mainwp_child_actions_data_checked","1740960932","auto"),
("2322","mainwp_child_connected_admin","admin","on"),
("2323","mainwp_child_pubkey","LS0tLS1CRUdJTiBQVUJMSUMgS0VZLS0tLS0KTUlJQklqQU5CZ2txaGtpRzl3MEJBUUVGQUFPQ0FROEFNSUlCQ2dLQ0FRRUF0ZEpyUlV0aHJHOFN2VnAxVS9rcwpneS9NalFhYjFUYjYyUC9YT1g5Y3c1OEF0MS9HK0JucGFNdWtYOForUW9NbFQzb043UGpzNlQ1MTl6YitweGxDCm1lNEhLK0pKZG0vKzlqcEJ0bVAzR00zeDBxNXk1cWlnamNhd0FoVnpmTnV4WjZaRG11TW5PUHE3MU5XSEZCNDkKL1NyYTJqVDhENWdHY3VWZnJDenlXMWhSY0hZUXR4cktxVG1FVjd2UHNlZEMwYVBMR3hWcFhnSU03RjhjRTJZbwpBZVJ4SXlxMSs2cmxtWHByeGZ1K0xFMmRlYm1PVzI0cVpaaUtQUVltZmpUSjVEVFVsdGdESXFNK1hoMnNoMy8vClo4RzhoK09vMVdIREw1cmR1YXpDWmlvS092bUpFTVlPaDNHTEh1WEJocERRNlBRSXE2QVo2MVhTaXdkZEtHcksKeFFJREFRQUIKLS0tLS1FTkQgUFVCTElDIEtFWS0tLS0tCg==","on"),
("2324","mainwp_child_server","9MJnhpz2NbzbUOl6v63lg2JNIFj8ZELrB9RiZyRVTdSmitFxpguyBUhfatFAVbG79wsZtfzIQEZqbjS6uAnB","off"),
("2325","mainwp_child_nonce","0","off"),
("2326","mainwp_premium_updates","a:0:{}","off"),
("2327","mainwp_child_openssl_sign_algo","7","auto"),
("2338","mainwp_child_actions_saved_data","a:5:{s:15:\"connected_admin\";s:5:\"admin\";i:17409609602720;a:7:{s:7:\"context\";s:7:\"plugins\";s:6:\"action\";s:9:\"installed\";s:11:\"action_user\";s:5:\"admin\";s:7:\"created\";i:1740960960;s:7:\"summary\";s:69:\"Installed plugin: All-in-One WP Migration Google Drive Extension 2.86\";s:9:\"meta_data\";a:6:{s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:46:\"All-in-One WP Migration Google Drive Extension\";s:7:\"version\";s:4:\"2.86\";s:4:\"slug\";s:40:\"all-in-one-wp-migration-gdrive-extension\";s:7:\"success\";b:1;s:9:\"meta_data\";a:6:{s:7:\"user_id\";i:1;s:12:\"display_name\";s:5:\"admin\";s:11:\"action_user\";s:5:\"admin\";s:4:\"role\";s:13:\"administrator\";s:15:\"user_role_label\";s:13:\"Administrator\";s:5:\"agent\";s:0:\"\";}}s:3:\"new\";i:0;}i:17409609661904;a:7:{s:7:\"context\";s:7:\"plugins\";s:6:\"action\";s:9:\"activated\";s:11:\"action_user\";s:5:\"admin\";s:7:\"created\";i:1740960966;s:7:\"summary\";s:66:\"\"All-in-One WP Migration Google Drive Extension\" plugin activated \";s:9:\"meta_data\";a:3:{s:4:\"name\";s:46:\"All-in-One WP Migration Google Drive Extension\";s:4:\"slug\";s:85:\"all-in-one-wp-migration-gdrive-extension/all-in-one-wp-migration-gdrive-extension.php\";s:9:\"meta_data\";a:6:{s:7:\"user_id\";i:1;s:12:\"display_name\";s:5:\"admin\";s:11:\"action_user\";s:5:\"admin\";s:4:\"role\";s:13:\"administrator\";s:15:\"user_role_label\";s:13:\"Administrator\";s:5:\"agent\";s:0:\"\";}}s:3:\"new\";i:0;}i:17409610504036;a:7:{s:7:\"context\";s:7:\"plugins\";s:6:\"action\";s:9:\"installed\";s:11:\"action_user\";s:5:\"admin\";s:7:\"created\";i:1740961050;s:7:\"summary\";s:41:\"Installed plugin: Duplicator Pro 4.5.16.4\";s:9:\"meta_data\";a:6:{s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:14:\"Duplicator Pro\";s:7:\"version\";s:8:\"4.5.16.4\";s:4:\"slug\";s:14:\"duplicator-pro\";s:7:\"success\";b:1;s:9:\"meta_data\";a:6:{s:7:\"user_id\";i:1;s:12:\"display_name\";s:5:\"admin\";s:11:\"action_user\";s:5:\"admin\";s:4:\"role\";s:13:\"administrator\";s:15:\"user_role_label\";s:13:\"Administrator\";s:5:\"agent\";s:0:\"\";}}s:3:\"new\";i:0;}i:17409610781855;a:7:{s:7:\"context\";s:7:\"plugins\";s:6:\"action\";s:9:\"activated\";s:11:\"action_user\";s:5:\"admin\";s:7:\"created\";i:1740961078;s:7:\"summary\";s:34:\"\"Duplicator Pro\" plugin activated \";s:9:\"meta_data\";a:3:{s:4:\"name\";s:14:\"Duplicator Pro\";s:4:\"slug\";s:33:\"duplicator-pro/duplicator-pro.php\";s:9:\"meta_data\";a:6:{s:7:\"user_id\";i:1;s:12:\"display_name\";s:5:\"admin\";s:11:\"action_user\";s:5:\"admin\";s:4:\"role\";s:13:\"administrator\";s:15:\"user_role_label\";s:13:\"Administrator\";s:5:\"agent\";s:0:\"\";}}s:3:\"new\";i:0;}}","auto"),
("2340","ai1wmge_plugin_key","4ea8a7b4-aa06-4077-833c-50da0f6d066f","auto"),
("2346","ai1wmue_plugin_key","e2a28d85-8164-4c35-ab46-88fe75d5b12e","auto"),
("2352","mainwp_child_clone_sites","0","off"),
("2353","mainwp_child_siteid","40","off"),
("2354","mainwp_child_actions_saved_number_of_days","30","off"),
("2355","mainwp_child_auto_purge_cache","0","auto"),
("2356","mainwp_child_cloud_flair_enabled","0","auto"),
("2357","mainwp_child_pingnonce","2cc39c76dc","off"),
("2359","duplicator_pro_reset_user_settings_required","0","auto"),
("2360","edd_sl_d4cddcbfacec1cb84c2108addd3c8f99","a:2:{s:7:\"timeout\";i:1740971889;s:5:\"value\";s:5:\"false\";}","off"),
("2361","duplicator_pro_plugin_version","4.5.16.4","on"),
("2394","wordfence_ls_version","1.1.12","auto"),
("2395","wfls_last_role_change","1724269142","off"),
("2396","wordfence_version","7.11.7","auto"),
("2397","wordfence_case","1","auto"),
("2398","wordfence_installed","1","auto"),
("2399","wordfenceActivated","1","auto"),
("2400","wf_plugin_act_error","","auto"),
("2446","wordfence_syncAttackDataAttempts","0","off"),
("2447","wordfence_syncingAttackData","0","off"),
("2448","wordfence_lastSyncAttackData","1740458630","off"),
("2514","ai1wm_secret_key","Gw2emxERhnNR","auto"),
("2515","ai1wm_backups_labels","a:0:{}","auto"),
("2516","ai1wm_sites_links","a:0:{}","auto"),
("2517","ai1wm_status","a:3:{s:4:\"type\";s:4:\"done\";s:5:\"title\";s:41:\"Your site has been imported successfully!\";s:7:\"message\";s:378:\"» <a class=\"ai1wm-no-underline\" href=\"https://best-ultrawin.com/wp-admin/options-permalink.php#submit\" target=\"_blank\">Save permalinks structure</a>. (opens a new window)<br />» <a class=\"ai1wm-no-underline\" href=\"https://wordpress.org/support/view/plugin-reviews/all-in-one-wp-migration?rate=5#postform\" target=\"_blank\">Optionally, review the plugin</a>. (opens a new window)\";}","auto"),
("2528","_transient_rank_math_first_submenu_id","rank-math","on"),
("2546","_site_transient_ai1wm_last_check_for_updates","1740924545","off"),
("2553","_site_transient_wp_plugin_dependencies_plugin_data","a:0:{}","off"),
("3219","_transient_health-check-site-status-result","{\"good\":19,\"recommended\":4,\"critical\":0}","on"),
("5018","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:26:\"admin@staging-projects.com\";s:7:\"version\";s:5:\"6.7.2\";s:9:\"timestamp\";i:1739328105;}","off"),
("10140","rank_math_review_notice_added","1","off"),
("10145","rank_math_pro_notice_added","1","off"),
("11032","rank_math_pro_version","3.0.25","auto"),
("11035","rank_math_pro_google_updates","[{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/unconfirmed-local-update-jan-2025\\/\",\"title\":\"Unconfirmed Google Local Ranking Update (Jan 2025)\",\"content\":\"There were reports of an unconfirmed algorithm update to Google\\u0027s local ranking system between January 5 and 6, 2025. However, most bloggers and SEOs believe the supposed update was actually a bug, which has now been resolved. \",\"date\":\"1736035200\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/december-2024-spam-update\\/\",\"title\":\"December 2024 Spam Update\",\"content\":\"Google released the December 2024 Spam Update on December 19, 2024 and completed it on December 26, 2024.  The update lasted for a week as Google expected and may have been Google largest spam update ever.\",\"date\":\"1734566400\",\"status\":\"confirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/december-2024-core-update\\/\",\"title\":\"December 2024 Core Update\",\"content\":\"Google released the December 2024 Core Update on December 12, 2024, and ended it abruptly on December 18, 2024. The update caused volatilities on search results pages with many sites earning traffic and many others losing it. \",\"date\":\"1733961600\",\"status\":\"confirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/november-2024-core-update\\/\",\"title\":\"November 2024 Core Update\",\"content\":\"Google released the November 2024 Core Update between November 11 and December 5, 2024. The update is intended to provide searchers with more helpful results and reduce the appearance of content created specifically to rank on search results pages.\",\"date\":\"1731283200\",\"status\":\"confirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/prolonged-volatility-sep-oct-2024\\/\",\"title\":\"Prolonged Google SERP Volatility (September – October 2024)\",\"content\":\"Google results pages have been experiencing prolonged volatility that has caused massive traffic loss since September 3, 2024. While many believe this may be due to an unconfirmed update, the cause remains unclear.\",\"date\":\"1725321600\",\"status\":\"unconfirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/august-2024-core-update\\/\",\"title\":\"August 2024 Core Update\",\"content\":\"Google released the August 2024 Core Update on August 15, 2024, the same day it experienced a ranking issue that was resolved a few days later. The update was completed on September 3, 2024. \",\"date\":\"1723680000\",\"status\":\"confirmed\"},{\"link\":\"https:\\/\\/rankmath.com\\/google-update\\/august-2024-ranking-issue\\/\",\"title\":\"August 2024 Ranking Issue\",\"content\":\"Google experienced a ranking issue that affected its search results pages between August 15 and 20, 2024. The issue began the same day Google released the August 2024 Core Update although Google clarified that both are unrelated. \",\"date\":\"1723680000\",\"status\":\"confirmed\"}]","off"),
("11041","action_scheduler_migration_status","complete","auto"),
("11333","rank_math_sitemap_cache_files","a:2:{s:46:\"rank_math_4dd0290b79e88f50dc50362c64b308c9.xml\";s:1:\"1\";s:46:\"rank_math_138228f061cd97ec28b3a13a7d130dd3.xml\";s:4:\"page\";}","auto"),
("14833","db_upgraded","","on"),
("14870","_transient_wp_styles_for_blocks","a:2:{s:4:\"hash\";s:32:\"d628f052e74dd68e056ff310c53482e0\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}","on"),
("37107","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.7.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.7.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.7.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.7.2-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.7.2\";s:7:\"version\";s:5:\"6.7.2\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1740961049;s:15:\"version_checked\";s:5:\"6.7.2\";s:12:\"translations\";a:0:{}}","off"),
("39182","rank_math_notifications","a:0:{}","auto"),
("40361","_site_transient_timeout_php_check_38979a08dcd71638878b7b4419751271","1741525713","off"),
("40362","_site_transient_php_check_38979a08dcd71638878b7b4419751271","a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}","off"),
("40377","_site_transient_update_themes","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1740961052;s:7:\"checked\";a:5:{s:13:\"generatepress\";s:5:\"3.4.0\";s:16:\"twentytwentyfive\";s:3:\"1.0\";s:16:\"twentytwentyfour\";s:3:\"1.2\";s:17:\"twentytwentythree\";s:3:\"1.5\";s:15:\"twentytwentytwo\";s:3:\"1.8\";}s:8:\"response\";a:5:{s:13:\"generatepress\";a:6:{s:5:\"theme\";s:13:\"generatepress\";s:11:\"new_version\";s:5:\"3.5.1\";s:3:\"url\";s:43:\"https://wordpress.org/themes/generatepress/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/generatepress.3.5.1.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"7.4\";}s:16:\"twentytwentyfive\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfive\";s:11:\"new_version\";s:3:\"1.1\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfive/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfive.1.1.zip\";s:8:\"requires\";s:3:\"6.7\";s:12:\"requires_php\";s:3:\"7.2\";}s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.3.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.6.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:15:\"twentytwentytwo\";a:6:{s:5:\"theme\";s:15:\"twentytwentytwo\";s:11:\"new_version\";s:3:\"1.9\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentytwo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentytwo.1.9.zip\";s:8:\"requires\";s:3:\"5.9\";s:12:\"requires_php\";s:3:\"5.6\";}}s:9:\"no_update\";a:0:{}s:12:\"translations\";a:0:{}}","off"),
("40489","_site_transient_timeout_wp_theme_files_patterns-1fc4e11cfb59b8e280b4932e654eef41","1740961729","off"),
("40490","_site_transient_wp_theme_files_patterns-1fc4e11cfb59b8e280b4932e654eef41","a:2:{s:7:\"version\";s:5:\"3.4.0\";s:8:\"patterns\";a:0:{}}","off"),
("40493","_transient_timeout_wfcredentialstatus_1","1740964529","off"),
("40494","_transient_wfcredentialstatus_1","084d3cc84007e9ae4edab39c1ed021c7df26d49ddb968c7c7cc0944f0f3ab0e77","off"),
("40495","_site_transient_timeout_browser_6dbb10952a38c11d19e2648023d5055b","1741565733","off"),
("40496","_site_transient_browser_6dbb10952a38c11d19e2648023d5055b","a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"133.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","off"),
("40497","_site_transient_timeout_theme_roots","1740962734","off"),
("40498","_site_transient_theme_roots","a:5:{s:13:\"generatepress\";s:7:\"/themes\";s:16:\"twentytwentyfive\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";s:15:\"twentytwentytwo\";s:7:\"/themes\";}","off"),
("40499","_transient_timeout_rank_math_feed_posts_v2","1741004135","off"),
("40500","_transient_rank_math_feed_posts_v2","a:4:{i:0;a:5:{s:5:\"title\";a:1:{s:8:\"rendered\";s:51:\"Content AI 2.0: Introducing AI SEO Inside WordPress\";}s:4:\"date\";s:19:\"2025-03-02 23:01:24\";s:4:\"link\";s:62:\"https://rankmath.com/blog/introducing-supercharged-content-ai/\";s:12:\"custom_label\";s:0:\"\";s:9:\"condition\";s:0:\"\";}i:1;a:3:{s:5:\"title\";a:1:{s:8:\"rendered\";s:49:\"Win a Free iPhone 16 Pro Max (Rank Math Giveaway)\";}s:4:\"date\";s:19:\"2025-02-18 17:52:01\";s:4:\"link\";s:35:\"https://rankmath.com/blog/giveaway/\";}i:2;a:3:{s:5:\"title\";a:1:{s:8:\"rendered\";s:43:\"5 Best Rewording Tools for Flawless Content\";}s:4:\"date\";s:19:\"2025-01-31 16:30:57\";s:4:\"link\";s:47:\"https://rankmath.com/blog/best-rewording-tools/\";}i:3;a:3:{s:5:\"title\";a:1:{s:8:\"rendered\";s:58:\"5 Best AI Content Idea Generators to Spark Your Creativity\";}s:4:\"date\";s:19:\"2025-01-23 18:20:56\";s:4:\"link\";s:58:\"https://rankmath.com/blog/best-ai-content-idea-generators/\";}}","off"),
("40501","can_compress_scripts","1","on"),
("40502","_site_transient_timeout_community-events-5482d18b1b1835b925a709deab3dc30c","1741004136","off"),
("40503","_site_transient_community-events-5482d18b1b1835b925a709deab3dc30c","a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:11:\"183.83.52.0\";}s:6:\"events\";a:2:{i:0;a:10:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:37:\"Women WordPress Day 2025 Delhi, India\";s:3:\"url\";s:50:\"https://events.wordpress.org/delhi/2025/WomensDay/\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2025-03-08 14:30:00\";s:8:\"end_date\";s:19:\"2025-03-08 14:30:00\";s:20:\"start_unix_timestamp\";i:1741424400;s:18:\"end_unix_timestamp\";i:1741424400;s:8:\"location\";a:4:{s:8:\"location\";s:12:\"Delhi, India\";s:7:\"country\";s:2:\"IN\";s:8:\"latitude\";d:28.6308044;s:9:\"longitude\";d:77.2226253;}}i:1;a:10:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:37:\"Women WordPress Day 2025 Ajmer, India\";s:3:\"url\";s:50:\"https://events.wordpress.org/ajmer/2025/WomensDay/\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2025-03-08 17:35:00\";s:8:\"end_date\";s:19:\"2025-03-08 17:35:00\";s:20:\"start_unix_timestamp\";i:1741435500;s:18:\"end_unix_timestamp\";i:1741435500;s:8:\"location\";a:4:{s:8:\"location\";s:12:\"Ajmer, India\";s:7:\"country\";s:2:\"IN\";s:8:\"latitude\";d:26.4807783;s:9:\"longitude\";d:74.6312489;}}}}","off"),
("40504","_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3","1741004136","off"),
("40505","_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3","a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"The latest news about WordPress and the WordPress community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 22 Feb 2025 15:04:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.8-alpha-59827\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Shaping Tomorrow at WordCamp Asia 2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://wordpress.org/news/2025/02/shaping-tomorrow-at-wordcamp-asia-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 22 Feb 2025 15:04:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18515\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:394:\"Over 1,400 attendees from 71 countries gathered at the Philippine International Convention Center in Manila, and nearly 15,000 more joined online, for WordCamp Asia 2025. It&#8217;s the people. It&#8217;s the friendships and the stories. Matt Mullenweg, WordPress Cofounder The flagship WordPress event started with a dedicated Contributor Day, followed by two days of engaging talks, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Nicholas Garofalo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:53681:\"\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"512\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-WCAsia-02-21-PM_1280x640-1-scaled-1.jpg?resize=1024%2C512&#038;ssl=1\" alt=\"WordCamp Asia 2025 attendees gathered for a group photo\" class=\"wp-image-18521\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-WCAsia-02-21-PM_1280x640-1-scaled-1-scaled.jpg?resize=1024%2C512&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-WCAsia-02-21-PM_1280x640-1-scaled-1-scaled.jpg?resize=300%2C150&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-WCAsia-02-21-PM_1280x640-1-scaled-1-scaled.jpg?resize=768%2C384&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-WCAsia-02-21-PM_1280x640-1-scaled-1-scaled.jpg?resize=1536%2C768&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-WCAsia-02-21-PM_1280x640-1-scaled-1-scaled.jpg?resize=2048%2C1024&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Over 1,400 attendees from 71 countries gathered at the Philippine International Convention Center in Manila, and nearly 15,000 more joined online, for WordCamp Asia 2025.</p>\n\n\n\n<div class=\"wp-block-group is-nowrap is-layout-flex wp-container-core-group-is-layout-1 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-pullquote alignwide has-text-align-center\"><blockquote><p>It&#8217;s the people. It&#8217;s the friendships and the stories.</p><cite>Matt Mullenweg, WordPress Cofounder</cite></blockquote></figure>\n</div>\n\n\n\n<p>The flagship WordPress event started with a dedicated Contributor Day, followed by two days of engaging talks, panels, hands-on workshops, and networking. Notable guests included WordPress Cofounder <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> and Gutenberg Lead Architect <a href=\"https://profiles.wordpress.org/matveb/\">Matías Ventura</a>, who were joined by a diverse lineup of speakers and panelists.</p>\n\n\n\n<p>Throughout the event, the sponsor hall buzzed with activity as companies from across the WordPress ecosystem showcased their latest products, engaged with attendees, and offered live demos and giveaways.&nbsp;Each day, attendees refueled with diverse food offerings featuring Filipino favorites, turning meals into a prime networking opportunity where new connections were made and ideas were exchanged.</p>\n\n\n\n<h2 class=\"wp-block-heading\">New Ways to Engage</h2>\n\n\n\n<p>This year’s event introduced several new programs to the schedule:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Solutions Spotlight</strong>—a series of dynamic 10-minute lightning talks that gave an inside look at innovative products, cutting-edge strategies, and real-world solutions from top-tier sponsors, all designed to help attendees succeed in the WordPress ecosystem. These fast-paced sessions offered a unique opportunity to discover how leading brands are solving challenges, empowering users, and shaping the future of WordPress.</li>\n\n\n\n<li><strong>YouthCamp</strong>, a dedicated event for kids and teens ages 8-17, offered a full day of free, hands-on sessions designed to spark creativity and introduce the world of WordPress and open source. Through interactive workshops covering web basics, design, and development, participants gained practical skills while exploring the power of building online.&nbsp;</li>\n\n\n\n<li>The new <strong>Career and Social Corners</strong> enhanced networking, fostered meaningful connections, and created new opportunities for those within the WordPress community. Career Corner was the go-to space for attendees exploring career opportunities, connecting with sponsors, and discovering exciting new roles. Meanwhile, Social Corner offered a relaxed, lounge-style environment where attendees could engage in informal discussions over refreshments.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Contributor Day</h2>\n\n\n\n<p>WordCamp Asia kicked off with an incredible Contributor Day, bringing together almost 800 contributors, many of them new, to collaborate, share knowledge, and give back to WordPress. With 37 dedicated table leads and 16 experts from the Human Library guiding the way, participants of all experience levels engaged in meaningful discussions, tackled important tasks, and made a lasting impact on the WordPress project.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-border-color has-darker-grey-background-color has-background wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-color:#1c2024;border-width:20px;border-radius:2px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f6db9e&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18526\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1834.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18526\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1834-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1834-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1834-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1834-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1834-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f6df52&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18537\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1914.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18537\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1914-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1914-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1914-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1914-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1914-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"(max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f6e262&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18527\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1989.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18527\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1989-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1989-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1989-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1989-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1989-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f6e573&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18524\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1926.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18524\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1926-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1926-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1926-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1926-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1926-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f6e881&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18530\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1920.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18530\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1920-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1920-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1920-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1920-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1920-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f6eba3&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18525\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1963.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18525\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1963-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1963-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1963-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1963-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1963-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f6eff4&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18528\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1902.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18528\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1902-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1902-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1902-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1902-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1902-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f6f320&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18534\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1886.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18534\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1886-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1886-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1886-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1886-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1886-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f6f759&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18531\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1885.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18531\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1885-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1885-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1885-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1885-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1885-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f6fb9a&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18536\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC07465.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18536\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC07465-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC07465-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC07465-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC07465-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC07465-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>Key contributions included resolving a critical media bug, advancing vertical text editing in Gutenberg, and refining the editing experience with dozens of issue closures. Performance optimizations and accessibility improvements abounded, joined by seven fresh patterns, and over 4,000 newly translated strings.</p>\n\n\n\n<p>New tools and workflows were explored to enhance testing and development. The day also saw meaningful conversations between hosting providers and users, improvements to event organizing processes, and hands-on training.</p>\n\n\n\n<p>With innovative ideas, new faces, and significant progress across multiple areas, Contributor Day reinforced the spirit of open source collaboration that drives WordPress forward.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The Future is WordPress</h2>\n\n\n\n<p>On the first full conference day, attendees gathered to celebrate the power of open source collaboration and innovation. Opening remarks from global and local event leads reflected on the incredible journey of WordCamp Asia, tracing its roots back to the first Southeast Asian WordCamp in Manila in 2008. This full-circle moment underscored how the WordPress community has flourished over the years, driven by shared knowledge and a commitment to an open web. The excitement continued with a highly anticipated opening keynote from Matías Ventura, who shared insights into the future of Gutenberg and WordPress, inspiring attendees to embrace the next wave of innovation and creativity in content publishing.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"There and Back Again\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/-Zgv2q5NHBA?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>The day then began in earnest. Talks highlighted new ways to integrate WordPress with external applications, opening possibilities for more interactive and scalable digital experiences. Simultaneously, content strategists and marketers explored evolving best practices in SEO, learning how to optimize their sites for visibility, engagement, and long-term growth. These sessions emphasized the importance of adaptability in a constantly evolving digital landscape, ensuring that WordPress users stay ahead of industry trends.</p>\n\n\n\n<p>Workshops throughout the day provided hands-on learning experiences tailored to a wide range of skill levels. Developers refined their expertise, gaining practical knowledge they could apply to their own projects. Accessibility advocates led discussions on designing for inclusivity, showcasing strategies to make WordPress-powered websites more navigable and user-friendly for people of all abilities.</p>\n\n\n\n<p>As the conference continued into the afternoon, conversations expanded to performance optimization and emerging technologies shaping the future of WordPress. A dedicated session explored AI-driven workflows, demonstrating how artificial intelligence can enhance site performance, automate repetitive tasks, and create more personalized user experiences. These discussions showcased the evolving role of WordPress as a versatile platform that extends beyond traditional publishing.</p>\n\n\n\n<p>The first day culminated in a thought-provoking keynote panel, WordPress in 2030, where industry leaders explored the future of the platform. The discussion covered the expanding open source community, emerging technologies, and the role of education and mentorship. Panelists shared their perspectives on the opportunities and challenges ahead, encouraging attendees to actively shape the future of WordPress by contributing, innovating, and advocating for an open web.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"442\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-CleanShot-2025-02-22-at-07.42.19%402x.jpg?resize=1024%2C442&#038;ssl=1\" alt=\"Panelists Noel Tock, Hong Phuc Dang, Jon Ang, Courtney Robertson, and Raquel Manriquez discuss WordPress in 2030\" class=\"wp-image-18561\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-CleanShot-2025-02-22-at-07.42.19%402x-scaled.jpg?resize=1024%2C442&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-CleanShot-2025-02-22-at-07.42.19%402x-scaled.jpg?resize=300%2C129&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-CleanShot-2025-02-22-at-07.42.19%402x-scaled.jpg?resize=768%2C331&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-CleanShot-2025-02-22-at-07.42.19%402x-scaled.jpg?resize=1536%2C663&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-CleanShot-2025-02-22-at-07.42.19%402x-scaled.jpg?resize=2048%2C883&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Returning for the final day of WordCamp Asia 2025, attendees explored a new set of sessions designed to push the boundaries of web development and strategy. Technical discussions on advanced Gutenberg block development highlighted innovative ways to build more dynamic and interactive content experiences, while another session examined performance optimization strategies to enhance site speed, accessibility, and overall user engagement. Content creators and marketers gained valuable insights into audience growth, effective storytelling, and data-driven content strategies to maximize impact.</p>\n\n\n\n<p>The final sessions of the conference reinforced WordPress’s adaptability and innovation, equipping attendees with new skills and strategies.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Q&amp;A</h2>\n\n\n\n<p>As the final day drew to a close, Matt shared historic photos from WordCamp Davao 2008 in the Philippines, and then answered questions from the audience.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<span class=\"embed-youtube\" style=\"text-align:center; display: block;\"><iframe loading=\"lazy\" class=\"youtube-player\" width=\"600\" height=\"338\" src=\"https://www.youtube.com/embed/LEm2NXwbZKc?version=3&#038;rel=1&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;fs=1&#038;hl=en-US&#038;autohide=2&#038;wmode=transparent\" allowfullscreen=\"true\" style=\"border:0;\" sandbox=\"allow-scripts allow-same-origin allow-popups allow-presentation allow-popups-to-escape-sandbox\"></iframe></span>\n</div></figure>\n\n\n\n<p>Questions covered a variety of topics, incluiding: publishing on the open web, AI, headless WordPress, education, and Matt’s personal motivations. It was clear throughout the Q&amp;A that the future of WordPress is as bright as the island-themed attire at the event’s after-party.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Closing</h2>\n\n\n\n<p>Thank you to all the hard-working organizers who made this event possible, the speakers who took the stage, the visitors who ventured to Manila, and everyone who tuned in from around the world. Our hope is that every WordCamp attendee leaves with new knowledge, new friends, and new inspiration to build a better web.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped has-border-color has-darker-grey-background-color has-background wp-block-gallery-2 is-layout-flex wp-block-gallery-is-layout-flex\" style=\"border-color:#1c2024;border-width:20px;border-radius:2px\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f70877&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18533\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1853.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18533\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1853-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1853-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1853-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1853-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1853-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f70dc7&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"684\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18547\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-T2S_5388.jpg?resize=1024%2C684&#038;ssl=1\" alt=\"\" class=\"wp-image-18547\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-T2S_5388-scaled.jpg?resize=1024%2C684&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-T2S_5388-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-T2S_5388-scaled.jpg?resize=768%2C513&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-T2S_5388-scaled.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-T2S_5388-scaled.jpg?resize=2048%2C1367&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f7125f&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18535\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1877.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18535\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1877-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1877-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1877-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1877-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1877-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f7168b&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18523\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1800.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18523\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1800-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1800-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1800-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1800-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1800-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f71ad2&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18532\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1861.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18532\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1861-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1861-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1861-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1861-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1861-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f71f1c&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18529\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1860.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18529\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1860-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1860-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1860-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1860-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1860-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f72348&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18545\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-250221_12-35-12_N7A00461_NExT.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18545\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-250221_12-35-12_N7A00461_NExT-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-250221_12-35-12_N7A00461_NExT-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-250221_12-35-12_N7A00461_NExT-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-250221_12-35-12_N7A00461_NExT-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-250221_12-35-12_N7A00461_NExT-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f72768&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18543\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-DSC_2549.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18543\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-DSC_2549-scaled.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-DSC_2549-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-DSC_2549-scaled.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-DSC_2549-scaled.jpg?resize=1536%2C1024&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-DSC_2549-scaled.jpg?resize=2048%2C1365&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f72a8c&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"684\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18546\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-IMG_3709.jpg?resize=1024%2C684&#038;ssl=1\" alt=\"\" class=\"wp-image-18546\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-IMG_3709-scaled.jpg?resize=1024%2C684&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-IMG_3709-scaled.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-IMG_3709-scaled.jpg?resize=768%2C513&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-IMG_3709-scaled.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-IMG_3709-scaled.jpg?resize=2048%2C1367&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f72d7d&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large has-custom-border wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"768\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18540\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-b9848a28-a181-47dc-80af-4d2eb6a72756.jpg?resize=1024%2C768&#038;ssl=1\" alt=\"\" class=\"wp-image-18540\" style=\"border-radius:2px\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-b9848a28-a181-47dc-80af-4d2eb6a72756.jpg?resize=1024%2C768&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-b9848a28-a181-47dc-80af-4d2eb6a72756.jpg?resize=300%2C225&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-b9848a28-a181-47dc-80af-4d2eb6a72756.jpg?resize=768%2C576&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-b9848a28-a181-47dc-80af-4d2eb6a72756.jpg?resize=1536%2C1152&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-b9848a28-a181-47dc-80af-4d2eb6a72756.jpg?w=1600&amp;ssl=1 1600w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>Be sure to mark your calendars for other major WordPress events in 2025: <a href=\"https://europe.wordcamp.org/2025/\">WordCamp Europe</a> (Basel, Switzerland) and<a href=\"https://us.wordcamp.org/2025/\"> WordCamp US</a> (Portland, Oregon, USA). Then join us in Mumbai, India for WordCamp Asia 2026!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18515\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Report: WordPress in 2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2025/02/wordpress-in-2025-report/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 15 Feb 2025 03:19:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18475\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:379:\"This year is set to be transformative for WordPress, yet many decision-makers risk overlooking the immense opportunities ahead. Our new “WordPress in 2025” report highlights why WordPress should be a cornerstone of your long-term strategy. Stay ahead of the curve—read the report now to see how WordPress can drive growth and innovation for your business in the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Noel Tock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3721:\"\n<p>This year is set to be transformative for WordPress, yet many decision-makers risk overlooking the immense opportunities ahead. Our new <strong>“WordPress in 2025”</strong> report highlights why WordPress should be a cornerstone of your long-term strategy. Stay ahead of the curve—read the report now to see how WordPress can drive growth and innovation for your business in the years to come.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"647\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/WordPress-in-2025-WPORG-2.jpg?resize=1024%2C647&#038;ssl=1\" alt=\"\" class=\"wp-image-18476\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/WordPress-in-2025-WPORG-2.jpg?resize=1024%2C647&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/WordPress-in-2025-WPORG-2.jpg?resize=300%2C189&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/WordPress-in-2025-WPORG-2.jpg?resize=768%2C485&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/WordPress-in-2025-WPORG-2.jpg?resize=1536%2C970&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2025/02/WordPress-in-2025-WPORG-2.jpg?resize=2048%2C1293&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Some of the key points we explore:&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>As proprietary &#8220;next-gen&#8221; CMS hype fizzles out and enterprise budgets shift priorities, open-source CMSs like WordPress are primed to gain ground in the commoditized CMS space. WordPress&#8217; maturity and extensibility provide a high starting point for innovation.</li>\n\n\n\n<li>WordPress&#8217; Block Editor has seen tremendous investment, amassing over 34,000 commits &#8211; more than entire competing CMS projects. New capabilities like Full Site Editing (FSE) give enterprises unprecedented ability to enable no-code site building.</li>\n\n\n\n<li>Just as being the first user-friendly publishing tool propelled WordPress&#8217; initial growth, AI presents a similar opportunity. WordPress&#8217; contributor community can build not just AI features, but an exciting multi-agent, LLM-agnostic ecosystem representing an intelligent content operating system.</li>\n\n\n\n<li>Pure-play headless vendors are working backwards to add no-code editing, while WordPress has long supported robust headless capabilities alongside its mature editor. For complex sites, hybrid architectures leveraging both are the pragmatic path forward.</li>\n</ul>\n\n\n\n<p><a href=\"https://wordpress.org/news/files/2025/02/WordPress-in-2025-Report-Noel-Tock.pdf\">Download the full WordPress in 2025 (PDF)</a> report directly to learn more.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Don’t miss WP:25, the virtual event.</h3>\n\n\n\n<p><a href=\"https://humanmade.com/wordpress-in-2025-event/?utm_campaign=41192678-WordPress%20in%202025&amp;utm_source=event&amp;utm_medium=Noel%20sales%20outreach&amp;utm_content=event%20landing%20page\">Save your spot at our free event, WP:25</a>, exploring the future of WordPress and featuring key people working with many of the ideas discussed in the report. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p><strong>About the report&#8217;s author, <a href=\"https://profiles.wordpress.org/noel_tock/\">Noel Tock</a></strong> — Having built his first website back in 1995, Noel has long been watching the evolution of the CMS space. As a co-owner at one of the leading enterprise WordPress agencies, Human Made, his belief in the power of open source is as great as ever. Human Made is a WordPress VIP Gold Partner specializing in DXP, headless, AI and more.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18475\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WordCamp Asia 2025: Manila Magic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2025/02/wordcamp-asia-2025-manila-magic/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Feb 2025 16:04:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18482\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:409:\"The first major WordCamp of the year is here! WordCamp Asia 2025 lands in Manila, Philippines, from February 20-22, bringing together open source enthusiasts, developers, and WordPress professionals from across the region—and the world. With three packed days of learning, networking, and collaboration, this year’s event promises fresh insights, dynamic discussions, and plenty of opportunities [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Bernard Meyer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4837:\"\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"536\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/444990627_474578655140578_2659126618470753960_n.jpg?resize=1024%2C536&#038;ssl=1\" alt=\"WordCamp Asia 2025\" class=\"wp-image-18491\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2025/02/444990627_474578655140578_2659126618470753960_n.jpg?resize=1024%2C536&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2025/02/444990627_474578655140578_2659126618470753960_n.jpg?resize=300%2C157&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2025/02/444990627_474578655140578_2659126618470753960_n.jpg?resize=768%2C402&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2025/02/444990627_474578655140578_2659126618470753960_n.jpg?w=1200&amp;ssl=1 1200w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>The first major WordCamp of the year is here! <a href=\"https://asia.wordcamp.org/2025/\">WordCamp Asia 2025</a> lands in Manila, Philippines, from February 20-22, bringing together open source enthusiasts, developers, and WordPress professionals from across the region—and the world.</p>\n\n\n\n<p>With three packed days of learning, networking, and collaboration, this year’s event promises fresh insights, dynamic discussions, and plenty of opportunities to connect.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Solutions spotlight</h3>\n\n\n\n<p>Throughout the conference days, multiple presentations will focus on the solutions provided by our amazing sponsors. This is a great opportunity to learn more about their initiatives and solutions.</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-1 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://asia.wordcamp.org/2025/solutions-spotlight/\">Explore the solutions spotlight</a></div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Keynotes, panels, and deep dives</h3>\n\n\n\n<p>The main conference, which will be held on February 21-22, will feature <a href=\"https://asia.wordcamp.org/2025/schedule/#day-2\">a lineup of notable keynote speakers</a>, including digital innovation leaders and open-source advocates. Attendees can expect diverse sessions on business strategy, development of best practices, and technical advancements.</p>\n\n\n\n<p>For those looking to sharpen their skills, presentations will dive deep into topics like SEO for WordPress, performance optimization, and AI-powered content creation. Plus, don’t miss the electrifying WordPress Speed Build Battle, where developers race to create stunning sites in record time.</p>\n\n\n\n<h3 class=\"wp-block-heading\">YouthCamp</h3>\n\n\n\n<p>On February 22, WordCamp Asia 2025 will host <a href=\"https://asia.wordcamp.org/2025/youthcamp/\">YouthCamp</a>, a pre-registered event designed to introduce young minds to WordPress and its endless possibilities. This initiative aims to engage the next generation of WordPress users, developers, and contributors through hands-on activities and interactive sessions</p>\n\n\n\n<h3 class=\"wp-block-heading\">Closing Q&amp;A with Matt Mullenweg</h3>\n\n\n\n<p>WordPress Cofounder Matt Mullenweg will wrap up the event with a live Q&amp;A session on February 22. Whether attending in person or tuning in online, you can catch his insights live on the <a href=\"https://www.youtube.com/@WordPress\">WordPress YouTube channel</a> at 4:00 p.m. Philippine Time (08:00 UTC).</p>\n\n\n\n<h3 class=\"wp-block-heading\">After party</h3>\n\n\n\n<p>As the sun sets on WordCamp Asia 2025, the excitement continues with the After Party (theme: Island Vibe)! Get ready to experience the vibrant spirit of the Philippines with a lively gathering at <a href=\"https://www.picc.gov.ph/\">The Forum at PICC</a>. Expect a night filled with great conversations, music, and a celebration of the WordPress community.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get WordCamp-ready</h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Secure your <a href=\"https://asia.wordcamp.org/2025/tickets/\">WordCamp Asia 2025 tickets</a> (if you haven’t already!)</li>\n\n\n\n<li>Browse the <a href=\"https://asia.wordcamp.org/2025/schedule/\">full schedule of sessions</a> to plan your experience</li>\n\n\n\n<li>Follow WordCamp Asia on<strong> </strong><a href=\"https://x.com/WordCampAsia\">X</a>, <a href=\"https://www.linkedin.com/company/wordcampasia/\">LinkedIn</a>, and <a href=\"https://www.instagram.com/wordcampasia/\">Instagram</a> for real-time updates</li>\n</ul>\n\n\n\n<p>As always, be part of the conversation! Whether you’re attending in Manila or following along online, share your experiences using <strong>#WCAsia</strong> and <strong>#WordPress</strong>.</p>\n\n\n\n<p>Manila is calling—see you at WordCamp Asia 2025!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18482\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 6.7.2 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2025/02/wordpress-6-7-2-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Feb 2025 16:52:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18445\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:371:\"WordPress 6.7.2 is now available! This minor release includes 35 bug fixes, addressing issues affecting multiple components including the block editor, HTML API, and Customize. WordPress 6.7.2 is a short-cycle release. The next major release will be version 6.8 planned for April 15, 2025. If you have sites that support automatic background updates, the update [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Aaron Jorbin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8487:\"\n<h2 class=\"wp-block-heading\">WordPress 6.7.2 is now available!</h2>\n\n\n\n<p>This minor release includes <a href=\"https://make.wordpress.org/core/tag/6-7-2/\">35 bug fixes</a>, addressing issues affecting multiple components including the block editor, HTML API, and Customize.</p>\n\n\n\n<p>WordPress 6.7.2 is a short-cycle release. The next major release will be <a href=\"https://make.wordpress.org/core/6-8/\">version 6.8</a> planned for April 15, 2025.</p>\n\n\n\n<p>If you have sites that support automatic background updates, the update process will begin automatically.</p>\n\n\n\n<p>You can <a href=\"https://wordpress.org/wordpress-6.7.2.zip\">download WordPress 6.7.2 from WordPress.org</a>, or visit your WordPress Dashboard, click “Updates”, and then click “Update Now”. For more information on this release, please <a href=\"https://wordpress.org/support/wordpress-version/version-6-7-2\">visit the HelpHub site</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Thank you to these WordPress contributors</h2>\n\n\n\n<p>This release was led by <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>.</p>\n\n\n\n<p>WordPress 6.7.2 would not have been possible without the contributions of the following people. Their asynchronous coordination to deliver maintenance fixes into a stable release is a testament to the power and capability of the WordPress community.</p>\n\n\n\n<p class=\"is-style-wporg-props-long\"><a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/ajlende\">Alex Lende</a>, <a href=\"https://profiles.wordpress.org/alexandrebuffet\">Alexandre Buffet</a>, <a href=\"https://profiles.wordpress.org/bowedk\">Andreas Pedersen</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/ankitkumarshah\">Ankit Kumar Shah</a>, <a href=\"https://profiles.wordpress.org/apermo\">apermo</a>, <a href=\"https://profiles.wordpress.org/benniledl\">Benedikt Ledl</a>, <a href=\"https://profiles.wordpress.org/bernhard-reiter\">bernhard-reiter</a>, <a href=\"https://profiles.wordpress.org/ironprogrammer\">Brian Alexander</a>, <a href=\"https://profiles.wordpress.org/cbravobernal\">Carlos Bravo</a>, <a href=\"https://profiles.wordpress.org/poena\">Carolina Nymark</a>, <a href=\"https://profiles.wordpress.org/coquardcyr\">Cyrille</a>, <a href=\"https://profiles.wordpress.org/danielpost\">Daniel Post</a>, <a href=\"https://profiles.wordpress.org/darerodz\">darerodz</a>, <a href=\"https://profiles.wordpress.org/dpcalhoun\">David Calhoun</a>, <a href=\"https://profiles.wordpress.org/get_dave\">David Smith</a>, <a href=\"https://profiles.wordpress.org/dmsnell\">Dennis Snell</a>, <a href=\"https://profiles.wordpress.org/dhewercorus\">dhewercorus</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/dougwollison\">Doug Wollison</a>, <a href=\"https://profiles.wordpress.org/ellatrix\">Ella</a>, <a href=\"https://profiles.wordpress.org/im3dabasia1\">Eshaan Dabasiya</a>, <a href=\"https://profiles.wordpress.org/fabiankaegy\">Fabian Kägy</a>, <a href=\"https://profiles.wordpress.org/gaambo\">Fabian Todt</a>, <a href=\"https://profiles.wordpress.org/flixos90\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/ffffelix\">Felix Renicks</a>, <a href=\"https://profiles.wordpress.org/franciscabusas22\">Francis Cabusas</a>, <a href=\"https://profiles.wordpress.org/frankbiganski\">Frank B.</a>, <a href=\"https://profiles.wordpress.org/mamaduka\">George Mamadashvili</a>, <a href=\"https://profiles.wordpress.org/ghinamt\">ghinamt</a>, <a href=\"https://profiles.wordpress.org/glynnquelch\">Glynn Quelch</a>, <a href=\"https://profiles.wordpress.org/gziolo\">Greg Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/jameskoster\">James Koster</a>, <a href=\"https://profiles.wordpress.org/jsnajdr\">Jarda Snajdr</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jdnd\">jdnd</a>, <a href=\"https://profiles.wordpress.org/jeryj\">jeryj</a>, <a href=\"https://profiles.wordpress.org/joedolson\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/jonsurrell\">Jon Surrell</a>, <a href=\"https://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/juanwp22\">juanwp22</a>, <a href=\"https://profiles.wordpress.org/jrf\">Juliette Reinders Folmer</a>, <a href=\"https://profiles.wordpress.org/karthickmurugan\">Karthick</a>, <a href=\"https://profiles.wordpress.org/mt8biz\">Kazuto Takeshita</a>, <a href=\"https://profiles.wordpress.org/ryelle\">Kelly Choyce-Dwan</a>, <a href=\"https://profiles.wordpress.org/ketanniruke\">Ketan Niruke</a>, <a href=\"https://profiles.wordpress.org/0mirka00\">Lena Morita</a>, <a href=\"https://profiles.wordpress.org/levskipg\">levskipg</a>, <a href=\"https://profiles.wordpress.org/maciejmackowiak\">Maciej Ma?kowiak</a>, <a href=\"https://profiles.wordpress.org/santosguillamot\">Mario Santos</a>, <a href=\"https://profiles.wordpress.org/mboynes\">Matthew Boynes</a>, <a href=\"https://profiles.wordpress.org/mayanktripathi32\">Mayank Tripathi</a>, <a href=\"https://profiles.wordpress.org/czapla\">Michal Czaplinski</a>, <a href=\"https://profiles.wordpress.org/mcsf\">Miguel Fonseca</a>, <a href=\"https://profiles.wordpress.org/presstoke\">Mitchell Austin</a>, <a href=\"https://profiles.wordpress.org/mreishus\">mreishus</a>, <a href=\"https://profiles.wordpress.org/mukesh27\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/assassinateur\">Nadir Seghir a11n</a>, <a href=\"https://profiles.wordpress.org/narenin\">Narendra Sishodiya</a>, <a href=\"https://profiles.wordpress.org/nareshbheda\">Naresh Bheda</a>, <a href=\"https://profiles.wordpress.org/neotrope\">neotrope</a>, <a href=\"https://profiles.wordpress.org/ndiego\">Nick Diego</a>, <a href=\"https://profiles.wordpress.org/oglekler\">Olga Gleckler</a>, <a href=\"https://profiles.wordpress.org/parthvataliya\">Parth vataliya</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/paullb\">paullb</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/pitamdey\">Pitam Dey</a>, <a href=\"https://profiles.wordpress.org/redkite\">redkite</a>, <a href=\"https://profiles.wordpress.org/rishavdutta\">Rishav Dutta</a>, <a href=\"https://profiles.wordpress.org/robertstaddon\">robertstaddon</a>, <a href=\"https://profiles.wordpress.org/rvoigt\">rvoigt</a>, <a href=\"https://profiles.wordpress.org/mi5t4n\">Sagar Tamang</a>, <a href=\"https://profiles.wordpress.org/sainathpoojary\">Sainath Poojary</a>, <a href=\"https://profiles.wordpress.org/seanlanglands\">seanlanglands</a>, <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/shyamkariya\">Shyam Kariya</a>, <a href=\"https://profiles.wordpress.org/smerriman\">smerriman</a>, <a href=\"https://profiles.wordpress.org/sabernhardt\">Stephen Bernhardt</a>, <a href=\"https://profiles.wordpress.org/sukhendu2002\">Sukhendu Sekhar Guria</a>, <a href=\"https://profiles.wordpress.org/TobiasBg\">TobiasBg</a>, <a href=\"https://profiles.wordpress.org/hellofromTonya\">Tonya Mork</a>, <a href=\"https://profiles.wordpress.org/vishy-moghan\">Vishy Moghan</a>, <a href=\"https://profiles.wordpress.org/westonruter\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/wongjn\">wongjn</a>, <a href=\"https://profiles.wordpress.org/yogeshbhutkar\">Yogesh Bhutkar</a>, <a href=\"https://profiles.wordpress.org/zaoyao\">zaoyao</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">How to contribute</h2>\n\n\n\n<p>To get involved in WordPress core development, head over to Trac, <a href=\"https://core.trac.wordpress.org/report/6\">pick a ticket</a>, and join the conversation in the <a href=\"https://wordpress.slack.com/archives/C02RQBWTW\">#core</a> and <a href=\"https://wordpress.slack.com/archives/C080HLPP2Q6\">#6-8-release-leads</a> channels. Need help? Check out the <a href=\"https://make.wordpress.org/core/handbook/\">Core Contributor Handbook</a>.</p>\n\n\n\n<p class=\"has-text-align-right\"><em>Props to <a href=\"https://profiles.wordpress.org/joedolson/\">@joedolson</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">@joemcgill</a> and <a href=\'https://profiles.wordpress.org/audrasjb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>audrasjb</a> for proofreading.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18445\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Joost/Karim Fork\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://wordpress.org/news/2025/01/jkpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 Jan 2025 02:06:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Meta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18394\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:319:\"Making great software, great product that stands the test of time and not just survives but thrives through monumental technological shifts is incredibly hard. That challenge is part of the reason I love doing it. There is never a dull day, and the reward of seeing the code you wrote used by the most amazing [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9904:\"\n<p>Making great software, great product that stands the test of time and not just survives but thrives through monumental technological shifts is <em>incredibly hard</em>. That challenge is part of the reason I love doing it. There is never a dull day, and the reward of seeing the code you wrote used by the most amazing creators in the world is an indescribable pleasure. <strong>When I see what people create with WordPress, some days I feel like I’m grinding pigment for Leonardo da Vinci or slitting a quill for Beethoven.</strong></p>\n\n\n\n<p>In open source, one thing that makes it even harder to ship great software is bringing together disparate groups of contributors who may have entirely different incentives or missions or philosophies about how to make great work. Working together on a team is such a delicate balance, and even one person rowing in the wrong direction can throw everyone else off.</p>\n\n\n\n<p>That’s why periodically I think it is very healthy for open source projects to fork, it allows for people to try out and experiment with different forms of governance, leadership, decision-making, and technical approaches. As I&#8217;ve said, forking is beautiful, and <a href=\"https://wordpress.org/news/2024/10/spoon/\">forks have my full support and we&#8217;ll even link and promote them</a>.</p>\n\n\n\n<p><a href=\"https://joost.blog/\">Joost</a> is a self-proclaimed leader in the SEO space, an industry known for making the web better. He asked for and <a href=\"https://joost.blog/leading-marketing-communication-for-wordpress/\">I gave him WordPress marketing leadership responsibility</a> in January 2019 and <a href=\"https://joost.blog/why-im-stepping-down-from-my-wordpress-marketing-role/\">he stepped down in June of 2019</a>, I think we would both agree in those 5 months he was not effective at leading the marketing team or doing the work himself.</p>\n\n\n\n<p><a href=\"https://marucchi.com/\">Karim</a> leads a small WordPress agency called <a href=\"https://crowdfavorite.com/\">Crowd Favorite</a> which counts clients such as Lexus and ABC and employs ~50 people.</p>\n\n\n\n<p>Both are men I have shared meals with and consider of the highest integrity. I would trust them to watch any of my 15 godchildren for a day. These are good humans. Now go do the work. It probably won&#8217;t happen on day one, but Joost and Karim&#8217;s fork, which I&#8217;ll call JKPress until they come up with a better name, has a number of ideas they want to try out around governance and architecture. While Joost and Karim will be unilaterally in charge in the beginning, it sounds <a href=\"https://joost.blog/wordpress-leadership/\">like they want to set up</a>:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>A non-profit foundation, with a broad board to control their new project.</li>\n\n\n\n<li>A website owned by that foundation which hosts community resources like a plugin directory, forums, etc.</li>\n\n\n\n<li>No more centralized and moderated plugin and theme directories with security guidelines or restrictions are what plugins are allowed to do like putting banners in your admin or gathering data, everything done in a federated/distributed manner.</li>\n\n\n\n<li>The trademarks for their new project will either be public domain or held by their foundation.</li>\n\n\n\n<li>&#8220;Modernization&#8221; of the technology stack, perhaps going a Laravel-like approach or changing how WordPress&#8217; architecture works.</li>\n\n\n\n<li>Teams and committees to make decisions for everything, so no single person has too much power or authority.</li>\n</ol>\n\n\n\n<p><a href=\"https://marucchi.com/wordpress-leadership-continued/\">Karim has a similar post</a>. Joost says he has the time and energy to lead:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-rich is-provider-twitter wp-block-embed-twitter\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\" data-width=\"500\" data-dnt=\"true\"><p lang=\"en\" dir=\"ltr\">So <a href=\"https://twitter.com/photomatt?ref_src=twsrc%5Etfw\">@photomatt</a> &#8211; I saw the post by <a href=\"https://twitter.com/automattic?ref_src=twsrc%5Etfw\">@automattic</a>.<br><br>I&#39;m ready to lead the next releases. I am sure plenty of people and companies are willing to help me and we&#39;ve got plenty of ideas on what we should be doing.<a href=\"https://twitter.com/hashtag/WordPress?src=hash&amp;ref_src=twsrc%5Etfw\">#WordPress</a></p>&mdash; Joost de Valk (@jdevalk) <a href=\"https://twitter.com/jdevalk/status/1877731220135538728?ref_src=twsrc%5Etfw\">January 10, 2025</a></blockquote><script async src=\"https://platform.twitter.com/widgets.js\" charset=\"utf-8\"></script>\n</div></figure>\n\n\n\n<p>Now, as core committer Jb Audras (not employed by me or Automattic) points out, within WordPress we have a process in which people earn the right to lead a release:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-rich is-provider-twitter wp-block-embed-twitter\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\" data-width=\"500\" data-dnt=\"true\"><p lang=\"en\" dir=\"ltr\">Before leading any major release of WordPress, please start with leading a minor one <a href=\"https://twitter.com/jdevalk?ref_src=twsrc%5Etfw\">@jdevalk</a>. Then, apply to be Triage Lead or Coordination Lead Deputy for a major release. These are the steps everyone in our community should follow before claiming to run « the next releases ».</p>&mdash; Jb Audras (@AudrasJb) <a href=\"https://twitter.com/AudrasJb/status/1877833087473565785?ref_src=twsrc%5Etfw\">January 10, 2025</a></blockquote><script async src=\"https://platform.twitter.com/widgets.js\" charset=\"utf-8\"></script>\n</div></figure>\n\n\n\n<p>However in Joost and Karim&#8217;s new project, they don&#8217;t need to follow our process or put in the hours to prove their worth within the WordPress.org ecosystem, they can just lead by example by shipping code and product to people that they can use, evaluate, and test out for themselves. If they need financial or hosting support is sounds like WP Engine wants to support their fork:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-rich is-provider-twitter wp-block-embed-twitter\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"twitter-tweet\" data-width=\"500\" data-dnt=\"true\"><p lang=\"en\" dir=\"ltr\">We appreciate <a href=\"https://twitter.com/jdevalk?ref_src=twsrc%5Etfw\">@jdevalk</a> and <a href=\"https://twitter.com/karimmarucchi?ref_src=twsrc%5Etfw\">@karimmarucchi</a> thoughtful call for constructive conversation, change and evolved leadership within the WordPress community. Moments of disruption challenge all of us to reflect and to act.<br><br>WordPress’s success as the most widely used CMS is not the…</p>&mdash; WP Engine (@wpengine) <a href=\"https://twitter.com/wpengine/status/1870242287218790849?ref_src=twsrc%5Etfw\">December 20, 2024</a></blockquote><script async src=\"https://platform.twitter.com/widgets.js\" charset=\"utf-8\"></script>\n</div></figure>\n\n\n\n<p>Awesome! (Maybe it&#8217;s so successful they rebrand as JK Engine in the future.) WP Engine, with its half a billion in revenue and 1,000+ employees, has more than enough resources to support and maintain a legitimate fork of WordPress. And they are welcome to use all the GPL code myself and others have created to do so, including many parts of WordPress.org that are open source released under the GPL, and Gutenberg which is GPL + MPL. </p>\n\n\n\n<p>Joost also is a major investor (owner?) in <a href=\"https://poststatus.com/\">Post Status</a> (which he tried to sell to me a few months ago, and I declined to buy, perhaps kicking off his consternation with me), so they have a news media site and Slack instance already ready to go. He also is an investor in <a href=\"https://patchstack.com/\">PatchStack</a> and appears to be trying to create a new business around something called <a href=\"https://progressplanner.com/\">Progress Planner</a>, both of which could be incorporated into the new non-profit project to give them some competitive distinctions from WordPress.</p>\n\n\n\n<p>To make this easy and hopefully give this project the push it needs to get off the ground, I&#8217;m deactivating the .org accounts of <a href=\"https://profiles.wordpress.org/joostdevalk/\">Joost</a>, <a href=\"https://profiles.wordpress.org/pirazo/\">Karim</a>, <a href=\"https://profiles.wordpress.org/sereedmedia/\">Se Reed</a>, <a href=\"https://profiles.wordpress.org/idea15/\">Heather Burns</a>, and <a href=\"https://profiles.wordpress.org/mor10/\">Morten Rand-Hendriksen</a>. I strongly encourage anyone who wants to try different leadership models or align with WP Engine to join up with their new effort.</p>\n\n\n\n<p>In the meantime, on top of my <a href=\"https://automattic.com/\">day job running a 1,700+ person company with 25+ products</a>, which I typically work 60-80 hours a week on, I&#8217;ll find time on nights and weekends to work on WordPress 6.8 and beyond. Myself and other &#8220;non-sponsored&#8221; contributors have been doing this a long time and while we may need to reduce scope a bit I think we can put out a solid release in March.</p>\n\n\n\n<p>Joost and Karim have a number of bold and interesting ideas, and I&#8217;m genuinely curious to see how they work out. The beauty of open source is they can take all of the GPL code in WordPress and ship their vision. You don&#8217;t need permission, you can just do things. If they create something that&#8217;s awesome, we may even merge it back into WordPress, that ability for code and ideas to freely flow between projects is part of what makes open source such an engine for innovation. I propose that in a year we do a WordPress + JKPress summit, look at what we&#8217;ve shipped and learned in the process, which I&#8217;d be happy to host and sponsor in NYC next January 2026. The broader community will benefit greatly from this effort, as it&#8217;s giving us a true chance to try something different and see how it goes.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18394\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WordPress Themes Need More Weird: A Call for Creative Digital Homes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"https://wordpress.org/news/2025/01/wordpress-themes-need-more-weird-a-call-for-creative-digital-homes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Jan 2025 18:53:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18358\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:409:\"The modern web has gradually shifted from a vibrant tapestry of personal expression to a landscape of identical designs, where millions of websites share not just similar structures, but identical visual language, spacing, and interaction patterns. As we collectively gravitate toward the same “proven” layouts and “conversion-optimized” designs, we’re not just losing visual diversity – [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Nick Hamze\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7673:\"\n<p>The modern web has gradually shifted from a vibrant tapestry of personal expression to a landscape of identical designs, where millions of websites share not just similar structures, but identical visual language, spacing, and interaction patterns. As we collectively gravitate toward the same “proven” layouts and “conversion-optimized” designs, we’re not just losing visual diversity – we’re ceding control over how we present ourselves to the world. This matters because genuine self-expression online isn’t just about aesthetics – it’s about maintaining spaces where authentic voices can flourish.&nbsp;</p>\n\n\n\n<p>When every blog has the same hero section, when every portfolio follows the same grid, when every restaurant site looks interchangeable, we create an echo chamber of sameness. The cost isn’t just visual monotony – it’s the slow erosion of the web’s ability to surprise, delight, and showcase truly individual perspectives. WordPress, with its emphasis on complete ownership and control, offers an opportunity to break free from this convergence of design, allowing creators to build digital spaces that truly reflect their unique voice and vision.</p>\n\n\n\n<p>Think of WordPress themes like album covers. They should have personality and create an immediate visual impact. The web has become too sanitized, with everyone chasing the same minimal, “professional” look.</p>\n\n\n\n<p>Great themes should:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Have a strong point of view – like how Kubrick (the classic WordPress theme) defined an era with its distinctive header gradient. Don&#8217;t try to be everything to everyone.</li>\n\n\n\n<li>Embrace specific aesthetics boldly – whether that’s brutalist design, pixel art, hand-drawn elements, or distinctive typography. Create themes that excite people rather than just working for everyone.</li>\n\n\n\n<li>Design for specific use cases – like a theme for photographers that’s all about full-bleed images or a theme for writers that treats typography as art or a theme for musicians that feels like an album cover.</li>\n\n\n\n<li>Break some rules thoughtfully – because not every theme needs a hamburger menu. Not every theme needs to be mobile-first. Sometimes constraints create character.</li>\n</ul>\n\n\n\n<p>We need more themes that make people say “Wow!” or “That’s different!” rather than “That’s clean and professional.” The web needs more personality, more risk-taking, more fun.</p>\n\n\n\n<p>After spending countless hours digging through the WordPress theme repository, searching for designs that break the mold and spark excitement, I came up nearly empty-handed. Don’t get me wrong – there are plenty of well-built themes out there. But where’s the daring? The personality? The unexpected?</p>\n\n\n\n<p>If you&#8217;ve got a wild theme idea burning in your mind – that portfolio theme that looks like a vintage trading card collection, that blog theme inspired by zine culture, that restaurant theme that feels like a hand-drawn menu – now&#8217;s the time to build it. WordPress desperately needs your creativity, your weird ideas, your willingness to break the visual rules. The future of the web shouldn&#8217;t be a monochrome landscape of identical layouts. Let&#8217;s make WordPress themes exciting again. Let&#8217;s make the web weird again.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-2 wp-block-gallery-3 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><a href=\"https://wordpress.org/themes/psychedeli\" target=\"_blank\" rel=\"noreferrer noopener\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"768\" data-id=\"18360\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/psychedeli.webp?resize=1024%2C768&#038;ssl=1\" alt=\"Psychedeli theme\" class=\"wp-image-18360\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/psychedeli.webp?resize=1024%2C768&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/psychedeli.webp?resize=300%2C225&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/psychedeli.webp?resize=768%2C576&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/psychedeli.webp?w=1200&amp;ssl=1 1200w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://wordpress.org/themes/kawaii-chan\" target=\"_blank\" rel=\"noreferrer noopener\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"768\" data-id=\"18362\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/kawaii.webp?resize=1024%2C768&#038;ssl=1\" alt=\"Kawaii-Chan theme\" class=\"wp-image-18362\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/kawaii.webp?resize=1024%2C768&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/kawaii.webp?resize=300%2C225&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/kawaii.webp?resize=768%2C576&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/kawaii.webp?w=1200&amp;ssl=1 1200w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://wordpress.org/themes/lowfi\" target=\"_blank\" rel=\"noreferrer noopener\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"768\" data-id=\"18361\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/lofi.webp?resize=1024%2C768&#038;ssl=1\" alt=\"LowFi theme\" class=\"wp-image-18361\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/lofi.webp?resize=1024%2C768&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/lofi.webp?resize=300%2C225&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/lofi.webp?resize=768%2C576&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/lofi.webp?w=1200&amp;ssl=1 1200w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://wordpress.org/themes/bedrock\" target=\"_blank\" rel=\"noreferrer noopener\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"768\" data-id=\"18364\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/bedrock.webp?resize=1024%2C768&#038;ssl=1\" alt=\"Bedrock theme\" class=\"wp-image-18364\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/bedrock.webp?resize=1024%2C768&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/bedrock.webp?resize=300%2C225&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/bedrock.webp?resize=768%2C576&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/bedrock.webp?w=1200&amp;ssl=1 1200w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://wordpress.org/themes/feelingood\" target=\"_blank\" rel=\"noreferrer noopener\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"768\" data-id=\"18363\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/feeling.webp?resize=1024%2C768&#038;ssl=1\" alt=\"Feelin’Good theme\" class=\"wp-image-18363\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/feeling.webp?resize=1024%2C768&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/feeling.webp?resize=300%2C225&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/feeling.webp?resize=768%2C576&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/feeling.webp?w=1200&amp;ssl=1 1200w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></a></figure>\n</figure>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18358\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Holiday Break\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/news/2024/12/holiday-break/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Dec 2024 00:36:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18328\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:362:\"In order to give myself and the many tired volunteers around WordPress.org a break for the holidays, we&#8217;re going to be pausing a few of the free services currently offered: We&#8217;re going to leave things like localization and the forums open because these don&#8217;t require much moderation. As you may have heard, I&#8217;m legally compelled [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2315:\"\n<p>In order to give myself and the many tired volunteers around WordPress.org a break for the holidays, we&#8217;re going to be pausing a few of the free services currently offered:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>New account registrations on WordPress.org (clarifying so press doesn&#8217;t confuse this: people can still make their own WordPress installs and accounts)</li>\n\n\n\n<li>New <a href=\"https://wordpress.org/plugins/\">plugin directory</a> submissions</li>\n\n\n\n<li>New plugin reviews</li>\n\n\n\n<li>New <a href=\"https://wordpress.org/themes/\">theme directory</a> submissions</li>\n\n\n\n<li>New <a href=\"https://wordpress.org/photos/\">photo directory</a> submissions</li>\n</ul>\n\n\n\n<p>We&#8217;re going to leave things like localization and the forums open because these don&#8217;t require much moderation.</p>\n\n\n\n<p>As you may have heard, <a href=\"https://www.theverge.com/2024/12/10/24318350/automattic-restore-wp-engine-access-wordpress\">I&#8217;m legally compelled to provide free labor and services to WP Engine thanks to the success of their expensive lawyers</a>, so in order to avoid bothering the court I will say that none of the above applies to WP Engine, so if they need to bypass any of the above please just have your high-priced attorneys talk to my high-priced attorneys and we&#8217;ll arrange access, or just reach out directly to me on Slack and I&#8217;ll fix things for you.</p>\n\n\n\n<p>I hope to find the time, energy, and money to reopen all of this sometime in the new year. Right now much of the time I would spend making WordPress better is being taken up defending against WP Engine&#8217;s legal attacks. Their attacks are against Automattic, but also me individually as the owner of WordPress.org, which means if they win I can be personally liable for millions of dollars of damages.</p>\n\n\n\n<p>If you would like to fund legal attacks against me, I would encourage you to sign up for WP Engine services, <a href=\"https://wpengine.com/plans/\">they have great plans and pricing starting at $50/mo and scaling all the way up to $2,000/mo</a>. If not, you can use <a href=\"https://wordpress.org/news/2024/10/wp-engine-promotions/\">literally any other web host in the world that isn&#8217;t suing me and is offering promotions and discounts for switching away from WP Engine</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18328\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"State of the Word 2024: Legacy, Innovation, and Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://wordpress.org/news/2024/12/state-of-the-word-2024-legacy-innovation-and-community/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Dec 2024 21:28:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:17:\"state of the word\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18205\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:282:\"On a memorable evening in Tokyo, State of the Word 2024 brought together WordPress enthusiasts from around the world—hundreds in person and millions more online. This event marked the first time State of the Word was hosted in Asia, reflecting the platform\'s growing global reach.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Nicholas Garofalo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:88259:\"\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"State of the Word 2024\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/KLybH5YvIPQ?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>On a memorable evening in Tokyo, State of the Word 2024 brought together WordPress enthusiasts from around the world—hundreds in person and millions more online. This event marked the first time State of the Word was hosted in Asia, reflecting the platform&#8217;s growing global reach. The setting couldn’t have been more fitting: a city where tradition and technology coexist in seamless harmony. Tokyo, much like WordPress itself, reflects a powerful blend of legacy and innovation, craftsmanship and technology, and moments of vast scale balanced by serene stillness.</p>\n\n\n\n<div class=\"wp-block-group is-nowrap is-layout-flex wp-container-core-group-is-layout-2 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-pullquote alignwide has-text-align-center\"><blockquote><p>Tokyo is a city you feel.</p><cite>Matt Mullenweg, WordPress Cofounder</cite></blockquote></figure>\n</div>\n\n\n\n<p>During the event, the concept of <em>kansei</em> engineering emerged as a central theme. This Japanese design philosophy seeks to create experiences that go beyond function and aesthetics, focusing on how something feels. As highlighted during the keynote, this principle has quietly influenced WordPress’s development, shaping its design and user experience in ways that resonate on an instinctive level.</p>\n\n\n\n<p>The evening also celebrated Japan’s deep-rooted connection to WordPress. Nearly 21 years ago, Japan became the first country to localize WordPress, long before a formal translation framework existed. It all started with<a href=\"https://wordpress.org/support/topic/localization-help-needed/\"> a single forum post from a user named Otsukare</a>, launching a translation project that helped WordPress become a truly global platform. Seeing how far the Japanese WordPress community has come—both in market share and cultural influence—was a powerful reminder of what shared purpose can achieve.</p>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f8e1d3&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-182521-8400-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"Photo of Matt exhibiting some of the community\'s wapuu creations\" class=\"wp-image-18208\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-182521-8400-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-182521-8400-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-182521-8400-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-182521-8400-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-182521-8400-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<p>Wapuu, WordPress’s beloved mascot, was also born in Japan. What began as a simple idea for a fun and friendly representation of WordPress evolved into a global phenomenon. Thanks to Kazuko Kaneuchi’s generous open-source contribution, Wapuu has been reimagined by WordPress communities worldwide, each version infused with local character. This uniquely Japanese creation has helped make WordPress more welcoming, approachable, and fun wherever it appears.</p>\n\n\n\n<h2 class=\"wp-block-heading\">WordPress Growth in 2024</h2>\n\n\n\n<p>WordPress cofounder Matt Mullenweg highlighted significant achievements that underscored WordPress’s growth, resilience, and expanding global presence in 2024. He shared that WordPress now powers 43.6% of all websites globally. In Japan, WordPress’s influence is even more pronounced, powering 58.5% of all websites. This remarkable statistic reinforces the platform’s enduring role as a cornerstone of the open web and accentuates Japan’s deep-rooted commitment to the WordPress ecosystem and its developers’ significant contributions.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"260\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/marklet-share-world-japan.jpg?resize=1024%2C260&#038;ssl=1\" alt=\"\" class=\"wp-image-18339\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/marklet-share-world-japan.jpg?resize=1024%2C260&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/marklet-share-world-japan.jpg?resize=300%2C76&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/marklet-share-world-japan.jpg?resize=768%2C195&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/marklet-share-world-japan.jpg?resize=1536%2C390&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/marklet-share-world-japan.jpg?resize=2048%2C520&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>WordPress sites using languages other than English are expected to surpass English-language sites by 2025. German recently overtook Japanese as the third-most-used language, though Japanese remained close behind. Meanwhile, emerging languages like Farsi experienced rapid adoption, reflecting the platform’s expanding multilingual ecosystem. In Southeast Asia, languages such as Indonesian, Vietnamese, and Thai saw substantial year-over-year growth, signaling broader adoption across diverse regions.</p>\n\n\n\n<p>Core downloads surged to nearly half a billion annually, with the notable releases of WordPress <a href=\"https://wordpress.org/download/releases/6-5/\">6.5</a>, <a href=\"https://wordpress.org/download/releases/6-6/\">6.6</a>, and <a href=\"https://wordpress.org/download/releases/6-7/\">6.7</a>.</p>\n\n\n\n<p>WordPress’s design and development ecosystem flourished as well. Over 1,700 new themes were uploaded in 2024, bringing more than 1,000 block themes to the official repository and reflecting increased interest in modern, flexible site design.</p>\n\n\n\n<p>The plugin ecosystem also saw record-breaking activity this year. Plugin downloads surged toward 2.35 billion, representing a 20% year-over-year increase. Plugin updates exceeded 3 billion and are on track to surpass 3.5 billion by year’s end. Notably, the Plugin Review Team made transformative improvements, drastically reducing the average review wait time. Their efficiency gains were complemented by the launch of the <a href=\"https://wordpress.org/plugins/plugin-check/\">Plugin Check</a> tool, which reduced submission issues by 41% while enabling the team to approve 138% more plugins each week.</p>\n\n\n\n<p>These accomplishments showcase WordPress’s resilience, adaptability, and ever-expanding influence. As the platform continues to evolve, its global community remains at the heart of its success, driving innovation and ensuring that WordPress thrives as the leading tool for building the open web.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-2-background-color has-background is-layout-flow wp-block-group-is-layout-flow\" style=\"padding-top:var(--wp--preset--spacing--40);padding-right:0;padding-bottom:var(--wp--preset--spacing--40);padding-left:0\">\n<p class=\"has-text-align-center\">Help shape the future of WordPress: Join a contributor team today!</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-2 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button has-custom-width wp-block-button__width-50\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://make.wordpress.org/\" target=\"_blank\" rel=\"noreferrer noopener\">Make WordPress</a></div>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Advancing the Platform</h2>\n\n\n\n<p>WordPress lead architect, Matías Ventura, highlighted WordPress’s evolution through the lenses of writing, design, building, and development, demoing various pieces of new and forthcoming enhancements.</p>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f8e96f&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/sotw-2024_keynote_vFINALFINAL-english.059.jpeg?resize=1024%2C576&#038;ssl=1\" alt=\"Write, Build, Design, Develop\" class=\"wp-image-18219\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/sotw-2024_keynote_vFINALFINAL-english.059.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/sotw-2024_keynote_vFINALFINAL-english.059.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/sotw-2024_keynote_vFINALFINAL-english.059.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/sotw-2024_keynote_vFINALFINAL-english.059.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/sotw-2024_keynote_vFINALFINAL-english.059.jpeg?w=1920&amp;ssl=1 1920w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Writing</h3>\n\n\n\n<p>The writing experience in WordPress saw notable advancements this year, with an improved distraction-free mode that helps users to focus on content creation without interface distractions. Now you can directly select the image itself to drag and drop it where you want, even enabling on-the-fly gallery creation when you drop images next to each other.</p>\n\n\n\n<p>Additionally, the introduction of block-level comments in the editor, currently an experimental feature, promises to reshape collaborative workflows by enabling teams to leave notes directly on blocks.</p>\n\n\n\n<p>These enhancements all work together to make writing, composing, and editing in WordPress feel more fluid, personal, and pleasant than ever.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Design</h3>\n\n\n\n<p>Along with new default theme Twenty Twenty-Five, more than 1,000 block themes offer tailored starting points for different site types, including portfolios, blogs, and business sites. Designers can also utilize the improved Style Book for a comprehensive view of their site’s appearance, ensuring a smooth design process.</p>\n\n\n\n<p>Design work isn’t just about aesthetics—it’s also about creating the right environment and guardrails. It’s important that users can interact with their site, add content, replace media, and choose sections without needing to know the layout details. We’re implementing better default experiences to help you focus exclusively on the content or on the design, depending on your needs at the moment.&nbsp;</p>\n\n\n\n<p>This all works seamlessly with the zoom-out view, where users can compose content using patterns without having to set up every individual block. Having a bird’s-eye view of your site can really help you gain a different perspective.</p>\n\n\n\n<p>These design capabilities scale with you as your WordPress projects grow. WordPress&#8217;s approach to design is systematic: blocks combine to form patterns, patterns form templates, and templates help separate content from presentation.</p>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f8ee3d&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/sotw-2024_keynote_vFINALFINAL-english.037.jpeg?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-18302\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/sotw-2024_keynote_vFINALFINAL-english.037.jpeg?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/sotw-2024_keynote_vFINALFINAL-english.037.jpeg?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/sotw-2024_keynote_vFINALFINAL-english.037.jpeg?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/sotw-2024_keynote_vFINALFINAL-english.037.jpeg?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/sotw-2024_keynote_vFINALFINAL-english.037.jpeg?w=1920&amp;ssl=1 1920w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Building</h3>\n\n\n\n<p>WordPress’s content management capabilities allow working at scale and across teams. Central to this is the introduction of Block Bindings, which merge the flexibility of blocks with the structured power of meta fields. This feature allows block attributes to be directly linked to data sources like post meta, reducing the need for custom blocks while creating deeper, more dynamic content relationships. The familiar block interface remains intact, making complex data management feel seamless. This connects naturally with our broader work on Data Views for post types and meta fields.&nbsp;</p>\n\n\n\n<p>These updates reinforce WordPress’s role as a powerful content management system by connecting its core primitives—blocks, post types, taxonomies, and meta fields—more intuitively.&nbsp;</p>\n\n\n\n<h3 class=\"wp-block-heading\">Development</h3>\n\n\n\n<p>Lastly, Matías showcased a range of groundbreaking tools that empower WordPress developers and streamline their workflows. One of the highlights was the new Templates API, which has simplified the process of registering and managing custom templates. Future updates to the API will allow users to register and activate templates seamlessly, enabling dynamic site customizations such as scheduling different homepage templates for special events or swapping category archives during campaigns. This flexible approach offers developers greater creative control in a standardized way.&nbsp;</p>\n\n\n\n<p>The session also explored the Interactivity API, designed to deliver fast, seamless website experiences by enabling server-rendered interactivity within WordPress. Unlike JavaScript-heavy frameworks, this technology keeps everything within WordPress’s existing ecosystem, bridging the gap between developers and content creators. Attendees saw live demos showcasing instant search, pagination, and commenting—all without page reloads—while maintaining a perfect performance score of 100 on Lighthouse. In addition, it was announced that responsive controls will receive significant attention, with new features being explored, like block visibility by breakpoint and adding min/max controls to the columns block.</p>\n\n\n\n<p>The WordPress Playground also emerged as a game-changer, allowing users to spin up WordPress sites directly in their browsers, experiment with Blueprints, and manage projects offline. With improved GitHub integration and expanded documentation, WordPress developers now have a more accessible and powerful toolkit than ever before.</p>\n\n\n\n<h2 class=\"wp-block-heading\">An AI Future</h2>\n\n\n\n<p>Returning to the stage, Matt noted that Gutenberg’s evolution is paving the way for AI-powered site building while keeping creative control in users’ hands. A recent speed building challenge on WordPress’s YouTube channel showcased this potential, with <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> using AI-assisted tools and <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> building manually. While the AI-assisted approach won, the key takeaway was that AI isn’t here to replace developers but to enhance creativity and efficiency.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"AI Takes On HUMAN in WordPress Speed Build Showdown &#x1f525;\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/vjw6KWahFlk?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Community Impact and Global Reach</h2>\n\n\n\n<p>When WordPress Executive Director Mary Hubbard took the stage, she emphasized WordPress’s commitment to its open-source mission and the power of its global community. Mary shared her passion for defending WordPress’s principles, reaffirming that when users choose WordPress, they should receive the authentic, community-driven experience that the platform stands for. This commitment to clarity, trust, and open-source integrity is central to ensuring WordPress’s long-term sustainability and success.</p>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f8f446&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-193636-0177_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"Photo of Mary Hubbard, WordPress Executive Director\" class=\"wp-image-18227\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-193636-0177_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-193636-0177_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-193636-0177_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-193636-0177_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-193636-0177_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button><figcaption class=\"wp-element-caption\">Mary Hubbard, WordPress Executive Director</figcaption></figure>\n\n\n\n<p>In 2024, WordPress’s global influence surged through expanded educational programs, developer contributions, and grassroots initiatives. The platform’s social media following grew to 2.3 million, while major events like WordCamps and live-streamed gatherings attracted millions of attendees and viewers, connecting people worldwide.</p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\">Learn WordPress</a> introduced Structured Learning Pathways, offering tailored tracks for beginners and developers, fostering a growing network of creators eager to learn and contribute. Grassroots programs flourished, with WP Campus Connect bringing WordPress education to Indian colleges and innovation competitions in Uganda empowering young creators. In Latin America, the Community Reactivation Project reignited meetups across nine cities, fostering a network of over 150 active members and setting the stage for three new WordCamps in 2025.</p>\n\n\n\n<p>WordPress’s efforts also advanced through <a href=\"https://openverse.org/\">Openverse</a>, which expanded its free content library to 884 million images and 4.2 million audio files, serving millions of creators worldwide and supporting WordPress’s broader mission of democratizing publishing.</p>\n\n\n\n<p>Whether through educational platforms, developer-driven innovation, or community-led projects, WordPress’s ecosystem continues to nurture shared learning, creativity, and collaboration, ensuring its growth and relevance for future generations.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Japanese Community Highlights</h2>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/nukaga/\">Junko Fukui Nukaga</a>—Community Team rep, program manager, and WordCamp organizer—noted that WordPress&#8217;s prominence in Japan contributes to an economy now estimated to exceed 100 billion yen.</p>\n\n\n\n<p>In October of 2024, the Japanese WordPress community celebrated DigitalCube’s IPO on the Tokyo PRO Market, marking a milestone for the local WordPress ecosystem. Major contributors like Takayuki Miyoshi’s <a href=\"https://wordpress.org/plugins/contact-form-7/\">Contact Form 7</a> plugin surpassed 10 million active users, while companies like Sakura Internet and XServer built specialized WordPress infrastructure.</p>\n\n\n\n<p>Community events in Japan have also flourished, with 189 local meetups held throughout the year, fueled by dedicated volunteers and organizers. Translation Night gatherings have ensured WordPress remains accessible to Japanese users, reflecting a thriving collaborative spirit.</p>\n\n\n\n<p>Matt gave special recognition to Japan’s standout contributor, <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a>, a Core Committer whose exceptional efforts elevated WordPress development over the past year. Hamano-san made an impressive 774 contributions to WordPress core, earning 162 props for WordPress 6.5, rising to 274 props for 6.6 as the second-highest contributor, and securing the top spot with 338 props for 6.7.Other notable Japanese contributors included <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a>, an active Docs Team member, and Nukaga, recognized for her exceptional community organizing efforts. Additionally, 13 Japanese contributors supported 5.4% of WordPress 6.6 development, showcasing the country’s growing influence in the WordPress ecosystem.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Data Liberation</h2>\n\n\n\n<p>Reflecting on the progress since the initiative&#8217;s launch last year, the focus remained on ensuring that WordPress not only becomes more powerful but also embodies freedom in its deepest sense—the freedom to move content anywhere, collaborate without limits, and create without constraints. This vision extends beyond individual sites to a broader web where content flows seamlessly across platforms, enabling unrestricted creativity and innovation.</p>\n\n\n\n<p>One compelling example demonstrated how easily ePub files could be imported into a WordPress site, integrating seamlessly with existing designs. This represents the initiative’s broader goal: making content migration and integration effortless. WordPress Playground plays a critical role in this vision by enabling easy site migration through a simple browser extension. With Playground as a staging area, migrating and adapting sites becomes intuitive and accessible.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Q&amp;A</h2>\n\n\n\n<p>The floor was opened to questions in both Japanese and English.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"State of the Word 2024 Q&amp;A\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/XPhQFSAvKVw?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<p>Questions from the audience, including <a href=\"https://en.wikipedia.org/wiki/Tokyo_Vice\"><em>Tokyo Vice</em></a> author Jake Adelstein, covered the future of blogging, WordPress performance, the impact of AI search, and what democratizing publishing means today. Matt shared his excitement for more open platforms such as Mastodon and Bluesky, as well as his recommendations for optimizing your site for both humans and AI. A common thread throughout was that a personal website is an important part of your digital identity, and WordPress allows you to<a href=\"https://playground.wordpress.net/?plugin=piano-block&amp;blueprint-url=https%3A%2F%2Fwordpress.org%2Fplugins%2Fwp-json%2Fplugins%2Fv1%2Fplugin%2Fpiano-block%2Fblueprint.json%3Frev%3D3166994%26lang%3D\"> express yourself in fun and unique ways</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Panels</h2>\n\n\n\n<p>After attendees enjoyed a special performance by the pianist, Takai-san, industry leaders, creators, and innovators took the stage for panel discussions about the present and future of WordPress, moderated by Mary Hubbard.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" title=\"State of the Word 2024 Panel Discussions\" width=\"500\" height=\"281\" src=\"https://www.youtube.com/embed/Qt5FOQYX1nE?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Publishing in the Open</h3>\n\n\n\n<p>Featuring:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Mieko Kawakami, Japanese Author and Poet&nbsp;</li>\n\n\n\n<li>Craig Mod, Author of Things Become Other Things&nbsp;</li>\n\n\n\n<li>Matt Mullenweg, WordPress Cofounder and Automattic CEO</li>\n</ul>\n\n\n\n<p>This first panel explored the transformative power of open-source publishing. Panelists shared insights into how open publishing has influenced their creative journeys, expanded audience engagement, and shaped storytelling across cultural boundaries.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Publishing in the open has defined what I’ve done. All the best connections I’ve made in live have been the result of publishing in the open. &#8211; Craig Mod</p>\n</blockquote>\n\n\n\n<p>Publishing in the open, like WordPress, is about building community, mutual connections, and putting power back into the hands of creators.</p>\n\n\n\n<h3 class=\"wp-block-heading\">The Future of WordPress in Japan and Beyond</h3>\n\n\n\n<p>Featuring:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Hajime Ogushi, mgn CEO</li>\n\n\n\n<li>Genki Taniguchi, SAKURA internet Inc. Senior Director</li>\n\n\n\n<li>Matt Mullenweg, WordPress Cofounder and Automattic CEO</li>\n</ul>\n\n\n\n<p>The second discussion highlighted WordPress&#8217;s remarkable growth in Japan and its broader global impact. The discussion covered the drivers behind Japan&#8217;s adoption of WordPress, its thriving ecosystem of WordPress-based businesses, and emerging trends in web development.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Compared to other CMSs the WordPress Japanese is much easier to use. &#8211; Hajime Ogushi</p>\n</blockquote>\n\n\n\n<p>The group discussed plugins such as <a href=\"https://wordpress.org/plugins/contact-form-7/\">Contact Form 7</a>, the affordability of hosting WordPress, and local meetups and events</p>\n\n\n\n<h2 class=\"wp-block-heading\">Closing</h2>\n\n\n\n<p>Thank you to all the guests who joined us on stage, those who ventured to Tokyo, and everyone who tuned in from around the world. Today’s event showcased how a free and infinitely flexible platform, an active global community, open innovation, and a commitment to a fully democratized web make us better at being who we are.</p>\n\n\n\n<p>From Tokyo, Arigatou Gozaimashita!</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-0 is-cropped is-style-rectangular wp-block-gallery-4 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f90495&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18249\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-202835-8841-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18249\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-202835-8841-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-202835-8841-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-202835-8841-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-202835-8841-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-202835-8841-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f90993&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18262\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-164917-7983-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18262\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-164917-7983-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-164917-7983-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-164917-7983-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-164917-7983-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-164917-7983-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f90dcb&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18274\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-163201-7815-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18274\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-163201-7815-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-163201-7815-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-163201-7815-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-163201-7815-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-163201-7815-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f911eb&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18252\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-140851-0095-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18252\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-140851-0095-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-140851-0095-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-140851-0095-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-140851-0095-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-140851-0095-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f915fa&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18258\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-135950-0093-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18258\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-135950-0093-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-135950-0093-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-135950-0093-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-135950-0093-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-135950-0093-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f91a47&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18240\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-142237-0135-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18240\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-142237-0135-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-142237-0135-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-142237-0135-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-142237-0135-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-142237-0135-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f91e91&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18260\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-181648-7911-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18260\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-181648-7911-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-181648-7911-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-181648-7911-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-181648-7911-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-181648-7911-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f9234b&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18251\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-203524-8925-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18251\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-203524-8925-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-203524-8925-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-203524-8925-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-203524-8925-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-203524-8925-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f92778&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"683\" height=\"1024\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18229\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-190404-0124_web2k.jpg?resize=683%2C1024&#038;ssl=1\" alt=\"\" class=\"wp-image-18229\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-190404-0124_web2k.jpg?resize=683%2C1024&amp;ssl=1 683w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-190404-0124_web2k.jpg?resize=200%2C300&amp;ssl=1 200w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-190404-0124_web2k.jpg?resize=768%2C1151&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-190404-0124_web2k.jpg?resize=1025%2C1536&amp;ssl=1 1025w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-190404-0124_web2k.jpg?w=1334&amp;ssl=1 1334w\" sizes=\"auto, (max-width: 683px) 100vw, 683px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f92bfe&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18230\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-193131-0170_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18230\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-193131-0170_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-193131-0170_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-193131-0170_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-193131-0170_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-193131-0170_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f92f6a&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18233\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-194151-8562-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18233\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-194151-8562-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-194151-8562-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-194151-8562-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-194151-8562-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-194151-8562-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f93297&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18236\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-194444-0195_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18236\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-194444-0195_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-194444-0195_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-194444-0195_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-194444-0195_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-194444-0195_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f93592&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"683\" height=\"1024\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18231\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-200909-0238_web2k.jpg?resize=683%2C1024&#038;ssl=1\" alt=\"\" class=\"wp-image-18231\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-200909-0238_web2k.jpg?resize=683%2C1024&amp;ssl=1 683w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-200909-0238_web2k.jpg?resize=200%2C300&amp;ssl=1 200w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-200909-0238_web2k.jpg?resize=768%2C1151&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-200909-0238_web2k.jpg?resize=1025%2C1536&amp;ssl=1 1025w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-200909-0238_web2k.jpg?w=1334&amp;ssl=1 1334w\" sizes=\"auto, (max-width: 683px) 100vw, 683px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f9389c&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18228\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-200404-0226_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18228\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-200404-0226_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-200404-0226_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-200404-0226_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-200404-0226_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-200404-0226_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f93b8f&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18272\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-210737-9358-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18272\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-210737-9358-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-210737-9358-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-210737-9358-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-210737-9358-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-210737-9358-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f93ec3&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18305\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-211905-9455-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18305\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-211905-9455-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-211905-9455-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-211905-9455-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-211905-9455-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-211905-9455-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f941b9&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18269\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-204404-9012-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18269\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-204404-9012-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-204404-9012-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-204404-9012-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-204404-9012-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-204404-9012-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f944e4&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18257\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-204317-8995-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18257\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-204317-8995-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-204317-8995-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-204317-8995-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-204317-8995-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-204317-8995-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f947da&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18271\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-210835-9366-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18271\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-210835-9366-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-210835-9366-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-210835-9366-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-210835-9366-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-210835-9366-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f94ac8&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18279\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-212042-9462-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18279\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-212042-9462-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-212042-9462-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-212042-9462-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-212042-9462-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-212042-9462-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f94dd5&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18275\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-210855-9369-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18275\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-210855-9369-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-210855-9369-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-210855-9369-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-210855-9369-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-210855-9369-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f95138&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18265\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-204253-8984-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18265\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-204253-8984-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-204253-8984-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-204253-8984-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-204253-8984-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-204253-8984-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f95454&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18282\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213938-9563-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18282\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213938-9563-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213938-9563-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213938-9563-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213938-9563-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213938-9563-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f9574d&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18280\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213231-9494-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18280\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213231-9494-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213231-9494-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213231-9494-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213231-9494-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213231-9494-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f95a54&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18268\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213105-9483-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18268\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213105-9483-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213105-9483-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213105-9483-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213105-9483-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213105-9483-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f95da3&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18266\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213722-60568-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18266\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213722-60568-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213722-60568-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213722-60568-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213722-60568-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213722-60568-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n\n\n\n<figure data-wp-context=\"{&quot;imageId&quot;:&quot;67c4f49f9610a&quot;}\" data-wp-interactive=\"core/image\" class=\"wp-block-image size-large wp-lightbox-container\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"683\" data-wp-class--hide=\"state.isContentHidden\" data-wp-class--show=\"state.isContentVisible\" data-wp-init=\"callbacks.setButtonStyles\" data-wp-on-async--click=\"actions.showLightbox\" data-wp-on-async--load=\"callbacks.setButtonStyles\" data-wp-on-async-window--resize=\"callbacks.setButtonStyles\" data-id=\"18281\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213349-60543-_web2k.jpg?resize=1024%2C683&#038;ssl=1\" alt=\"\" class=\"wp-image-18281\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213349-60543-_web2k.jpg?resize=1024%2C683&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213349-60543-_web2k.jpg?resize=300%2C200&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213349-60543-_web2k.jpg?resize=768%2C512&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213349-60543-_web2k.jpg?resize=1536%2C1025&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/20241216-Automattic-213349-60543-_web2k.jpg?w=2000&amp;ssl=1 2000w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /><button\n			class=\"lightbox-trigger\"\n			type=\"button\"\n			aria-haspopup=\"dialog\"\n			aria-label=\"Enlarge\"\n			data-wp-init=\"callbacks.initTriggerButton\"\n			data-wp-on-async--click=\"actions.showLightbox\"\n			data-wp-style--right=\"state.imageButtonRight\"\n			data-wp-style--top=\"state.imageButtonTop\"\n		>\n			<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"12\" height=\"12\" fill=\"none\" viewBox=\"0 0 12 12\">\n				<path fill=\"#fff\" d=\"M2 0a2 2 0 0 0-2 2v2h1.5V2a.5.5 0 0 1 .5-.5h2V0H2Zm2 10.5H2a.5.5 0 0 1-.5-.5V8H0v2a2 2 0 0 0 2 2h2v-1.5ZM8 12v-1.5h2a.5.5 0 0 0 .5-.5V8H12v2a2 2 0 0 1-2 2H8Zm2-12a2 2 0 0 1 2 2v2h-1.5V2a.5.5 0 0 0-.5-.5H8V0h2Z\" />\n			</svg>\n		</button></figure>\n</figure>\n\n\n\n<p>For those interested in exploring past State of the Word keynotes, WordPress has curated a comprehensive YouTube playlist featuring keynotes from previous years. Watch them all here:<a href=\"https://www.youtube.com/playlist?list=PL1pJFUVKQ7ES1piZxljCvMTJCYpVBnwYU\" target=\"_blank\" rel=\"noreferrer noopener\"> State of the Word YouTube Playlist</a>. Be sure to mark your calendars for major WordPress events in 2025: <a href=\"https://asia.wordcamp.org/2025/\" target=\"_blank\" rel=\"noreferrer noopener\">WordCamp Asia</a> (Manila, Philippines), <a href=\"https://europe.wordcamp.org/2025/\" target=\"_blank\" rel=\"noreferrer noopener\">WordCamp Europe</a> (Basel, Switzerland), and <a href=\"https://us.wordcamp.org/2025/\" target=\"_blank\" rel=\"noreferrer noopener\">WordCamp US</a> (Portland, Oregon, USA).</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18205\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Write Books With the Block Editor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2024/12/write-books-with-the-block-editor/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Dec 2024 08:36:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18176\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:327:\"If you need a little push to start writing this winter, in the comfort of your familiar editor, here it is! You can now use the Block Editor to create electronic books and other documents—all completely offline. What a full circle moment for Gutenberg! The Block Editor contains so many features I miss when writing [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Ella\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6919:\"\n<p>If you need a little push to start writing this winter, in the comfort of your familiar editor, here it is! You can now use the Block Editor to create electronic books and other documents—all completely offline. What a full circle moment for Gutenberg!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"711\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Screenshot-2024-12-10-at-09.35.01.png?resize=1024%2C711&#038;ssl=1\" alt=\"\" class=\"wp-image-18179\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Screenshot-2024-12-10-at-09.35.01.png?resize=1024%2C711&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/Screenshot-2024-12-10-at-09.35.01.png?resize=300%2C208&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/Screenshot-2024-12-10-at-09.35.01.png?resize=768%2C533&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/Screenshot-2024-12-10-at-09.35.01.png?resize=1536%2C1067&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/Screenshot-2024-12-10-at-09.35.01.png?resize=2048%2C1422&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>The Block Editor contains so many features I miss when writing in other editors. It produces clean, semantic markup. You can paste in content from anywhere and the editor will clean it up for you, or paste a link onto selected text to auto-link. The List View and Outline panels allow you to easily navigate and inspect the content. And we’re constantly iterating on the Block Editor: more features and improvements are on the way, such as refined drag and drop interactions coming in early 2025.</p>\n\n\n\n<p>All this inspired me to wrap our editor in an app that can read and write local files—just as other document editors do. It turns out that EPUB is the best file format to store the content, because EPUB is an open standard for e-books that is essentially a ZIP file containing HTML and media—HTML like your WordPress posts!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"560\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Screenshot-2024-12-03-at-23.34.36.png?resize=1024%2C560&#038;ssl=1\" alt=\"\" class=\"wp-image-18180\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Screenshot-2024-12-03-at-23.34.36.png?resize=1024%2C560&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/Screenshot-2024-12-03-at-23.34.36.png?resize=300%2C164&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/Screenshot-2024-12-03-at-23.34.36.png?resize=768%2C420&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/Screenshot-2024-12-03-at-23.34.36.png?resize=1536%2C839&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/Screenshot-2024-12-03-at-23.34.36.png?resize=2048%2C1119&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>And just like that, the WordPress Block Editor can also be used to write books! The cool thing about EPUB files is that any e-book app, such as Kindle and Apple Books, can open it. So even if someone doesn’t have this editor, they can still easily read the content, which makes the files it produces portable.</p>\n\n\n\n<p>The editor allows you to create a cover, so you can easily distinguish between the books or documents you write. It will also treat each heading as a chapter so you can easily navigate content when opened in an e-book reader.</p>\n\n\n\n<div class=\"wp-block-columns alignfull is-layout-flex wp-container-core-columns-is-layout-1 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:60%\">\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"793\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Screenshot-2024-12-03-at-23.27.56.png?resize=1024%2C793&#038;ssl=1\" alt=\"\" class=\"wp-image-18181\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Screenshot-2024-12-03-at-23.27.56.png?resize=1024%2C793&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/Screenshot-2024-12-03-at-23.27.56.png?resize=300%2C232&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/Screenshot-2024-12-03-at-23.27.56.png?resize=768%2C595&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/Screenshot-2024-12-03-at-23.27.56.png?resize=1536%2C1190&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/Screenshot-2024-12-03-at-23.27.56.png?resize=2048%2C1586&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:40%\">\n<figure class=\"wp-block-image aligncenter size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"768\" height=\"1024\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/screenshot_2024_12_11T12_00_190100.png?resize=768%2C1024&#038;ssl=1\" alt=\"\" class=\"wp-image-18178\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/screenshot_2024_12_11T12_00_190100.png?resize=768%2C1024&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/screenshot_2024_12_11T12_00_190100.png?resize=225%2C300&amp;ssl=1 225w, https://i0.wp.com/wordpress.org/news/files/2024/12/screenshot_2024_12_11T12_00_190100.png?resize=1152%2C1536&amp;ssl=1 1152w, https://i0.wp.com/wordpress.org/news/files/2024/12/screenshot_2024_12_11T12_00_190100.png?w=1236&amp;ssl=1 1236w\" sizes=\"auto, (max-width: 768px) 100vw, 768px\" /></figure>\n</div>\n</div>\n\n\n\n<p>The term “book” should be taken broadly. While the file that the Block Editor produces is primarily used for e-books, you can create any document with it. It’s possible to export your document to a DOCX file in case you need it, though the more complex blocks are not supported yet.</p>\n\n\n\n<p>It is still very much a nascent project. There’s many features left to be added, such as revisions and the ability to open any externally created EPUB files, or even DOCX files, so keep an eye out for these in the coming weeks and months! If you’re interested in this editor, it’s all <a href=\"https://github.com/block-editors/blockdocs\">open source</a>, and I welcome any kind of help.</p>\n\n\n\n<p>For now, the <a href=\"https://block-editors.github.io/blockdocs/\">demo editor</a> is installable as a Progressive Web App (PWA) in Chrome. While it’s totally usable without installation, it does give you some nice benefits such as allowing you to open the EPUB files directly from your OS. In the future we might wrap it in proper native apps. Your feedback is welcome on <a href=\"https://github.com/block-editors/blockdocs\">GitHub</a>!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18176\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"Openverse.org: A Sight for Sore Eyes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2024/12/openverse-org-a-sight-for-sore-eyes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 11 Dec 2024 17:45:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18168\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:378:\"Openverse.org, the vibrant platform for openly licensed media, has introduced a sleek and modern Dark Mode feature. This new site theme is designed to enhance users&#8217; comfort and style as they explore the extensive library of creative resources. Whether for late-night browsing or simply a preference for darker aesthetics, Dark Mode makes engaging with Openverse [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brett McSherry\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7308:\"\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Dark-home-with-yellow-background.png?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-18196\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Dark-home-with-yellow-background.png?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/Dark-home-with-yellow-background.png?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/Dark-home-with-yellow-background.png?resize=768%2C432&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/Dark-home-with-yellow-background.png?resize=1536%2C864&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/Dark-home-with-yellow-background.png?resize=2048%2C1152&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p><a href=\"https://openverse.org/\">Openverse.org</a>, the vibrant platform for openly licensed media, has introduced a sleek and modern Dark Mode feature. This new site theme is designed to enhance users&#8217; comfort and style as they explore the extensive library of creative resources. Whether for late-night browsing or simply a preference for darker aesthetics, Dark Mode makes engaging with Openverse easier on the eyes and more personalized than ever.</p>\n\n\n\n<p>By reducing screen brightness in low-light settings, Dark Mode offers a more relaxed viewing experience, helping to minimize eye strain. It also caters to users with light sensitivity, creating a more inclusive browsing environment. This thoughtful addition underscores Openverse’s commitment to delivering tools that are as functional as they are visually appealing.</p>\n\n\n\n<div class=\"wp-block-jetpack-slideshow\" data-effect=\"slide\"><div class=\"wp-block-jetpack-slideshow_container swiper-container\"><ul class=\"wp-block-jetpack-slideshow_swiper-wrapper swiper-wrapper\"><li class=\"wp-block-jetpack-slideshow_slide swiper-slide\"><figure><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"573\" alt=\"\" class=\"wp-block-jetpack-slideshow_image wp-image-18188\" data-id=\"18188\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Audio-results-and-player-2.png?resize=1024%2C573&#038;ssl=1\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Audio-results-and-player-2.png?resize=1024%2C573&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/Audio-results-and-player-2.png?resize=300%2C168&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/Audio-results-and-player-2.png?resize=768%2C430&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/Audio-results-and-player-2.png?resize=1536%2C860&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/Audio-results-and-player-2.png?resize=2048%2C1147&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure></li><li class=\"wp-block-jetpack-slideshow_slide swiper-slide\"><figure><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"545\" alt=\"\" class=\"wp-block-jetpack-slideshow_image wp-image-18189\" data-id=\"18189\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Search-results-switcher-2.png?resize=1024%2C545&#038;ssl=1\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Search-results-switcher-2.png?resize=1024%2C545&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/Search-results-switcher-2.png?resize=300%2C160&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/Search-results-switcher-2.png?resize=768%2C409&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/Search-results-switcher-2.png?resize=1536%2C817&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/Search-results-switcher-2.png?resize=2048%2C1090&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure></li><li class=\"wp-block-jetpack-slideshow_slide swiper-slide\"><figure><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"553\" alt=\"\" class=\"wp-block-jetpack-slideshow_image wp-image-18195\" data-id=\"18195\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Audio-single-page.png?resize=1024%2C553&#038;ssl=1\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Audio-single-page.png?resize=1024%2C553&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/Audio-single-page.png?resize=300%2C162&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/Audio-single-page.png?resize=768%2C415&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2024/12/Audio-single-page.png?resize=1536%2C829&amp;ssl=1 1536w, https://i0.wp.com/wordpress.org/news/files/2024/12/Audio-single-page.png?resize=2048%2C1106&amp;ssl=1 2048w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure></li></ul><a class=\"wp-block-jetpack-slideshow_button-prev swiper-button-prev swiper-button-white\" role=\"button\"></a><a class=\"wp-block-jetpack-slideshow_button-next swiper-button-next swiper-button-white\" role=\"button\"></a><a aria-label=\"Pause Slideshow\" class=\"wp-block-jetpack-slideshow_button-pause\" role=\"button\"></a><div class=\"wp-block-jetpack-slideshow_pagination swiper-pagination swiper-pagination-white\"></div></div></div>\n\n\n\n<p>The release of Dark Mode is part of Openverse’s broader effort to innovate and adapt to the needs of its growing community. From the thoughtful interface design to the careful attention to accessibility, every detail was crafted to reflect Openverse’s mission of empowering creativity. By embracing modern frontend implementations like Dark Mode without compromising usability or accessibility, Openverse continues to grow while honoring the brand’s essence. In addition, this update lays the groundwork for future developments aimed at providing even more customization options and improved user experiences.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p><em>“Dark Mode marks an exciting step forward for Openverse. We designed and implemented a new user interface that keeps the brand&#8217;s essence while providing the same search experience. We’re thrilled to see how this feature fits within users&#8217; preferences and enhances the creative journey.”&nbsp; – Francisco Vera. Designer</em></p>\n</blockquote>\n\n\n\n<p></p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img data-recalc-dims=\"1\" loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Theme-switcher-flow.gif?resize=1024%2C576&#038;ssl=1\" alt=\"\" class=\"wp-image-18174\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2024/12/Theme-switcher-flow.gif?resize=1024%2C576&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2024/12/Theme-switcher-flow.gif?resize=300%2C169&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2024/12/Theme-switcher-flow.gif?resize=768%2C432&amp;ssl=1 768w\" sizes=\"auto, (max-width: 1000px) 100vw, 1000px\" /></figure>\n\n\n\n<p>Ready to explore Openverse in a whole new light? Head to <a href=\"https://openverse.org/\">Openverse.org</a> today and look for the Dark Mode toggle in the site footer.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"18168\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Mon, 03 Mar 2025 00:15:36 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:25:\"strict-transport-security\";s:12:\"max-age=3600\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Sat, 22 Feb 2025 15:04:04 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:2:\"br\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";i:1731542504;s:21:\"cache_expiration_time\";i:1741004136;s:23:\"__cache_expiration_time\";i:1741004136;}","off");

INSERT IGNORE INTO `wp_options` VALUES 
("40506","_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3","1741004136","off"),
("40507","_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3","1740960936","off"),
("40508","_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9","1741004138","off"),
("40509","_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9","a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"Gravatar: How to Personalize Your Customer Onboarding for Better Retention\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=2545\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://blog.gravatar.com/2025/02/28/customer-onboarding-strategy/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:21872:\"<p>Getting your customer onboarding right can make the difference between long-term success and early user drop-off. But a generic approach won&#8217;t cut it – you need to personalize your message to keep users engaged and active.</p>\n\n\n\n<p>Smart personalization strategies help users find value faster in your product. So, naturally, companies that tailor their onboarding see higher retention rates, increased feature adoption, and stronger customer relationships. Their users are more likely to become product champions and recommend the service to others.</p>\n\n\n\n<p>And the numbers back this up. In <a href=\"https://business.adobe.com/content/dam/dx/us/en/resources/reports/the-business-impact-of-investing-in-experience-forrester-thought-leadership-paper-2021/the-business-impact-of-investing-in-experience-forrester-thought-leadership-paper-2021.pdf\">research by Forrester</a>, businesses that have invested in building better customer and prospect experiences see up to 20% more improvement in customer retention and 25% in customer lifetime value compared to businesses that don’t.   </p>\n\n\n\n<img width=\"1618\" height=\"641\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/study-results-personalized-experiences.png\" alt=\"Comparing customer, revenue, and employee benefits between experience-driven companies and non-experience-driven companies\" class=\"wp-image-2549\" />\n\n\n\n<p>This guide breaks down proven strategies to create personalized onboarding experiences that stick. From sign-up optimization to data-driven improvements, you&#8217;ll learn practical techniques to transform your onboarding into a powerful retention tool.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 1: Effortless sign-up process</strong></h2>\n\n\n\n<p>A streamlined sign-up process sets the tone for your entire <a href=\"https://blog.gravatar.com/2024/09/06/onboarding-user-experience/\">user experience</a>. The challenge? Balancing the need to collect essential user data while keeping friction low. Too many form fields can drive users away, while too few might limit your ability to personalize their experience.</p>\n\n\n\n<p>Start by identifying the minimum information needed to provide value. For most products, this includes an email address, name, password, and their role or use case. Many companies ask for the company website and department, as well.&nbsp;</p>\n\n\n\n<p>From the beginning of the process, you can use <a href=\"https://gravatar.com/\">Gravatar</a> to help you out.&nbsp;</p>\n\n\n\n<img width=\"2160\" height=\"1140\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/gravatar-paas-wordpress.png\" alt=\"Gravatar – Profile as a Service \" class=\"wp-image-2550\" />\n\n\n\n<p>For example, if you’re using WordPress to build your website, some level of Gravatar functionality will already be enabled. <a href=\"http://wordpress.org\">WordPress.org</a> will automatically pull in user avatars, or <a href=\"https://blog.gravatar.com/2024/07/19/wordpress-profile-picture/\">profile pictures</a>, connected to their Gravatar profiles.</p>\n\n\n\n<img width=\"1744\" height=\"946\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/wordpress-org-gravatar-profile-picture.png\" alt=\"Profile picture in WordPress.org\" class=\"wp-image-2552\" />\n\n\n\n<p>However, you can extend this in a massive way, through the free <a href=\"https://wordpress.org/plugins/gravatar-enhanced/\">Gravatar Enhanced plugin</a> to add features like the profile block, which is perfect for author pages and websites focused on creating a community. This block lets you automatically display user information pulled in from their profiles, such as their bio and verified links.&nbsp;</p>\n\n\n\n<img width=\"660\" height=\"377\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/gravatar-profile-block.png?w=660\" alt=\"Gravatar profile block\" class=\"wp-image-2575\" />\n\n\n\n<p>Another option to integrate Gravatar on a deeper level is with the <a href=\"https://blog.gravatar.com/2024/06/03/profiles-as-a-service/\">REST API</a> – and you can do this whether you’re on a WordPress website or not. This allows you to auto-populate user profiles instantly when someone signs up with their email address. This reduces manual data entry while still gathering rich profile information for personalization, which is especially effective with <a href=\"https://blog.gravatar.com/2024/10/08/saas-onboarding-checklist/\">SaaS onboarding</a>.</p>\n\n\n\n<a href=\"https://docs.gravatar.com/getting-started/\"><img width=\"3242\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/gravatar_integration_cta.png\" alt=\"\" class=\"wp-image-2632\" /></a>\n\n\n\n<p>What makes this a gamechanger is that all websites that integrate with Gravatar pull in information from a unified source, which allows you to create familiar experience for users across multiple platforms while reducing sign-up friction.</p>\n\n\n\n<p>Want to take it further? Use progressive profiling:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Collect essential information during sign-up.</li>\n\n\n\n<li>Ask for additional details as users engage with specific features.</li>\n\n\n\n<li>Use behavior patterns to build user profiles over time.</li>\n\n\n\n<li>Allow users to import data from existing profiles.</li>\n</ul>\n\n\n\n<p>Remember to test different form variations with real users. Track completion rates and drop-off points to optimize the process continuously.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 2: Automated welcome email</strong></h2>\n\n\n\n<p>The welcome email acts as your first direct communication with new users. It needs to accomplish several goals while remaining clear and engaging.&nbsp;</p>\n\n\n\n<p>So, to make your welcome email effective, you need to first use an effective subject line. Here are some examples:&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>&#8220;Welcome to [Product] – Here&#8217;s your next step&#8221;</li>\n\n\n\n<li>&#8220;You&#8217;re in! Let&#8217;s get started with [Product]&#8221;</li>\n\n\n\n<li>&#8220;[Name], welcome aboard! Your account is ready&#8221;</li>\n</ul>\n\n\n\n<p>If you’re not sure what to include, you can structure the email content like this:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Start with a personal greeting using their name.&nbsp;</li>\n\n\n\n<li>Confirm their account creation.&nbsp;</li>\n\n\n\n<li>Highlight one clear next action.&nbsp;</li>\n\n\n\n<li>Include essential links without overwhelming them.&nbsp;</li>\n</ol>\n\n\n\n<p>For example, this is the welcome email we send to our users when they create a Gravatar profile:&nbsp;</p>\n\n\n\n<table class=\"has-fixed-layout\"><tbody><tr><td>Hello!<strong>Your email now has a profile!</strong>There are two things you should know about Gravatar:<strong>Your email can introduce yourself</strong><br /><img width=\"976\" height=\"480\" class=\"wp-image-2553\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/gravatar-profiles-across-different-websites.gif\" alt=\"\" /><br />Anytime you share your email, it’s like handing over a digital business card. Your Gravatar profile automatically appears on any Gravatar-enabled site, so you can feel at home instantly. Your avatar and identity follow you seamlessly across the web. Say goodbye to filling out profile forms all over the web.<br /><br /><strong>One link, all about you</strong><br /><img width=\"976\" height=\"480\" class=\"wp-image-2557\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/gravatar-free-profile-website.png\" alt=\"\" /><br />Your Gravatar account comes with a free profile website.<br /><br />It’s a brief introduction of yourself and the perfect way to share where people can find you online. Customize the design and your profile URL. Simple. Make it yours!<br /><br />Any questions? You know where you can find us <img src=\"https://s0.wp.com/wp-content/mu-plugins/wpcom-smileys/twemoji/2/72x72/1f609.png\" alt=\"😉\" class=\"wp-smiley\" /> &#8211; Ask us anything! Or just reply to this email.</td></tr></tbody></table>\n\n\n\n<p><img src=\"https://s0.wp.com/wp-content/mu-plugins/wpcom-smileys/twemoji/2/72x72/2728.png\" alt=\"✨\" class=\"wp-smiley\" /><strong>Pro tip:</strong><strong><em> </em></strong><em>With Gravatar integration, you can personalize the greeting with the user&#8217;s preferred name and include their profile image, making the email feel more personal and familiar.</em></p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 3: Follow-up email to initiate the onboarding process</strong></h2>\n\n\n\n<p>Send this email 24-48 hours after the welcome message. Its purpose? Moving users from sign-up to actual engagement with your product.</p>\n\n\n\n<p>A strong follow-up email includes:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Recognition of whether they&#8217;ve logged in yet.</li>\n\n\n\n<li>One specific action they can take right now.</li>\n\n\n\n<li>Clear value proposition for that action.</li>\n\n\n\n<li>Estimated time commitment.</li>\n</ul>\n\n\n\n<p>Here&#8217;s a tested template:</p>\n\n\n\n<table class=\"has-fixed-layout\"><tbody><tr><td><strong>Subject:</strong> Ready for your first [specific win] with [Product]?<br /><br />Hi [Name],<br /><br /><strong>Quick check-in:</strong> Have you had a chance to [specific action] yet?&nbsp;<br />It takes just 5 minutes to [achieve specific outcome]. Here&#8217;s how:<br /><br />1. Log in to your account<br />2. Click on [feature]<br />3. [Simple action step]<br /><br />Tip: Users who complete this step see [specific benefit] within [timeframe].<br />Need help? Reply to this email or book a quick call: [calendar link]</td></tr></tbody></table>\n\n\n\n<p>Using Gravatar&#8217;s API, you can adapt this email based on the user&#8217;s professional background or location. For instance, customize examples and use cases that match their industry.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 4: Choosing the right onboarding strategy for your product</strong></h2>\n\n\n\n<p>Selecting the right onboarding approach determines how effectively users will adopt your product. Let&#8217;s examine four proven strategies and when to use each one.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>One-on-one onboarding</strong></h3>\n\n\n\n<p>Enterprise software with complex implementations demands personal attention. This high-touch approach works best for products with annual contract values above $10,000 or solutions requiring custom workflows. The direct interaction helps catch potential issues early and ensures users extract maximum value.</p>\n\n\n\n<p>Tips for successful one-on-one onboarding:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Record sessions for future reference.</li>\n\n\n\n<li>Create custom agendas based on user roles.</li>\n\n\n\n<li>Set clear milestones for each call.</li>\n\n\n\n<li>Follow up with written summaries.</li>\n\n\n\n<li>Track time to first value achievement.</li>\n\n\n\n<li>Monitor customer satisfaction scores.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Group onboarding</strong></h3>\n\n\n\n<p>Mid-market solutions and team-based tools often benefit from group sessions. This approach builds community while efficiently onboarding multiple users who share similar needs. It&#8217;s particularly effective for products where users can learn from each other&#8217;s questions and use cases.</p>\n\n\n\n<p>Keys to effective group onboarding:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Segment sessions by industry or use case.</li>\n\n\n\n<li>Keep groups small (5-8 participants).</li>\n\n\n\n<li>Include hands-on exercises.</li>\n\n\n\n<li>Encourage peer learning.</li>\n\n\n\n<li>Schedule sessions across convenient time zones.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Self-service onboarding</strong></h3>\n\n\n\n<p>Products with straightforward features or tech-savvy user bases thrive with self-service onboarding. This approach scales efficiently for high-volume, lower-price products where personal attention isn&#8217;t cost-effective.</p>\n\n\n\n<p>Essential self-service elements include:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Interactive product tours.</li>\n\n\n\n<li>Short video tutorials.</li>\n\n\n\n<li>Progress tracking.</li>\n\n\n\n<li>Clear success milestones.</li>\n\n\n\n<li>Help documentation.</li>\n\n\n\n<li>Chat support option.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Hybrid approach</strong></h3>\n\n\n\n<p>Many successful products combine multiple approaches. Use self-service for basic features, group sessions for advanced functionality, and one-on-one support for custom needs. This flexibility lets you match support levels to user needs and value.</p>\n\n\n\n<p>Implementation strategies:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Use data to trigger different support levels.</li>\n\n\n\n<li>Monitor user progress automatically.</li>\n\n\n\n<li>Offer easy ways to upgrade support.</li>\n\n\n\n<li>Track which methods work best for different segments.</li>\n\n\n\n<li>Adjust based on user feedback and engagement metrics.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 5: Setting initial goals and milestones</strong></h2>\n\n\n\n<p>Setting clear goals with users creates momentum and drives engagement. The trick lies in balancing ambition with achievability – goals should stretch users while remaining within reach. Success starts by understanding what matters most to each user through direct conversations about the problems they&#8217;re trying to solve and their vision for the first 30 days.</p>\n\n\n\n<p>Break larger objectives into manageable milestones. The first milestone should be achievable within 24-48 hours of signup, building confidence and showing immediate progress. Follow this with weekly targets for the first month, then transition to monthly milestones.</p>\n\n\n\n<p>Simple gamification elements can boost motivation:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Progress bars showing completion status.</li>\n\n\n\n<li>Achievement badges for hitting milestones.</li>\n\n\n\n<li>Team leaderboards for group implementations.</li>\n</ul>\n\n\n\n<p>Gravatar integration enhances this experience by displaying user avatars alongside achievements and in team views. This personalization makes the journey feel more engaging and tailored to each user.</p>\n\n\n\n<p><strong><img src=\"https://s0.wp.com/wp-content/mu-plugins/wpcom-smileys/twemoji/2/72x72/2728.png\" alt=\"✨\" class=\"wp-smiley\" />Tip:</strong> <em>Set up automated monitoring to flag when users struggle with specific milestones. This allows customer success teams to step in proactively with support. Stay flexible and adjust goals based on user feedback and behavior patterns.</em></p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 6: Strategies for personalized onboarding</strong></h2>\n\n\n\n<p>Personalization transforms generic onboarding into targeted experiences that resonate with users. Advanced strategies go beyond basic segmentation, using real-time data and behavior patterns to adapt the experience for each user.</p>\n\n\n\n<p>For example, you can use AI-driven paths to analyze user actions and modify the onboarding flow automatically. So, when a user struggles with a specific feature, the system can offer extra guidance or suggest alternative approaches. This dynamic adaptation ensures users get help exactly when they need it.</p>\n\n\n\n<p>Integrating Gravatar adds another layer of personalization from the first interaction. The API provides valuable context about user roles and industries, allowing you to <a href=\"https://blog.gravatar.com/2024/08/16/user-experience-personalization/\">customize the UI</a>,&nbsp; examples, and terminology accordingly. A developer might see technical implementation details, while a marketing professional receives analytics-focused guidance.</p>\n\n\n\n<p>Micro-segmentation takes this further by combining behavioral data with profile insights. For example:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Tailor feature introductions based on past product usage.</li>\n\n\n\n<li>Adjust communication frequency by engagement levels.</li>\n\n\n\n<li>Customize success metrics for different roles.</li>\n</ul>\n\n\n\n<p>Remember that <a href=\"https://blog.gravatar.com/2024/09/03/app-onboarding/\">in-app guidance</a> should feel natural and contextual. Rather than overwhelming users with information, show relevant tips when they&#8217;re most likely to need them. This might mean highlighting advanced features only after users master basics or suggesting integrations when usage patterns indicate they&#8217;d be valuable.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 7: Provide access to a detailed knowledge base</strong></h2>\n\n\n\n<p>An effective knowledge base empowers users to find answers on their own terms. Rather than forcing users to contact support for every question, good documentation lets them solve problems at their own pace.</p>\n\n\n\n<p>Here’s what we recommend:&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Build your knowledge base around user needs, not product features.&nbsp;</li>\n\n\n\n<li>Start with common questions and problems users face during onboarding.&nbsp;</li>\n\n\n\n<li>Structure content in a logical flow that matches the user&#8217;s learning curve – from basic setup to advanced features.</li>\n</ul>\n\n\n\n<p>Video tutorials and interactive guides complement written documentation. Short screencast tutorials work well for showing complex processes, while step-by-step guides help users implement specific features. Keep videos brief and focused on single tasks.</p>\n\n\n\n<p>AI-powered search helps users find relevant information quickly. Smart categorization and related article suggestions guide users to helpful resources they might have missed. Think of your knowledge base as a living document and update it based on common support tickets, user feedback, product updates, and usage analytics.&nbsp;</p>\n\n\n\n<p>Finally, track which articles users read most and where they spend time. This data reveals gaps in documentation and helps prioritize future content creation.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 8: Strategies for checking in with customers</strong></h2>\n\n\n\n<p>Regular check-ins help spot potential issues before they become problems. The best check-ins feel natural, not forced, and happen at moments that matter to users.</p>\n\n\n\n<p>The best strategy is combining automated and personal outreach based on user behavior. After major milestones, send congratulatory messages with tips for the next steps. If usage drops suddenly, trigger a friendly check-in to offer help. Schedule more detailed reviews after the first week and first month to ensure users stay on track.</p>\n\n\n\n<p>Personal check-ins should focus on learning, not just status updates. Ask specific questions about their experience and goals. For example: &#8220;Has [feature] helped with [specific goal] yet?&#8221; or &#8220;What&#8217;s been the biggest challenge so far?&#8221; These conversations often reveal valuable insights about user needs.</p>\n\n\n\n<p>You also should have either a live chat option, email support, and/or video calls because they each serve different purposes. Quick questions work well in chat, while video calls help build relationships and tackle complex issues. Use email to share resources and document action items.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Step 9: Iterate based on feedback</strong></h2>\n\n\n\n<p>Feedback drives improvement, but only if you act on it systematically. Collect both quantitative data (usage statistics, completion rates) and qualitative insights (user interviews, survey responses) to build a complete picture.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Create feedback loops at every stage of onboarding.</strong> Short in-app surveys capture immediate reactions, while detailed questionnaires after key milestones provide deeper insights. User interviews reveal nuances that numbers alone might miss.</li>\n\n\n\n<li><strong>Take action quickly on clear pain points.</strong> If multiple users struggle with the same step, examine it closely. Sometimes, small tweaks, like clearer instructions or simplified workflows, make a big difference. Share improvements with users who provided feedback – it shows you value their input.</li>\n\n\n\n<li><strong>Build a systematic approach to evaluating and implementing changes:</strong>\n<ul class=\"wp-block-list\">\n<li>Analyze feedback patterns</li>\n\n\n\n<li>Prioritize high-impact changes</li>\n\n\n\n<li>Test solutions with small user groups</li>\n\n\n\n<li>Monitor results before rolling out widely</li>\n</ul>\n</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Enhance your onboarding with Gravatar&#8217;s developer API</strong></h2>\n\n\n\n<p>A strong onboarding process keeps users engaged and helps them find value quickly in your service. By integrating Gravatar&#8217;s developer API, you can create a more personalized, friction-free experience from the first interaction.</p>\n\n\n\n<p>Think about your sign-up process. Instead of asking users to fill out multiple fields or upload profile pictures, Gravatar automatically populates this information. Users who already have Gravatar profiles – and there are millions – get a faster, more familiar experience across platforms.</p>\n\n\n\n<p>The API opens up creative possibilities beyond basic profile data. Use it to:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Create personalized welcome screens.</li>\n\n\n\n<li>Show relevant examples based on user industries.</li>\n\n\n\n<li>Build community features with consistent user identities.</li>\n\n\n\n<li>Maintain professional profiles across multiple services.</li>\n</ul>\n\n\n\n<p>Major platforms like WordPress and Slack already use Gravatar to streamline their onboarding, so what are you waiting for?&nbsp;</p>\n\n\n\n<p><a href=\"https://en.gravatar.com/site/implement/\">Check out Gravatar&#8217;s developer documentation</a> to see how easy integration can be. Focus on creating those meaningful first interactions that turn new signups into long-term users.</p>\n\n\n\n<a href=\"https://docs.gravatar.com/getting-started/\"><img width=\"3242\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/gravatar_integration_cta.png\" alt=\"\" class=\"wp-image-2632\" /></a>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 28 Feb 2025 16:28:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"Gravatar: Essential Tips for an Effective Email Signature\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=2673\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://blog.gravatar.com/2025/02/28/what-to-include-in-email-signature/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:15603:\"<p>Creating an effective email signature takes more thought than you might expect. Yes, it&#8217;s just a small block of text at the bottom of your emails – but it&#8217;s also a powerful tool for making memorable connections and building your professional reputation.</p>\n\n\n\n<p>This is especially important if you&#8217;re reaching out to potential clients, applying for jobs, or trying to grow your network. Your signature can be the difference between someone remembering you or your message getting lost in their inbox.</p>\n\n\n\n<p>But here&#8217;s the challenge: <strong>Finding the right balance</strong>. Add too little information and recipients won&#8217;t know enough about you. Add too much, and your signature becomes cluttered, potentially making your emails look unprofessional or even spammy.  </p>\n\n\n\n<p>Let&#8217;s explore how to craft an email signature that makes an impact, including a smart strategy for sharing more about yourself without overwhelming your recipients.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Checklist of elements to consider in your email signature</strong></h2>\n\n\n\n<p>Before diving into specific elements, remember this: You don&#8217;t need to include everything listed below. In fact, that would be counterproductive. Pick the elements that matter most for your professional goals and match your <a href=\"https://blog.gravatar.com/2024/04/10/personal-branding-tools/\">personal brand</a>. And as you&#8217;ll see later,linking to an online profile, such as your <a href=\"https://gravatar.com/\">Gravatar</a>, is a smart way to share additional information without cramming it all into your signature.</p>\n\n\n\n<p>Here are the essential elements to consider:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Name and title: </strong>Format as &#8220;Name, Title&#8221; for quick scanning. This is non-negotiable – it&#8217;s the foundation of your signature.</li>\n\n\n\n<li><strong>Basic contact details: </strong>Include your primary phone number and email address. If you need multiple numbers, use standard notation: (o) for office, (m) for mobile.</li>\n\n\n\n<li><strong>Company information: </strong>Add your company name and department if relevant. For freelancers, your business name or professional title works well.</li>\n\n\n\n<li><strong>Visual elements:</strong> A small professional headshot or company logo can increase recognition. But keep it modest – aim for subtlety rather than flash.</li>\n\n\n\n<li><strong>Social proof: </strong>Choose 2-3 relevant professional profiles. <a href=\"https://www.linkedin.com/\">LinkedIn</a> is often essential, while other choices depend on your field. A portfolio site works well for creatives, while <a href=\"https://github.com/\">GitHub</a> is a must for developers. And of course, if you need a versatile profile platform that can display a wide range of information, links, and media, all in a compact design, then a Gravatar profile is a must.&nbsp;</li>\n</ul>\n\n\n\n<p>Now, besides these basic elements, there are also some practical additions that would vary based on your needs:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Calendar booking link if you schedule lots of meetings.</li>\n\n\n\n<li>Industry certifications for specialized fields.</li>\n\n\n\n<li>Office location or timezone for global teams.</li>\n\n\n\n<li>Languages spoken for international work.</li>\n\n\n\n<li>Pronouns for inclusive communication.</li>\n\n\n\n<li>Legal disclaimers if required by your industry.</li>\n</ul>\n\n\n\n<p>Remember: <strong>White space is your friend</strong>. A clean, readable signature beats an overcrowded one every time.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Design Tips to make your email signature stand out</strong></h2>\n\n\n\n<p>Email signatures need precise design choices to look professional across different devices and email clients. Here&#8217;s how to create one that works everywhere:</p>\n\n\n\n<p><strong>Size guidelines that prevent problems:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Keep the total width under 600px – this ensures your signature displays correctly on mobile devices.</li>\n\n\n\n<li>Limit height to 150 or 200px maximum to avoid overwhelming your message.</li>\n\n\n\n<li>Size company logos at 100x50px.</li>\n\n\n\n<li>Set headshots to 80x80px square.</li>\n\n\n\n<li>Leave 10px minimum spacing between elements.</li>\n</ul>\n\n\n\n<p><strong>Typography and formatting:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Set your name in 14-16px font size – it should be instantly noticeable.</li>\n\n\n\n<li>Use 11-12px for contact details and other information.</li>\n\n\n\n<li>Stick to standard, professional fonts like Arial or Helvetica.</li>\n\n\n\n<li>Pick two brand colors at most, plus black or gray for text.</li>\n\n\n\n<li>Organize information in order of importance.</li>\n\n\n\n<li>Use simple separators like pipes ( | ) between elements.</li>\n</ul>\n\n\n\n<p><strong>Technical requirements to prevent display issues:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Apply inline CSS to maintain consistent formatting.</li>\n\n\n\n<li>Structure elements to stack properly on mobile screens.</li>\n\n\n\n<li>Test your signature in major email clients (<a href=\"https://www.microsoft.com/en-us/microsoft-365/outlook/email-and-calendar-software-microsoft-outlook\">Outlook</a>, <a href=\"https://mail.google.com/mail/u/0/\">Gmail</a>, <a href=\"https://www.icloud.com/mail/\">Apple Mail</a>).</li>\n\n\n\n<li>Compress images under 40KB to ensure quick loading.</li>\n</ul>\n\n\n\n<p>Hierarchy matters – put your most important information first. Think about what your recipient needs to know right away versus what can go below. A clear structure with proper spacing helps readers find what they need quickly.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Examples of well-designed email signatures</strong></h3>\n\n\n\n<p>To help you get inspired, here are some interesting templates from <a href=\"https://www.canva.com/search?q=email+signature\">Canva</a> that really capture what makes a great email signature.&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Minimalistic signature without a headshot:&nbsp;</li>\n</ul>\n\n\n\n<img width=\"660\" height=\"330\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/black-white-minimalist-personal-professional-email-signature.png?w=660\" alt=\"Example of a minimalistic email signature for a manager\" class=\"wp-image-2676\" />\n\n\n\n<ul class=\"wp-block-list\">\n<li>Elegant signature with a photo:&nbsp;</li>\n</ul>\n\n\n\n<img width=\"660\" height=\"330\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/white-simple-real-estate-business-email-signature.png?w=660\" alt=\"Example of a simplistic email signature for a real estate agent \" class=\"wp-image-2677\" />\n\n\n\n<ul class=\"wp-block-list\">\n<li>Another design for a real estate agent with a cover photo.&nbsp;</li>\n</ul>\n\n\n\n<img width=\"660\" height=\"330\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/black-and-yellow-elegant-realtor-email-signature.png?w=660\" alt=\"Example of an email signature for a real estate agent with a cover photo\" class=\"wp-image-2678\" />\n\n\n\n<ul class=\"wp-block-list\">\n<li>A very unique approach for a graphic designer, allowing them to show their creativity even through their email signature.&nbsp;</li>\n</ul>\n\n\n\n<img width=\"660\" height=\"330\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/orange-green-gradient-creative-graphic-designer-email-signature.png?w=660\" alt=\"Example of an email signature for a graphic designer\" class=\"wp-image-2680\" />\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Automating design with an email signature generator</strong></h3>\n\n\n\n<p>While working with a designer gives you the most polished results, email signature generators offer a practical starting point. These tools handle the technical details and help you create something professional without diving into HTML or CSS.</p>\n\n\n\n<p>Here are some reliable options:</p>\n\n\n\n<h4 class=\"wp-block-heading\"><a href=\"https://www.hubspot.com/email-signature-generator\"><strong>HubSpot Email Signature Generator (Free)</strong></a></h4>\n\n\n\n<img width=\"660\" height=\"404\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/hubspot-email-signature-generator.png?w=660\" alt=\"Hubspot email signature generator\" class=\"wp-image-2681\" />\n\n\n\n<ul class=\"wp-block-list\">\n<li>Provides clean, professional templates.</li>\n\n\n\n<li>Easy to customize colors and layout.</li>\n\n\n\n<li>Exports HTML code you can copy directly.</li>\n\n\n\n<li>No account required.</li>\n</ul>\n\n\n\n<h4 class=\"wp-block-heading\"><a href=\"https://www.wisestamp.com/\"><strong>WiseStamp</strong></a></h4>\n\n\n\n<img width=\"660\" height=\"391\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/wisestamp-email-signature-generator.png?w=660\" alt=\"WiseStamp email signature generator\" class=\"wp-image-2682\" />\n\n\n\n<ul class=\"wp-block-list\">\n<li>Offers multiple professional templates.</li>\n\n\n\n<li>Integrates with major email clients.</li>\n\n\n\n<li>Includes advanced features like banners.</li>\n\n\n\n<li>Paid plans start at $5.80/month.</li>\n\n\n\n<li>Also offers an email signature management service.&nbsp;</li>\n</ul>\n\n\n\n<h4 class=\"wp-block-heading\"><a href=\"https://newoldstamp.com/\"><strong>NewOldStamp</strong></a></h4>\n\n\n\n<img width=\"660\" height=\"355\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/newoldstamp-graphbic.png?w=660\" alt=\"NewOldStamp homepage\" class=\"wp-image-2683\" />\n\n\n\n<ul class=\"wp-block-list\">\n<li>Built for teams and companies.</li>\n\n\n\n<li>Manages signatures across departments.</li>\n\n\n\n<li>Ensures brand consistency.</li>\n\n\n\n<li>Team pricing available.</li>\n</ul>\n\n\n\n<h4 class=\"wp-block-heading\"><a href=\"https://www.canva.com/\"><strong>Canva</strong></a></h4>\n\n\n\n<img width=\"660\" height=\"455\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/canva-brand-kit.png?w=660\" alt=\"Example of a Canva editor with the brand kit feature\" class=\"wp-image-2679\" />\n\n\n\n<ul class=\"wp-block-list\">\n<li>A wide variety of email signature templates.&nbsp;</li>\n\n\n\n<li>Interesting graphics and design tools.&nbsp;</li>\n\n\n\n<li>An AI writing and design tool for the PRO version.&nbsp;</li>\n\n\n\n<li>Versatile applications – use it for marketing campaigns, social media, blog posts, etc.&nbsp;</li>\n\n\n\n<li>Lets you create a brand kit to use on all your visuals.&nbsp;</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Why you should link to your Gravatar profile for more impact</strong></h2>\n\n\n\n<img width=\"660\" height=\"457\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/ronnie-gravatar-profile.png?w=660\" alt=\"Ronnie Burt’s Gravatar profile\" class=\"wp-image-2684\" />\n\n\n\n<p>An email signature has limited space, but your <a href=\"https://gravatar.com/profile\">Gravatar profile</a> can showcase everything about your professional identity, just like a <a href=\"https://blog.gravatar.com/2024/11/08/creating-a-digital-business-card/\">dynamic business card</a>. Think of it as an extension of your signature – one that updates automatically across all platforms where you use your email.</p>\n\n\n\n<p>Your Gravatar profile becomes a comprehensive hub for:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Professional background and accomplishments.</li>\n\n\n\n<li>Portfolio pieces and project highlights.</li>\n\n\n\n<li>Complete set of social media profiles.</li>\n\n\n\n<li>Full contact information.</li>\n\n\n\n<li>Recent blog posts or updates.</li>\n\n\n\n<li>Speaking engagements or events.</li>\n</ul>\n\n\n\n<p>The magic happens in the synchronization. Update your Gravatar profile once, and those changes appear everywhere your email is used – including past emails. No need to update multiple signatures or worry about outdated information floating around.</p>\n\n\n\n<p>This approach solves a common problem: Keeping professional information current across platforms. A hiring manager might find your year-old email with an outdated job title, but clicking your Gravatar link shows them your current role and achievements.</p>\n\n\n\n<a href=\"https://gravatar.com/connect/?gravatar_from=blog\"><img width=\"3243\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/free_profile_cta.png\" alt=\"\" class=\"wp-image-2616\" /></a>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Crafting CTAs to your Gravatar profile in your email signature</strong></h3>\n\n\n\n<p>One option is to add the Gravatar icon to your email signature as you would for any other online profile. This works well, though as Gravatar can be used for a wide range of purposes it might not give your recipients enough context about what they’ll find when they open it. Another option is to link to your Gravatar profile with clear, action-oriented text that hints at the value:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>&#8220;See my complete portfolio and background.&#8221;</li>\n\n\n\n<li>&#8220;Find my latest projects and contact info.&#8221;</li>\n\n\n\n<li>&#8220;Connect with me professionally.&#8221;</li>\n\n\n\n<li>&#8220;View my full professional profile.&#8221;</li>\n</ul>\n\n\n\n<p>Match your CTA to your goals. If you&#8217;re job hunting, emphasize your portfolio. For networking, focus on connection opportunities. The right CTA tells recipients exactly what they&#8217;ll gain by clicking through.</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Create an effective email signature with the help of Gravatar</strong></h2>\n\n\n\n<p>Gravatar actually makes it super easy. Just login to your profile editor, copy your email signature code, and paste it in. </p>\n\n\n\n<img width=\"2086\" height=\"970\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/02/cleanshot-2025-02-18-at-12.24.39402x.png\" alt=\"\" class=\"wp-image-2932\" />\n\n\n\n<p><strong>Here’s how:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Head to&nbsp;<a href=\"http://gravatar.com/profile\">gravatar.com/profile</a></li>\n\n\n\n<li>click on&nbsp;<strong><em>Email signature</em></strong>&nbsp;in the bottom left</li>\n\n\n\n<li>grab the code and paste it into Gmail or your email client</li>\n</ul>\n\n\n\n<p>Check out our&nbsp;<a href=\"https://support.gravatar.com/your-profile/email-signature/\">quick setup guides</a>&nbsp;for Gmail, Apple Mail, and other popular email tools.</p>\n\n\n\n<p>Email signatures perform a delicate balancing act. Add too much information, and you risk looking unprofessional. Add too little and recipients miss important context about who you are.</p>\n\n\n\n<p>Linking to a Gravatar profile offers an elegant solution. Your email signature stays clean and focused, while still giving recipients access to everything they might want to know about you. Plus, you never have to worry about outdated information lingering in old emails – your Gravatar profile updates everywhere, automatically.</p>\n\n\n\n<p>Here&#8217;s what makes this approach particularly effective:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Recipients get a complete picture of your professional identity.</li>\n\n\n\n<li>Your signature stays concise and professional.</li>\n\n\n\n<li>Information stays current without manual updates.</li>\n\n\n\n<li>Old emails maintain their relevance.</li>\n\n\n\n<li>You control how much information to share.</li>\n</ul>\n\n\n\n<p>A well-crafted email signature paired with a Gravatar profile helps you make stronger professional connections. Recipients can learn exactly what they need about you, whether that&#8217;s your latest work, professional background, or preferred contact methods.</p>\n\n\n\n<p>Ready to enhance your email signature? <a href=\"https://gravatar.com/profile\">Create your free Gravatar profile </a>and start building a more effective professional presence.</p>\n\n\n\n<a href=\"https://gravatar.com/connect/?gravatar_from=blog\"><img width=\"3243\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/free_profile_cta.png\" alt=\"\" class=\"wp-image-2616\" /></a>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 28 Feb 2025 16:27:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"Do The Woo Community: WordCamp Asia 2025 Photo Memories\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=91875\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://dothewoo.io/blog/wordcamp-asia-2025-photo-memories/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:160:\"Well this year I had the opportunity to take just a few more photos despite being incredibly busy with the booth. So as they say, a picture is a thousand words.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 28 Feb 2025 13:22:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"bbPress: bbPress 2.6.12 is out!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://bbpress.org/?p=243415\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://bbpress.org/blog/2025/02/bbpress-2-6-12-is-out/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1535:\"<p>bbPress 2.6.12 is a <strong>minor</strong> release that fixes <em>1 security issue</em> and <a href=\"https://bbpress.trac.wordpress.org/query?status=closed&milestone=2.6.12\">1 small bug</a>.</p>\n\n\n\n<p>The security issue was responsibly disclosed via the <a href=\"https://hackerone.com/wordpress\">WordPress HackerOne bounty program</a>. It does not appear to be actively exploited, and specifically targets: single-site WordPress installations, newer than 5.3.0, with the &#8220;Membership&#8221; setting set to &#8220;Anyone can register&#8221;, and with bbPress active.</p>\n\n\n\n<p><em>(Even if that isn&#8217;t you, you should still update bbPress to 2.6.12 anyways!)</em></p>\n\n\n\n<p>The minor bug was a regression to the search component introduced in 2.6.11, causing search results to not be as accurate as everyone deserves for them to be. <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f575.png\" alt=\"🕵\" class=\"wp-smiley\" /></p>\n\n\n\n<p>Both of these fixes are already merged into the 2.7 development branch.</p>\n\n\n\n<p>Thank you to <a href=\"https://profiles.wordpress.org/gdragon/\"></a><a href=\"https://bbpress.trac.wordpress.org/query?status=!closed&reporter=GDragoN\">GDragoN</a> and mungah (via HackerOne) for your help fixing bugs, and <a href=\"https://bbpress.org/forums/profile/robin-w/\">Robin W</a> for keeping the bbPress.org Forums squeaky clean and well-supported! I really appreciate all of y&#8217;all! <img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f41d.png\" alt=\"🐝\" class=\"wp-smiley\" /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 26 Feb 2025 19:40:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"John James Jacoby\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: #158 – John Overall on How Podcasting Shaped His WordPress Journey\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=187567\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://wptavern.com/podcast/158-john-overall-on-how-podcasting-shaped-his-wordpress-journey\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:48337:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, how podcasting shaped our guests WordPress journey.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice, or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox and use the form there.</p>\n\n\n\n<p>[00:01:11] <strong>Nathan Wrigley:</strong> So on the podcast today, we have John Overall. John is a veteran in the WordPress podcasting world, bringing over 16 years of experience with the WP Plugins A to Z show. He&#8217;s an early adopter of WordPress, and has seen the platform evolve and grow, and has built a wealth of knowledge around plugins, which he thinks have been pivotal to WordPress&#8217;s versatility.</p>\n\n\n\n<p>John shares his journey into the world of podcasting, initially using it as a tool to grow his business, and expand his expertise within the WordPress ecosystem. He gets into how the podcast landscape has shifted from its early days to the present, with technological advances making it easier than ever to produce and distribute shows.</p>\n\n\n\n<p>We talk about the evolution of WordPress plugins, how they have shaped the WordPress platform over the years, and John&#8217;s unique approach to managing and understanding these powerful tools, making a podcast to help him better understand what each plugin does.</p>\n\n\n\n<p>John also shares stories about his interactions with his audience, and how the podcast has forged connections that might not be the norm for client relationships.</p>\n\n\n\n<p>We move into the ever changing WordPress environment, and John shares predictions and insights about the platform&#8217;s future, and how he&#8217;s using podcasting as a medium to continually learn and adapt, which in turn benefits his audience.</p>\n\n\n\n<p>Something new for John is how he&#8217;s involving his family in his podcasting journey. His daughter has breathed new life and perspectives into the show, hoping to appeal to a younger generation while retaining his loyal audience.</p>\n\n\n\n<p>If you&#8217;re passionate about WordPress, podcasting, or just interested in understanding a holistic approach to long-term content creation and audience engagement, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you John Overall.</p>\n\n\n\n<p>I am joined on the podcast by John Overall, how are you doing?</p>\n\n\n\n<p>[00:03:20] <strong>John Overall:</strong> I am doing fantastic, thanks Nathan. I appreciate being on your show.</p>\n\n\n\n<p>[00:03:24] <strong>Nathan Wrigley:</strong> I am really pleased to have John. I want to call you Jonathan. Is there a time when you were a Jonathan or have I just misremembered?</p>\n\n\n\n<p>[00:03:31] <strong>John Overall:</strong> No, no, I&#8217;ve been called Jonathan, Johnny, Johnny Boy. I answer to all kinds of names. My mom actually calls me Alan because she refuses to call me John.</p>\n\n\n\n<p>[00:03:40] <strong>Nathan Wrigley:</strong> Well, it&#8217;s an absolute pleasure having you on the podcast today.</p>\n\n\n\n<p>Very frequently when I interview people, people tell me that they&#8217;ve listened to my podcast and I find that really, I get quite emotional when people do that, I think that&#8217;s lovely. But the tables are turned, because today I&#8217;m here to say that I have listened to Jonathan&#8217;s podcast many, many times in the past.</p>\n\n\n\n<p>And I was just saying that there was a period of time in my life when my children went to music lessons. And I used to accompany them to those music lessons, and I had to sit in the, if you call it like a waiting room, basically. Every week I would sit there faithfully listening to your plugin podcast, you know, it was the, we call it A to Z, but you call it A to Z. And I would listen to you talking about plugins, and giving them ratings and what have you with your co-host. And so this is a bit of a stars in my eyes moment. I&#8217;m so pleased to have you on the podcast.</p>\n\n\n\n<p>[00:04:31] <strong>John Overall:</strong> Well, I appreciate that. And yeah, the WP Plugins A to Z, and we do call it Z here in Canada. But when I had my American co-host in the beginning years, he called it Z. So we used to argue with it. And then we actually have someone, our intro, one of my listeners, he recorded it, and we have a minor intro that says, it&#8217;s WP Plugins, A to Z, not Z. It&#8217;s still something we use. It was generated years ago by one of the listeners. But yeah, it&#8217;s been a longstanding show. It&#8217;s been around for over 16 years now.</p>\n\n\n\n<p>[00:05:00] <strong>Nathan Wrigley:</strong> So I really didn&#8217;t know that podcasts were a thing. And podcasts came into my life at the moment when mobile phones had apps that could do that. I didn&#8217;t listen to them on desktop or anything like that. And it was always for me, a bit of dead time. I wouldn&#8217;t listen to them in the car or anything like that. I would always listen to them in a moment where I was sat in a chair and had nothing else to pay attention to. And I just found them immediately really, really important in my life.</p>\n\n\n\n<p>And then I found WordPress. And then quickly found a bunch of podcasts which I listened to, and yours was the one that somehow settled in my brain as the, I&#8217;m going to music now, I&#8217;m going to sit for half an hour and consume the podcast.</p>\n\n\n\n<p>And really, without listening to podcasts like yours, my life would&#8217;ve been very different, I think. Because it occurred to me that, as I was listening to you and your co-host talk, I got a sense of, well, you&#8217;re not a media personality. You are not somebody who is sitting in some sort of CNN type studio producing content. You are a guy that does the kind of job that I do. And I got a real sense of, gosh, maybe this is something that I could explore at some point. And there we go, and the rest is history. That&#8217;s now all I&#8217;ve done for many years.</p>\n\n\n\n<p>[00:06:07] <strong>John Overall:</strong> Well I will gladly take the credit for expanding podcasting. I&#8217;ve enjoyed podcasting since the beginning. I discovered it as I graduated from my applied communication program at college, which led me into the internet. And it was shortly after that that we saw the rise of it. And of course, Adam Curry from the No Agenda Show, who is known as the Pod Father, he created podcasting as it stands today with the RSS feeds.</p>\n\n\n\n<p>And he&#8217;s even ensured that it&#8217;s going to stay a free and open source platform due to the now existing podcasting index. Which is where everybody gets that in their newfangled apps. Like I quit using the apps from the Apple store for my podcast. I use the newer apps, because they do a much better job and they go into the podcast and index for everything.</p>\n\n\n\n<p>So, yeah, it&#8217;s really great. And the nice thing is, what it did was allowed me, with WordPress in particular, was to expand my knowledge. Because I used it to build my knowledge. I saw WordPress and what it was doing with the plugins. Because in the beginning, WordPress was great for a blogging platform. I started using it probably about version two, so they were like two, maybe two and a half years old when I discovered WordPress.</p>\n\n\n\n<p>I&#8217;d seen it once before when it first came out, and one of my clients put it on my server and I almost banned it from my server because its use of resources was ridiculous. It was literally crashing one of my servers. But I ended up working with it, and it kept getting better and better and better. And then when they introduced the plugins to it, to expand it into a full CMS, I went, oh dear God, this is going to be huge.</p>\n\n\n\n<p>And I&#8217;ve watched it as it climbed from like, I went back recently to look at my first episodes. My first episode there was less than 9,000 plugins available for WordPress. I watched it grow and grow and grow and grow. And now there&#8217;s over, hundreds of thousands of plugins. The WordPress repository has only 50,000. At one point they had 90,000, so they&#8217;ve cleaned out a big mess, it has expanded it, and it&#8217;s going to take, you know, WordPress is going into, it&#8217;s in a changing mode right now.</p>\n\n\n\n<p>WordPress is in a massive flux right now, with all the things that have occurred in the last six months. But many people have been panicking, oh my God, It&#8217;s going to go away. It&#8217;s like, no, it&#8217;s not going anywhere. It&#8217;s going to change, and a lot of things are going to be different, but there&#8217;s too many people in the world making a living, depending upon their daily bread, their monthly rents, having WordPress fully functioning. And there&#8217;s companies that are as big as Automattic, if not bigger, that are using WordPress.</p>\n\n\n\n<p>I was reading an article yesterday of the top 12 websites built in WordPress. We&#8217;re talking NASA, The Times magazine, well, we know whitehouse.gov is using it. And you look at them and some of them are just insanely developed. And if it wasn&#8217;t for the plugin capability of WordPress, it wouldn&#8217;t be possible.</p>\n\n\n\n<p>[00:08:52] <strong>Nathan Wrigley:</strong> When you look back over all those years, so rewind until, let&#8217;s say the month, the year before you began your podcast journey, what was the thing that kicked you into doing podcasting? Was it just like a bit of serendipity? Did you know that you wanted to create audio content or was it just a bit of an accident?</p>\n\n\n\n<p>[00:09:09] <strong>John Overall:</strong> It was a bit of everything. What it really was, was I was just starting, I had just sold my computer store, so I was working off of money from selling a successful sale of a computer store I had for several years. Because I sold out the computer industry just before it went full mobile and impossible to really make a living with a computer store. And I was going back to the internet and developing websites and I was exploring things.</p>\n\n\n\n<p>I looked at Drupal, Joomla and WordPress, trying to figure out what would be the best CMS system so I wouldn&#8217;t have to write PHP code, and CSS by hand anymore, or at least minimise it. And I needed a way to reach people. And one of the ways, podcasts was just starting to pick up at that time, that was somewhere around 2010, 2011, right around there. And it was just starting to pick up, and I realised, wait a minute, people are listening to the podcast. I can start putting out a podcast and I can focus. And I looked at WordPress and I realised, you know, what would be the best component to focus on in WordPress?</p>\n\n\n\n<p>And so I chose plugins. And I went, okay, well I needed a domain. I went, WP Plugins, well, A to Z. And I had this really crazy idea at the beginning, because there was so few plugins, I was going to cover WordPress plugins, literally from A to Z. My first 20 episodes was A, B, C, D plugins starting with those letters. I got that far into it and I went, okay, this ain&#8217;t going to work, there&#8217;s no way.</p>\n\n\n\n<p>And people were adding them at a continuous rate every week. And I went, okay, this isn&#8217;t going to work, but it still constitutes, the name constituted everything. So I just started diving into what I thought was the best plugins, or if I used the plugin and I thought wasn&#8217;t very good, it was a way to warn people, please, avoid this plugin. Don&#8217;t make my mistake.</p>\n\n\n\n<p>So it was all of those things. So it was a little bit of serendipity, but what I was more after was growing my business. And it literally did grow my business for several years. I would suddenly get a call, or an email from people, because I put my email and everything into the shows. I would get emails from listeners saying, hey, I&#8217;ve been listening to your show for several months and I&#8217;m having this WordPress problem, and you talked about it. Can you fix it? And I said, well, hold on, let&#8217;s see what we can do.</p>\n\n\n\n<p>And so I still have six or seven clients from those early years, that have been clients ever since they came to me. And they came to me because, when people listen to you on podcasts they begin to trust you. They start to feel like they know who you are, because they&#8217;ve been listening to you. You&#8217;re a friend, you&#8217;re not a stranger. And because of that, what happens, I had people, they would contact me and I asked them for, I&#8217;m really cautious about what information I get from my clients to access their stuff, their hosting or whatever. And I get people and I ask them for this, and all of a sudden they&#8217;ve given me all of their keys to their castle. And they have no idea who I am. They don&#8217;t know if I&#8217;m trustworthy of that, but I&#8217;ve built that trust by the way they&#8217;ve heard me talk over the however period of time, months or years they&#8217;ve listened to my show.</p>\n\n\n\n<p>[00:11:55] <strong>Nathan Wrigley:</strong> It is interesting because from your perspective, you haven&#8217;t given out any metric which might be a measure of trust, but you have. You really have. I mean, giving that much time and putting out your thoughts, and speaking like you speak, and talking like you talk, and the language that you use, and the way that you present yourself, it does lend trust.</p>\n\n\n\n<p>And it is very, very similar with the podcasts that I listen to, dozens that I listen to each week. And I really do get a feeling that I know these people. I never thought of using a podcast as a marketing tool to be honest. But I do remember the sort of bits that you would drop in, and I thought, yeah, that was kind of interesting.</p>\n\n\n\n<p>Yeah, perfect, it ended up creating new business, not just a bit of fun that you had to crowbar into each week.</p>\n\n\n\n<p>[00:12:38] <strong>John Overall:</strong> It literally helped build my business, and it made it successful to sustain me for many years. And that&#8217;s what I&#8217;ve enjoyed. That&#8217;s part of what I&#8217;ve enjoyed about it.</p>\n\n\n\n<p>The other is, I got to meet lots of people virtually, all over the globe. In addition to the, well, we&#8217;re going to do episode 642 next week, and in addition to those episodes for just the WP plugins, I did interview shows, which were a separate episode. And I&#8217;ve done over 150 of those over the years.</p>\n\n\n\n<p>Plus I&#8217;ve also had three or four other podcasts, I kept thinking I was going to start different podcasts for different things, and I&#8217;d get maybe 20, 30, 100, 200 episodes into them, and then that&#8217;s like, okay, I don&#8217;t have time for these ones anymore, and they just fall by the wayside. In total I&#8217;ve probably got 2000 episodes of podcasts behind me for various podcasts.</p>\n\n\n\n<p>[00:13:23] <strong>Nathan Wrigley:</strong> You really are a veteran of this industry. How has it changed? Just for those of us who are podcasting nowadays, it&#8217;s so simple. There&#8217;s a tool for everything. There&#8217;s a SaaS platform for everything. You can pay your monthly subscription, and it&#8217;ll more or less podcast for you really. But back in the day, when I started there were definite hurdles, but you were many, many years before me. So I&#8217;m imagining there was lots of hurdles to overcome just to get the thing out there.</p>\n\n\n\n<p>[00:13:49] <strong>John Overall:</strong> In the beginning it was really hard, especially if you had a host, a co-host. It&#8217;s like we didn&#8217;t have the easy software like we&#8217;re using right now for recording back and forth. Even now, I don&#8217;t use this software for doing mine. I use Microsoft Teams for recording with my co-host. But in the beginning we had, oh, what the heck was it called?</p>\n\n\n\n<p>[00:14:08] <strong>Nathan Wrigley:</strong> I&#8217;ll tell you what I used at the beginning and this will kind of date me. I used Skype.</p>\n\n\n\n<p>[00:14:13] <strong>John Overall:</strong> That&#8217;s it.</p>\n\n\n\n<p>[00:14:13] <strong>Nathan Wrigley:</strong> That was it.</p>\n\n\n\n<p>[00:14:14] <strong>John Overall:</strong> That was it? Skype? I was trying to remember what it was. It still loads on my computer when I reboot my computer and I have to shut it off because I just haven&#8217;t got around to, well, I haven&#8217;t rebuilt my computer for almost 10 years. I&#8217;m getting a new one this next year, because my computer&#8217;s finally ending its life.</p>\n\n\n\n<p>But yeah, Skype. And the other thing was, is we didn&#8217;t have the easy ways to clean up the audio feed that we have now. You get those high pitch wines, or bad cable, or background noise, or whatever, or even the mismatched audio levels. You had to actually go in and kind of edit that a little bit to get your audio as clean as possible.</p>\n\n\n\n<p>Because the biggest thing from the beginning I knew is, it doesn&#8217;t really matter what you&#8217;re talking about, if the audio&#8217;s not clean, people will stop listening. If the audio&#8217;s got annoying noises or something, or they can&#8217;t quite hear, or one host is suddenly blaring in the air and the other host is like a mouse talking in the other ear, they go, oh, I can&#8217;t listen to this. And they won&#8217;t listen to you.</p>\n\n\n\n<p>[00:15:09] <strong>Nathan Wrigley:</strong> Do you know, it&#8217;s really interesting because somebody warned me of this right at the beginning of my podcast journey, and they framed it even more than that. They said that if you&#8217;re watching a video and the quality of the video is poor, you&#8217;ll forgive that. But you&#8217;ll never forgive bad audio. You just can&#8217;t watch something on, let&#8217;s say, YouTube or a film or whatever if the audio is crackly or distorted. There&#8217;s just nothing, you know, unless you can lip read, there&#8217;s nothing coming at you that&#8217;s useful.</p>\n\n\n\n<p>And I remember taking that to heart and thinking, okay, that&#8217;s important. But then being frustrated by the technology that, just things like Skype couldn&#8217;t keep up. There&#8217;d be dropouts in everything, and so editing was a nightmare.</p>\n\n\n\n<p>[00:15:48] <strong>John Overall:</strong> Yes, it was. And although pretty much all my shows are live to tape, I discovered a program that&#8217;s called Level Later. And it&#8217;s a very old program, but what it does is you can take any audio file with multiple levels in it, you throw it into this, it runs it through some passes, some computer magic, and it comes out and all the levels are perfect in it. And I&#8217;ve been using Level Later for years now, because no matter how hard I try, I can never get the levels perfect when I&#8217;m recording it between two hosts. Because I&#8217;m not using intermediate software that&#8217;s doing it for me. I record mine straight to OBS.</p>\n\n\n\n<p>[00:16:22] <strong>Nathan Wrigley:</strong> Yeah, if you are thinking about getting into the podcasting world, and we can decide whether or not that&#8217;s useful these days given the dearth of podcasts. But if you are, honestly, it&#8217;s so straightforward now. I&#8217;m using, currently, an app called SquadCast, but there&#8217;s a whole bunch of rivals out there in the marketplace. There&#8217;s things like Riverside.FM and many, many others.</p>\n\n\n\n<p>And they allow you to record through a browser, and in this case, John&#8217;s track and my track will be isolated, I&#8217;ll download them both. And so that never happened. Before it was just one track that you had to, if your audio is mucky, then so was mine. There was no way of separating those two.</p>\n\n\n\n<p>But now yours will come separately, mine will come separately, and if I&#8217;ve got 10 guests, they&#8217;ll all be separate. And then I throw them into, similar to you, I throw them into an app which basically cleans things up and automatically levels things. And then will create transcripts, and it&#8217;s just miraculous. It&#8217;s so, so straightforward.</p>\n\n\n\n<p>[00:17:13] <strong>John Overall:</strong> It&#8217;s gotten really good. I&#8217;m, re-embracing all of that stuff. For the last four years, I&#8217;d taken my business down to the minimal levels of what I had to put into it, and I focused on my farmstead that I have, my urban farmstead. And in this last year I realised I needed to get back to my roots, and my WordPress and all of my other work. And so this last year we&#8217;ve been rebuilding everything.</p>\n\n\n\n<p>And the WP Plugin show, it went off the rails for a little while. I got a little political for a little while and lost a large chunk of my audience, and a lot of them are coming back now because I&#8217;ve got it back to what it was, the show it was before. It is allowing everything, and also I&#8217;ve got a new co-host in there, my daughter, been training in my business for the last five years to take over this business as I get ready for retirement time.</p>\n\n\n\n<p>She&#8217;s become my co-host on there. In fact, she&#8217;s more of the host than I am now. She does more of the talking and more of the direction of the show each week. Which is kind of interesting. It makes for a more interesting show, having a different viewpoint on it than mine. Because I think I went, when Marcus left the show back in 2016 or 17, and I did like four years of just me on the show. And it&#8217;s really hard to be a single host on a show week after week after week.</p>\n\n\n\n<p>[00:18:27] <strong>Nathan Wrigley:</strong> I feel your pain.</p>\n\n\n\n<p>[00:18:28] <strong>John Overall:</strong> That&#8217;s why you need guests or you need to have a co-host to help keep some life in it. Anyone who tries to do a podcast, like podcasts nowadays. Yeah, anyone can do them and, yes, there is a dearth of them, but the problem is, if you go look at those podcasts, about 80% of them never make it past episode 30.</p>\n\n\n\n<p>[00:18:45] <strong>Nathan Wrigley:</strong> Or even, I mean, it&#8217;s probably like 50% past episode one in all honesty.</p>\n\n\n\n<p>[00:18:50] <strong>John Overall:</strong> Yeah that too. They find out, wait a minute, this is a lot of work, and it&#8217;s really hard. It&#8217;s usually the ones that try to do it by themselves and they&#8217;ve got the momentum for the first 10, 15 episodes. After that, you&#8217;ve got to keep pushing yourself.</p>\n\n\n\n<p>[00:19:02] <strong>Nathan Wrigley:</strong> Yeah, there&#8217;s a grind, isn&#8217;t there? And although we&#8217;ve just made the case that making a podcast is straightforward, from a technological point of view, it&#8217;s easier than ever. But the grind hasn&#8217;t gone away. And in fact, new grind has been added in.</p>\n\n\n\n<p>So when you began, and when I began, social media was a bit of a thing, but not really. It wasn&#8217;t kind of an essential component. But now it&#8217;s almost like the only distribution mechanism, outside of RSS, and perhaps a WordPress website.</p>\n\n\n\n<p>All of those pieces have kind of got bundled in. So you have to make sure to promote it, and cross-promote it, and create, I don&#8217;t know, alternative, different snippets of it that go on this platform and that platform. So there&#8217;s a whole load of other things.</p>\n\n\n\n<p>It isn&#8217;t something that, unless you&#8217;ve got a real passion for it, it&#8217;s something that, like you said, episode 30 is probably going to be where you get and give in because you start in New Year, brand new, New Year&#8217;s resolution. January, I&#8217;m going to do a podcast, and you keep going for a little while. And I was telling you that there are very few things in my life where I&#8217;ve had the capacity to stick at it, but podcasting for some reason has worked for me. I guess I just like listening to my own voice.</p>\n\n\n\n<p>[00:20:05] <strong>John Overall:</strong> There&#8217;s that aspect too, listening to your own voice. Sometimes I listen to myself and I go, really? That&#8217;s me? You don&#8217;t get used to that. No matter all these years, I still can&#8217;t get used to my voice.</p>\n\n\n\n<p>But the other thing is, for some people, a lot of people use it to help improve their knowledge in their particular area they&#8217;re podcasting about.</p>\n\n\n\n<p>I like history podcasts from time to time. And those ones there, it means it&#8217;s a serious history buff doing a podcast about something he&#8217;s excited about. And what he&#8217;s getting a chance to do is share to the world what he&#8217;s doing.</p>\n\n\n\n<p>The same I do with WordPress, I share things to everybody about what is in the WordPress world and what&#8217;s changing. And now our show has moved in a different direction. We dropped down from the number of plugins we do each week. We have more discussion about things we see happening. There&#8217;s new segments coming into the show that&#8217;ll be talking about, here&#8217;s a problem in WordPress we found, how we solved it, coming from my daughter&#8217;s perspective, who, she&#8217;s five years into this, so she&#8217;s relatively new and everything. It&#8217;s like everything&#8217;s brand new to her. A lot of it&#8217;s all, oh yeah, it&#8217;s just CSS. I don&#8217;t understand that Dad. And I was like, oh yeah, you&#8217;re kind of new at this. I have to explain things.</p>\n\n\n\n<p>So when I&#8217;ve discovered problems, there&#8217;s problems I can solve in like 20 minutes and it takes her five hours because she doesn&#8217;t know where to go to see the problem. These are what I&#8217;m starting to bring back to the show. Stuff that used to be in the show and it had gotten lost along the way. And it&#8217;s also we&#8217;re talking about what we see changing in the WordPress environment, and how we see this environment evolving over the next couple years.</p>\n\n\n\n<p>We did a show, our Christmas and New Year&#8217;s shows were prerecorded. We do prerecorded shows usually about that time, so we can spend time with the family and not worry about the show. But we&#8217;d made predictions of what was coming in the New Year that hadn&#8217;t yet come to pass. By the time we did our first show, a week and a half ago, by the time we did our first show for the New Year, we had already had two or three successful predictions of what was changing in WordPress.</p>\n\n\n\n<p>We&#8217;re both starting to see this, which is exciting in the fact that, oh, okay, this sort of event is going to happen in WordPress and this is where it&#8217;s going to go. With all the doom and gloom, as I mentioned, the doom and gloom as I see, like I follow the forums over at the Reddits, and Twitters, and all over the place because I get our news from everywhere to keep up. And I see a lot of people, doom and gloom of people abandoning.</p>\n\n\n\n<p>I tried abandoning WordPress at the introduction of Gutenberg. I even took my show towards ClassicPress. And that happened for about two years. And then I realised, unfortunately, ClassicPress didn&#8217;t have a community momentum behind it, and WordPress kept going. Even though I currently build in WordPress, I don&#8217;t use Gutenberg, because no matter how many times I try to wrap my head around it, I can&#8217;t get my brain to think that way. And so I use Elementor for all my builds. And it allows me to continue using the Classic Editor.</p>\n\n\n\n<p>But that sort of thing is going to continue. They were going to supposedly stop supporting the Classic Editor, but unfortunately it&#8217;s not happening, because a good 50% of the WordPress community still uses the Classic Editor, and a page builder of some sort. Versus 50% that are using Gutenberg. And they can live together. It took me a while to realise that they can live together. You just have to work with it.</p>\n\n\n\n<p>I have a couple of clients who use Gutenberg. I can sort of muck my way through it if I really work at it. But it&#8217;s going to continue, and these things are going to keep changing and evolving. The WordPress plugins, I&#8217;ve seen the developers creating some amazing developments. When we just launched the new website for our business, we actually have a whole WP Pro A to Z lineup, WP Plugins, WP Pro A to Z.</p>\n\n\n\n<p>When we launched our new site, I found a plugin I didn&#8217;t know existed, which will be coming in one of my shows, upcoming. If you need a booking plugin and you use Gravity Forms, somebody wrote a full blown addition to Gravity Forms for a booking plugin. So you don&#8217;t have to go spend money on another third party service or a service as a software, SaaS service where you&#8217;re putting out money. You pay for this one plugin, integrate it into Gravity Forms and you get everything. And now it&#8217;s all in one form and you still control your data.</p>\n\n\n\n<p>[00:24:07] <strong>Nathan Wrigley:</strong> I really like the idea that you had of having that kind of theme running through, because in any of the podcasts I do, basically each episode is atomised, you know, it&#8217;s just an episode and then you listen to a different one, and there&#8217;s no real connection necessarily between the episodes. And I really like the idea of having a thread which runs through.</p>\n\n\n\n<p>But also, I am really curious about plugins in particular, and I would love to have the excuse to play with them. Because then it would be, air quotes, then it would be work suddenly. The excuse of, what are you doing? I&#8217;m doing work. I&#8217;m playing with a plugin.</p>\n\n\n\n<p>[00:24:39] <strong>John Overall:</strong> Play with a plugin, figuring it out, throw it on one of my dozens of domains that I&#8217;m doing nothing with, that collect all kinds of stuff.</p>\n\n\n\n<p>No, the other joy is, as you mentioned with plugins, is of course, because once developers rediscover us, and the way we review stuff, and we give honest reviews, we tell them, truthfully what we find wrong and what we don&#8217;t. We give a good, honest rating. It&#8217;s very seldom we&#8217;ll give a rating as low as a two, but it has happened in the past.</p>\n\n\n\n<p>We don&#8217;t automatically like give it a five, it has to be worthy of a five. Most of them fall between three and four, which is where most of them are anyway.</p>\n\n\n\n<p>But the other joy is, is I get developers, they got a premium plugin and they go, hey, you want to check it out and I say, yeah, give me your premium plugin and a license, all give it a review.</p>\n\n\n\n<p>So I get to play with premium plugins without having to spend the money on them, which is a joy. But it also allows people to find out what it might do. And the other thing that&#8217;s coming again, I used to have training videos, create training videos on how to use plugins. In fact, my training videos on my YouTube channel, some of them are still some of my highest rated plugins.</p>\n\n\n\n<p>[00:25:38] <strong>Nathan Wrigley:</strong> I feel that I was really lucky being in the WordPress community, then discovering podcasting. Because I feel like all the pieces of the jigsaw, which go into making a podcast, are easily handled with WordPress. And so that was just a nice bit of serendipity. If you understand how to put a website up, well, that&#8217;s one thing you kind of really do need if you&#8217;re going to have a podcast.</p>\n\n\n\n<p>And there&#8217;s plugins which will handle the RSS feed. There&#8217;s plugins which will handle the contact forms. There&#8217;s plugins which will handle the display of your website if you&#8217;re not using Core. And so I felt that talking about WordPress, and having the capacity to use WordPress was a real boon for me. Just made the whole thing much more straightforward. But like you&#8217;re describing about your daughter, not the same for everybody.</p>\n\n\n\n<p>[00:26:21] <strong>John Overall:</strong> Yeah, well, one of the interesting things about, when you mentioned a plugin for this and a plugin for that, you remember the early days of the Apple advertising, There&#8217;s an app for that.</p>\n\n\n\n<p>[00:26:29] <strong>Nathan Wrigley:</strong> For the iPhone, yeah.</p>\n\n\n\n<p>[00:26:30] <strong>John Overall:</strong> We used to say for the longest time, well, there&#8217;s a plugin for that.</p>\n\n\n\n<p>[00:26:32] <strong>Nathan Wrigley:</strong> Yeah. And there was.</p>\n\n\n\n<p>[00:26:34] <strong>John Overall:</strong> There literally was, and there still is. And if you don&#8217;t think there is, it&#8217;s easy enough to build. It&#8217;s like, I&#8217;ve actually gone so far, in the last couple of years, to pay developers to create plugins for me. Sometime around the end of this year we&#8217;ll be introducing a plugin that has not been created yet for any of the things on WordPress. We&#8217;ve been working on something, and so that&#8217;s a little tidbit of what&#8217;s coming. As we get closer to the beta release, which is expected, the beta release is expected September, October of this year. Then we&#8217;ll be talking more and more in depth about this plugin.</p>\n\n\n\n<p>[00:27:07] <strong>Nathan Wrigley:</strong> Do you still intend to keep going with your podcast into the, basically into the future, forever? Do you have a sort of timeline, like when you get to, I don&#8217;t know, a thousand episodes of this particular podcast, that&#8217;ll be it?</p>\n\n\n\n<p>[00:27:18] <strong>John Overall:</strong> As long as the show has still got listeners, and some audience, and it still provides value for what we do, no. Because one of the biggest things, and even my daughters realised this. Because she has to do research for every episode, because a lot of people don&#8217;t realizse, okay, you do a podcast, oh, it&#8217;s about an hour long. They don&#8217;t realise that that hour long required three to four hours of research in preparation of your notes and everything for the show, plus whatever post-production, everything else. By the time you&#8217;re done, a one hour show is usually a five to seven hour investment of time.</p>\n\n\n\n<p>The thing is, when you&#8217;re doing that research, what it does is that increases your knowledge, because you&#8217;re looking at things you hadn&#8217;t looked at before, and it helps increase and input more knowledge into you, and expand your knowledge as an expert in the field. Many, many people started podcasts as a side hobby, and turned into experts in their field, because of their podcast. That&#8217;s what it forces you to do, is it forces you to become an expert in whatever field your podcast focuses on.</p>\n\n\n\n<p>[00:28:18] <strong>Nathan Wrigley:</strong> Did you ever get into creating podcast websites for people?</p>\n\n\n\n<p>[00:28:22] <strong>John Overall:</strong> No.</p>\n\n\n\n<p>[00:28:22] <strong>Nathan Wrigley:</strong> No, me neither. And there&#8217;s some part of me which regrets that, because I think that would&#8217;ve been a real good wheelhouse for me.</p>\n\n\n\n<p>[00:28:28] <strong>John Overall:</strong> It would&#8217;ve been, and it would&#8217;ve been except for, you would&#8217;ve been changing a lot, and the investment in time and the screenshots for it would be even higher than the investment in time I&#8217;ve got now.</p>\n\n\n\n<p>It was all about how much investment in time versus the return on that investment in time. It is how I&#8217;ve done it.</p>\n\n\n\n<p>I did training videos, and my training videos are still some of the highest viewed videos on YouTube, and they&#8217;re old and ancient now, and they&#8217;re out of date. And I even got a question from one of the training videos, what was it, a couple of months ago, somebody contacted me and asked me questions. I said, oh, dear God, I forgot I did that.</p>\n\n\n\n<p>And when I went and looked at it, I said, I&#8217;m sorry, it&#8217;s out of date. I haven&#8217;t used that plugin in four or five years now, so I don&#8217;t know. And this is the problem of it. And so I&#8217;m starting to create new ones, partly because I&#8217;m creating these training videos for my clients to be able to manage their sites. Because my job as a web designer is not to manage their website forever, but build them a website that they can do all their own content and not keep having me having to put the content in, because they don&#8217;t want to pay the fees for simple things like adding content.</p>\n\n\n\n<p>And so we build websites to do that, but they need instructions on how to do it. So we build nice, simple training videos that they can go look at and remind themselves how to do it. And so I&#8217;m actually starting to do that with the plugins again. And for plugins, in fact, one of my training videos for a plugin I did a few years ago, the plugin developer adopted that video right into their code as their training video for how to use the plugin. I do do very detailed, and something people told me was, I&#8217;m very good at translating geek to English.</p>\n\n\n\n<p>And that was the nice thing is, if you try to tell them how to do it in geek, and a lot of computer guys, they can&#8217;t translate geek to English.</p>\n\n\n\n<p>[00:30:09] <strong>Nathan Wrigley:</strong> Also you have this strange thing on an audio podcast where in many cases you&#8217;re trying to describe the functionality of something, which would be so much easier if you could just see it. So it does this, and the way it does this, oh, okay, and you have to try and explain it. And sometimes that involves saying, well, you have to tick this box over here, and then go over here, and do this, and this.</p>\n\n\n\n<p>And it really does make you stop and think, what&#8217;s the best way to describe this? What&#8217;s going to work? What&#8217;s not going to work? And I think you&#8217;re right, it does make you think around the problem. They say that if you can teach something, then you truly understand it. I think there&#8217;s a little bit of that in there.</p>\n\n\n\n<p>[00:30:42] <strong>John Overall:</strong> That was the other thing I did in the beginning of WordPress. I actually taught WordPress. I had courses here in Victoria where I live. I had night classes that people would sign up and come pay me money to teach them how to use WordPress. And I did those for about, all the way up until version four of WordPress when YouTube got flooded with tutorials and my courses became irrelevant. But for a few years, that was another way I expanded my knowledge was I taught it to people, because in preparation to teach it, I had to know what I was telling people.</p>\n\n\n\n<p>[00:31:10] <strong>Nathan Wrigley:</strong> You mentioned that there was a period of time where you fell out with podcasting or it fell out with you, or whatever it may be. You sort of dropped away from it. Did you find though, that when you came back, you mentioned that the audience is sort of still there? The curious thing for me is, I noticed this just the other day, a podcast that is in my podcast player that I have never listened to for years, and the reason I haven&#8217;t listened is because they just went away, but it&#8217;s still there.</p>\n\n\n\n<p>And then they came back. RSS is a bit brilliant like that. Because there&#8217;s no algorithm feeding it to you, there&#8217;s no algorithm like on YouTube saying, okay, now what about this. It jumped right to the top of my playlist. And I suddenly thought, gosh, I haven&#8217;t seen that one for a while. Click play, and the first words were, we&#8217;re back, we&#8217;ve had a couple of years off or whatever.</p>\n\n\n\n<p>I thought that was really cool. So I did wonder if your audience, by just mere fact of the way RSS readers work, and RSS feeds work with podcast players, if they&#8217;d stock with you, even though they didn&#8217;t know they were sticking with you.</p>\n\n\n\n<p>[00:32:05] <strong>John Overall:</strong> I&#8217;d say about one third of my audience, in truth, I never left it entirely. We would always put out a episode of WP Plugins A to Z. We would put out an episode, at worst it fell to an episode a month is what happened. It was never completely off the air. But the audience dropped down to, we&#8217;re about one third right now the audience we used to have.</p>\n\n\n\n<p>And a lot of them left me during my period of despair with the world, is lack of a better term. A lot of them left me during that period there. I chased a few of them away. Some of them I will earn back, some of them I won&#8217;t. Some of them have retired, I imagine, because what was interesting is my audience for the most part is as old or almost as old as me. And I&#8217;m pushing, you know, the upper echelons of fifties now. Because I&#8217;ve been doing this since my early forties. And some people, they&#8217;ve aged out.</p>\n\n\n\n<p>We&#8217;re actually, because my daughter is a millennial, she&#8217;s in her thirties now, we&#8217;re going after the people in her audience segment. We&#8217;re changing our audience focus. We&#8217;re no longer worried about the old time geeks, the ones that know what they&#8217;re doing. We want the younger people who don&#8217;t know where they&#8217;re going, what they&#8217;re doing, they&#8217;re looking for advice, they want to do these things.</p>\n\n\n\n<p>We&#8217;re working the audience to go after the younger generation, the millennials and the Zoomers, who are just now coming up into, okay, I need to build a business. What do I choose for building my website? Do I go with WordPress? Do I go with Shopify? Do I get Wix? Do I go crazy and go on a Drupal website? You know, it&#8217;s like, what are they going to do?</p>\n\n\n\n<p>And so we&#8217;re hoping that we can find these people that are hunting, and get them to look to us for the expertise and advice, and come see me. Like, I now have 25, actually 26 years now of experience in this industry. So I&#8217;ve just started offering consulting services for building a website. Because a lot of people don&#8217;t realise it&#8217;s like, you can dive into your website and you can spend, what&#8217;s your time worth? Is your time worth money, or is it not as valuable?</p>\n\n\n\n<p>So you can spend the next 70, 80 hours trying to figure things out. Or do you want to buy a few hours of my time and get some direction, and save yourself hours and hours of time, and know where you&#8217;re going with your website. Like, we&#8217;ve been fortunate enough to, in the last couple of years, build some very high frontend websites such as we rebuilt the website for the sierraclub.bc.ca, here in Western Canada.</p>\n\n\n\n<p>So we&#8217;ve had a few high-end websites like that we&#8217;ve built the last couple of years, to be able to showcase the kind of work and capabilities we have now. So it helps show that, yes, we have expertise in this. And I&#8217;m just going back and tying into all my years of knowledge now and bringing it back forward.</p>\n\n\n\n<p>[00:34:44] <strong>Nathan Wrigley:</strong> I think that&#8217;s a really credible thing to be able to show as well. You know, I&#8217;ve been doing a podcast for 15 odd years or something, it&#8217;s definitely a lot of credibility. But also I think it&#8217;s great that you&#8217;ve managed to sort of co-opt your daughter into it. So not only has that breathed a whole new generation of an audience into the podcast, but it&#8217;s also binding you to a family member, a close family member, and I think that&#8217;s lovely.</p>\n\n\n\n<p>[00:35:05] <strong>John Overall:</strong> Yeah, well, I&#8217;m also trying to co-op my granddaughters into it too.</p>\n\n\n\n<p>[00:35:08] <strong>Nathan Wrigley:</strong> Really a different generation.</p>\n\n\n\n<p>[00:35:10] <strong>John Overall:</strong> Neither one of my sons are much interested in technology, they&#8217;re so, so. But my oldest son&#8217;s become an electrician. My youngest son is looking at possibly going into trades as a welder. But my oldest son definitely is being an electrician, he starts as an apprentice as soon as he graduates.</p>\n\n\n\n<p>But it&#8217;s really good to bring in your next generations. If you have them, bring them in. If they&#8217;re excited in any way, find which component of your business they might be excited in, and put them into it. That&#8217;s one less person you have to worry about. And you can help ensure that maybe your business will last a couple of generations.</p>\n\n\n\n<p>[00:35:43] <strong>Nathan Wrigley:</strong> Well, Jonathan, unfortunately time has got the better of us. I really appreciate all of the content that you&#8217;ve put out there. I hope that it carries on and you&#8217;ll be able to make the new show with your daughter a real success. Where do people find you?</p>\n\n\n\n<p>[00:35:55] <strong>John Overall:</strong> You can find us online at two places, WP Plugins, A to Z, or Z for the Americans .com. And that&#8217;s where the show is hosted at. And all of our show notes are there. And you can also find us at wpproatoz.com. That&#8217;s our company website.</p>\n\n\n\n<p>[00:36:12] <strong>Nathan Wrigley:</strong> I will definitely put all of those links into the show notes. Jonathan Overall, thank you so much for chatting to me today. I really appreciate it.</p>\n\n\n\n<p>[00:36:19] <strong>John Overall:</strong> Thanks a lot, Nathan. It&#8217;s been a pleasure.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://wppluginsatoz.com/\">John Overall</a>.</p>\n\n\n\n<p>John is a veteran in the WordPress podcasting world, bringing over 16 years of experience with the WP Plugins A to Z show. He&#8217;s an early adopter of WordPress, and has seen the platform evolve and grow, and has built a wealth of knowledge around plugins, which he thinks have been pivotal to WordPress&#8217;s versatility.</p>\n\n\n\n<p>John shares his journey into the world of podcasting, initially using it as a tool to grow his business, and expand his expertise within the WordPress ecosystem. He gets into how the podcast landscape has shifted from its early days to the present, with technological advances making it easier than ever to produce and distribute shows.</p>\n\n\n\n<p>We talk about the evolution of WordPress plugins, how they have shaped the WordPress platform over the years, and John&#8217;s unique approach to managing and understanding these powerful tools, making a podcast to help him better understand what each plugin does.</p>\n\n\n\n<p>John also shares stories about his interactions with his audience, and how the podcast has forged connections that might not be the norm for client relationships.</p>\n\n\n\n<p>We move onto the ever-changing WordPress environment, and John shares predictions and insights about the platform&#8217;s future, and how he’s using podcasting as a medium to continually learn and adapt, which in turn benefits his audience.</p>\n\n\n\n<p>Something new for John is how he’s involving his family in his podcasting journey. His daughter has breathed new life, and perspectives, into the show, hoping to appeal to a younger generation while retaining his loyal audience.</p>\n\n\n\n<p>If you’re passionate about WordPress, podcasting, or just interested in understanding a holistic approach to long-term content creation and audience engagement, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://wppluginsatoz.com/\">WP Plugins AtoZ website</a></p>\n\n\n\n<p><a href=\"https://squadcast.fm/\"> SquadCast</a></p>\n\n\n\n<p><a href=\"https://riverside.fm/\"> Riverside.FM</a></p>\n\n\n\n<p><a href=\"https://www.classicpress.net/\">ClassicPress</a></p>\n\n\n\n<p><a href=\"https://elementor.com/\">Elementor</a></p>\n\n\n\n<p><a href=\"https://wpproatoz.com/\">WP Pro A to Z website</a></p>\n\n\n\n<p><a href=\"https://www.gravityforms.com/\">Gravity Forms</a></p>\n\n\n\n<p><a href=\"https://sierraclub.bc.ca/\">Sierra Club BC website</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 26 Feb 2025 15:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"Do The Woo Community: From Design to Deployment: Why Figma and Design Systems Are Essential for WordPress Projects\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=90664\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"https://dothewoo.io/blog/from-design-to-deployment-why-figma-and-design-systems-are-essential-for-wordpress-projects/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:227:\"Using Figma and design systems streamlines WordPress workflows, ensuring precision, consistency, and efficiency. Learn how structured design approaches empower developers and designers to create scalable, high-quality websites.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 26 Feb 2025 10:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Ash Shaw\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"Do The Woo Community: Insights and Innovations in WooCommerce: Embracing the Future\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=89390\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://dothewoo.io/blog/insights-and-innovations-in-woocommerce-embracing-the-future/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:167:\"Learn about WooCommerce\'s growth through community engagement, builder tools, core features, and the \"default to public\" philosophy for transparency and collaboration.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 25 Feb 2025 10:44:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"WordPress.org blog: Shaping Tomorrow at WordCamp Asia 2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18515\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://wordpress.org/news/2025/02/shaping-tomorrow-at-wordcamp-asia-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14237:\"<img width=\"1024\" height=\"512\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-WCAsia-02-21-PM_1280x640-1-scaled-1.jpg?resize=1024%2C512&ssl=1\" alt=\"WordCamp Asia 2025 attendees gathered for a group photo\" class=\"wp-image-18521\" />\n\n\n\n<p>Over 1,400 attendees from 71 countries gathered at the Philippine International Convention Center in Manila, and nearly 15,000 more joined online, for WordCamp Asia 2025.</p>\n\n\n\n<div class=\"wp-block-group is-nowrap is-layout-flex wp-container-core-group-is-layout-1 wp-block-group-is-layout-flex\">\n<blockquote><p>It&#8217;s the people. It&#8217;s the friendships and the stories.</p><cite>Matt Mullenweg, WordPress Cofounder</cite></blockquote>\n</div>\n\n\n\n<p>The flagship WordPress event started with a dedicated Contributor Day, followed by two days of engaging talks, panels, hands-on workshops, and networking. Notable guests included WordPress Cofounder <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> and Gutenberg Lead Architect <a href=\"https://profiles.wordpress.org/matveb/\">Matías Ventura</a>, who were joined by a diverse lineup of speakers and panelists.</p>\n\n\n\n<p>Throughout the event, the sponsor hall buzzed with activity as companies from across the WordPress ecosystem showcased their latest products, engaged with attendees, and offered live demos and giveaways.&nbsp;Each day, attendees refueled with diverse food offerings featuring Filipino favorites, turning meals into a prime networking opportunity where new connections were made and ideas were exchanged.</p>\n\n\n\n<h2 class=\"wp-block-heading\">New Ways to Engage</h2>\n\n\n\n<p>This year’s event introduced several new programs to the schedule:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Solutions Spotlight</strong>—a series of dynamic 10-minute lightning talks that gave an inside look at innovative products, cutting-edge strategies, and real-world solutions from top-tier sponsors, all designed to help attendees succeed in the WordPress ecosystem. These fast-paced sessions offered a unique opportunity to discover how leading brands are solving challenges, empowering users, and shaping the future of WordPress.</li>\n\n\n\n<li><strong>YouthCamp</strong>, a dedicated event for kids and teens ages 8-17, offered a full day of free, hands-on sessions designed to spark creativity and introduce the world of WordPress and open source. Through interactive workshops covering web basics, design, and development, participants gained practical skills while exploring the power of building online.&nbsp;</li>\n\n\n\n<li>The new <strong>Career and Social Corners</strong> enhanced networking, fostered meaningful connections, and created new opportunities for those within the WordPress community. Career Corner was the go-to space for attendees exploring career opportunities, connecting with sponsors, and discovering exciting new roles. Meanwhile, Social Corner offered a relaxed, lounge-style environment where attendees could engage in informal discussions over refreshments.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Contributor Day</h2>\n\n\n\n<p>WordCamp Asia kicked off with an incredible Contributor Day, bringing together almost 800 contributors, many of them new, to collaborate, share knowledge, and give back to WordPress. With 37 dedicated table leads and 16 experts from the Human Library guiding the way, participants of all experience levels engaged in meaningful discussions, tackled important tasks, and made a lasting impact on the WordPress project.</p>\n\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1834.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18526\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1914.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18537\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1989.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18527\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1926.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18524\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1920.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18530\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1963.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18525\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1902.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18528\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1886.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18534\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1885.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18531\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC07465.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18536\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n\n<p>Key contributions included resolving a critical media bug, advancing vertical text editing in Gutenberg, and refining the editing experience with dozens of issue closures. Performance optimizations and accessibility improvements abounded, joined by seven fresh patterns, and over 4,000 newly translated strings.</p>\n\n\n\n<p>New tools and workflows were explored to enhance testing and development. The day also saw meaningful conversations between hosting providers and users, improvements to event organizing processes, and hands-on training.</p>\n\n\n\n<p>With innovative ideas, new faces, and significant progress across multiple areas, Contributor Day reinforced the spirit of open source collaboration that drives WordPress forward.</p>\n\n\n\n<h2 class=\"wp-block-heading\">The Future is WordPress</h2>\n\n\n\n<p>On the first full conference day, attendees gathered to celebrate the power of open source collaboration and innovation. Opening remarks from global and local event leads reflected on the incredible journey of WordCamp Asia, tracing its roots back to the first Southeast Asian WordCamp in Manila in 2008. This full-circle moment underscored how the WordPress community has flourished over the years, driven by shared knowledge and a commitment to an open web. The excitement continued with a highly anticipated opening keynote from Matías Ventura, who shared insights into the future of Gutenberg and WordPress, inspiring attendees to embrace the next wave of innovation and creativity in content publishing.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n\n</div>\n\n\n\n<p>The day then began in earnest. Talks highlighted new ways to integrate WordPress with external applications, opening possibilities for more interactive and scalable digital experiences. Simultaneously, content strategists and marketers explored evolving best practices in SEO, learning how to optimize their sites for visibility, engagement, and long-term growth. These sessions emphasized the importance of adaptability in a constantly evolving digital landscape, ensuring that WordPress users stay ahead of industry trends.</p>\n\n\n\n<p>Workshops throughout the day provided hands-on learning experiences tailored to a wide range of skill levels. Developers refined their expertise, gaining practical knowledge they could apply to their own projects. Accessibility advocates led discussions on designing for inclusivity, showcasing strategies to make WordPress-powered websites more navigable and user-friendly for people of all abilities.</p>\n\n\n\n<p>As the conference continued into the afternoon, conversations expanded to performance optimization and emerging technologies shaping the future of WordPress. A dedicated session explored AI-driven workflows, demonstrating how artificial intelligence can enhance site performance, automate repetitive tasks, and create more personalized user experiences. These discussions showcased the evolving role of WordPress as a versatile platform that extends beyond traditional publishing.</p>\n\n\n\n<p>The first day culminated in a thought-provoking keynote panel, WordPress in 2030, where industry leaders explored the future of the platform. The discussion covered the expanding open source community, emerging technologies, and the role of education and mentorship. Panelists shared their perspectives on the opportunities and challenges ahead, encouraging attendees to actively shape the future of WordPress by contributing, innovating, and advocating for an open web.</p>\n\n\n\n<img width=\"1024\" height=\"442\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-CleanShot-2025-02-22-at-07.42.19%402x.jpg?resize=1024%2C442&ssl=1\" alt=\"Panelists Noel Tock, Hong Phuc Dang, Jon Ang, Courtney Robertson, and Raquel Manriquez discuss WordPress in 2030\" class=\"wp-image-18561\" />\n\n\n\n<p>Returning for the final day of WordCamp Asia 2025, attendees explored a new set of sessions designed to push the boundaries of web development and strategy. Technical discussions on advanced Gutenberg block development highlighted innovative ways to build more dynamic and interactive content experiences, while another session examined performance optimization strategies to enhance site speed, accessibility, and overall user engagement. Content creators and marketers gained valuable insights into audience growth, effective storytelling, and data-driven content strategies to maximize impact.</p>\n\n\n\n<p>The final sessions of the conference reinforced WordPress’s adaptability and innovation, equipping attendees with new skills and strategies.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Q&amp;A</h2>\n\n\n\n<p>As the final day drew to a close, Matt shared historic photos from WordCamp Davao 2008 in the Philippines, and then answered questions from the audience.</p>\n\n\n\n<div class=\"wp-block-embed__wrapper\">\n<span class=\"embed-youtube\"></span>\n</div>\n\n\n\n<p>Questions covered a variety of topics, incluiding: publishing on the open web, AI, headless WordPress, education, and Matt’s personal motivations. It was clear throughout the Q&amp;A that the future of WordPress is as bright as the island-themed attire at the event’s after-party.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Closing</h2>\n\n\n\n<p>Thank you to all the hard-working organizers who made this event possible, the speakers who took the stage, the visitors who ventured to Manila, and everyone who tuned in from around the world. Our hope is that every WordCamp attendee leaves with new knowledge, new friends, and new inspiration to build a better web.</p>\n\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1853.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18533\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"684\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-T2S_5388.jpg?resize=1024%2C684&ssl=1\" alt=\"\" class=\"wp-image-18547\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1877.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18535\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1800.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18523\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1861.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18532\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250220-DSC_1860.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18529\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-250221_12-35-12_N7A00461_NExT.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18545\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"683\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-DSC_2549.jpg?resize=1024%2C683&ssl=1\" alt=\"\" class=\"wp-image-18543\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"684\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250221-IMG_3709.jpg?resize=1024%2C684&ssl=1\" alt=\"\" class=\"wp-image-18546\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n<img width=\"1024\" height=\"768\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/20250222-b9848a28-a181-47dc-80af-4d2eb6a72756.jpg?resize=1024%2C768&ssl=1\" alt=\"\" class=\"wp-image-18540\" /><button class=\"lightbox-trigger\" type=\"button\">\n			\n				\n			\n		</button>\n\n\n\n\n<p>Be sure to mark your calendars for other major WordPress events in 2025: <a href=\"https://europe.wordcamp.org/2025/\">WordCamp Europe</a> (Basel, Switzerland) and<a href=\"https://us.wordcamp.org/2025/\"> WordCamp US</a> (Portland, Oregon, USA). Then join us in Mumbai, India for WordCamp Asia 2026!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 22 Feb 2025 15:04:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Nicholas Garofalo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Matt: WordCamp Asia and Maha Kumbh Mela\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=138006\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://ma.tt/2025/02/wcasia-kumbh/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1434:\"<p>It&#8217;s been fantastic being in the Philippines for <a href=\"https://asia.wordcamp.org/2025/\">this year&#8217;s WordCamp Asia</a>. We have attendees from 71 countries, over 1,800 tickets sold, and contributor day had over 700 people! It&#8217;s an interesting contrast to US and EU WordCamps as well in that the audience is definitely a lot younger, and there&#8217;s very little interest in &#8220;wpdrama&#8221; du jour, in fact I&#8217;ve had tons of amazing conversations of support and talking about the strength and growth of the community.</p>\n\n\n\n<p>Some of the earliest international WordCamps I went to were in Manila and Davao, back in 2008. (I&#8217;m going to share some pictures at the start of my talk.) Between that and spending lots of time in Daly City when I moved to San Francisco when I was 20 I have developed a fondness for the cuisine, creativity, family orientation, and warmth of the culture here.</p>\n\n\n\n<p>After this I&#8217;ll be taking a bit of time off for a trip to the big Hindu religious pilgrimage in India, the <a href=\"https://en.wikipedia.org/wiki/Kumbh_Mela\">Maha Kumbh Mela</a>, which is currently on a 144 cycle. It&#8217;s the largest human gathering in the world, with some days measured with tens of millions of people visiting. I&#8217;ll be returning to my Photomatt roots as well and bringing my big camera rig, right now a Nikon Z 7II, and two lenses: 24-70 2.8 and 70-200 2.8.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 22 Feb 2025 06:01:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"Do The Woo Community: Do the Woo v5.0 Changelog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=91258\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://dothewoo.io/blog/do-the-woo-v5-0-changelog/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"Version 5.0 2025-02-20 You can see our entire changelog here.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Feb 2025 11:46:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"Do The Woo Community: Do the Woo v5.0 is in the Wild at WordCamp Asia 2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=91204\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://dothewoo.io/do-the-woo-v5-0-is-in-the-wild-at-wordcamp-asia-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:354:\"In this episode, BobWP announces the launch of version 5.0 at WordCamp Asia, featuring a redesigned homepage that emphasizes multimedia content. The update introduces video, enhancing the existing audio format. He welcomes new host Cami MacNamara and encourages listeners to check out the changelog for further updates and visit their booth at the event.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Feb 2025 00:05:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"Gravatar: New! Initials Avatars, Email Signatures, and More\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=2918\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://blog.gravatar.com/2025/02/19/initials-avatars-email-signatures/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3769:\"<p>Your Gravatar is your globally recognized avatar, showing up on millions of sites across the web. In fact, we&#8217;re serving up <strong><em>30,000 avatar requests every second</em></strong> &#8211; that&#8217;s <strong><em>billions of avatars every week</em></strong>, helping put faces to names all over the internet.</p>\n\n\n\n<p>And today, we&#8217;re making Gravatar even better. </p>\n\n\n\n<h2 class=\"wp-block-heading\">Initials Avatars: You Asked, We Delivered</h2>\n\n\n\n<img width=\"719\" height=\"404\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/02/image-edited.png\" alt=\"\" class=\"wp-image-2921\" />\n\n\n\n<p>Developers, this one&#8217;s for you. After years of requests (we heard you, we promise!), initials avatars are here. Now available through our <a href=\"https://docs.gravatar.com/api/avatars/images/\">free Avatars service</a> and the Gravatar Enhanced plugin for WordPress, you can automatically generate professional-looking avatars using your users&#8217; initials. Even if they don&#8217;t have a Gravatar account.</p>\n\n\n\n<p>These new avatars automatically pull from the profile display name, creating initials with beautifully generated background and foreground colors. No display name? No problem &#8211; we&#8217;ll show a friendly emoji instead.</p>\n\n\n\n<p>And while we were at it, we gave our default avatars a fresh wardrobe. The classic silhouette and logo avatars got a modern makeover that feels right at home in 2025.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Email Signatures That Pop</h2>\n\n\n\n<img width=\"2086\" height=\"970\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/02/cleanshot-2025-02-18-at-12.24.39402x.png\" alt=\"\" class=\"has-border-color has-contrast-border-color wp-image-2932\" />\n\n\n\n<p>Want to share your Gravatar profile in your emails? We&#8217;ve made it ridiculously easy. </p>\n\n\n\n<p><strong>Here&#8217;s how:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Head to <a href=\"http://gravatar.com/profile\">gravatar.com/profile</a></li>\n\n\n\n<li>click on <strong><em>Email signature</em></strong> in the bottom left</li>\n\n\n\n<li>grab the code and paste it into Gmail or your email client </li>\n</ul>\n\n\n\n<p>Check out our <a href=\"https://support.gravatar.com/your-profile/email-signature/\">quick setup guides</a> for Gmail, Apple Mail, and other popular email tools.</p>\n\n\n\n<p>Clean, professional, and just a bit fun.</p>\n\n\n\n<h2 class=\"wp-block-heading\">New Block Pattern for WordPress</h2>\n\n\n\n<img width=\"2880\" height=\"2136\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/02/image-2.png\" alt=\"\" class=\"has-border-color has-contrast-border-color wp-image-2930\" />\n\n\n\n<p>For WordPress users, we&#8217;ve added a slick new block pattern in the Gravatar Enhanced plugin. </p>\n\n\n\n<p>Build beautiful about pages for your company or team in seconds. Each team member&#8217;s Gravatar profile automatically populates their bio section &#8211; no copy-pasting required.</p>\n\n\n\n<p>And profiles automatically update when changes are made on Gravatar.</p>\n\n\n\n<h2 class=\"wp-block-heading\">What&#8217;s Next?</h2>\n\n\n\n<p>Keep an eye out for more updates as we continue making Gravatar the best way to represent yourself across the web.</p>\n\n\n\n<p>And in case you missed last week&#8217;s update: <a href=\"https://blog.gravatar.com/2025/02/12/simplify-link-sharing-with-smart-redirects/\">custom domain smart redirects are now live</a>!</p>\n\n\n\n<p>Want to try these features? Log in to your <a href=\"https://gravatar.com/profile\">Gravatar dashboard</a> or grab the <a href=\"https://wordpress.org/plugins/gravatar-enhanced/\">Gravatar Enhanced</a> plugin for WordPress. </p>\n\n\n\n<p>PS: Developers, check out our updated <a href=\"https://docs.gravatar.com/api/avatars/images/\">Avatar docs</a> for implementation details on initials avatars.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 19 Feb 2025 17:29:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"WPTavern: #157 – Katie Keith on the Move From Agency Owner to WordPress Theme Development to Plugin Success\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=187360\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:123:\"https://wptavern.com/podcast/157-katie-keith-on-the-move-from-agency-owner-to-wordpress-theme-development-to-plugin-success\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49017:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley. Jukebox is a podcast</p>\n\n\n\n<p>which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, the move from agency owner to WordPress theme development company, and finally to plugin success.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast player of choice. Or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox and use the form there.</p>\n\n\n\n<p>So on the podcast today we have Katie Keith.</p>\n\n\n\n<p>Katie is a founder and CEO of Barn2 plugins. With a background deeply rooted in WordPress, Katie&#8217;s journey presents an interesting narrative of transformation, from the early days of running a WordPress agency, to now managing a flourishing plugin business Barn2 plugins has a portfolio of 19 premium plugins, many of which extend functionalities inside WooCommerce</p>\n\n\n\n<p>Today, Katie previews her upcoming lightning talk, which she&#8217;ll be giving at WordCamp Asia. She talks about the transition from agency work to plugin development, highlighting early challenges and choices that shaped the business&#8217; path.</p>\n\n\n\n<p>We get into the initial allure of client projects, and their subsequent realization of the benefits offered by productizing their skills for global reach. Katie describes the decisions that led them to WordPress plugins with products like WooCommerce Protected Categories and Document Library Pro, and explores how customer feedback and market needs drove their product diversification.</p>\n\n\n\n<p>As Katie explains, the plugin world wasn&#8217;t without its hurdles. There was trial and error involved in launching new products. This underscores the importance of market research. Additionally, she touches on Barn2&#8217;s current pivot into Shopify apps, aiming for diversification to help ensure that the business has stability by being available across multiple platforms.</p>\n\n\n\n<p>Katie investigates the current WordPress and WooCommerce landscape, discussing how she perceives the industry will change, potential growth areas, and the necessity of staying agile.</p>\n\n\n\n<p>If you&#8217;re curious about the intricacies of building a plugin business, or are seeking inspiration from someone who has already navigated the WordPress ecosystem, this episode is for you.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast, where you&#8217;ll find all the other episodes as well. And so, without further delay, I bring you Katie Keith.</p>\n\n\n\n<p>I am joined on the podcast by Katie Keith.</p>\n\n\n\n<p>[00:03:29] <strong>Katie Keith:</strong> Hey, Nathan.</p>\n\n\n\n<p>[00:03:30] <strong>Nathan Wrigley:</strong> Very nice to have you on the podcast. Katie and I have met, actually many times in person over at a variety of different WordCamps. This conversation that we&#8217;re going to have today is inspired by a WordCamp, but a WordCamp which hasn&#8217;t taken place yet. Because Katie is heading off to Manila in a few days time to give a lightning talk at WordCamp Asia. Do you just want to, before we get a bio properly, do you want to tell us what you&#8217;re going to talk about and then we&#8217;ll learn more about you?</p>\n\n\n\n<p>[00:03:52] <strong>Katie Keith:</strong> Yep. So my talk is going to be a lightning talk about my story, specifically the transition from being a WordPress agency into a WordPress plugin company.</p>\n\n\n\n<p>[00:04:03] <strong>Nathan Wrigley:</strong> Now that&#8217;s the perfect opportunity to give us your little bio. So don&#8217;t reveal all the detail of everything that you want to talk about, but just tell us the one minute potted history of you, WordPress, technology, wherever you want to land with that.</p>\n\n\n\n<p>[00:04:16] <strong>Katie Keith:</strong> Yeah, so I&#8217;m Katie Keith, founder and CEO at Barn2 plugins. We are a, as you probably guessed, a plugin shop. We currently have 19 premium plugins, a few free ones, and that&#8217;s about it.</p>\n\n\n\n<p>But as we&#8217;ll talk about this more later, we started life as an agency building WordPress sites for clients, and then over the years we&#8217;ve switched into plugins.</p>\n\n\n\n<p>We mostly specialise in WooCommerce plugins. So about 14 of our 19 are building extra functionality for WooCommerce. And we&#8217;ve also got a really popular document library plugin, which is not for WooCommerce.</p>\n\n\n\n<p>[00:04:54] <strong>Nathan Wrigley:</strong> Haven&#8217;t you pivoted a little bit in the direction of Shopify as well?</p>\n\n\n\n<p>[00:04:57] <strong>Katie Keith:</strong> Yeah, that is in progress. So the current growth strategy is to continue what we&#8217;re doing with the WordPress side of things, and also to diversify into selling Shopify apps so that we are across multiple platforms, and largely as a sort of stability thing, so that we spread any risks. Because we&#8217;re all dependent on WordPress at the moment, which is obviously a good horse to back and always has been. But it feels like it&#8217;s a good idea to be on multiple platforms as well.</p>\n\n\n\n<p>[00:05:26] <strong>Nathan Wrigley:</strong> So I don&#8217;t know a single person, personally, who began their journey into web development intentionally. That is to say anybody of my era, anybody that wandered into web development when I did, the industry wasn&#8217;t really an industry. It was kind of just beginning. People just did it as a hobby. You know, some friend came along and said, I&#8217;d like a website, well, I can dabble with that. I&#8217;ve heard about websites and I know how to code a little bit of HTML and things like that.</p>\n\n\n\n<p>But I&#8217;m wondering if you were more intentional when you began looking around post school, post college, whatever you did. Did you and your husband, I know he was a big part of the business. Did you jump into web development, and you said you were an agency for a while? Did you do that intentionally or was it more, oh, let&#8217;s try our hand at this for a bit?</p>\n\n\n\n<p>[00:06:11] <strong>Katie Keith:</strong> It actually was intentional. So, Andy and I spent our twenties with normal jobs, both government type jobs, talking about how we wanted to start a business together, and how much more flexible that would be. How much more our finances could scale if we worked for ourselves. But we just didn&#8217;t have any ideas.</p>\n\n\n\n<p>And we talked for years about different ideas and never really saw anything through or had a killer idea. Andy particularly got quite fed up with his job in the civil service in England and we thought, we need to do something. And thought, okay, well, what would combine our skills, and he was a software developer, not really web but software, and I was a project management and marketing person. And so we thought, well, building websites for people actually combines those skills.</p>\n\n\n\n<p>He didn&#8217;t want to go into like software consultancy or something because we are from the southwest of England, which is quite rural, and we would probably have had to move to a big city. Remote work wasn&#8217;t such a thing back then, and so we didn&#8217;t really want that lifestyle change.</p>\n\n\n\n<p>So he thought, well, maybe he could scale down a bit and learn web development instead of enterprise level software. And then that allows us to run a kind of more small business that we can live where we want to work. And websites need marketing, SEO, copywriting, project management, communication with clients. So that fitted in my skills as well. So, yes, it was intentional having analysed our respective skills and what we could realistically get into.</p>\n\n\n\n<p>[00:07:45] <strong>Nathan Wrigley:</strong> That&#8217;s really great actually. Looking back, you had the perfect blend of different things there. Maybe a bit of serendipity, but your marketing side, and Andy&#8217;s coding side, that is really the basis of a successful agency business, growing agency business. You need to have the capacity to code, but also to sell it into the marketplace. I mean, how many stories have you heard of people who can code but they can&#8217;t launch a business, because they don&#8217;t have the wherewithal to sell it and drum up business and things like that. So that&#8217;s fascinating.</p>\n\n\n\n<p>In the show notes that we shared, one of the things that you said was that you didn&#8217;t quite go in the right direction at the beginning. Well, it turned out that you didn&#8217;t go in the right direction. You went with client websites, building one site, shipping it, launching another, and so on. But that didn&#8217;t turn out to be something that you wanted to maintain. Why was that?</p>\n\n\n\n<p>[00:08:30] <strong>Katie Keith:</strong> Yeah, so we thought client websites are a really good way to get started because you don&#8217;t need to invest lots of money, and you just get paid by the project. So if you can get one client that brings in, back then it was like £500 or something, not very much. And then you just keep going and grow slowly. I&#8217;d never really been attracted to the kind of business that you need to put a lot of money into upfront.</p>\n\n\n\n<p>I love the program Dragons Den, which is Shark Tank in the US. But I&#8217;ve never wanted that kind of business where you need a lot of investment. So web design, just stick out a few flyers or something in your local, actually, fish and chip shop got us one client. We just put some flyers on the counter and we actually got a website for a local cycling club. Things like that. So you could start small.</p>\n\n\n\n<p>So it was a good way to get started. And it was really good because it got us into WordPress. So we didn&#8217;t initially think, let&#8217;s be WordPress specialists. We thought, let&#8217;s build websites. And then Andy started researching the right tools and discovered WordPress and told me about it. I thought it sounded like an awful idea, because he made it sound like a kind of a blogging thing and like, oh, you choose a template for your blog. And I was like, no, we want to build business websites for people. Why are you using this blogging software?</p>\n\n\n\n<p>But that was about a year after custom post types came in, and it was becoming a proper platform. It was about 2010 back then. We started specialising in WordPress. And then, to answer your question, at this point, the client work was better than having jobs, but it wasn&#8217;t quite the lifestyle you wanted, in that we wanted more flexibility where we&#8217;re not like on call to clients all the time.</p>\n\n\n\n<p>If someone&#8217;s website goes down when you&#8217;re on holiday, you&#8217;ve got to fix it. And we did try to get help, project managers and things. And we did do well getting freelance designers and developers, but we just couldn&#8217;t find anybody that we could trust to communicate with the clients for us. And that really put a limitation on the lifestyle benefits because we were on, mainly me, we&#8217;re on call to clients all the time. So we thought, actually maybe that&#8217;s not the right business model.</p>\n\n\n\n<p>[00:10:38] <strong>Nathan Wrigley:</strong> You&#8217;re also selling your time for money, and going through that feast famine life cycle where one project is ongoing. And then at what point do you sort of cut that off and say, okay, we need to start looking for the next one, even though we haven&#8217;t quite finished this one. There&#8217;s inevitably going to be some overlap where that all just works out well. And obviously the agencies which grow and scale and become enterprise, they just have that figured somehow.</p>\n\n\n\n<p>My experience with that was always that there was a period where you were quite uncertain as to where the next website was going to come from. And you were, like I said, just trading your time for money. And WordPress offers so much more than that. You&#8217;ve got yourself into a kind of global marketplace where you could build a thing and then sell that thing 1,000 times, 10,000 times over, which I guess, where we&#8217;re going next. But you didn&#8217;t go to plugins first. You actually went into themes, which was a bit of a, well, a bit of a dead end it turns out. But tell us about the theme building enterprise.</p>\n\n\n\n<p>[00:11:35] <strong>Katie Keith:</strong> Yeah, so because of all those things you&#8217;ve mentioned, selling time for money and the lifestyle thing, we thought selling WordPress products would be a much better business model because it could scale more. You can build one product and then sell it an unlimited number of times in theory, instead of selling one hour for a certain amount of money.</p>\n\n\n\n<p>So we thought products are good. And we looked at the products and thought, ah, themes are the way to go. Themes seemed to be a big growth area, well, they were a big growth area. This is 2013.</p>\n\n\n\n<p>And when we started work in about 2012 on our first, our only theme, ThemeForest was just growing loads. Plugins existed, but you didn&#8217;t hear about super successful plugin companies particularly. Whereas you could go on ThemeForest and you could see the sales that the big themes were getting, and it was very tempting to be part of that. So we thought, let&#8217;s build a theme. So we did. And it took like a year because of all the demands of client work. So it was just a sideline, building this theme. And then in that year ThemeForest changed, which we didn&#8217;t see coming. ThemeForest changed in the year we were building our theme.</p>\n\n\n\n<p>So we&#8217;d analysed the themes that were successful at the time, and they were quite simple. They were nice, designed, often quite bold, clear designs, a bit minimal, and didn&#8217;t have that many features. And then between 2012 and 2013, themes such as uDesign and Avada and that kind of thing became popular. And they were massive multipurpose themes with so many features. And that wasn&#8217;t what we wanted to do. We wanted a product that we could maintain and develop ourselves easily, and it wouldn&#8217;t be this massive headache or anything like that.</p>\n\n\n\n<p>So it just wasn&#8217;t what we wanted. And of course, that meant they rejected our theme because it wasn&#8217;t the sort of theme they were looking for. I think they would&#8217;ve accepted it a year before, but they didn&#8217;t when we got actually ready to submit it. So we were like, ah, do we rewrite the theme and make it loads more complicated? Do we sell it independently? And I wasn&#8217;t confident in my ability to market a theme independently, because you&#8217;re competing with the giants. And I didn&#8217;t have experience of that. I wanted to be on a marketplace.</p>\n\n\n\n<p>[00:13:51] <strong>Nathan Wrigley:</strong> I think back in the day, 2013, like you mentioned, ThemeForest was the place to go for things like that, wasn&#8217;t it? And although I wasn&#8217;t really in the WordPress space, I jumped in after that endeavor. When I got there, ThemeForest was already, basically saturated with themes that could, well, themes that claimed to do more or less everything. You just buy this one theme and it can do everything. Or there was also a dearth of themes which offered a specific kind of functionality, like a real estate, or you might say, realtor theme, or a portfolio theme or, I don&#8217;t know, I&#8217;m a gym owner, I need a theme for my gym.</p>\n\n\n\n<p>Kind of felt like it went in that direction, but it seems like you were trying to build something which was more agnostic of industry. It was just a, here&#8217;s the bare bones of a theme, you now go and do the artistic work. But yeah, like you say, ThemeForest was going off in a different direction.</p>\n\n\n\n<p>So what happened there? Was it a case of staring at each other and saying, okay, what do we do? Do we try to pivot this theme? Or did you just at some point say, no, abandon it.</p>\n\n\n\n<p>[00:14:51] <strong>Katie Keith:</strong> We were fairly depressed and disappointed and just gave up for a few years. So we carried on with the client work, which was going fine. We had a successful business that was keeping us both going. We didn&#8217;t need to do products. So we just continued with the client work.</p>\n\n\n\n<p>[00:15:08] <strong>Nathan Wrigley:</strong> Okay, so steady away. And then what was the moment where you, kind of had the revelation about plugins? Because, again, coming into the WordPress space, 2015, something like that, plugins and themes were already selling like hotcakes. I don&#8217;t really know about the period in which plugins was a bit new, a bit maybe dangerous, a bit, putting your business on the line with plugins. Maybe that was a tough one back then, I don&#8217;t know.</p>\n\n\n\n<p>[00:15:30] <strong>Katie Keith:</strong> By the time it got to 2016, I supppose frustrations accumulate over time. So we were again like, oh, the client works just kind of annoying. It&#8217;s not quite flexible enough, and it&#8217;s not scaling enough, it&#8217;s just going up a little bit. So we need to do products. What shall we do again?</p>\n\n\n\n<p>And this time we thought, well, plugins could work because unlike these massive multipurpose themes, a plugin can be really tiny or it can be incredibly complex. A plugin can just be a line of code, you know, as an extreme minimum. So we thought, well, that way we can choose products that fit with the scale that we want to offer technically. I hated the idea of a big theme or a massive plugin because you kind of end up being responsible for basically the user&#8217;s whole website.</p>\n\n\n\n<p>So imagine if somebody&#8217;s using a theme which takes over their whole site, and it affects every aspect of the visuals. They&#8217;re going to send you a support ticket for everything, even if it&#8217;s not the theme&#8217;s fault. And then you are going to have to prove it&#8217;s not the theme&#8217;s fault. And we just thought that&#8217;s not sustainable.</p>\n\n\n\n<p>And I think the same would happen with really large plugins like, I don&#8217;t know, a membership plugin or an e-commerce plugin or something thing like that. So we thought, well, we are just the two of us, plus our freelancers, so let&#8217;s choose a more realistic plugin idea and build it and see what happens.</p>\n\n\n\n<p>[00:16:54] <strong>Nathan Wrigley:</strong> So you always had the agency, the client based websites. That was the backup plan. Always something to fall back on if the plugin business didn&#8217;t work out. You took the plunge. What was the first plugin that you came up with?</p>\n\n\n\n<p>[00:17:07] <strong>Katie Keith:</strong> So the first plugin, we found by going on a website, which used to exist, which was the WooCommerce Ideas Forum. They used to have a whole website where people just gave ideas and, basically feature request board. But they have that now if people want to look, but I think it&#8217;s per extension instead of a whole thing for WooCommerce. So you access it differently and it&#8217;s hard to find. But there was this whole website.</p>\n\n\n\n<p>So we went on this and you can sort it by the number of votes for each suggestion. And we chose an idea which had the highest number of votes that wasn&#8217;t that complex to build, which was WooCommerce password protected categories, which is very specific.</p>\n\n\n\n<p>[00:17:47] <strong>Nathan Wrigley:</strong> That&#8217;s a great title, I like that.</p>\n\n\n\n<p>[00:17:48] <strong>Katie Keith:</strong> Yeah, nice and snappy. WordPress itself already has password protection for its posts and pages, but not categories, and therefore WooCommerce doesn&#8217;t have it for its categories either. And people were saying that they wanted it for things like building a wholesale site, or selling different products to different clients.</p>\n\n\n\n<p>If you imagine that you sell products to sports teams and they each have a logo, so the product&#8217;s different for each team, you might create a protected category for that team to log in and order their branded sportswear. Those sorts of use cases. And we thought, well, that&#8217;s quite simple. You just add a category field to the page and a few other features like login and things.</p>\n\n\n\n<p>So we built the plugin. It wasn&#8217;t that difficult, and we launched it. And because it was unique and I was a marketer, I wrote a few blog posts about it, like how to password protect categories in WooCommerce, really niche posts. They went right to the top of Google because you could then, and there was nobody else offering that. And we actually started getting sales after about three days. And we were like, we are getting sales for our plugin and we couldn&#8217;t believe it.</p>\n\n\n\n<p>[00:18:57] <strong>Nathan Wrigley:</strong> That is quite remarkable because I know the story is harder now than ever. That story is very hard to replicate because, you know, the market is saturated.</p>\n\n\n\n<p>But just going back to your actual plugin, realistically, when you built that and you saw that idea, okay, we&#8217;re going to password protect a category, and it will impact WooCommerce, so I don&#8217;t know, we could send it to company A and the category will be A, and they can access it with a password, and we&#8217;ll send it to company B, and the category will be B and they can access it and so on.</p>\n\n\n\n<p>Honestly, what was your expectation at that point? Because coming into the community, it&#8217;s hard to understand, how big is WordPress? And then the layer underneath that, how big is the plugin which sits inside of WordPress, WooCommerce, how big is that? And then we&#8217;ve got this niche little one, just does one tiny thing. Honestly, what were your expectations?</p>\n\n\n\n<p>[00:19:44] <strong>Katie Keith:</strong> Very low. It was an experiment. It wasn&#8217;t a huge amount of work. Basically, Andy stopped doing some agency work for a while, and I relied on the freelance developers a bit more while he coded it. It wasn&#8217;t a big sacrifice for us to build it, and we didn&#8217;t have any kind of a business plan or projections or anything. It was just, let&#8217;s launch a small plugin and see what happens.</p>\n\n\n\n<p>And we were amazed. And it still exists now. It&#8217;s now called WooCommerce Protected Categories because it has different ways of protecting the category, not just passwords, like user role and that kind of thing. And it actually, a few months ago it met half a million dollars in revenue lifetime. So that tiny idea has done half a million dollars in 8 years.</p>\n\n\n\n<p>[00:20:30] <strong>Nathan Wrigley:</strong> So how quickly did that money start to roll in? And so it doesn&#8217;t have to be about money, the amount of, I don&#8217;t know, plugin licenses that you sold or whatever it may be. But how quickly did your intuition turn to, oh, there is really something in this? Like you mentioned you got a sale or two within two or three days, which is exciting. But obviously if it then just sort of trickled along one or two a week, it is exciting, but it&#8217;s not that exciting.</p>\n\n\n\n<p>And what was the point where you and Andy started to look at each other and think, woah, we could potentially forget all the agency work if we now pivot into this? How long did it take you to make those decisions?</p>\n\n\n\n<p>[00:21:03] <strong>Katie Keith:</strong> Yeah, because that was just pocket money, the first sales. It was just nice because it&#8217;s an indication that it could work. So that kept growing. And we also launched other plugins as well. Like our second one came from a client project.</p>\n\n\n\n<p>The client paid us to build a custom plugin, which was a searchable, sortable table of blog posts for their blog. So they had hundreds of blog posts and they wanted a more easy way for people to find them. So we built this table plugin, and we launched it on wordpress.org as a free plugin called Post Table with Search and Sort. So that&#8217;s just as good a name as WooCommerce Password Protected Category.</p>\n\n\n\n<p>[00:21:40] <strong>Nathan Wrigley:</strong> Got the SEO juice going there, definitely.</p>\n\n\n\n<p>[00:21:43] <strong>Katie Keith:</strong> Oh yeah, it does what it says. So that was a free plugin, but that led to a lot of sales because people started sending us feature requests once it was on wordpress.org.</p>\n\n\n\n<p>So the first ones wanted custom fields, custom taxonomies, and custom post types, rather than just blog posts in their table. So they might want to create like a table of documents or members for a directory of consultants or something like that, like custom post types and data. So we built Post Table Pro, which was the premium version, and that&#8217;s done really well.</p>\n\n\n\n<p>And then people started asking for even more features, which we used to develop different plugins. So we built WooCommerce Product Table, which is a WooCommerce version of that table, which has things like add to cart buttons and variation dropdowns.</p>\n\n\n\n<p>And so that cluster of plugins that came from this free table plugin is what really kind of catapulted the success. So that within about six months of launching our first plugin we were making, I don&#8217;t know, several thousand dollars a month. And we thought, given that we have some revenue from clients like maintenance and hosting, so our existing clients were paying us for certain things, we can afford to stop taking new projects, and therefore put more resources into building more plugins, and improving our existing ones, and marketing them, of course. So it was about six months that we decided, let&#8217;s stop accepting new client projects.</p>\n\n\n\n<p>[00:23:13] <strong>Nathan Wrigley:</strong> So the plugin that you just mentioned there, the sorting of the tables, it sounds like you got that out of a client project. So it was actually a client that came to you. We need this idea and, okay, we&#8217;ll build that. But then the back of that is, can we then take that code and run with it? Which you did. And then you&#8217;ve got the pro version, which adds in a bunch of different features. And now you&#8217;ve got two plugins and a third one came on quite quickly. We&#8217;re six months in, and the dollar signs are starting to make sense.</p>\n\n\n\n<p>You can see that, okay, there&#8217;s a living in this. We&#8217;ll take our foot off the client websites, but we&#8217;ll keep it going just in case something goes wrong. So I&#8217;m presuming though, at this point you are all guns aimed at, we need more plugins, more and more and more plugins. And so when did it become, okay, let&#8217;s just go in on Woo? How did you end up as Woo as opposed to just WordPress?</p>\n\n\n\n<p>[00:23:59] <strong>Katie Keith:</strong> We never did. Our biggest plugin now is Document Library Pro, which is not Woo, and that came from Post Table Pro as well. The biggest use case of Post Table Pro ended up being documents. So we built a document plugin that had download buttons and previews and stuff that&#8217;s specific to documents. Again, it&#8217;s just a table plugin, and that has been our biggest seller for the last three or four years since we launched it.</p>\n\n\n\n<p>So because of the success of that and Post Table Pro, we never could actually just be WooCommerce. So we are not like, say Iconic, who specialise in WooCommerce, that&#8217;s all they do.</p>\n\n\n\n<p>So we have this reputation of being WooCommerce. And I wish we were actually. Obviously I like having a successful plugin, but I wish that we had that clear identity because it&#8217;s, like I explained the business at the beginning in the introduction, I&#8217;m like, oh, we have these plugins, they&#8217;re mostly WooCommerce. It is not as clean as it could be.</p>\n\n\n\n<p>[00:24:56] <strong>Nathan Wrigley:</strong> Sitting where you are now, and we can get into the numbers of how many plugins and all of that that you&#8217;ve got. Have you made any missteps with, like has any plugin that you&#8217;ve built misfired completely? You thought this would be a great idea, let&#8217;s build it, let&#8217;s market it. But then you build it and the customers do not come. Or has every single one had a fair degree of, they don&#8217;t all have to be super successful, but has everything stood on its own two feet and been worth doing?</p>\n\n\n\n<p>[00:25:20] <strong>Katie Keith:</strong> It depends how you define success. But it&#8217;s largely relative. So if you&#8217;re doing one plugin that&#8217;s doing X a month, then if you have one that&#8217;s much smaller, that&#8217;s not necessarily worth it.</p>\n\n\n\n<p>I would say my biggest mistake, repeatedly, has been thinking too small. So I have a very bad track record of building plugins that are too small and too niche to be worth bothering with. Lots of examples.</p>\n\n\n\n<p>One example was WooCommerce Discontinued Products. So that adds a discontinued stock status to your store. We built it because we were hiring some new senior developers and we were doing a project for these developers. Before we hired them, we were paying them to build a small plugin to check how good they were. And we thought, well, the ones we hired, we may as well release their plugin. So we did.</p>\n\n\n\n<p>We did WooCommerce Variation Prices, Discontinued Products. We had multiple plugins that were just trial projects for the developer, but they were good. And their first project after they joined properly was to complete the plugin, and make it sellable. But that&#8217;s a lot of work. You&#8217;ve got to create all the marketing images, the marketing content, the sales page, market it.</p>\n\n\n\n<p>Each plugin has an overhead as well as maintaining it. And so with hindsight, I shouldn&#8217;t have released all of those small plugins. And we actually sold five of our plugins last year to a WooCommerce company called Kestrel, because we had 24 at the time, and it was just too many. And I did an 80 20 rule analysis of the business and how much revenue was coming from each plugin. And that cluster of five were all doing, they were all doing at least several hundreds a month, but generally less than a thousand a month.</p>\n\n\n\n<p>And compared to our other plugins, that was a small proportion. So I thought, let&#8217;s group these plugins and sell them to a company who would appreciate and grow them more, where that fits better with their business plan.</p>\n\n\n\n<p>[00:27:17] <strong>Nathan Wrigley:</strong> Are you still on the lookout for new ideas? Or do you want to just hunker down on the ones that you&#8217;ve got? In other words, do you constantly ideate and think, let&#8217;s find a new thing or is it more serendipity? You accidentally stumble across an idea, we should build that, and so we do. Or do you deliberately try, in the same way that you did previously going to the WooCommerce forum, do you try to find new products to build and see how they work?</p>\n\n\n\n<p>[00:27:41] <strong>Katie Keith:</strong> I suppose a bit of both depending on our current priorities. So for example, in 2024 last year, that&#8217;s when we sold the five plugins. And I thought, we&#8217;ve got a handful of really successful plugins, we need to put our resources into making them as good as they can be to maximise their potential sales.</p>\n\n\n\n<p>So for example, instead we did launch one plugin last year, our WooCommerce Discount Plugin, but we were already building that when I made this decision. So once I made that decision, I put all our developers on adding features to our existing plugins, including some really big features.</p>\n\n\n\n<p>For example, we have a WooCommerce Product Options plugin, which adds extra options to your product pages. And dozens and dozens and dozens of people were saying to us, we want live image previews. So when you use our plugin to upload an image to the product page, we want that to appear superimposed on a picture of the T-shirt, for example. So if you upload your picture of your child, that will appear on the T-shirt.</p>\n\n\n\n<p>And that was a big project. So we could have built a completely different plugin, but instead we added live preview. We actually did it as an add-on, so it&#8217;s sort of an extra plugin, but it&#8217;s dependent on the main plugin, and things like that. So we thought, what&#8217;s working and how could we make what&#8217;s working even more successful? But I do have a list of plugin ideas for the future.</p>\n\n\n\n<p>[00:29:06] <strong>Nathan Wrigley:</strong> So there&#8217;s a laundry list of things that you might build, but the priorities are not to build them all right away? Just see how the market goes. Speaking of that, speaking of the market, you&#8217;re obviously heavily embedded in WordPress, heavily embedded in WooCommerce. What do you make of the landscape at the moment?</p>\n\n\n\n<p>You&#8217;re obviously beginning to pitch into Shopify a little bit as well, and I imagine you&#8217;re at pains to say we&#8217;re not taking our foot off the WordPress pedal. How do you feel the landscape is shaping up in 2025? It does seem like things are plateauing a little bit in terms of market share for WordPress, whether or not they&#8217;ll go up or down. How confident are you in the future? Is it still WordPress all the way down?</p>\n\n\n\n<p>[00:29:42] <strong>Katie Keith:</strong> I certainly don&#8217;t think WordPress is going anywhere, and it probably won&#8217;t shrink a lot, if at all. But I also don&#8217;t feel that we are having a rising tide that we can all ride the journey upwards like we used to. For example, in 2020 when everybody was locked down, there was huge growth for nearly all WordPress companies, because the world was going online so rapidly and we had a huge, huge growth very quickly.</p>\n\n\n\n<p>And then since then it has slowed down. The growth has slowed down and now seems fairly stable. Stable is a good word, but it&#8217;s not really growing in a particularly measurable way. And you could argue that that is just a correction because it went up so much, so quickly during the pandemic that maybe it just took a few years to get back to where it would&#8217;ve done if there was no pandemic.</p>\n\n\n\n<p>So if you imagine a steep line rather than a big bump followed by a plateau. So you could argue that. But it feels like we have to work harder than we used to to see growth, and make that happen through our own efforts, rather than just relying on a growing market.</p>\n\n\n\n<p>[00:30:48] <strong>Nathan Wrigley:</strong> So obviously that would be nice if WordPress could keep going in that same way. What about Woo? Obviously we were just talking about WordPress. I don&#8217;t really involve myself with Woo so much, so I don&#8217;t really know what the statistics are. I know that in terms of e-commerce platforms, it&#8217;s the leader, but I don&#8217;t know if that&#8217;s sort of going up or going down. You got any insight in that?</p>\n\n\n\n<p>[00:31:07] <strong>Katie Keith:</strong> It is very confusing because it depends where you look. So there&#8217;s two main websites that publish data about e-commerce usage, and one of them says WooCommerce is the leader and the other says Shopify is. And they use slightly different data sets. For example, the top X websites in the world, versus the whole internet, versus a sample of a million, which they use to extrapolate upwards.</p>\n\n\n\n<p>So there are different ways of looking at the data. So I genuinely don&#8217;t know, there probably is no correct answer, which is the biggest e-commerce platform, but they&#8217;re both doing really well and neither are going anywhere. So that&#8217;s why it felt that it made sense for us to be building products for both.</p>\n\n\n\n<p>I think WooCommerce is really interesting because it has a good reputation. It has, I think the best leadership team around it that I&#8217;ve seen in the 8 years I&#8217;ve been building plugins on top of it right now. But I wish they would do more marketing. They&#8217;re not promoting their platform in the way that say Shopify is, and that scares me. I would like to see them doing more centralised marketing.</p>\n\n\n\n<p>They&#8217;re a company, they make money from WooCommerce, even though it&#8217;s free. They have extensions, they have revenue sharing from their Stripe and they have lots of ways of making money, which they&#8217;ve recently talked about publicly. And so I&#8217;d like them to be doing some proper marketing like Shopify does.</p>\n\n\n\n<p>[00:32:29] <strong>Nathan Wrigley:</strong> It is interesting, I know you no longer live in the UK. I do, and it doesn&#8217;t take many trips down high streets to realise that the high street is really in decline. You only have to walk down one street in more or less any town to realise that the shutters are going up, the wood is going over the doors, bricks and mortar shops are really struggling.</p>\n\n\n\n<p>And it&#8217;s this inexorable rise. I can only imagine that, well, people are still buying things, but they&#8217;re buying things increasingly on the internet. My age group, I imagine has been fairly straightforward, because we grew up when the internet was coming around. Children that are growing up now, I think they&#8217;re really just not interested in doing things like going into town in a sort of social way like I did. So I imagine that eCommerce&#8217;s future, just generally e-commerce, platform agnostic, you&#8217;ve got to imagine its got everything going for it, I would&#8217;ve thought.</p>\n\n\n\n<p>[00:33:24] <strong>Katie Keith:</strong> Yeah, that makes sense. And we often look at things like market share data, but that&#8217;s just a percentage. So even if WordPress&#8217; market, or let&#8217;s say WooCommerce&#8217;s market share did go down at some point, if the whole of e-commerce was growing, then WooCommerce could still be growing. And it doesn&#8217;t really matter so much if it&#8217;s smaller percentage, if the whole cake is bigger.</p>\n\n\n\n<p>So I think that&#8217;s the case. And you do see quite regularly published e-commerce data about, particularly after Black Friday, like the most revenue ever went through e-commerce sites this Black Friday. And it does seem to be constantly growing. And I think that is primarily through websites. A lot of people are buying through apps, of course, instead of websites, particularly something like Amazon or even Temu or something these days. But I think e-commerce websites are still huge and I can&#8217;t see that changing.</p>\n\n\n\n<p>[00:34:15] <strong>Nathan Wrigley:</strong> No, because in most of the towns that I&#8217;ve visited where I can see this, the big, we call them department stores in the UK. An example might be something like Marks &amp; Spencer. They&#8217;ve got a branch in more or less every town. You kind of feel that they&#8217;re immune. They&#8217;ve got their online bit as well, so they&#8217;ve probably inoculated themselves in that way. They&#8217;ve just got so much kudos, and so much loyalty built in that you feel they might be immune for a period of time.</p>\n\n\n\n<p>But all of the little shops, the little jeweler, the little corner shop selling a thing that they build, whatever it may be, you kind of feel they are going to struggle because the footfall is less. They really do fit into what you sell. I&#8217;m reasonably technical, but I can&#8217;t build, I can&#8217;t code, I can&#8217;t do any of that, so I need a solution.</p>\n\n\n\n<p>I think the future for WooCommerce and the kind of things that you create and sell, I think the future&#8217;s really bright because I see that market just going up and up. The younger people are going to be wanting to use their devices because they&#8217;re all really fascinated by them, everybody&#8217;s got a mobile phone nowadays. The footfall is sort of falling away, and it all seems like a perfect storm for e-commerce to grow. I could be being overly optimistic there, but it feels like it&#8217;s fair weather for the next decade or so.</p>\n\n\n\n<p>[00:35:26] <strong>Katie Keith:</strong> Yeah, I know what you mean. And it&#8217;s a good example to use those small shops because even if they keep their storefront, which probably isn&#8217;t profitable, they should be selling online. And small shops, they&#8217;ve got a few choices, that could be WooCommerce. That might be harder to set up in the first place, they might need to hire someone. But then their costs are super, super low compared to most platforms.</p>\n\n\n\n<p>They could go for Shopify, which is slightly reversed in that sense. Or they could use something like Etsy if they&#8217;re a jeweller, to use your example. So there&#8217;s lots of ways for them to sell online, but they do need to be thinking of it for their survival because of the decline of things like the high street, as you say.</p>\n\n\n\n<p>[00:36:03] <strong>Nathan Wrigley:</strong> Yeah, I think so. Looking back, again, just casting your mind back to 2013 when you began all of this. Do you think that you were lucky when you decided to pivot into making plugins? What I&#8217;m really saying is, if you were beginning now in 2025, everything was the same, it was just 12 years later, 2013 to 2025. Do you think you&#8217;d have the same degree of success with the exact same kind of approach to it?</p>\n\n\n\n<p>Basically, has the market got harder, more saturated, more difficult to sell into, more savvy? Anything around there. Do you feel, basically, you were lucky in terms of timing?</p>\n\n\n\n<p>[00:36:38] <strong>Katie Keith:</strong> I think to an extent. I don&#8217;t believe it&#8217;s fully saturated yet, but it is more full than it was when we started. So when we started, there were no WooCommerce protected category plugins, there were no WordPress dynamic table plugins, there were no document library plugins, there were no product table plugins for WooCommerce.</p>\n\n\n\n<p>So we managed to do that because those were gaps. Now they&#8217;re not. And now we&#8217;ve done successful plugins in those categories people have copied. So we have competition now, which came along after we launched. So those are no longer gaps. But I do firmly believe that there are still gaps that you can fill.</p>\n\n\n\n<p>And the way to find them is through already being in WordPress in some way, which most typically is through building sites for clients, or doing some kind of client work. Because they will always find a gap and ask you to fill it through a custom plugin or something like that. So if you concentrate hard enough on the client work that you&#8217;re getting, you probably will find gaps.</p>\n\n\n\n<p>And if you find something that doesn&#8217;t already exist, then yes, you could get to the top of Google quickly for a very specific keyword. Of course, WordPress and WooCommerce are much bigger now than they were in 2016 when we launched our first plugin. So even if it&#8217;s slightly more diluted with competition, the market is bigger. So there is potential now you&#8217;re a part of a bigger market.</p>\n\n\n\n<p>[00:38:03] <strong>Nathan Wrigley:</strong> So last question really, Katie. Do you see WordPress being the thing for you and your husband, the business you are going to pursue for the next decade or so, or do you think you will be scrambling around for more opportunities in the Shopify space? I don&#8217;t know, other CMSs, pivot completely, who knows? What does the future hold? What&#8217;s the next decade looking like from where you sit right now?</p>\n\n\n\n<p>[00:38:24] <strong>Katie Keith:</strong> I must admit, I&#8217;m not very good at long-term planning. I just do what feels right for the short and medium term.</p>\n\n\n\n<p>[00:38:31] <strong>Nathan Wrigley:</strong> It&#8217;s worked.</p>\n\n\n\n<p>[00:38:32] <strong>Katie Keith:</strong> Well, yeah, exactly. Does it matter? You do something and then you focus on what works and learn and keep iterating. I think that&#8217;s why I haven&#8217;t created, I don&#8217;t know, hundreds of million dollar worth business because I&#8217;m not a visionary that has this long-term view that I&#8217;ll do anything to make it happen.</p>\n\n\n\n<p>Instead, I try something and keep learning, which has created a successful business, but in a more steady growth kind of way. So I&#8217;d rather be that visionary, but I&#8217;m not. It&#8217;s hard to know personally. I think you wanted to talk about the fact that my husband left the business about 8 months ago now. He&#8217;d lost his passion for it and wanted to reflect on other things he could do for the rest of his career, which he&#8217;s still doing.</p>\n\n\n\n<p>So I&#8217;m now running it on my own and he owns half of it, so that might affect the future. We talked about whether he should sell his share, for example, at the time, and he decided, oh, WordPress is growing so nicely, it&#8217;s so stable, he&#8217;ll leave his money in the business.</p>\n\n\n\n<p>Well, since then there&#8217;s been all this drama, so we are thinking, was that the right call? Should we get some money out?</p>\n\n\n\n<p>But I love what I do and want to stay doing what I&#8217;m doing for the foreseeable future. But we could do something like take on a partner or investment or something if Andy wants to, say, invest his half elsewhere. So there&#8217;s that, which might affect our future.</p>\n\n\n\n<p>[00:39:54] <strong>Nathan Wrigley:</strong> Oh gosh, that&#8217;s interesting. So, you heard here first. If people wanted to get in touch with you, Katie, not necessarily about taking on half the business or anything like that, but they&#8217;re just curious about what we&#8217;ve talked about today, or anything else related to WooCommerce plugins, et cetera, where would you be hanging out online? Is that a social network or an email? What&#8217;s the best thing?</p>\n\n\n\n<p>[00:40:15] <strong>Katie Keith:</strong> So for company stuff, it&#8217;s Barn2.com to check out our plugins and so on. And for me, the most active place that I am would be Twitter, which is katiekeithbarn2.</p>\n\n\n\n<p>[00:40:27] <strong>Nathan Wrigley:</strong> So Katie Keith, I appreciate you chatting to me today. Thank you so much and every success for 2025 and beyond. Thank you.</p>\n\n\n\n<p>[00:40:34] <strong>Katie Keith:</strong> Thanks for having me.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://x.com/katiekeithbarn2\">Katie Keith</a>.</p>\n\n\n\n<p>Katie is a founder and CEO of <a href=\"https://barn2.com/\">Barn2 Plugins</a>. With a background deeply rooted in WordPress, Katie&#8217;s journey presents an interesting narrative of transformation, from the early days of running a WordPress agency, to now managing a flourishing plugin business. Barn2 plugins has a portfolio of 19 premium plugins, many of which extend functionalities in WooCommerce.</p>\n\n\n\n<p>Today, Katie previews her upcoming lightning talk which she’ll be giving at WordCamp Asia. She talks about the transition from agency work to plugin development, highlighting early challenges and choices that shaped the business’ path.</p>\n\n\n\n<p>We get into the initial allure of client projects and their subsequent realisation of the benefits offered by productising their skills for global reach. Katie describes the decisions that led them to WordPress plugins, with products like WooCommerce Protected Categories and Document Library Pro, and explores how customer feedback and market needs drove their product diversification.</p>\n\n\n\n<p>As Katie explains, the plugin world wasn’t without its hurdles. There was trial and error involved in launching new products. This underscored the importance of market research. Additionally, she touches on Barn2&#8217;s current pivot into Shopify apps, aiming for diversification to help ensure that the business has stability by being available across multiple platforms.</p>\n\n\n\n<p>Katie investigates the current WordPress and WooCommerce landscape, discussing how she perceives the industry will change, potential growth areas, and the necessity of staying agile.</p>\n\n\n\n<p>If you’re curious about the intricacies of building a plugin business, or are seeking inspiration from someone who has already navigated the WordPress ecosystem, this episode is for you.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Useful links</h2>\n\n\n\n<p><a href=\"https://barn2.com/\">Barn2 website</a></p>\n\n\n\n<p><a href=\"https://www.shopify.com/\">Shopify</a></p>\n\n\n\n<p><a href=\"https://themeforest.net/\">Themeforest</a></p>\n\n\n\n<p><a href=\"https://iconicwp.com/\">Iconic website</a></p>\n\n\n\n<p><a href=\"https://x.com/katiekeithbarn2\">Katie&#8217;s X profile</a></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 19 Feb 2025 15:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Nathan Wrigley\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"Do The Woo Community: Why You Shouldn’t Miss WP:25: A Virtual Deep Dive into Enterprise WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=91213\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://dothewoo.io/blog/why-you-shouldnt-miss-wp25-a-virtual-deep-dive-into-enterprise-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:194:\"WP:25 is a virtual event by Human Made discussing the future of WordPress in the enterprise sector, featuring keynotes, panel discussions, and insights for developers, freelancers, and agencies.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 19 Feb 2025 13:29:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"Do The Woo Community: Enterprise WordPress 2025: AI Tools, CMS Strategies, and Roadmap Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=90729\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://dothewoo.io/enterprise-wordpress-2025-ai-tools-cms-strategies-and-roadmap-updates/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:219:\"In this episode, the hosts discuss the future of enterprise WordPress in 2025, focusing on AI advancements, multi-CMS strategies, security concerns, and upcoming features like full-site editing and multilingual support.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 19 Feb 2025 10:07:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"Do The Woo Community: Do the Woo Hooks, Tips You Can Take Action On\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=91193\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://dothewoo.io/blog/do-the-woo-hooks-tips-you-can-take-action-on/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"It\'s official. Introducing Do the Woo Hooks with tips from our community of builders and creators.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Feb 2025 21:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"Do The Woo Community: Decisions, Partners, and Pricing. A Chat with Nathan Tyler.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=90640\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://dothewoo.io/decisions-partners-and-pricing-a-chat-with-nathan-tyler/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:247:\"In this episode of Woo BizChat, Nathan Tyler discusses crucial business decisions for plugin and SaaS owners, covering pricing strategies, customer support, partnerships, and transitioning from services to product development for sustained growth.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Feb 2025 10:30:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Matt: Sun and shadows\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://ma.tt/2025/02/sun-and-shadows/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://ma.tt/2025/02/sun-and-shadows/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:133:\"<img width=\"604\" height=\"702\" src=\"https://i0.wp.com/ma.tt/files/2025/02/image.jpg?resize=604%2C702&ssl=1\" class=\"wp-image-137931\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Feb 2025 01:06:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Gravatar: How to Be Better at Networking: Leverage Existing Contacts\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=2864\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://blog.gravatar.com/2025/02/17/how-to-be-better-at-networking/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:11047:\"<p>Did you know that <a href=\"https://images.forbes.com/forbesinsights/StudyPDFs/Business_Meetings_FaceToFace.pdf\">85% of people build stronger business relationships</a> through in-person networking compared to online? That sounds promising, but the reality is that many professionals still struggle to turn brief connections into meaningful career opportunities. Networking can feel overwhelming, especially for those who face social anxiety or find traditional approaches too transactional.</p>\n\n\n\n<p>The good news? <strong>Building genuine relationships doesn’t have to feel like a chore.</strong> By focusing on leveraging the contacts you already have and combining practical strategies with powerful digital tools, networking can become both effective and enjoyable.</p>\n\n\n\n<p>This guide will walk you through actionable tips to help you maximize your current network, rekindle dormant connections, and stand out with tools like Gravatar, a <a href=\"https://blog.gravatar.com/2024/11/08/creating-a-digital-business-card/\">digital business card</a> that keeps your professional presence consistent and memorable.&nbsp;</p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Turn connections into lasting professional relationships</strong></h2>\n\n\n\n<p>Here&#8217;s a counterintuitive truth about networking: <strong>your most valuable professional connections might be people you haven&#8217;t spoken to in years. </strong>While most of us focus on maintaining active relationships or making new ones, <a href=\"https://www.researchgate.net/publication/220520957_Dormant_Ties_The_Value_Of_Reconnecting\">research from Organization Science</a> reveals that reconnecting with dormant contacts often yields greater benefits than relying on current ties. These forgotten connections – rich with untapped potential and fresh perspectives – could be the key to your next career breakthrough.</p>\n\n\n\n<p>So, what can you do to take advantage of those?&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Start by conducting a </strong><a href=\"https://blog.gravatar.com/2024/06/16/how-to-network-at-a-conference/\"><strong>network audit</strong></a><strong>.</strong> List your contacts and assess which connections may have gone inactive but still hold relevance. Using tools like Gravatar, you can revitalize your professional presence by ensuring your contact details and digital profiles are updated. This unified presence boosts credibility and simplifies re-engagement.</li>\n\n\n\n<li><strong>When reaching out, avoid generic follow-ups.</strong> Instead, build on shared professional interests or reference past collaborations to create meaningful touchpoints. For example, share an article or idea relevant to their industry. Crafting a strong elevator pitch is essential here – it’s your opportunity to leave a lasting impression when reconnecting.</li>\n\n\n\n<li><strong>Finally, don’t let </strong><a href=\"https://hbr.org/2022/05/if-networking-makes-you-anxious-try-this\"><strong>networking anxiety</strong></a><strong> hold you back.</strong> It’s normal to feel nervous, but simple techniques like visualization and scripting your conversations in advance can ease those worries​. With practice and intentionality, reconnecting with dormant ties can transform them into enduring professional relationships.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Making authentic follow-ups that get responses</strong></h3>\n\n\n\n<p>Imagine reconnecting with an old colleague. During your initial call, you discuss a mutual interest in emerging industry trends, such as AI-powered customer insights. A week later, you follow up by sharing a report on the topic, along with a thoughtful note: “Our chat inspired me to dive deeper into this – thought you’d find it interesting too.” This kind of personalized follow-up shows genuine interest and keeps the conversation alive.</p>\n\n\n\n<p>Sharing relevant industry insights or opportunities is a simple but powerful way to create value. It positions you as someone who contributes rather than merely seeks help. For example, sending an article that aligns with their current projects or highlighting a conference they might enjoy can make you memorable.</p>\n\n\n\n<p><strong>If starting these conversations feels daunting, practice a few </strong><a href=\"https://www.themuse.com/advice/30-brilliant-networking-conversation-starters\"><strong>go-to openers</strong></a><strong>. </strong>Questions like, “What inspired you to attend this event?” or “What’s been the most exciting project you’ve worked on recently?” are engaging and natural​. You can also keep it light and personal with openers like, “Have you been to this venue before?” or “What’s your favorite part about working in this industry?”</p>\n\n\n\n<p><strong>When reconnecting via email or LinkedIn, make your opener personal and specific. </strong>A great example could be referencing a shared memory: “I was just thinking about the project we worked on together back in 2018 – still one of the most innovative teams I’ve been a part of!” These thoughtful touches can make the difference between a generic interaction and one that leads to a meaningful, lasting connection.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Using Gravatar to stay memorable after meetings</strong></h3>\n\n\n\n<img width=\"1397\" height=\"716\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/gravatar-new-homepage-1.png\" alt=\"The Gravatar homepage\" class=\"wp-image-2867\" />\n\n\n\n<p><a href=\"https://gravatar.com/\">Gravatar</a> offers an easy way to leave a lasting impression after professional meetings. By creating a unified digital profile, Gravatar ensures that your contact information and portfolio remain accessible and automatically updated across platforms like <a href=\"https://wordpress.com/\">WordPress</a>, <a href=\"https://github.com/\">GitHub</a>, and <a href=\"https://slack.com/\">Slack</a>.&nbsp;</p>\n\n\n\n<img width=\"1421\" height=\"985\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/ronnie-gravatar-profile-3.png\" alt=\"Example of a Gravatar profile\" class=\"wp-image-2868\" />\n\n\n\n<p>But the standout feature for networking? <strong>QR codes.</strong></p>\n\n\n\n<p>Gravatar enables users to generate personalized QR codes linked directly to their profiles. Imagine this: You’re wrapping up a productive meeting, and instead of fumbling for a physical business card, you share your Gravatar QR code. Scanning it instantly provides your connection with access to your contact details, social links, and a dynamic calendar link for easy follow-ups​.</p>\n\n\n\n<p>The code itself is hidden behind your Gravatar profile picture and to see it, you just need to click the little icon on the top right corner.&nbsp;</p>\n\n\n\n<img width=\"1474\" height=\"974\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/01/gravatar-qr-code.png\" alt=\"Example of profile QR code\" class=\"wp-image-2869\" />\n\n\n\n<p>However, if you’re a developer, you could even <a href=\"https://docs.gravatar.com/api/profiles/qr-codes/\">customize the QR code</a> by adjusting its size and style, and even include your avatar or logo at its center. The codes can be embedded on name tags, event lanyards, or even digital signatures, making them a versatile tool for any networking scenario that includes <a href=\"https://blog.gravatar.com/2024/08/02/organizational-benefits-of-efficient-contact-sharing/\">contact sharing​</a>.</p>\n\n\n\n<p>This not only saves time but also positions you as tech-savvy and organized – qualities that help you stand out. With a Gravatar profile and QR code, staying memorable is as easy as a quick scan.</p>\n\n\n\n<a href=\"https://gravatar.com/connect/?gravatar_from=blog\"><img width=\"3243\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/free_profile_cta.png\" alt=\"\" class=\"wp-image-2616\" /></a>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Stand out at conferences: Strategies and digital tools for real-world networking</strong></h2>\n\n\n\n<p>Industry conferences often bring together professionals from all stages of your career – making them perfect opportunities to reconnect with dormant contacts and forge new relationships. Here&#8217;s how to maximize these moments:</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Before the conference</strong></h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Review the attendee list for former colleagues and new people you’d like to connect with.</li>\n\n\n\n<li>Use LinkedIn to identify which of these people (old and new contacts) will be speaking or attending.</li>\n\n\n\n<li>Plan your schedule around sessions where you&#8217;re likely to encounter these contacts.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>During the conference</strong></h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Use Gravatar&#8217;s QR code on your name tag with a note like &#8220;Worked at [Previous Company] 2018-2020&#8221; to help former colleagues recognize you.</li>\n\n\n\n<li>After reconnecting, use <a href=\"https://www.linkedin.com/help/linkedin/answer/a554240\">LinkedIn Live</a> to host quick session recaps, tagging relevant colleagues and attendees to maintain engagement.</li>\n\n\n\n<li>Log reconnections in CRM tools like <a href=\"https://www.hubspot.com/products/crm\">HubSpot</a> or <a href=\"https://www.zoho.com/\">Zoho</a>, noting shared history and current interests. Then, you can set reminders to follow up with a personalized email a week later.</li>\n</ul>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Post-conference follow-up</strong></h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Use <a href=\"https://zapier.com/\">Zapier</a> to automate personalized follow-ups that reference your shared history.</li>\n\n\n\n<li>Share conference insights relevant to your reconnected contacts&#8217; current roles.</li>\n\n\n\n<li>Schedule virtual coffee chats to continue conversations started at the event.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>Set up your professional digital hub in five minutes</strong></h2>\n\n\n\n<p>With Gravatar, setting up a professional digital hub is quick and simple. Here’s how to get started:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><a href=\"http://gravatar.com\">Register on Gravatar.com</a> and upload a professional photo to ensure a consistent, recognizable online presence.</li>\n\n\n\n<li>Include LinkedIn, GitHub, or other platforms where your professional work is showcased.</li>\n\n\n\n<li>Highlight your expertise and current role to make a great first impression.</li>\n\n\n\n<li>Use Gravatar’s QR code feature to share your profile at conferences or in follow-up emails​.</li>\n</ol>\n\n\n\n<p>In minutes, you’ll have a centralized, dynamic digital business card that keeps your contact details and portfolio accessible across platforms. Whether you’re connecting online or in person, Gravatar ensures you stay memorable and organized with minimal effort.</p>\n\n\n\n<a href=\"https://gravatar.com/connect/?gravatar_from=blog\"><img width=\"3243\" height=\"729\" src=\"https://blog.gravatar.com/wp-content/uploads/2024/12/free_profile_cta.png\" alt=\"\" class=\"wp-image-2616\" /></a>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 17 Feb 2025 16:23:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"Do The Woo Community: Do the Woo v4.2 Changelog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=89017\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://dothewoo.io/blog/do-the-woo-v4-2-changelog/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:212:\"Version 4.2 introduces new shows including WooCommerce Accessibility Insights and WP Agency Tracks, hosts Marcus Burnette, Mark Westguard, and Matthias Pfefferle, while deleting All Things WordPress and Woo Show.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 15 Feb 2025 09:30:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"WordPress.org blog: Report: WordPress in 2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18475\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/news/2025/02/wordpress-in-2025-report/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2965:\"<p>This year is set to be transformative for WordPress, yet many decision-makers risk overlooking the immense opportunities ahead. Our new <strong>“WordPress in 2025”</strong> report highlights why WordPress should be a cornerstone of your long-term strategy. Stay ahead of the curve—read the report now to see how WordPress can drive growth and innovation for your business in the years to come.</p>\n\n\n\n<img width=\"1024\" height=\"647\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/WordPress-in-2025-WPORG-2.jpg?resize=1024%2C647&ssl=1\" alt=\"\" class=\"wp-image-18476\" />\n\n\n\n<p>Some of the key points we explore:&nbsp;</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>As proprietary &#8220;next-gen&#8221; CMS hype fizzles out and enterprise budgets shift priorities, open-source CMSs like WordPress are primed to gain ground in the commoditized CMS space. WordPress&#8217; maturity and extensibility provide a high starting point for innovation.</li>\n\n\n\n<li>WordPress&#8217; Block Editor has seen tremendous investment, amassing over 34,000 commits &#8211; more than entire competing CMS projects. New capabilities like Full Site Editing (FSE) give enterprises unprecedented ability to enable no-code site building.</li>\n\n\n\n<li>Just as being the first user-friendly publishing tool propelled WordPress&#8217; initial growth, AI presents a similar opportunity. WordPress&#8217; contributor community can build not just AI features, but an exciting multi-agent, LLM-agnostic ecosystem representing an intelligent content operating system.</li>\n\n\n\n<li>Pure-play headless vendors are working backwards to add no-code editing, while WordPress has long supported robust headless capabilities alongside its mature editor. For complex sites, hybrid architectures leveraging both are the pragmatic path forward.</li>\n</ul>\n\n\n\n<p><a href=\"https://wordpress.org/news/files/2025/02/WordPress-in-2025-Report-Noel-Tock.pdf\">Download the full WordPress in 2025 (PDF)</a> report directly to learn more.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Don’t miss WP:25, the virtual event.</h3>\n\n\n\n<p><a href=\"https://humanmade.com/wordpress-in-2025-event/?utm_campaign=41192678-WordPress%20in%202025&utm_source=event&utm_medium=Noel%20sales%20outreach&utm_content=event%20landing%20page\">Save your spot at our free event, WP:25</a>, exploring the future of WordPress and featuring key people working with many of the ideas discussed in the report. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p><strong>About the report&#8217;s author, <a href=\"https://profiles.wordpress.org/noel_tock/\">Noel Tock</a></strong> — Having built his first website back in 1995, Noel has long been watching the evolution of the CMS space. As a co-owner at one of the leading enterprise WordPress agencies, Human Made, his belief in the power of open source is as great as ever. Human Made is a WordPress VIP Gold Partner specializing in DXP, headless, AI and more.</p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 15 Feb 2025 03:19:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Noel Tock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WordPress.org blog: WordCamp Asia 2025: Manila Magic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=18482\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2025/02/wordcamp-asia-2025-manila-magic/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4133:\"<img width=\"1024\" height=\"536\" src=\"https://i0.wp.com/wordpress.org/news/files/2025/02/444990627_474578655140578_2659126618470753960_n.jpg?resize=1024%2C536&ssl=1\" alt=\"WordCamp Asia 2025\" class=\"wp-image-18491\" />\n\n\n\n<p>The first major WordCamp of the year is here! <a href=\"https://asia.wordcamp.org/2025/\">WordCamp Asia 2025</a> lands in Manila, Philippines, from February 20-22, bringing together open source enthusiasts, developers, and WordPress professionals from across the region—and the world.</p>\n\n\n\n<p>With three packed days of learning, networking, and collaboration, this year’s event promises fresh insights, dynamic discussions, and plenty of opportunities to connect.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Solutions spotlight</h3>\n\n\n\n<p>Throughout the conference days, multiple presentations will focus on the solutions provided by our amazing sponsors. This is a great opportunity to learn more about their initiatives and solutions.</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-1 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://asia.wordcamp.org/2025/solutions-spotlight/\">Explore the solutions spotlight</a></div>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Keynotes, panels, and deep dives</h3>\n\n\n\n<p>The main conference, which will be held on February 21-22, will feature <a href=\"https://asia.wordcamp.org/2025/schedule/#day-2\">a lineup of notable keynote speakers</a>, including digital innovation leaders and open-source advocates. Attendees can expect diverse sessions on business strategy, development of best practices, and technical advancements.</p>\n\n\n\n<p>For those looking to sharpen their skills, presentations will dive deep into topics like SEO for WordPress, performance optimization, and AI-powered content creation. Plus, don’t miss the electrifying WordPress Speed Build Battle, where developers race to create stunning sites in record time.</p>\n\n\n\n<h3 class=\"wp-block-heading\">YouthCamp</h3>\n\n\n\n<p>On February 22, WordCamp Asia 2025 will host <a href=\"https://asia.wordcamp.org/2025/youthcamp/\">YouthCamp</a>, a pre-registered event designed to introduce young minds to WordPress and its endless possibilities. This initiative aims to engage the next generation of WordPress users, developers, and contributors through hands-on activities and interactive sessions</p>\n\n\n\n<h3 class=\"wp-block-heading\">Closing Q&amp;A with Matt Mullenweg</h3>\n\n\n\n<p>WordPress Cofounder Matt Mullenweg will wrap up the event with a live Q&amp;A session on February 22. Whether attending in person or tuning in online, you can catch his insights live on the <a href=\"https://www.youtube.com/@WordPress\">WordPress YouTube channel</a> at 4:00 p.m. Philippine Time (08:00 UTC).</p>\n\n\n\n<h3 class=\"wp-block-heading\">After party</h3>\n\n\n\n<p>As the sun sets on WordCamp Asia 2025, the excitement continues with the After Party (theme: Island Vibe)! Get ready to experience the vibrant spirit of the Philippines with a lively gathering at <a href=\"https://www.picc.gov.ph/\">The Forum at PICC</a>. Expect a night filled with great conversations, music, and a celebration of the WordPress community.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Get WordCamp-ready</h3>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Secure your <a href=\"https://asia.wordcamp.org/2025/tickets/\">WordCamp Asia 2025 tickets</a> (if you haven’t already!)</li>\n\n\n\n<li>Browse the <a href=\"https://asia.wordcamp.org/2025/schedule/\">full schedule of sessions</a> to plan your experience</li>\n\n\n\n<li>Follow WordCamp Asia on<strong> </strong><a href=\"https://x.com/WordCampAsia\">X</a>, <a href=\"https://www.linkedin.com/company/wordcampasia/\">LinkedIn</a>, and <a href=\"https://www.instagram.com/wordcampasia/\">Instagram</a> for real-time updates</li>\n</ul>\n\n\n\n<p>As always, be part of the conversation! Whether you’re attending in Manila or following along online, share your experiences using <strong>#WCAsia</strong> and <strong>#WordPress</strong>.</p>\n\n\n\n<p>Manila is calling—see you at WordCamp Asia 2025!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Feb 2025 16:04:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Bernard Meyer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"Do The Woo Community: Friday Shares: Back in 2025 v9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://dothewoo.io/?post_type=blog&p=90887\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://dothewoo.io/blog/friday-shares-back-in-2025-v9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"A bit ago I announced the end of Friday Shares but, due to community feedback, will continue them alongside a new newsletter.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Feb 2025 11:41:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matt: Scale\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=137506\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://ma.tt/2025/02/scale/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:340:\"<p>In high school when 5% of your class doesn&#8217;t like you it&#8217;s like 3-5 people. </p>\n\n\n\n<p>Running a company of 1,700+ when 5% doesn&#8217;t like you, that&#8217;s 85 people! That fills a room. </p>\n\n\n\n<p>150k followers and 5% don&#8217;t like you now you have a small stadium of 7,500 people. </p>\n\n\n\n<p>It&#8217;s still 5%.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Feb 2025 00:40:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"Do The Woo Community: Woo Marketplace Hits 1000 Extensions—What’s Next?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=90625\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://dothewoo.io/woo-marketplace-hits-1000-extensions-whats-next/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:263:\"BobWP announces the WooCommerce Marketplace hitting 1,000 extensions and shares updates on streamlined workflows and quicker approvals within 1-4 days. WooCommerce is accepting both free and freemium products, encouraging builders to submit their extensions here.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Feb 2025 12:26:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"Do The Woo Community: Building WordPress Agency Habits with Cami MacNamara\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://dothewoo.io/?p=90590\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://dothewoo.io/building-wordpress-agency-habits/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:232:\"In this first episode of WP Agency Tracks, hosts Marcus Burnette and Cami McNamara discuss effective habits for agency owners, focusing on time management, mental health, and community engagement to enhance productivity and success.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Feb 2025 09:45:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BobWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WordCamp Central: WordCamp Mukono 2025: A Celebration of WordPress and Women in Tech\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"https://central.wordcamp.org/?p=9547410\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"https://central.wordcamp.org/news/2025/02/wordcamp-mukono-2025-a-celebration-of-wordpress-and-women-in-tech/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:11035:\"<h2 class=\"wp-block-heading has-text-align-center\">Welcome to the Pearl of Africa’s first WordCamp 2025!</h2>\n\n\n\n<img src=\"https://mukono.wordcamp.org/2025/files/2025/02/Home-scaled.jpg\" alt=\"\" />\n\n\n\n<p>Uganda, known as the Pearl of Africa, is a land of breathtaking landscapes, diverse cultures, and warm hospitality. Within this vibrant country lies <strong>Mukono</strong>, a fast-growing town known for its dynamic community, top-tier educational institutions, and entrepreneurial spirit. Mukono is not just a town—it is a hub of ideas, innovation, and collaboration.</p>\n\n\n\n<p>This Year, Mukono will host one of the most anticipated WordPress events in East Africa: <a href=\"https://mukono.wordcamp.org/2025/\">WordCamp Mukono 2025</a>. This gathering of WordPress enthusiasts, developers, designers, marketers, and content creators will take place on <strong>March 8, 2025</strong>, at the <a href=\"https://www.google.com/search?client=firefox-b-d&q=mukono+synod+hall&sei=nfuqZ53JM4ewhbIP6MmCqQc\">Synod Hall Mukono</a>, near <a href=\"https://www.bishopss.com/\">Bishop’s Senior School</a>.<br /><br />The Venue has been specifically selected to accommodate everyone. This is the easiest venue to get to Ever.  It is in the CBD and in a serene and quiet environment. You will not be suffering from Noise Pollution. Whether you&#8217;re a seasoned WordPress professional, an aspiring entrepreneur, a curious beginner, or someone passionate about technology and community building, this event is designed for you.</p>\n\n\n\n<h2 class=\"wp-block-heading has-text-align-center has-medium-font-size\">A Theme That Matters: WP HERoes – Women Powering the WordPress Universe</h2>\n\n\n\n<p>For WordCamp Mukono 2025, we are embracing a powerful and transformative theme: “<strong>WP HERoes: Women Powering the WordPress Universe</strong>”. This year’s event is dedicated to celebrating, empowering, and amplifying the voices of women in the WordPress community. Women have played a pivotal role in shaping WordPress, from coding and design to content creation and community leadership. However, their contributions often go unnoticed.</p>\n\n\n\n<p>At WordCamp Mukono 2025, we will shine a spotlight on these incredible women—the <strong>HER</strong>oes—who are making WordPress a more inclusive, innovative, and vibrant ecosystem. Just as Mukono is a center for education and opportunity, this event aims to foster growth, learning, and collaboration among WordPress users of all backgrounds. We believe that when diverse voices are heard and empowered, the entire community thrives.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>Why Attend WordCamp Mukono 2025?</strong></h3>\n\n\n\n<p>This is more than just another tech conference. <a href=\"https://mukono.wordcamp.org/2025/\">WordCamp Mukono 2025</a> is a place where ideas spark, collaborations begin, and knowledge is shared. Here’s what you can expect:</p>\n\n\n\n<h3 class=\"wp-block-heading has-text-align-center\"><strong>World-Class Speakers and Engaging Sessions</strong></h3>\n\n\n\n<img src=\"https://mukono.wordcamp.org/2025/files/2025/02/Speakerlst.jpg\" alt=\"\" />\n\n\n\n<p><strong>Prepare to be inspired!</strong> We are bringing together an incredible lineup of local and international speakers who will share their expertise on various aspects of WordPress. Whether you&#8217;re new to WordPress or an advanced user, there&#8217;s something for everyone:<br /><br /><strong>Design &amp; User Experience (UX)</strong> – Master the art of crafting visually stunning and user-friendly websites.<br /><strong>Business &amp; Digital Marketing</strong> – Explore strategies for freelancers, bloggers, and entrepreneurs looking to monetize their WordPress skills.<br /><strong>Women in Tech</strong> – Hear firsthand stories of empowerment, success, and resilience from female leaders in the WordPress community.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Unmatched Networking Opportunities</h4>\n\n\n\n<p>WordCamp Mukono 2025 is not just an event—it’s an experience. It’s a rare opportunity to meet like-minded individuals, expand your professional network, and forge lasting collaborations. Whether you’re looking for a mentor, business partner, or simply want to connect with fellow WordPress enthusiasts, this is the place to be.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Hands-On Learning &amp; Workshops</h4>\n\n\n\n<p>Our workshops are designed to be interactive and practical, giving you hands-on experience with WordPress tools and technologies. Learn from seasoned experts and walk away with real-world skills you can apply immediately.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Showcasing Mukono: A City of Growth and Culture</h4>\n\n\n\n<p>Mukono is a blend of urban convenience and natural beauty. From its bustling markets to its serene landscapes, Mukono offers a unique experience for visitors. If you’re traveling from outside the town, you’ll find comfortable accommodations ranging from budget-friendly guesthouses to upscale hotels.<br />We encourage attendees to arrive early and explore Mukono—its culture, food, and hospitality will make your visit even more memorable!</p>\n\n\n\n<h2 class=\"wp-block-heading\">Event Details: When and Where?</h2>\n\n\n\n<p><strong><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f4cd.png\" alt=\"📍\" class=\"wp-smiley\" /> Location:</strong> <a href=\"https://maps.app.goo.gl/rir2trT2GUuGb2kK8\">Synod Hall Mukono</a>, near Bishop’s Senior School<br /><strong><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f4c5.png\" alt=\"📅\" class=\"wp-smiley\" /> Date:</strong> March 8, 2025<br /><strong><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f465.png\" alt=\"👥\" class=\"wp-smiley\" /> Capacity: </strong>Over 400 attendees<br /><strong><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" /> Tickets:</strong> <a href=\"https://mukono.wordcamp.org/2025/tickets/\">Buy Tickets Here</a> (Limited slots available—get yours now!)</p>\n\n\n\n<p><br /><a href=\"https://mukono.wordcamp.org/2025/location/\">Our venue</a>, Synod Hall Mukono, is a spacious and well-equipped location with excellent lighting, ventilation, and accessibility. Its proximity to Mukono’s central business district makes it the perfect setting for an event of this magnitude.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Be a Part of Something Bigger: Sponsorship Opportunities</h2>\n\n\n\n<img src=\"https://mukono.wordcamp.org/2025/files/2025/01/Sponsors.jpg\" alt=\"\" />\n\n\n\n<p>WordCamp Mukono 2025 is made possible through the generosity of <a href=\"https://mukono.wordcamp.org/2025/sponsors/\">sponsors</a> who believe in empowering the WordPress community. If your company or organization wants to gain exposure while supporting a great cause, we invite you to <a href=\"https://mukono.wordcamp.org/2025/call-for-sponsors/\">become a sponsor!</a></p>\n\n\n\n<h4 class=\"wp-block-heading\">Sponsorship offers unique benefits, including: </h4>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2705.png\" alt=\"✅\" class=\"wp-smiley\" /> <strong>Brand Visibility </strong>– Reach a targeted audience of WordPress professionals and enthusiasts. <br /><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2705.png\" alt=\"✅\" class=\"wp-smiley\" /> <strong>Community Engagement</strong> – Connect with potential customers, partners, and talent. <br /><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/2705.png\" alt=\"✅\" class=\"wp-smiley\" /> <strong>Networking &amp; Recruitment </strong>– Identify and engage with skilled WordPress developers, designers, and marketers.</p>\n\n\n\n<p><strong>Interested in sponsoring? Learn more here: <a href=\"https://mukono.wordcamp.org/2025/call-for-sponsors/\">https://mukono.wordcamp.org/2025/call-for-sponsors/</a></strong></p>\n\n\n\n<h2 class=\"wp-block-heading has-text-align-center\">Accommodation &amp; Travel Tips</h2>\n\n\n\n<img src=\"https://mukono.wordcamp.org/2025/files/2025/02/Accomodation-2.jpg\" alt=\"\" />\n\n\n\n<p>Mukono offers a variety of accommodation options, from budget guesthouses to high-end hotels. If you’re traveling from outside Mukono, we recommend booking early to secure the best options near the venue. For more details, visit: <a href=\"https://mukono.wordcamp.org/2025/accommodation-guide-for-visitors-to-mukono-town/\">Location Post</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Secure Your Spot – Get Your Ticket Today!</h2>\n\n\n\n<img src=\"https://mukono.wordcamp.org/2025/files/2025/02/Tickets-scaled.jpg\" alt=\"\" />\n\n\n\n<p><a href=\"https://mukono.wordcamp.org/2025/tickets-now-available/\">Tickets for WordCamp</a> Mukono 2025 are now available! We offer different ticket categories, including:<br /><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" /> Regular Ticket – <strong>UGX 15,000. </strong>Each ticket includes access to all sessions, networking opportunities, swag, refreshments, and a truly unforgettable experience!<br /><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" /> Actual Cost Ticket – <strong>UGX 100,000. </strong>Each ticket includes access to all sessions, networking opportunities, swag, refreshments, and a truly unforgettable experience! A ticket for people who love and Support wordPress and want to ensure that the Event moves super smoothly.<br /><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f449.png\" alt=\"👉\" class=\"wp-smiley\" /> Reserve your spot today: <a href=\"https://mukono.wordcamp.org/2025/tickets/\">Click Here</a></p>\n\n\n\n<p><strong>Join the WordCamp Mukono 2025 Movement!</strong><br />WordCamp Mukono 2025 is more than just an event—it’s a movement that celebrates WordPress, women in tech, and the power of community. Whether you&#8217;re a beginner, expert, entrepreneur, or enthusiast, there is something for you.</p>\n\n\n\n<p><strong><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f4ac.png\" alt=\"💬\" class=\"wp-smiley\" /> Let’s start the conversation! Use the official hashtags:</strong><br />#WCMukono25 #WordPressMukono #WPHeroes #WomenInWordPress</p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f4e7.png\" alt=\"📧\" class=\"wp-smiley\" /> Contact Us: mukono@wordcamp.org<br /><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f310.png\" alt=\"🌐\" class=\"wp-smiley\" /> Official Website: <a href=\"https://mukono.wordcamp.org/2025\">https://mukono.wordcamp.org/2025/</a><br /><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" /> Tickets Info: <a href=\"https://mukono.wordcamp.org/2025/tickets/\">Buy Tickets Here</a> (Limited slots available—get yours now!)<br /><img src=\"https://s.w.org/images/core/emoji/15.0.3/72x72/1f91d.png\" alt=\"🤝\" class=\"wp-smiley\" /> Sponsorship: <a href=\"https://mukono.wordcamp.org/2025/call-for-sponsors-wordcamp-mukono/\">https://mukono.wordcamp.org/2025/call-for-sponsors-wordcamp-mukono/</a><br /><strong>See you in Mukono for an unforgettable WordPress celebration!</strong></p>\n\n\n\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Feb 2025 08:53:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Moses Cursor Ssebunya\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Matt: Hash tables\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://ma.tt/?p=137372\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://ma.tt/2025/02/hash-tables/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:405:\"<p>“You didn’t just come up with a cool hash table,” he remembers telling Krapivin. “You’ve actually completely wiped out a 40-year-old conjecture!” <a href=\"https://www.quantamagazine.org/undergraduate-upends-a-40-year-old-data-science-conjecture-20250210/\">There&#8217;s a delightful article on an undergraduate discovering an optimization in a very basic computer science principle</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Feb 2025 22:03:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"Gravatar: Simplify Link Sharing With Smart Redirects\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://blog.gravatar.com/?p=2877\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://blog.gravatar.com/2025/02/12/simplify-link-sharing-with-smart-redirects/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4108:\"<p>You know what&#8217;s better than easy-to-share links? Easy-to-share links on your own custom domain. </p>\n\n\n\n<p>We just rolled out Smart Redirects for all Gravatar custom domains. Zero setup required.</p>\n\n\n\n<p><em>And right now, we&#8217;re offering free custom domains for your first year.</em> </p>\n\n\n\n<h2 class=\"wp-block-heading\">What Are Smart Redirects?</h2>\n\n\n\n<p>They&#8217;re simple shortcuts that make sharing your online presence a breeze. Add the name of any of your verified services to the end your domain:</p>\n\n\n\n<pre class=\"wp-block-preformatted\"><code>your-name.link/bluesky<br />your-name.link/linkedin<br />your-name.link/calendar</code></pre>\n\n\n\n<p>That&#8217;s it. Your domain automatically redirects to your connected accounts. No configuration. No DNS wizardry. Just connect your accounts to Gravatar and the redirects work instantly.</p>\n\n\n\n<p>These are perfect for email signatures, business cards, social media profiles, and more.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Simplified Payments With /pay</h2>\n\n\n\n<p>Here&#8217;s something cool: Smart Redirects make sharing payment links much nicer. Instead of dropping a long payment URL in your messages or emails, just use:</p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-1 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<div class=\"wp-block-group has-global-padding is-layout-constrained wp-block-group-is-layout-constrained\">\n<pre class=\"wp-block-preformatted\"><code>your-name.link/pay</code></pre>\n\n\n\n<p>This currently works with:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>PayPal</li>\n\n\n\n<li>Venmo</li>\n\n\n\n<li>Crypto currencies</li>\n\n\n\n<li>Custom (any link you want)</li>\n</ul>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<img width=\"490\" height=\"374\" src=\"https://blog.gravatar.com/wp-content/uploads/2025/02/cleanshot-2025-02-12-at-12.55.50402x.png\" alt=\"\" class=\"wp-image-2885\" />\n</div>\n</div>\n\n\n\n<p>Just add your payment details to your Gravatar profile, and your /pay link automatically directs people to all of your preferred payment methods. Perfect for freelancers, creators, splitting the bill among friends, or anyone who needs to receive payments.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Free Domain? Tell Me More</h2>\n\n\n\n<p>For a limited time, claim your .link, .bio, or .social domain (or choose from other popular TLDs) through Gravatar. Just log in to your dashboard and look for the domain claim option at the top of your profile. Free for the first year. </p>\n\n\n\n<p>Once you have your domain, Smart Redirects are automatically enabled. No extra steps needed.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Available Now</h2>\n\n\n\n<p>Smart Redirects work with most major platforms including GitHub, LinkedIn, Bluesky, Mastodon, Tumblr, and many more. We&#8217;ve also added handy shortcuts for your calendar (/calendar), contact (/contact), and payment info (/pay).<br /></p>\n\n\n\n<h2 class=\"wp-block-heading\">Getting Started</h2>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Claim your free domain (if you haven&#8217;t already)</li>\n\n\n\n<li>Connect your accounts in your Gravatar profile</li>\n\n\n\n<li>Start sharing your shorter, sweeter links</li>\n</ol>\n\n\n\n<p>And fun fact: both <code><em>/twitter</em></code> and <code><em>/x</em></code> work for your X profile. We&#8217;ve got you covered either way.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Why Your Own Domain Matters</h2>\n\n\n\n<p>Your domain is your identity on the open web. It&#8217;s not just for your Gravatar profile – use it everywhere to build your presence and own your digital footprint. And with Smart Redirects, it&#8217;s now even more useful.</p>\n\n\n\n<p>Want to see all the available redirects and learn more? Check out our <a href=\"https://support.gravatar.com/smart-redirects\">Smart Redirects guide</a>.</p>\n\n\n\n<p>Smart Redirects are live for all <a href=\"https://gravatar.com/custom-domains\">Gravatar custom domains</a>. And remember, domains are free for your first year. Go ahead, claim yours and give Smart Redirects a try!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Feb 2025 19:52:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Ronnie Burt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: #156 – Derek Ashauer on Analytics Options and Privacy Challenges\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wptavern.com/?post_type=podcast&p=187359\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://wptavern.com/podcast/156-derek-ashauer-on-analytics-options-and-privacy-challenges\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:57075:\"Transcript<div>\n<p>[00:00:00] <strong>Nathan Wrigley:</strong> Welcome to the Jukebox Podcast from WP Tavern. My name is Nathan Wrigley.</p>\n\n\n\n<p>Jukebox is a podcast which is dedicated to all things WordPress. The people, the events, the plugins, the blocks, the themes, and in this case, analytics options and privacy challenges for WordPress site owners.</p>\n\n\n\n<p>If you&#8217;d like to subscribe to the podcast, you can do that by searching for WP Tavern in your podcast, player of choice. Or by going to wptavern.com/feed/podcast, and you can copy that URL into most podcast players.</p>\n\n\n\n<p>If you have a topic that you&#8217;d like us to feature on the podcast, I&#8217;m keen to hear from you, and hopefully get you, or your idea, featured on the show. Head to wptavern.com/contact/jukebox and use the form there.</p>\n\n\n\n<p>So on the podcast today we have Derek Ashauer.</p>\n\n\n\n<p>Having spent over 15 years in the WordPress arena, Derek has transitioned from building client sites to creating specialized WordPress plugins. Today we get to hear about his journey creating Conversion Bridge, a tools specifically designed to streamline the process of implementing analytics platforms and conversion tracking on WordPress websites.</p>\n\n\n\n<p>We start with an overview of analytics, tracing its evolution from the simple server logs of the early internet days, to the sophisticated data gathering mechanisms provided by Google Analytics and others.</p>\n\n\n\n<p>We explore how the introduction of European privacy laws has significantly impacted the data landscape, challenging marketers and businesses to adapt to a new era where data privacy is regarded differently in different locales.</p>\n\n\n\n<p>Derek offers his perspectives on this rapidly changing field, discussing the rise of modern privacy focused analytics platforms like Fathom, Plausible and others. He explains how these technologies employ cookieless tracking techniques to respect user privacy, while still providing valuable insights for website owners.</p>\n\n\n\n<p>We also address the problem of data accessibility and user privacy. Derek, sharing his personal views as a marketer, acknowledges the complexity of balancing effective marketing strategies with ethical data use. He explains his thoughts on why modern solutions might strike a better balance, ensuring that user data remains private, while allowing businesses to glean just the insights they need.</p>\n\n\n\n<p>Whether you are managing a WooCommerce store, or building sites for clients, Derek&#8217;s insights into conversion tracking will be of interest. He talks about some of the hurdles site builders face with traditional systems and how Conversion Bridge simplifies conversion tracking across various platforms and plugins without the need for extensive coding.</p>\n\n\n\n<p>If you&#8217;re an agency, developer, or digital marketer, this discussion will help equip you with the knowledge and strategies to navigate the ever evolving landscape of web analytics.</p>\n\n\n\n<p>If you&#8217;re interested in finding out more, you can find all of the links in the show notes by heading to wptavern.com/podcast. Where you&#8217;ll find all the other episodes as well.</p>\n\n\n\n<p>And so without further delay, I bring you Derek Ashauer.</p>\n\n\n\n<p>I am joined on the podcast by Derek Ashauer. How you doing, Derek?</p>\n\n\n\n<p>[00:03:40] <strong>Derek Ashauer:</strong> I am doing well, thank you so much.</p>\n\n\n\n<p>[00:03:41] <strong>Nathan Wrigley:</strong> Thank you very much for joining me. We&#8217;ve had various chats over the years, but this is going to be a chat that we&#8217;ve never had before. This is going to be all about analytics.</p>\n\n\n\n<p>We&#8217;ll talk about all of the different bits and pieces, perhaps get into the future of analytics, the past of analytics, who knows? But stay with us, dear listener. It&#8217;s going to be a really interesting conversation. I feel like things are at a bit of an inflection point, and people definitely have strong opinions on this, and I think that can often lie on geographical grounds, where you live in the world and things like that.</p>\n\n\n\n<p>So before we get into that conversation, Derek, do you just want to give us a little potted bio? Tell us who you are.</p>\n\n\n\n<p>[00:04:15] <strong>Derek Ashauer:</strong> Yeah, my name&#8217;s Derek Ashauer, I&#8217;m in Colorado US. I&#8217;ve been in the WordPress community for, well, I guess I&#8217;ve been working with WordPress for about 15 years, I think. Doing client sites and things like that. So I&#8217;ve done the independent freelancer agency, but now I&#8217;ve moved to making WordPress plugins. So I have one for photographers called Sunshine Photo Cart.</p>\n\n\n\n<p>But my big one that I&#8217;m working on lately is called Conversion Bridge, which really makes it easy to add analytics platforms to your WordPress website, and also make it really easy to do conversion tracking, which is something that a lot of agencies and people are building sites for clients just neglect to do. And one reason why is because it&#8217;s kind of a pain in the butt.</p>\n\n\n\n<p>So the goal is to make it a lot easier so that I can do it for myself, and my client sites that I&#8217;ve worked on, but also then to make it easier for everyone else. So that&#8217;s how I got the idea for that.</p>\n\n\n\n<p>[00:05:02] <strong>Nathan Wrigley:</strong> Prior to hitting the record button, Derek and I were saying that, you are on a journey with this, you know, you&#8217;re not putting yourself up here as the definitive authority. I think you were basically saying that a little while ago your knowledge was not that deep in this arena and you&#8217;ve really had to educate yourself. And I think it&#8217;s fair to say that you were trying to summarise it as you&#8217;re still learning.</p>\n\n\n\n<p>So let&#8217;s have a conversation about this and see where we end up. The thought occurs to me that if we were to go back, oh gosh, I mean the internet, every time I say this sentence the internet does obviously get a little bit older, but let&#8217;s go for 20 years, something like that. I feel that if you went to a website, there wasn&#8217;t even the thought that there was any kind of analytics. Maybe there was some server log somewhere that was recording that, okay, we served up a page, but that was about it.</p>\n\n\n\n<p>And then at some point analytics software came along and very quickly started to leverage all of the existing technologies and became really, really sophisticated ever so quickly. You would copy and paste a code, and it was typically Google, I think that dominated the arena right from the outset. They offered a free service, Google Analytics. You could copy and paste one line of code. There was no barrier to entry to that technology. And it would give you all sorts of fascinating information really quickly.</p>\n\n\n\n<p>I think everybody was happy with that status quo, but in the more recent past, let&#8217;s say decade or so, but definitely it seems to be ramping up at the moment. There seems to be concerns about who gets the data, why is this data necessary? Is this data consumable by, I don&#8217;t know, an American company looking at a European who&#8217;s browsing on a particular website and things like that?</p>\n\n\n\n<p>With all of this, just give us your overarching opinion on it, and then we can go from there. What&#8217;s the state of play at the moment with analytics? Where are we? The year 2025 at the moment. Do you have any sort of overarching insight into where analytics, in air quotes, is at the moment?</p>\n\n\n\n<p>[00:06:55] <strong>Derek Ashauer:</strong> Yeah, it&#8217;s a lot harder because of the European privacy laws for the analytics platforms to get the data that marketers and other people have been used to for a long time. Where people came from, you used to be able to get like exactly what search terms people were looking at and landed on your site and what they did. You know, if someone searched Fort Collins landscaper, local landscape company could see that that&#8217;s exactly what they searched, and then what that user did on their website from that search term. And that&#8217;s just kind of gone. That deep level of data is unfortunately not possible anymore to follow those type of European laws, and privacy restrictions and things like that. So there&#8217;s a lot of people who are struggling to get the data that they were used to. That&#8217;s kind of the short of it, I guess.</p>\n\n\n\n<p>[00:07:40] <strong>Nathan Wrigley:</strong> Do you think that we kind of let the horse escape from the barn a little bit, and we&#8217;re now just trying to get the horse back into the barn and get it under control again? And what I mean by that is, do you think that these technologies, the analytics and what have you, do you think it kind of just crept up upon us? There was this slow but inexorable extension of what analytics software could do. And all the while it felt like completely benign, you know, there&#8217;s no problem with it. How could anybody possibly make use of this in a way which might be harmful or, I don&#8217;t know, intrusive or what have you?</p>\n\n\n\n<p>So the software became more and more clever. But then I think people, especially like you said on the European side of things, started to take a look at it and thought, hmm, it&#8217;s interesting, a lot of this data is going to, in many cases, big North American companies. Google, I suppose would be a perfect example, but you&#8217;ve obviously got other things like Facebook and what have you.</p>\n\n\n\n<p>Just try to maybe restore something a bit more where the user is in control, as opposed to these giant corporations being in control. So just trying to bring it back to the starting line, if you like, to the moment before the horse got out so that we can reestablish some rules.</p>\n\n\n\n<p>So, I don&#8217;t know. It sounds from what you were saying as if you&#8217;re kind of regretful that the analytics solutions can&#8217;t do what they once could. I suppose the European argument would be, well, that&#8217;s because it never really, with hindsight, we should never have let it get that far in the first place. What&#8217;s your thoughts on that?</p>\n\n\n\n<p>[00:09:07] <strong>Derek Ashauer:</strong> I mean, I kind of see it. The way I often describe a lot of things is like a pendulum swing. In the beginning it went really far in one direction, we got all kinds of data, and then the laws popped up and now it feels like, we can&#8217;t get nearly enough data for advanced marketing, for large corporations that are really doing massive campaigns.</p>\n\n\n\n<p>And then there&#8217;s the alternatives, Fathom, Plausible, Pirsch, you know, lots of great, Usermaven. There&#8217;s a lot of new alternative analytics platforms now that are out there, and now finding clever ways to claw back some of that.</p>\n\n\n\n<p>It&#8217;s never going to be nearly as detailed as it was a decade ago, that was kind of like the heyday of marketing where you could get so much great data on stuff. But you know, so we had too much maybe in some people&#8217;s opinions, and then maybe there&#8217;s a bit of not enough, and now those companies are finding some ways to move maybe towards a middle ground of what works for everyone.</p>\n\n\n\n<p>And as an American, I&#8217;m like, yeah, whatever. You saw that I visited these several websites in a row, I really don&#8217;t care. That never really bothered me, I haven&#8217;t understood the massive problem with it.</p>\n\n\n\n<p>Going through all this, I have learned, you know, maybe there&#8217;s a few spots where it would be good to protect that and maybe they don&#8217;t know that but, yeah, I&#8217;m the person that does accept all on every single website that I got to as a marketer, because I&#8217;m just like, yeah, great, I&#8217;ll give this website some data on me, I don&#8217;t mind.</p>\n\n\n\n<p>[00:10:20] <strong>Nathan Wrigley:</strong> Yeah, you&#8217;ve got a very open mind to all of that, haven&#8217;t you? And obviously, you are digging into this and your business is kind of largely tied up to that, so very understandable position to have.</p>\n\n\n\n<p>You mentioned there several platforms, and you rattled them off one after another, Fathom and others. So a lot of these will be unfamiliar, I think, to this audience. What is the proposition?</p>\n\n\n\n<p>So it sounds like many of them are quite new. What is it that they bring to the table, and are these SaaS based products, or are in some cases a WordPress plugin? Or something that can install on your own hardware? What&#8217;s going on there? Just rattle off those names again and maybe just give us the low down on what they do, and how they&#8217;re getting into the market, and competing against giants like Google.</p>\n\n\n\n<p>[00:11:01] <strong>Derek Ashauer:</strong> Yeah, so there&#8217;s definitely some great new options and a lot of the initial ones were SaaS based. So there&#8217;s ones, like I said, Plausible, Fathom, Usermaven, Pirsch is another great one that I really enjoy. My plugin Conversion Bridging integrates with like 12 different analytics platforms, so there&#8217;s tons of them, and there&#8217;s still many more that I have on my list to do. So there&#8217;s lots of alternatives, which there weren&#8217;t any before, until Google Analytics 4 kind of came out and people were like, we don&#8217;t like GA4, and that opened the door for a lot of platforms.</p>\n\n\n\n<p>But to get back to your question, yeah, one of the differences that they offer is they do what&#8217;s called cookieless tracking. So that&#8217;s one of the big things that the privacy laws in Europe were like, it was around cookies and tracking the cross websites. So that the user, they go to landscaper website, then they go, no, I&#8217;m going to go to Home Depot and I&#8217;m going to look for my own lawnmower, and now I&#8217;m going to price check against Lowe&#8217;s and all these different things. And Google Analytics could see where they were going, and all these different places. Or Facebook ads could track all these different websites that they went to and gauge this type of person and who they are and what they&#8217;re shopping for and things like that. So trying to crack down on that.</p>\n\n\n\n<p>Well, these alternative platforms do it without cookies. They have a way, a method, without getting too technical of just basically fingerprinting the user, and know for that one session when they&#8217;re on your website, what they&#8217;re doing. But then it stops there. It doesn&#8217;t go to all the other websites and give your entire four hours you were online, and all the different websites that you&#8217;re browsing to a company to let them know what you&#8217;re doing everywhere.</p>\n\n\n\n<p>So that&#8217;s kind of their main offering. And they are SaaS, you know, they&#8217;re just like Google Analytics, but they do cost. So that&#8217;s, they can be affordable. They&#8217;re anywhere, I think there&#8217;s some that are like $6, $7 a month for what a basic blog would ever need, up to $50 to, or even $100 a month depending on the amount of traffic, which is hard to reconcile for a lot of people who were used to free Google Analytics.</p>\n\n\n\n<p>So it&#8217;s hard to make that leap when you&#8217;re going, wait, I could do Google Analytics for free and there&#8217;s some countries, and even like a state or two in the US that have some laws where it&#8217;s like, erm, what&#8217;s the setup involved in that? There might be law violations, simply by using Google Analytics you could be violating some of those things in a couple countries.</p>\n\n\n\n<p>But there are some setups you can do to try and make it work with European privacy laws and stuff. Takes some extra work. But it&#8217;s a challenge. Is it worth it? We&#8217;ve been so used to, for 20 years, for having free analytics to then now suddenly switch and pay for analytics can be hard for some site owners.</p>\n\n\n\n<p>Or as if you&#8217;re an agency doing that to convince your client&#8217;s like, well, we should actually start paying for this. And because you get 200,000 visits a month, it&#8217;s going to cost you $100 a month. They go, or I could use the free version. Yeah, well, I&#8217;ll just stick to the free version. So it is, it&#8217;s a hard conversation to have. When is it worthwhile? It just really depends on, I mean, you&#8217;ve got to really try it out.</p>\n\n\n\n<p>[00:13:44] <strong>Nathan Wrigley:</strong> I suppose no matter how wonderful the staff at Google are, they&#8217;re not in the business of losing money. And so I&#8217;m guessing that at some point the pendulum does swing in Google&#8217;s favor. So what might be free at the point of use, so in other words, you download a snippet from Google, and you put it into the back end of your website, or you pay, let&#8217;s say $20 a month, or $50 a month, or whatever. I&#8217;m guessing that Google are doing quite well, let&#8217;s say, in terms of the data that they gather, and the way that they can use that themselves. Or, I don&#8217;t know if they sell that data onto any other brokers or what have you. But presumably there&#8217;s that concern.</p>\n\n\n\n<p>Just going back to what you said about these other, and I&#8217;m going to use modern platforms, let&#8217;s go for that, the ones that you mentioned. You said fingerprinting, and I&#8217;ve heard this phrase before, and I have the merest idea of what that means. So Google Analytics traditionally came about with a cookie, and we get what that is. But what are the ways around that, that fingerprinting, well, essentially, what is fingerprinting? What are some examples of how that works?</p>\n\n\n\n<p>[00:14:40] <strong>Derek Ashauer:</strong> Yeah, it&#8217;s a term that I just use in this moment. It&#8217;s not necessarily a term that you&#8217;ll see as you go around, it&#8217;s just the word that came out. But it&#8217;s just a way to uniquely identify somebody through various different points. You check these five different things about a person, and because of exactly what they are, those five elements, then we can say, that&#8217;s this person. So that&#8217;s kind of, each platform, I call them alternative platforms, you said modern platforms, they have their slightly different way of doing it, but they have their way of identifying without using cookies.</p>\n\n\n\n<p>So the traditional way is like Google Analytics, you set a cookie, random value in the browser, and then every time they go to a new page, you just check for that cookie and that value. That&#8217;s how we know they are, because that&#8217;s how we know who they are. Again, the modern platforms are doing it every time the page loads, it&#8217;s saying, who is this again? Let&#8217;s check these five points. I think sometimes it&#8217;s browser, it&#8217;s various different elements that they&#8217;ll check to then determine who that person is, and then know who you are as you go down the path on the website, but it&#8217;s not setting cookies to do that.</p>\n\n\n\n<p>[00:15:38] <strong>Nathan Wrigley:</strong> So what kind of information might it be? I mean, I can imagine an obvious one would be things like, okay, what browser are you using, for example? That might be one indicator, and then if you match that with another indicator, and then a third one, and a fourth one, over four or five different indicators, you are going to be, well, what are the chances that that&#8217;s a different person?</p>\n\n\n\n<p>[00:15:58] <strong>Derek Ashauer:</strong> General location, stuff like that, yeah. Using this specific browser, this version of their browser. In my stuff, I haven&#8217;t fully identified what those platforms are actually using. I&#8217;ve just kind of, at this point left it. They do cookieless tracking, they have a way of doing it, okay great.</p>\n\n\n\n<p>Some are better than others. To be honest, there are, Fathom has improved this. I know it was a struggle when I started Conversion Bridge about a year ago. For example, when someone landed on your page and then they did a conversion, say they fill out a form or made a purchase 10 pages later, those two weren&#8217;t associated with, because it was just one page view at a time, wholly independent things. They couldn&#8217;t tell that you are that person on that page view, and that person on that page view. I actually did this, I think last week just to check in on them, and it actually did finally say, okay, yeah, that was the same person. That came in and did that. So yeah, they&#8217;re finding ways to make it work and better identify those across one website.</p>\n\n\n\n<p>[00:16:50] <strong>Nathan Wrigley:</strong> Yeah, is the promise of these platforms though that they are different, or are they trying without cookies to get back to the point where cookies were? In other words, a cookie, until it was cleared out, could literally follow you everywhere. You know, it would know which website you&#8217;d been to, and could last for a long, long time and all of those concerns.</p>\n\n\n\n<p>Is the intention of these other analytics platforms to sort of step away from that and say, okay, we&#8217;re going to track you on this one domain. So if you&#8217;ve got example.com as your domain, and it&#8217;s an e-commerce store, whilst you&#8217;re there, our platform will keep an eye on you, and we&#8217;ll learn if you have gone through a bunch of pages, and whether you&#8217;ve converted and bought a thing or not. But once you step away from that domain, that&#8217;s it, we are done with you.</p>\n\n\n\n<p>Or do you get the intention that they are somehow just, humans always figure out a way, right? If we give them enough time, they&#8217;ll figure out a way. Is the intention for these other platforms, do you perceive that they would like to get to the point where cookies were?</p>\n\n\n\n<p>[00:17:45] <strong>Derek Ashauer:</strong> No. They&#8217;re number one selling point, I think if you went to the homepage of every single one of them is they do privacy first analytics, is like the banner thing. That&#8217;s what they&#8217;re offering. And that&#8217;s why it&#8217;s so much bigger in Europe than it is here in the US and North America and stuff like that.</p>\n\n\n\n<p>But, yeah, that&#8217;s their main thing, their privacy focused analytics. Google Analytics alternatives that are privacy focused is their main draw. I think someone reminded me of, Katie Keith from Barn2, she reminded me of the story from Fathom. They specifically sent Google Analytics a cake to thank them for being so bad at what they do that they allowed them to create a whole industry as an alternative to them. Stuff like that. So, I think they&#8217;re trying to do the privacy focused stuff, and then backfill in the features to give people as much data as they possibly can that they were used to in Google Analytics.</p>\n\n\n\n<p>[00:18:39] <strong>Nathan Wrigley:</strong> You said earlier, and we&#8217;ll just touch on this briefly, you said earlier that, the implication of what you said, and you may not have meant this, but I&#8217;ll say it as if you are saying it, and then you can criticise whatever I say. It sounds like, if you could rewind the clock and get rid of the European legislation and what have you, you would do that, and you&#8217;d be happy with that position. You are okay with being tracked and all bets are off. So firstly, let&#8217;s address that. Would you be okay with all of that?</p>\n\n\n\n<p>[00:19:03] <strong>Derek Ashauer:</strong> I think there&#8217;s got to be a balance between the two. I get that there&#8217;s, you know, for me it&#8217;s a thing. I don&#8217;t care if you know all the different things of where I went. You know, you see those futuristic movies where it&#8217;s individualised ads on video screens, and I&#8217;m like, that&#8217;s actually kind of cool. It helps give me gift ideas for my wife, stuff like that, because I&#8217;m a terrible gift giver. So, yeah, recommend me some products. I wouldn&#8217;t have thought to do that. I&#8217;ve bought things off of ads I&#8217;ve seen on Facebook or Twitter, things like that. Because I was like, that was a great gift for my dad. I never would&#8217;ve purposely found that if I hadn&#8217;t been shown that ad because for whatever reason, so I&#8217;m not against that personally.</p>\n\n\n\n<p>[00:19:37] <strong>Nathan Wrigley:</strong> My guess though is that it&#8217;s not really that that&#8217;s the problem in most people&#8217;s minds. It&#8217;s like, who&#8217;s holding that data, and where does that data get moved to? Just the idea that, as an example, there might be a data broker firm who may purchase that data. And in some cases, let&#8217;s imagine that you ended up on a website which you regret going to. You can read into that, dear listener, whatever you like. But you end up somewhere and all of a sudden connections are made between you as a person. And you can also imagine scenarios in which, I don&#8217;t know, data gets linked from various data brokers and they start to create an impression of who you are.</p>\n\n\n\n<p>I can imagine scenarios where that could get out of hand, and potentially come back to bite you as an individual. So I suppose there&#8217;s a little bit of that muddled up in it. It&#8217;s not that the business, the WooCommerce store or whatever, is going to have any nefarious reason to have that data. Or wish to know where you&#8217;ve come from, where you&#8217;re going to, what ad you might have clicked on, what were the previous page that you came from, and so on and so forth.</p>\n\n\n\n<p>It&#8217;s more that there just seems to be this fairly bizarre industry of data brokers who managed to get their hands on this data, and at that moment, you don&#8217;t know what&#8217;s going to happen with it. And we&#8217;ve all made mistakes in life, but we can erase them just with the passage of time. But with the advent of the internet, some of those mistakes might stick with us for a long time. Does that make any sense?</p>\n\n\n\n<p>[00:21:04] <strong>Derek Ashauer:</strong> No, it makes sense. I mean, I could see how someone would visit, again, visit the landscaper website, and all of a sudden they did not know that the fact that they went to a landscaper website was sent to Meta. They&#8217;re like, well, I didn&#8217;t know that was, I was going to a landscaper website. Why does Meta need to know that I was checking out who was going to cut my grass?</p>\n\n\n\n<p>I get that in some regards, that there&#8217;s just not a knowledge of where things are going. I think it&#8217;s a pretty safe thing to say that cookie popups, that was just not the right way to go about it. That&#8217;s just made things, made the internet significantly worse. What are the solutions to give website owners the data they need to make good marketing decisions?</p>\n\n\n\n<p>Because otherwise, I mean, I think of it even on a bigger macro level that that landscaper, if they don&#8217;t know any of the ads are working or what&#8217;s going on or what people are doing, then they don&#8217;t know what ads, where to spend their money that works best. Now they have to increase their costs to cover the blanket marketing that they have to do because they don&#8217;t know exactly what attribution, what marketing channel is actually working for them. So to pay for the 50 different marketing channels they have to do, they have to increase the cost for everybody.</p>\n\n\n\n<p>So if they were able to narrow it down and say, well, we know that mailers and these Google ads are actually our best ways to make money, we don&#8217;t need to spend on email newsletter, or all these different things, our marketing spends only 5% of what it would be otherwise, that means we don&#8217;t have to charge as much.</p>\n\n\n\n<p>So it goes to bigger macro level discussions of economics of, in some ways for the consumer, it could be better for these companies to have some data about you.</p>\n\n\n\n<p>But I understand what you&#8217;re saying though. It is like, again, I don&#8217;t want Meta to have it, I want the landscaper company to have it. That&#8217;s okay. And that&#8217;s the line that I think a lot of people, I think would agree that, yeah, I don&#8217;t want Meta to have that data but, yeah, I&#8217;m okay with my local landscaper having the data so they knew what ads worked and things like that.</p>\n\n\n\n<p>And those privacy or the modern analytics platforms do at least get you a good amount of that data. So they are some good alternatives to that. But it&#8217;s not going to get you, those mega corporations are not going to get the, okay, well they clicked on our ad, they went to these other places, then came back to our site, and then did this and they came back to site, and then did this and came back to our site. And to get those really deep analytics. They&#8217;re not going to and that&#8217;s the challenge. But I would say, the WordPress space, that&#8217;s 90% of people are going to do fantastic with modern analytics platforms and get the data that they need.</p>\n\n\n\n<p>[00:23:29] <strong>Nathan Wrigley:</strong> Yeah, that&#8217;s really interesting because you are owning the domain, you&#8217;re running the domain, you probably don&#8217;t have any interest in brokering the data out to Facebook anyway. So what you can get out of that is probably useful. We&#8217;ll dig into that in a moment.</p>\n\n\n\n<p>I&#8217;m just curious, being a resident in the USA, and I&#8217;m obviously, you can tell by my accent, I&#8217;m based in the UK, we may have, and I don&#8217;t know if we do, we may have a very different experience of browsing the internet.</p>\n\n\n\n<p>I, for my part, if I was to open up a brand new browser, clean out everything that&#8217;s ever happened in that browser and start again, and browse around a whole variety of websites, I am inundated with cookie banners. Go to any large property, I am going to see cookie banners a lot, a very significant amount of the time because that&#8217;s how it goes over here.</p>\n\n\n\n<p>They can be confusing. They can be deliberately confusing. And in some cases they can be eye wateringly difficult to understand. The language is inverted so that you are kind of clicking on something you didn&#8217;t intend to click on. There can be so many options. I mean, it is really remarkable how many options there can be. You open up this little popup and you scroll, and you scroll, and you scroll, and you scroll, and you could do that whole scroll thing for like a whole minute and you still haven&#8217;t run out of options. And so we are living through this, and I don&#8217;t know if it&#8217;s the same where you are, I don&#8217;t know if you encounter any of this stuff.</p>\n\n\n\n<p>[00:24:51] <strong>Derek Ashauer:</strong> I definitely see them, but it&#8217;s not on every single website because those cookie banners can be configured so that they can be region specific. So if someone is located in a space where there are no laws around that, then just don&#8217;t show on the banner. And I happen to be in that one. So there&#8217;s some that aren&#8217;t as complex that have that feature, and so I still will see those. But I mean, yeah, it&#8217;s not every single website. Honestly not sure how many, but I would say maybe 50%.</p>\n\n\n\n<p>[00:25:16] <strong>Nathan Wrigley:</strong> Yeah, I mean, if I was going to a website which is just purely, I don&#8217;t know, informational in content, it&#8217;s like a blog basically, then I&#8217;m sure I won&#8217;t see those kind of things because, what possible thing could they be doing? But if it&#8217;s a website where there&#8217;s some sort of login option or an option where they clearly are using analytics and they&#8217;re intending to sell that on, you do get bombarded with, there&#8217;s so many things that you can opt into and opt out of. It&#8217;s bizarre.</p>\n\n\n\n<p>[00:25:40] <strong>Derek Ashauer:</strong> Yeah, it&#8217;s a challenge. And it&#8217;s definitely an area that I am working on with my plugin and stuff, and trying to wrap my head around and understand to help guide people on it. But that&#8217;s one great thing about like the modern ones. For example, if you use Plausible, you do not need a cookie banner because of Plausible. You don&#8217;t need one. It doesn&#8217;t set cookies. It doesn&#8217;t use cookies. So just because you have analytics doesn&#8217;t mean you have to have a cookie banner.</p>\n\n\n\n<p>And that&#8217;s one thing I think is something that some people may not understand. You may need it for other reasons, depending on what you have going on your site. But there are sites where you just, I think there&#8217;s a lot of sites that have cookie banners that don&#8217;t actually need them because they&#8217;re so terrified of the EU cookie laws or those privacy laws that they&#8217;re like, it&#8217;s better to be safe than sorry. Lets just throw it up there and put it on there, CYA type stuff, cover your ass. Let&#8217;s just put it on there so that we don&#8217;t have to worry about it.</p>\n\n\n\n<p>But Google Analytics is a little like, probably should but, you know, if you are using one of those alternatives, that analytics platform, just that itself does not mean you have to have a cookie banner. And so it&#8217;s worth investigating to see if you could switch to alternatives. Some of them have free plans that you could stay within for a website, have your clients set up their own account. And if they have very small usage then use their free plan, and stick under that limit. And then you don&#8217;t even need a cookie banner on their site. And that can help annoy their visitors less. It&#8217;s something definitely worth investigating.</p>\n\n\n\n<p>[00:27:04] <strong>Nathan Wrigley:</strong> I think what I&#8217;ve noticed is that, and I could be wrong about this, my intuition though, because I see the same UI often. The cookie banner is clearly provided by the same company. Everything is the same apart from the choices that you can make, but obviously at some point they&#8217;ve ticked boxes and what have you. And it does feel a little bit like that. We don&#8217;t have the capacity to figure out what we really need to do, so what we&#8217;ll do is just enable every single option. Here&#8217;s all the choices that we could possibly provide.</p>\n\n\n\n<p>And of course that itself, that feels very self-defeating. Looking at it from the end user perspective, no matter what you think about the legislation and the merits of it, the fact that every single one of us is being caught up in this sort of dragnet of clicking away, rejecting cookies and what have you. That does seem like something which is not a good experience. I mean, I don&#8217;t know how many hours humanity wastes every day rejecting cookie banners.</p>\n\n\n\n<p>[00:27:57] <strong>Derek Ashauer:</strong> I mean, yeah, the cookie banners is a whole other thing. In my opinion it should be, if you&#8217;re going to do it, it should be in the browser. There should be a setting in the browser and the analytics code snippet that you have obeys the browser setting so that there&#8217;s not, there should be no need for independent, every single website owner to do their own remediation of, you know, through cookie banners of doing all this kind of stuff.</p>\n\n\n\n<p>It&#8217;s bonkers to me when every single website, if every single website needs to follow this, then put it at the browser level. You can just configure in your browser, in Chrome, say, I want to accept marketing cookies and I want to not accept these types of cookies or whatever, and then call it done. And every website you go to then just includes Google Analytics, includes whatever thing. It just can look at the browser settings and follow that, and you&#8217;re done. And it saves everyone thousands of dollars, hours of headache and all this kind of stuff, and it is what it is.</p>\n\n\n\n<p>[00:28:47] <strong>Nathan Wrigley:</strong> It sounds like a very sensible position. I&#8217;m just wondering, is that a clarion call that is in the industries that you are following, the analytics and the marketing side of things, is that something that&#8217;s gaining momentum or no?</p>\n\n\n\n<p>[00:28:59] <strong>Derek Ashauer:</strong> I haven&#8217;t heard of any movement to actually make that happen. I don&#8217;t know why I haven&#8217;t looked into it too much, but I haven&#8217;t read in the stuff that I&#8217;ve come across and reading and learning about it on my journey through this and educating myself about it. To me it seems like a pretty simple approach.</p>\n\n\n\n<p>[00:29:12] <strong>Nathan Wrigley:</strong> Let&#8217;s imagine a scenario in which cookies across the board are just outlawed universally for this kind of thing in the future. And obviously that&#8217;s not something that you would desire, but let&#8217;s just imagine a scenario where that was the case.</p>\n\n\n\n<p>As you call them, these modern solutions, if we were to bind that, let&#8217;s say into WooCommerce website, and obviously with Conversion Bridge, you&#8217;re all about the conversion. Does somebody arriving at the website end up doing a particular action? Do they purchase something? Do they end up at a landing page after a particular transaction has occurred, or something along those lines?</p>\n\n\n\n<p>How credible do those things feel to you now? And it said that a year ago you couldn&#8217;t do it with this particular platform, and now you can. Does it feel like that whole conversion industry, you know, conversion tracking in particular, does it feel like it&#8217;s fighting a losing battle? Or does it feel like with those modern analytics companies that you&#8217;re still in the game. You can still get the data that you probably need all be it, it&#8217;s not going off to some giant third party?</p>\n\n\n\n<p>[00:30:11] <strong>Derek Ashauer:</strong> So the first answer that came to mind when you&#8217;re asking that is, for example, in my testing of some of the various modern platforms, even on those, you&#8217;re getting 70% of the conversions actually getting tracked. And that could be for various reasons of JavaScript blockers, ad blockers, or things like that. And that&#8217;s one of the reasons why I&#8217;m really focusing on doing API based tracking, so that it&#8217;s server to server, not aligned to JavaScript. Because server to server, behind like, through PHP and APIs and stuff like that. If you can track what people are doing, then it&#8217;s going to be a lot more accurate actually.</p>\n\n\n\n<p>That&#8217;s one thing that I&#8217;m working on for my plugin is so that whatever analytics platform you&#8217;re using, it can be as accurate as possible. But yeah, I think you&#8217;re trying to hint at it, are these other modern platforms going to go the way of Google and try and sell data? Is that kind of what you mean?</p>\n\n\n\n<p>[00:30:58] <strong>Nathan Wrigley:</strong> No, what I was meaning was, do you feel that they are credible in that, okay, so let&#8217;s imagine that I own a WooCommerce store, I&#8217;ve been using Google forever and it&#8217;s been giving me this incredibly valuable data, and I really don&#8217;t want to let go of that. But I feel, for one reason or another, maybe that&#8217;s legislation, or just a moral compulsion that I feel I have, I want to move over to these platforms. Am I throwing away a ton of useful data that I&#8217;ll never get back? Or are these modern platforms slowly but surely offering a solution, which gives me more or less what I need.</p>\n\n\n\n<p>[00:31:31] <strong>Derek Ashauer:</strong> Yeah. From my perspective, what I&#8217;m seeing is when Google Analytics 4 came out, they haven&#8217;t been able to get the same level of data they used to 10 years ago with UA, Universal Analytics. Which was what we were, most of us were used to when we said Google Analytics, that&#8217;s what we had for a very, very long time, and then Google Analytics 4 came out.</p>\n\n\n\n<p>I would say the platforms, some are better than others. There&#8217;s definitely some that have a lot more advanced features than others. Fathom, for example, is pretty straightforward. I wouldn&#8217;t say it&#8217;s very well geared towards detailed conversion tracking and getting good, detailed, in-depth insights. It&#8217;s good at getting page views, where they came from, what country they&#8217;re at. Something you would hand to a client so they could look at a nice little dashboard.</p>\n\n\n\n<p>And Universal Analytics, it used to be great. I used to say, hey, here&#8217;s Universal Analytics, go check it out. Didn&#8217;t even have to walk them through any of it. They could look at the screen, understand the data, it made sense. Now, Google Analytics 4 is a cluster. It is for professional level marketers, and that is it at this point. You have to really know the software. There&#8217;s week long classes on how to use Google Analytics 4 these days, because it is so overwhelmingly complex. And I think it went almost too far in that regard.</p>\n\n\n\n<p>But anyway, I think these modern platforms can get most site owners the data they need to make good decisions about, are my ads working if I&#8217;m doing Facebook ads? Or am I doing Google ads? Are they working for me? You know, if I&#8217;m doing link building from another site and you can tag those same UTM codes, that might be something, if you&#8217;re familiar. There are codes that you can add to the URL, with the little query and the query variables, to kind of identify that this link came from this source.</p>\n\n\n\n<p>And then that can track that user throughout the process. You know, the add to cart, checkout and complete the purchase. And then know that that user came from that UTM tracking code from either somewhere on your own website or from an external website. So it can do all those great things.</p>\n\n\n\n<p>So for a lot of mom and pop, WooCommerce stores I think can get a lot of great, useful data. It&#8217;s really when you are more an enterprise company, and maybe you&#8217;re doing like a million dollars a week in ad spend, you&#8217;re going to want something that is really, these crazy reports that you can run. And it&#8217;s more about the reporting than anything that you can do in GA 4 that maybe these modern platforms can&#8217;t quite do yet.</p>\n\n\n\n<p>And so, like I said, for my clients, any of the clients that I&#8217;ve built sites for over the last 20 years, they don&#8217;t need any of that stuff. They would be very happy with the reports from, say, Plausible. Many of them would be happy with even Fathom, which I said, which isn&#8217;t the most conversion oriented platform. Even they would be great with those ones.</p>\n\n\n\n<p>[00:34:14] <strong>Nathan Wrigley:</strong> So your plugin, which is called Conversion Bridge, what does it do? It feels from the outside as if it&#8217;s almost like a Zapier for analytics meets website, if you know what I mean. You bind your website to the analytics platform, and then you can give it, I don&#8217;t know, if this, then that kind of functionality to figure out, okay, what are the conversions?</p>\n\n\n\n<p>And also it just feels like you are stripping out the technical burden of learning those platforms. Is that basically what it&#8217;s doing or have I missed the target?</p>\n\n\n\n<p>[00:34:46] <strong>Derek Ashauer:</strong> That&#8217;s very close. The idea is, when I was building sites for clients, I didn&#8217;t set up any conversion tracking for a lot of them. One, because it&#8217;s just the cost, because you go buy Gravity Forms well, this site we&#8217;re going to use WS Form. Well, this site we&#8217;re going to use Ninja Forms, or this site we&#8217;re using WooCommerce, this other one we&#8217;re going to use this other, you know.</p>\n\n\n\n<p>There&#8217;s so many different ways that you could do a form, do a purchase. Page builders, what button? How do I add a click tracking? Like, every time someone clicks on the buy now button on my homepage and goes to that. So we want to really track all this kind of stuff. It was a challenge of, how did you add that to your WordPress site? And so oftentimes it just didn&#8217;t happen because it was such a pain in the butt to do it.</p>\n\n\n\n<p>So what Conversion Bridge tries to do is makes it easy to add the analytics tracking codes. A lot of people just cut and paste it into the header, footer, code snippets, type plugins and all this kind of stuff. That is a way to do it. It&#8217;s not really the ideal way. But it does allow you to quickly and easily add one of, I think I have 12 different analytics platforms, whether it&#8217;s Google Analytics, Fathom, all that kind of stuff. Toggle, copy and paste your just like little ID number. And then the analytics code has been added to the site where it needs to. Make sure it does it for the right users. Like, I don&#8217;t want to track admin users, let&#8217;s make sure we don&#8217;t track admin users. Stuff like that.</p>\n\n\n\n<p>But the real benefit is, is that conversion tracking. So say you have a form that you&#8217;re using, and it&#8217;s just a simple, yes, add conversion tracking, done. That&#8217;s all I had to do. Click a toggle. I didn&#8217;t have to think about code snippets. How do I do it? Researching the form plugin, where does it need to get output? When does it need to get output? All this kinda stuff, it just was a pain in the butt.</p>\n\n\n\n<p>And then the real benefit for agencies is that, regardless of what site they&#8217;re doing, whether they&#8217;re using Bricks Builder or Beaver Builder, using WS Form, Gravity Forms, it&#8217;s all one plugin that works for any site that you would need, because it integrates with 50 plus different WordPress plugins to just have one click toggle conversion tracking.</p>\n\n\n\n<p>And websites really need conversion tracking. They need to know what users are doing on their site. And I think it&#8217;s a huge value that especially professional site builders could add to their plugin stack that they put on every client site to just, oh, all I have to do is copy, paste the little ID number from Fathom, and then I just need to check one little box in WS Form, and suddenly I have, not only analytics on the site, but I&#8217;m also tracking every single form submission.</p>\n\n\n\n<p>And we can see where they&#8217;re coming from and which ones generate the most contact form leads on this website that is for a landscaper to fill out forms and get lead quotes. And now I can tell my client, these resources, whether it&#8217;s this external blog that linked to us, oh my God, we got mentioned in this blog, and all of a sudden they&#8217;re generating 50 leads a month from us. We need to do more outreach to all these blogs. And to really understand where your leads are coming from. It&#8217;s a huge value to add to client sites.</p>\n\n\n\n<p>[00:37:28] <strong>Nathan Wrigley:</strong> I have a couple of questions following on from that. The first one is, have you got any examples, like curious examples, maybe unexpected examples? Because everybody gets the, okay, I want to convert, I want to track that a person arrived at the website, looked at this product and then ended up buying it, you know? Brilliant.</p>\n\n\n\n<p>But are there any quirky ones that people have reached out to you that they&#8217;ve used and you thought, oh gosh, I never imagined people would want to track that conversion?</p>\n\n\n\n<p>[00:37:52] <strong>Derek Ashauer:</strong> Not yet. It is pretty straightforward, you know, the things that you need to track. Form submissions, email newsletter signups are a good one. I mean purchases, stuff like that. What buttons on your page? You know, maybe you have a homepage and you want to know which button on that page actually got them to go to the buy now?</p>\n\n\n\n<p>So maybe you have one in the main banner. Maybe you have one near the FAQ section. Maybe you have one near the testimonials. Which one actually got people to actually go to that page. So button tracking, link tracking is good ones. Yeah, there&#8217;s not too many surprises on that regard.</p>\n\n\n\n<p>[00:38:23] <strong>Nathan Wrigley:</strong> And then the other one is about the plugins that you work with. So, and again, it sounds like your UVP really is that, look, we&#8217;ve looked at how their plugin works, how the code works, and you just tick the button. You say, I&#8217;ve got WS Form, I&#8217;ve got Gravity Forms, or whatever it may be, and now it&#8217;s just done. That&#8217;s part of the deal. You&#8217;re buying it so that you don&#8217;t have to do any coding.</p>\n\n\n\n<p>[00:38:45] <strong>Derek Ashauer:</strong> Yeah, because that&#8217;s, you know, what everyone wants these days. There&#8217;s no code. And they don&#8217;t even want to, even cutting and pasting code snippets. Before it was, a lot of plugins were like, add this, you had to use this hook, and then add this code. I mean, they provided this snippet, and then you had to kind of customise it and all this kinda stuff. It&#8217;s no. Just toggle and it&#8217;s done.</p>\n\n\n\n<p>You know, like for WooCommerce, it&#8217;ll send all the detailed data about the purchase. What product they purchased. How much it cost. What the order total was. So you can get all that good data in there so you can do some advanced reporting in Google Analytics or even Plausible and some other, Pirsch, and stuff like that. So these alternatives you can do as well.</p>\n\n\n\n<p>[00:39:18] <strong>Nathan Wrigley:</strong> No code solution. Yeah, that&#8217;s nice. And the other one I suppose would be, where do you feel your audience is? Is it kind of agencies, or do you have customers who are, I don&#8217;t know, just building their own website and really don&#8217;t have any technical background? Or is it more, like I said, is it more kind of agencies who are deploying this for their clients and they have an understanding of how to set these things up?</p>\n\n\n\n<p>[00:39:39] <strong>Derek Ashauer:</strong> You know, I&#8217;m doing my own market research and learning that as a business owner of how to do your, what is ICP? Ideal Customer Profile. And I&#8217;m kind of identifying that it, I think agencies would, so far, I think are the top of the list.</p>\n\n\n\n<p>I know there&#8217;s some people that have bought it that are single site owners, but then I&#8217;ve learned, you know, they bought a one site license, but then I learned that they were just trying it on one site to see how it worked.</p>\n\n\n\n<p>And they&#8217;re like, okay, yeah, this makes sense, and then they&#8217;re going to upgrade to, you know, a 20 site license because then they&#8217;re like, now I&#8217;m going to use this on all my client sites. This is what I&#8217;ve noticed those one site license purchases have been so far. So yeah, I think agencies do get the best of it.</p>\n\n\n\n<p>But it&#8217;s also a great tool to try out because I can actually, and I have it on my development test site, but I can enable 12 different analytics platforms at once. It&#8217;s obviously not something that you would do, but you technically could. And it&#8217;s great because you can actually test different things.</p>\n\n\n\n<p>Say, if you&#8217;re using Google Analytics, I want to test out Plausible. Let me try it out. Well, let me just add Google Analytics and Plausible, and everywhere you&#8217;ve checked that box on WS Form to do conversion tracking, it&#8217;ll send it to every single platform for you. You don&#8217;t have to then do a different snippet or code for, okay, now let me cut, do this snippet for WS Form in Plausible. Do this snippet for WooCommerce and Plausible. This snippet for Google Analytics and WooCommerce. It just takes care of all that for you.</p>\n\n\n\n<p>So you could try, do the free trial for a week for three or four different analytics platforms. Look at the data. Okay, we ran it for a week, let&#8217;s see which one I actually do like. So it&#8217;s one little side benefit. I allowed multiple analytics platforms to make it easy for me to develop, but then I quickly realised, this is actually an advantage to test out these different platforms and see if I can get good data, and data that is usable without losing Google Analytics data while you keep maintaining that.</p>\n\n\n\n<p>[00:41:13] <strong>Nathan Wrigley:</strong> It feels like there&#8217;s very few parts of our industry where politics gets in. There&#8217;s just no politics in the kind of things that I deal with. You know, what I mean by that, international politics. Not the kind of politics within the kind of baseball of WordPress, but the international politics.</p>\n\n\n\n<p>It feels like this is a bit of a moving target at the moment. And it&#8217;d be curious to see if we were to do this episode again in a year&#8217;s time, whether or not the sand has shifted, and you&#8217;ve had to pivot your product because it&#8217;s moved in one direction or another. Yeah, just absolutely fascinating.</p>\n\n\n\n<p>I wish you all the best. Just before we wrap it up, where do people find you? What&#8217;s the URL or the social network or both? Where can we find you? And of course, Conversion Bridge.</p>\n\n\n\n<p>[00:41:55] <strong>Derek Ashauer:</strong> Yeah, conversionbridgewp.com is the Conversion Bridge plugin, and then I am pretty active on Twitter. You can find me @derekashauer on Twitter or X, I guess, sorry.</p>\n\n\n\n<p>[00:42:05] <strong>Nathan Wrigley:</strong> Yeah. As is always the case, I will drop all of the links for anything that we discuss today, including the host of analytics platforms and what have you that we mentioned. I&#8217;ll put all of those into the show notes. If you head to wptavern.com, search for the episode with Derek in, all of the links will be right there.</p>\n\n\n\n<p>So, Derek, it just remains for me to say thank you very much for chatting to me today. I really appreciate it. It.</p>\n\n\n\n<p>[00:42:24] <strong>Derek Ashauer:</strong> It&#8217;s been a pleasure. Thanks for having me on.</p>\n</div>\n\n\n\n<p>On the podcast today we have <a href=\"https://x.com/derekashauer\">Derek Ashauer</a>.</p>\n\n\n\n<p>Having spent over 15 years in the WordPress arena, Derek has transitioned from building client sites to creating specialised WordPress plugins. Today, we get to hear about his journey creating <a href=\"https://conversionbridgewp.com/\">Conversion Bridge</a>, a tool specifically designed to streamline the process of implementing analytics platforms and conversion tracking on WordPress websites.</p>\n\n\n\n<p>We start with an overview of analytics, tracing its evolution from the simple server logs of the early internet days, to the sophisticated data gathering mechanisms provided by Google Analytics and others.</p>\n\n\n\n<p>We explore how the introduction of European privacy laws has significantly impacted the data landscape, challenging marketers and businesses to adapt to a new er